/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.image.ndimage;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.image.ndimage.ExtendMode;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;

public class Correlate1D {
    Array weights;
    ExtendMode mode;
    int axis = -1;
    double cValue = 0.0;

    public Correlate1D(Array weights, ExtendMode mode) {
        this.weights = weights.copyIfView();
        this.mode = mode;
    }

    public Correlate1D(Array weights) {
        this(weights, ExtendMode.REFLECT);
    }

    public Correlate1D() {
        this(Array.factory((DataType)DataType.INT, (int[])new int[]{1, 1, 1}), ExtendMode.REFLECT);
    }

    public Array getWeights() {
        return this.weights;
    }

    public void setWeights(Array value) {
        this.weights = value.copyIfView();
    }

    public ExtendMode getMode() {
        return this.mode;
    }

    public void setMode(ExtendMode value) {
        this.mode = value;
    }

    public int getAxis() {
        return this.axis;
    }

    public void setAxis(int value) {
        this.axis = value;
    }

    public double getCValue() {
        return this.cValue;
    }

    public void setCValue(double value) {
        this.cValue = value;
    }

    public Array correlate(Array a) throws InvalidRangeException {
        int size = (int)this.weights.getSize();
        int origin = size / 2;
        int n = (int)a.getSize();
        Array r = Array.factory((DataType)a.getDataType(), (int[])a.getShape());
        if (a.getRank() == 1) {
            ArrayList<Double> dList = new ArrayList<Double>();
            IndexIterator iter = a.getIndexIterator();
            while (iter.hasNext()) {
                dList.add(iter.getDoubleNext());
            }
            ArrayList<Double> rList = this.correlate(dList);
            int i = 0;
            while ((long)i < r.getSize()) {
                r.setDouble(i, rList.get(i).doubleValue());
                ++i;
            }
        } else {
            Index index = a.getIndex();
            int[] shape = a.getShape();
            if (this.axis == -1) {
                this.axis = n - 1;
            }
            int nn = shape[this.axis];
            Index indexr = r.getIndex();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int i = 0; i < n; ++i) {
                if (i == this.axis) {
                    ranges.add(new Range(0, 0, 1));
                    continue;
                }
                ranges.add(new Range(0, shape[i] - 1, 1));
            }
            IndexIterator rii = r.sectionNoReduce(ranges).getIndexIterator();
            while (rii.hasNext()) {
                rii.next();
                int[] current = rii.getCurrentCounter();
                ranges = new ArrayList();
                for (int j = 0; j < n; ++j) {
                    if (j == this.axis) {
                        ranges.add(new Range(0, shape[j] - 1, 1));
                        continue;
                    }
                    ranges.add(new Range(current[j], current[j], 1));
                }
                ArrayList<Double> stlist = new ArrayList<Double>();
                IndexIterator ii = a.getRangeIterator(ranges);
                while (ii.hasNext()) {
                    double v = ii.getDoubleNext();
                    stlist.add(v);
                }
                ArrayList<Double> rList = this.correlate(stlist);
                for (int j = 0; j < nn; ++j) {
                    indexr.set(current);
                    r.setObject(indexr, (Object)rList.get(j));
                    current[this.axis] = current[this.axis] + 1;
                }
            }
        }
        return r;
    }

    private ArrayList<Double> correlate(ArrayList<Double> a) {
        int size = (int)this.weights.getSize();
        int origin = size / 2;
        int n = a.size();
        ArrayList<Double> r = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            double v = 0.0;
            for (int j = 0; j < size; ++j) {
                int idx = i - origin + j;
                v += this.getValue(a, idx, origin) * this.weights.getDouble(j);
            }
            r.add(v);
        }
        return r;
    }

    private double getValue(List<Double> dList, int idx, int origin) {
        int n = dList.size();
        switch (this.mode) {
            case REFLECT: {
                if (idx < 0) {
                    idx = -idx - 1;
                } else if (idx > n - 1) {
                    idx = n - (idx - (n - 1));
                }
                return dList.get(idx);
            }
            case CONSTANT: {
                if (idx < 0 || idx > n - 1) {
                    return this.cValue;
                }
                return dList.get(idx);
            }
            case NEAREST: {
                if (idx < 0) {
                    idx = 0;
                } else if (idx > n - 1) {
                    idx = n - 1;
                }
                return dList.get(idx);
            }
            case MIRROR: {
                if (idx < 0) {
                    idx = -idx;
                } else if (idx > n - 1) {
                    idx = n - 1 - (idx - (n - 1));
                }
                return dList.get(idx);
            }
            case WRAP: {
                if (idx < 0) {
                    idx += origin;
                } else if (idx > n - 1) {
                    idx -= origin;
                }
                return dList.get(idx);
            }
        }
        return Double.NaN;
    }
}

