/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.integrate;

import java.util.ArrayList;
import org.apache.commons.math4.legacy.ode.ContinuousOutputModel;
import org.apache.commons.math4.legacy.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math4.legacy.ode.FirstOrderIntegrator;
import org.apache.commons.math4.legacy.ode.nonstiff.DormandPrince54Integrator;
import org.apache.commons.math4.legacy.ode.nonstiff.DormandPrince853Integrator;
import org.apache.commons.math4.legacy.ode.sampling.StepHandler;
import org.apache.commons.math4.legacy.ode.sampling.StepInterpolator;
import org.meteoinfo.math.integrate.IntegrateMethod;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.Index2D;

public class ODESolver {
    private IntegrateMethod method;
    private FirstOrderIntegrator integrator;
    private FirstOrderDifferentialEquations equations;
    private Array y0;
    private double t0;
    private double tf;
    private Array tEval;
    private double minStep = 1.0E-6;
    private double maxStep = 100.0;
    private double rTol = 1.0E-6;
    private double aTol = 1.0E-6;
    private boolean denseOutput = false;
    private ContinuousOutputModel denseOutputModel;
    private Array tResult;
    private Array yResult;

    public ODESolver(String method, FirstOrderDifferentialEquations equations, double t0, double tf, Array y0) {
        this.method = IntegrateMethod.valueOf(method.toUpperCase());
        this.equations = equations;
        this.t0 = t0;
        this.tf = tf;
        this.y0 = y0.copyIfView();
    }

    public void setTEval(Array value) {
        this.tEval = value;
    }

    public void setMinStep(double value) {
        this.minStep = value;
    }

    public void setMaxStep(double value) {
        this.maxStep = value;
    }

    public void setRTol(double value) {
        this.rTol = value;
    }

    public void setATol(double value) {
        this.aTol = value;
    }

    public void setDenseOutput(boolean value) {
        this.denseOutput = value;
    }

    public Array getTResult() {
        return this.tResult;
    }

    public Array getYResult() {
        return this.yResult;
    }

    public void solve() throws NoSuchMethodException {
        switch (this.method) {
            case RK45: {
                this.integrator = new DormandPrince54Integrator(this.minStep, this.maxStep, this.aTol, this.rTol);
                break;
            }
            case DOP853: {
                this.integrator = new DormandPrince853Integrator(this.minStep, this.maxStep, this.aTol, this.rTol);
                break;
            }
            default: {
                throw new NoSuchMethodException("No such");
            }
        }
        int ny0 = (int)this.y0.getSize();
        double[] y0v = (double[])this.y0.getStorage();
        double[] yDot = new double[ny0];
        final ArrayList<Double> tlist = new ArrayList<Double>();
        final ArrayList<double[]> ylist = new ArrayList<double[]>();
        if (this.denseOutput) {
            this.denseOutputModel = new ContinuousOutputModel();
            this.integrator.addStepHandler((StepHandler)this.denseOutputModel);
            this.integrator.integrate(this.equations, this.t0, y0v, this.tf, yDot);
        } else {
            if (this.tEval == null) {
                this.integrator.addStepHandler(new StepHandler(){

                    public void init(double t0, double[] y0, double t) {
                        tlist.add(t0);
                        ylist.add(y0);
                    }

                    public void handleStep(StepInterpolator interpolator, boolean isLast) {
                        double t = interpolator.getCurrentTime();
                        tlist.add(t);
                        double[] y = interpolator.getInterpolatedState();
                        ylist.add((double[])y.clone());
                    }
                });
                this.integrator.integrate(this.equations, this.t0, y0v, this.tf, yDot);
            } else {
                ContinuousOutputModel denseOutputModel = new ContinuousOutputModel();
                this.integrator.addStepHandler((StepHandler)denseOutputModel);
                this.integrator.integrate(this.equations, this.t0, y0v, this.tf, yDot);
                int i = 0;
                while ((long)i < this.tEval.getSize()) {
                    double t = this.tEval.getDouble(i);
                    tlist.add(t);
                    denseOutputModel.setInterpolatedTime(t);
                    double[] v = denseOutputModel.getInterpolatedState();
                    ylist.add((double[])v.clone());
                    ++i;
                }
            }
            int nt = tlist.size();
            this.tResult = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{nt});
            this.yResult = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ny0, nt});
            Index2D index = (Index2D)this.yResult.getIndex();
            for (int i = 0; i < nt; ++i) {
                this.tResult.setDouble(i, ((Double)tlist.get(i)).doubleValue());
                double[] interpolatedY = (double[])ylist.get(i);
                index.set1(i);
                for (int j = 0; j < ny0; ++j) {
                    index.set0(j);
                    this.yResult.setDouble((Index)index, interpolatedY[j]);
                }
            }
        }
    }

    public Array solve(Array t) {
        t = t.copyIfView();
        int ny0 = (int)this.y0.getSize();
        int nt = (int)t.getSize();
        Array y = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ny0, nt});
        Index2D index = (Index2D)y.getIndex();
        int i = 0;
        while ((long)i < t.getSize()) {
            this.denseOutputModel.setInterpolatedTime(t.getDouble(i));
            double[] v = this.denseOutputModel.getInterpolatedState();
            index.set1(i);
            for (int j = 0; j < ny0; ++j) {
                index.set0(j);
                y.setDouble((Index)index, v[j]);
            }
            ++i;
        }
        return y;
    }
}

