/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.ProgrammingError;
import org.ojalgo.array.Array1D;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.GenericDecomposition;
import org.ojalgo.matrix.decomposition.function.ExchangeColumns;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.structure.Access2D;

abstract class EigenvalueDecomposition<N extends Comparable<N>>
extends GenericDecomposition<N>
implements Eigenvalue<N> {
    private MatrixStore<N> myD = null;
    private Array1D<ComplexNumber> myEigenvalues = null;
    private int mySquareDim = 0;
    private MatrixStore<N> myV = null;
    private boolean myValuesOnly = false;

    static void sort(double[] d, ExchangeColumns mtrxV) {
        int size = d.length;
        int length = size - 1;
        for (int i = 0; i < length; ++i) {
            int k = i;
            double p = Math.abs(d[i]);
            for (int j = i + 1; j < size; ++j) {
                if (!(Math.abs(d[j]) > p)) continue;
                k = j;
                p = d[j];
            }
            if (k == i) continue;
            d[k] = d[i];
            d[i] = p;
            mtrxV.exchangeColumns(i, k);
        }
    }

    protected EigenvalueDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        super(aFactory);
    }

    @Override
    public N calculateDeterminant(Access2D<?> matrix) {
        this.decompose(this.wrap(matrix));
        return this.getDeterminant();
    }

    @Override
    public boolean computeValuesOnly(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
        return this.decompose(matrix, true);
    }

    @Override
    public final boolean decompose(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
        return this.decompose(matrix, false);
    }

    @Override
    public int getColDim() {
        return this.mySquareDim;
    }

    @Override
    public final MatrixStore<N> getD() {
        if (this.myD == null && this.isComputed()) {
            this.myD = this.makeD();
        }
        if (this.myD == null) {
            throw new IllegalStateException();
        }
        return this.myD;
    }

    @Override
    public final Array1D<ComplexNumber> getEigenvalues() {
        if (this.myEigenvalues == null && this.isComputed()) {
            this.myEigenvalues = this.makeEigenvalues();
        }
        return this.myEigenvalues;
    }

    @Override
    public int getMaxDim() {
        return this.mySquareDim;
    }

    @Override
    public int getMinDim() {
        return this.mySquareDim;
    }

    @Override
    public int getRowDim() {
        return this.mySquareDim;
    }

    @Override
    public final MatrixStore<N> getV() {
        if (this.myV == null && !this.myValuesOnly && this.isComputed()) {
            this.myV = this.makeV();
        }
        if (this.myV == null) {
            throw new IllegalStateException();
        }
        return this.myV;
    }

    @Override
    public void reset() {
        super.reset();
        this.myD = null;
        this.myEigenvalues = null;
        this.myV = null;
        this.myValuesOnly = false;
        this.mySquareDim = 0;
    }

    private final boolean decompose(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean valuesOnly) {
        this.reset();
        this.myValuesOnly = valuesOnly;
        long countRows = matrix.countRows();
        if (matrix.countColumns() != countRows) {
            ProgrammingError.throwIfNotSquare(matrix);
        }
        this.mySquareDim = Math.toIntExact(countRows);
        boolean retVal = this.doDecompose(matrix, valuesOnly);
        return this.computed(retVal);
    }

    protected abstract boolean doDecompose(Access2D.Collectable<N, ? super PhysicalStore<N>> var1, boolean var2);

    protected abstract MatrixStore<N> makeD();

    protected abstract Array1D<ComplexNumber> makeEigenvalues();

    protected abstract MatrixStore<N> makeV();

    final void setD(MatrixStore<N> newD) {
        this.myD = newD;
    }

    final void setEigenvalues(Array1D<ComplexNumber> eigenvalues) {
        this.myEigenvalues = eigenvalues;
    }

    final void setV(MatrixStore<N> newV) {
        this.myV = newV;
    }
}

