/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.util.HashMap;
import java.util.Map;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.SparseArray;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.RowsSupplier;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;

final class OptimisationData {
    private static final PhysicalStore.Factory<Double, Primitive64Store> FACTORY = Primitive64Store.FACTORY;
    private Map<String, MultiaryFunction.TwiceDifferentiable<Double>> myAdditionalConstraints;
    private MatrixStore<Double> myAE = null;
    private RowsSupplier<Double> myAI = null;
    private MatrixStore<Double> myBE = null;
    private MatrixStore<Double> myBI = null;
    private Primitive64Store myLB = null;
    private MultiaryFunction.TwiceDifferentiable<Double> myObjective;
    private Primitive64Store myUB = null;

    OptimisationData() {
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        retVal.append("[ variables=");
        retVal.append(this.countVariables());
        retVal.append(", equalities=");
        retVal.append(this.countEqualityConstraints());
        retVal.append(", inequalities=");
        retVal.append(this.countInequalityConstraints());
        retVal.append(" ]");
        return retVal.toString();
    }

    void addConstraint(String key, MultiaryFunction.TwiceDifferentiable<Double> value) {
        if (this.myAdditionalConstraints == null) {
            this.myAdditionalConstraints = new HashMap<String, MultiaryFunction.TwiceDifferentiable<Double>>();
        }
        this.myAdditionalConstraints.put(key, value);
    }

    void addInequalities(MatrixStore<Double> mtrxAI, MatrixStore<Double> mtrxBI) {
        ProgrammingError.throwIfNull(mtrxAI, mtrxBI);
        ProgrammingError.throwIfNotEqualRowDimensions(mtrxAI, mtrxBI);
        if (this.myAI == null || this.myBI == null) {
            this.setInequalities(mtrxAI, mtrxBI);
        }
        int offset = this.myAI.getRowDim();
        this.myAI.addRows(mtrxAI.getRowDim());
        if (mtrxAI instanceof SparseStore) {
            ((SparseStore)mtrxAI).nonzeros().forEach(nz -> this.myAI.getRow(offset + Math.toIntExact(nz.row())).set(nz.column(), nz.doubleValue()));
        } else {
            for (int i = 0; i < mtrxAI.getRowDim(); ++i) {
                SparseArray<Double> tmpRow = this.myAI.getRow(offset + i);
                for (int j = 0; j < mtrxAI.getColDim(); ++j) {
                    double value = mtrxAI.doubleValue(i, j);
                    if (value == PrimitiveMath.ZERO) continue;
                    tmpRow.set((long)j, value);
                }
            }
        }
        this.myBI = this.myBI.below((Access2D<Double>)mtrxBI);
    }

    void clearEqualities() {
        this.myAE = null;
        this.myBE = null;
    }

    int countAdditionalConstraints() {
        return this.myAdditionalConstraints != null ? this.myAdditionalConstraints.size() : 0;
    }

    int countEqualityConstraints() {
        return this.myAE != null ? this.myAE.getRowDim() : 0;
    }

    int countInequalityConstraints() {
        return this.myAI != null ? this.myAI.getRowDim() : 0;
    }

    int countVariables() {
        if (this.myAE != null) {
            return this.myAE.getColDim();
        }
        if (this.myAI != null) {
            return this.myAI.getColDim();
        }
        if (this.myObjective != null) {
            return this.myObjective.arity();
        }
        throw new ProgrammingError("Cannot deduce the number of variables!");
    }

    MatrixStore<Double> getAE() {
        return this.myAE;
    }

    MatrixStore<Double> getAI() {
        return this.myAI.get();
    }

    SparseArray<Double> getAI(int row) {
        return this.myAI.getRow(row);
    }

    RowsSupplier<Double> getAI(int ... rows) {
        return this.myAI.selectRows(rows);
    }

    MatrixStore<Double> getBE() {
        return this.myBE;
    }

    MatrixStore<Double> getBI() {
        return this.myBI;
    }

    double getBI(int row) {
        return this.myBI.doubleValue(row);
    }

    Primitive64Store getLowerBounds() {
        return this.myLB;
    }

    <T extends MultiaryFunction.TwiceDifferentiable<Double>> T getObjective() {
        return (T)this.myObjective;
    }

    Access2D.RowView<Double> getRowsAI() {
        return this.myAI.rows();
    }

    Primitive64Store getUpperBounds() {
        return this.myUB;
    }

    boolean hasAdditionalConstraints() {
        return this.countAdditionalConstraints() > 0;
    }

    boolean hasEqualityConstraints() {
        return this.countEqualityConstraints() > 0;
    }

    boolean hasInequalityConstraints() {
        return this.countInequalityConstraints() > 0;
    }

    boolean isObjectiveSet() {
        return this.myObjective != null;
    }

    void newEqualities(int nbEqualities, int nbVariables) {
        MatrixStore mtrxAE = (MatrixStore)FACTORY.make(nbEqualities, nbVariables);
        MatrixStore mtrxBE = (MatrixStore)FACTORY.make(nbEqualities, 1);
        this.setEqualities(mtrxAE, mtrxBE);
    }

    void newInequalities(int nbInequalities, int nbVariables) {
        RowsSupplier<Double> mtrxAI = FACTORY.makeRowsSupplier(nbVariables);
        mtrxAI.addRows(nbInequalities);
        MatrixStore mtrxBI = (MatrixStore)FACTORY.make(nbInequalities, 1);
        this.setInequalities(mtrxAI, mtrxBI);
    }

    void reset() {
        this.myAE = null;
        this.myAI = null;
        this.myBE = null;
        this.myBI = null;
        this.myObjective = null;
    }

    void setBounds(Access1D<Double> lower, Access1D<Double> upper) {
        ProgrammingError.throwIfNull(lower, upper);
        this.myLB = lower instanceof Primitive64Store ? (Primitive64Store)lower : (Primitive64Store)FACTORY.columns(lower);
        this.myUB = upper instanceof Primitive64Store ? (Primitive64Store)upper : (Primitive64Store)FACTORY.columns(upper);
    }

    void setEqualities(Access2D<Double> mtrxAE, Access1D<Double> mtrxBE) {
        ProgrammingError.throwIfNull(mtrxAE, mtrxBE);
        ProgrammingError.throwIfNotEqualRowDimensions(mtrxAE, mtrxBE);
        this.myAE = mtrxAE instanceof MatrixStore ? (MatrixStore<Object>)mtrxAE : Primitive64Store.FACTORY.makeWrapper(mtrxAE);
        this.myBE = mtrxBE instanceof MatrixStore ? (MatrixStore)mtrxBE : (MatrixStore)FACTORY.columns(mtrxBE);
    }

    void setInequalities(Access2D<Double> mtrxAI, Access1D<Double> mtrxBI) {
        ProgrammingError.throwIfNull(mtrxAI, mtrxBI);
        ProgrammingError.throwIfNotEqualRowDimensions(mtrxAI, mtrxBI);
        if (mtrxAI instanceof RowsSupplier) {
            this.myAI = (RowsSupplier)mtrxAI;
        } else {
            this.myAI = FACTORY.makeRowsSupplier(mtrxAI.getColDim());
            this.myAI.addRows(mtrxAI.getRowDim());
            if (mtrxAI instanceof SparseStore) {
                ((SparseStore)mtrxAI).nonzeros().forEach(nz -> this.myAI.getRow(Math.toIntExact(nz.row())).set(nz.column(), nz.doubleValue()));
            } else {
                int i = 0;
                while ((long)i < mtrxAI.countRows()) {
                    SparseArray<Double> tmpRow = this.myAI.getRow(i);
                    int j = 0;
                    while ((long)j < mtrxAI.countColumns()) {
                        double value = mtrxAI.doubleValue(i, j);
                        if (value != PrimitiveMath.ZERO) {
                            tmpRow.set((long)j, value);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        this.myBI = mtrxBI instanceof MatrixStore ? (MatrixStore)mtrxBI : (MatrixStore)FACTORY.columns(mtrxBI);
    }

    void setObjective(MultiaryFunction.TwiceDifferentiable<Double> objective) {
        ProgrammingError.throwIfNull(objective);
        this.myObjective = objective;
    }

    void validate() {
        if (this.myAE != null || this.myBE != null) {
            this.setEqualities(this.myAE, this.myBE);
        }
        if (this.myAI != null || this.myBI != null) {
            this.setInequalities(this.myAI, this.myBI);
        }
        this.setObjective(this.myObjective);
        int nbVariables = this.countVariables();
        if (this.myAE != null && this.myAE.getColDim() != nbVariables) {
            throw new ProgrammingError("AE has the wrong number of columns!");
        }
        if (this.myBE != null && this.myBE.getColDim() != 1) {
            throw new ProgrammingError("BE must have precisely one column!");
        }
        if (this.myAI != null && this.myAI.getColDim() != nbVariables) {
            throw new ProgrammingError("AI has the wrong number of columns!");
        }
        if (this.myBI != null && this.myBI.getColDim() != 1) {
            throw new ProgrammingError("BI must have precisely one column!");
        }
        if (this.myObjective != null && this.myObjective.arity() != nbVariables) {
            throw new ProgrammingError("The objective function has the wrong arity!");
        }
    }
}

