/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.render.jogl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.meteoinfo.chart.graphic.MeshGraphic;
import org.meteoinfo.chart.jogl.Program;
import org.meteoinfo.chart.jogl.Transform;
import org.meteoinfo.chart.jogl.Utils;
import org.meteoinfo.chart.render.jogl.JOGLGraphicRender;
import org.meteoinfo.geometry.legend.PolygonBreak;

public class MeshRender
extends JOGLGraphicRender {
    private MeshGraphic meshGraphic;
    private IntBuffer vbo;
    private IntBuffer vao;
    private Program program;
    private int sizePosition;
    private int sizeNormal;
    private int sizeColorTexture;
    private int sizeIndices;
    private Texture texture;
    private int textureID;

    public MeshRender(GL2 gl) {
        super(gl);
        this.useShader = false;
        if (this.useShader) {
            try {
                this.compileShaders();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.initVertexBuffer();
    }

    public MeshRender(GL2 gl, MeshGraphic meshGraphic) {
        this(gl);
        this.meshGraphic = meshGraphic;
        this.setBufferData();
        if (meshGraphic.isUsingTexture()) {
            this.texture = AWTTextureIO.newTexture((GLProfile)gl.getGLProfile(), (BufferedImage)meshGraphic.getImage(), (boolean)true);
            this.textureID = this.texture.getTextureObject((GL)gl);
            this.bindingTextures();
        }
    }

    private void initVertexBuffer() {
        this.vao = GLBuffers.newDirectIntBuffer((int)1);
        this.vbo = GLBuffers.newDirectIntBuffer((int)2);
    }

    private void setBufferData() {
        float[] vertexData = this.meshGraphic.getVertexPosition();
        FloatBuffer vertexBuffer = GLBuffers.newDirectFloatBuffer((float[])vertexData);
        FloatBuffer normalBuffer = GLBuffers.newDirectFloatBuffer((float[])this.meshGraphic.getVertexNormal());
        this.sizePosition = vertexBuffer.capacity() * 4;
        this.sizeNormal = normalBuffer.capacity() * 4;
        int totalSize = this.sizePosition + this.sizeNormal;
        FloatBuffer ctBuffer = this.meshGraphic.isUsingTexture() ? GLBuffers.newDirectFloatBuffer((float[])this.meshGraphic.getVertexTexture()) : GLBuffers.newDirectFloatBuffer((float[])this.meshGraphic.getVertexColor());
        this.sizeColorTexture = ctBuffer.capacity() * 4;
        this.gl.glGenBuffers(2, this.vbo);
        this.gl.glBindBuffer(34962, this.vbo.get(0));
        this.gl.glBufferData(34962, (long)(totalSize += this.sizeColorTexture), null, 35044);
        this.gl.glBufferSubData(34962, 0L, (long)this.sizePosition, (Buffer)vertexBuffer);
        this.gl.glBufferSubData(34962, (long)this.sizePosition, (long)this.sizeNormal, (Buffer)normalBuffer);
        this.gl.glBufferSubData(34962, (long)(this.sizePosition + this.sizeNormal), (long)this.sizeColorTexture, (Buffer)ctBuffer);
        this.gl.glBindBuffer(34962, 0);
        IntBuffer indexBuffer = GLBuffers.newDirectIntBuffer((int[])this.meshGraphic.getVertexIndices());
        this.gl.glBindBuffer(34963, this.vbo.get(1));
        this.gl.glBufferData(34963, (long)(indexBuffer.capacity() * 4), (Buffer)indexBuffer, 35044);
        this.gl.glBindBuffer(34963, 0);
    }

    @Override
    public void setTransform(Transform transform, boolean alwaysUpdateBuffers) {
        boolean updateBuffer = true;
        if (!alwaysUpdateBuffers && this.transform != null && this.transform.equals(transform)) {
            updateBuffer = false;
        }
        super.setTransform((Transform)transform.clone());
        if (alwaysUpdateBuffers) {
            this.setBufferData();
            if (this.meshGraphic.isUsingTexture()) {
                this.texture = AWTTextureIO.newTexture((GLProfile)this.gl.getGLProfile(), (BufferedImage)this.meshGraphic.getImage(), (boolean)true);
                this.textureID = this.texture.getTextureObject((GL)this.gl);
                this.bindingTextures();
            }
        }
    }

    void bindingTextures() {
        this.gl.glBindTexture(3553, this.textureID);
        this.gl.glTexParameteri(3553, 10241, 9728);
        this.gl.glTexParameteri(3553, 10240, 9729);
        this.gl.glBindTexture(3553, 0);
    }

    void compileShaders() throws Exception {
        String vertexShaderCode = Utils.loadResource("/shaders/surface/vertex.vert");
        String fragmentShaderCode = Utils.loadResource("/shaders/surface/surface.frag");
        this.program = new Program("surface", vertexShaderCode, fragmentShaderCode);
    }

    public void updateShaders() {
        if (this.program == null) {
            try {
                this.compileShaders();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void setUniforms() {
        this.program.allocateUniform(this.gl, "MVP", (gl2, loc) -> gl2.glUniformMatrix4fv(loc.intValue(), 1, false, this.viewProjMatrix.get(Buffers.newDirectFloatBuffer((int)16))));
        this.program.allocateUniform(this.gl, "MV", (gl2, loc) -> gl2.glUniformMatrix4fv(loc.intValue(), 1, false, this.toMatrix(this.mvmatrix).get(Buffers.newDirectFloatBuffer((int)16))));
        this.program.allocateUniform(this.gl, "MVI", (gl2, loc) -> gl2.glUniformMatrix4fv(loc.intValue(), 1, false, this.toMatrix(this.mvmatrix).invert().get(Buffers.newDirectFloatBuffer((int)16))));
        this.program.allocateUniform(this.gl, "transMatrix", (gl2, loc) -> gl2.glUniformMatrix4fv(loc.intValue(), 1, false, this.transform.getTransformMatrix().get(Buffers.newDirectFloatBuffer((int)16))));
        float[] rgba = this.meshGraphic.getColor().getRGBComponents(null);
        this.program.allocateUniform(this.gl, "color", (gl2, loc) -> gl2.glUniform4f(loc.intValue(), rgba[0], rgba[1], rgba[2], rgba[3]));
        this.program.allocateUniform(this.gl, "lightPosition", (gl2, loc) -> gl2.glUniform4fv(loc.intValue(), 0, this.lighting.getPosition(), 0));
        this.program.setUniforms(this.gl);
    }

    @Override
    public void draw() {
        if (this.useShader) {
            this.program.use(this.gl);
            this.setUniforms();
            int attribVertexPosition = this.gl.glGetAttribLocation(this.program.getProgramId().intValue(), "vertexPosition");
            int attribVertexNormal = this.gl.glGetAttribLocation(this.program.getProgramId().intValue(), "vertexNormal");
            int attribVertexColor = this.gl.glGetAttribLocation(this.program.getProgramId().intValue(), "vertexColor");
            int attribVertexIndices = this.gl.glGetAttribLocation(this.program.getProgramId().intValue(), "vertexIndices");
            this.gl.glBindBuffer(34962, this.vbo.get(0));
            this.gl.glEnableVertexAttribArray(attribVertexPosition);
            this.gl.glEnableVertexAttribArray(attribVertexNormal);
            this.gl.glEnableVertexAttribArray(attribVertexColor);
            this.gl.glVertexAttribPointer(attribVertexPosition, 3, 5126, false, 0, 0L);
            this.gl.glVertexAttribPointer(attribVertexNormal, 3, 5126, false, 0, (long)this.sizePosition);
            this.gl.glVertexAttribPointer(attribVertexColor, 3, 5126, false, 0, (long)(this.sizePosition + this.sizeNormal));
            this.gl.glDrawArrays(4, 0, this.meshGraphic.getVertexNumber());
            this.gl.glDisableVertexAttribArray(0);
            this.gl.glDisableVertexAttribArray(1);
            this.gl.glUseProgram(0);
        } else {
            this.gl.glBindBuffer(34962, this.vbo.get(0));
            this.gl.glBindBuffer(34963, this.vbo.get(1));
            this.gl.glEnableClientState(32885);
            this.gl.glEnableClientState(32884);
            this.gl.glNormalPointer(5126, 0, (long)this.sizePosition);
            this.gl.glVertexPointer(3, 5126, 0, 0L);
            if (this.meshGraphic.isUsingTexture()) {
                this.gl.glEnable(3553);
                this.gl.glEnableClientState(32888);
                this.gl.glTexCoordPointer(2, 5126, 0, (long)(this.sizePosition + this.sizeNormal));
            } else {
                this.gl.glEnableClientState(32886);
                this.gl.glColorPointer(4, 5126, 0, (long)(this.sizePosition + this.sizeNormal));
            }
            PolygonBreak pb = (PolygonBreak)this.meshGraphic.getLegendScheme().getLegendBreak(0);
            if (pb.isDrawFill()) {
                this.gl.glEnable(32823);
                this.gl.glPolygonOffset(1.0f, 1.0f);
                if (this.meshGraphic.isUsingTexture()) {
                    this.gl.glColor3f(1.0f, 1.0f, 1.0f);
                    this.gl.glBindTexture(3553, this.textureID);
                }
                if (this.meshGraphic.isFaceInterp()) {
                    this.gl.glDrawElements(7, this.meshGraphic.getVertexIndices().length, 5125, 0L);
                } else {
                    this.gl.glShadeModel(7424);
                    this.gl.glDrawElements(7, this.meshGraphic.getVertexIndices().length, 5125, 0L);
                    this.gl.glShadeModel(7425);
                }
            }
            if (pb.isDrawOutline()) {
                boolean lightEnabled = this.lighting.isEnable();
                if (lightEnabled) {
                    this.lighting.stop(this.gl);
                }
                this.gl.glLineWidth(pb.getOutlineSize() * this.dpiScale);
                if (!this.meshGraphic.isMesh()) {
                    this.gl.glDisableClientState(32886);
                    float[] rgba = pb.getOutlineColor().getRGBComponents(null);
                    this.gl.glColor4fv(rgba, 0);
                }
                this.gl.glPolygonMode(1032, 6913);
                this.gl.glDrawElements(7, this.meshGraphic.getVertexIndices().length, 5125, 0L);
                this.gl.glPolygonMode(1032, 6914);
                if (lightEnabled) {
                    this.lighting.start(this.gl);
                }
            }
            this.gl.glDisableClientState(32885);
            this.gl.glDisableClientState(32884);
            if (this.meshGraphic.isUsingTexture()) {
                this.gl.glDisableClientState(32888);
                this.gl.glBindTexture(3553, 0);
            } else {
                this.gl.glDisableClientState(32886);
            }
            this.gl.glBindBuffer(34962, 0);
            this.gl.glBindBuffer(34963, 0);
        }
    }
}

