/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.dimarray;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.MAMath;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;

public class DimArray {
    private Array array;
    private List<Dimension> dimensions;

    public DimArray() {
        this.array = null;
        this.dimensions = new ArrayList<Dimension>();
    }

    public DimArray(Array array) {
        int[] shape;
        this.array = array;
        this.dimensions = new ArrayList<Dimension>();
        for (int s : shape = array.getShape()) {
            this.dimensions.add(new Dimension(s));
        }
    }

    public DimArray(Array array, List<Dimension> dims) {
        this.array = array;
        this.dimensions = dims;
    }

    public Array getArray() {
        return this.array;
    }

    public void setArray(Array value) {
        this.array = value;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(List<Dimension> value) {
        this.dimensions = value;
    }

    public long getSize() {
        return this.array.getSize();
    }

    public Object getValue(int idx) {
        return this.array.getObject(idx);
    }

    public int getDimNum() {
        return this.dimensions.size();
    }

    public Dimension getDimension(int idx) {
        return this.dimensions.get(idx);
    }

    public void setDimension(int idx, Dimension dim) {
        this.dimensions.set(idx, dim);
    }

    public double getDimValue(int dimIdx, int vIdx) {
        return this.dimensions.get(dimIdx).getDimValue(vIdx);
    }

    public Dimension getStaggerDim() {
        for (Dimension dim : this.dimensions) {
            if (!dim.isStagger()) continue;
            return dim;
        }
        return null;
    }

    public int getStaggerDimIndex() {
        int i = 0;
        for (Dimension dim : this.dimensions) {
            if (dim.isStagger()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Dimension getXDimension() {
        for (Dimension dim : this.dimensions) {
            if (dim.getDimType() != DimensionType.X) continue;
            return dim;
        }
        return null;
    }

    public Dimension getYDimension() {
        for (Dimension dim : this.dimensions) {
            if (dim.getDimType() != DimensionType.Y) continue;
            return dim;
        }
        return null;
    }

    public Dimension getZDimension() {
        for (Dimension dim : this.dimensions) {
            if (dim.getDimType() != DimensionType.Z) continue;
            return dim;
        }
        return null;
    }

    public Dimension getTDimension() {
        for (Dimension dim : this.dimensions) {
            if (dim.getDimType() != DimensionType.T) continue;
            return dim;
        }
        return null;
    }

    public void asAscending() {
        boolean changed = false;
        int i = 0;
        for (Dimension dimension : this.dimensions) {
            if (dimension.isDescending()) {
                dimension.reverse();
                this.array = this.array.flip(i);
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.array = this.array.copy();
        }
    }

    public DimArray section(int[] origin, int[] size, int[] stride) throws InvalidRangeException {
        Array r = this.array.section(origin, size, stride);
        Array rr = Array.factory((DataType)r.getDataType(), (int[])r.getShape());
        MAMath.copy((Array)rr, (Array)r);
        Section section = new Section(origin, size, stride);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        for (int i = 0; i < section.getRank(); ++i) {
            Range range = section.getRange(i);
            if (range.length() <= 1) continue;
            Dimension dim = this.dimensions.get(i).extract(range);
            dims.add(dim);
        }
        return new DimArray(rr, dims);
    }

    public DimArray section(List<Range> ranges) throws InvalidRangeException {
        Array r = this.array.section(ranges);
        Array rr = Array.factory((DataType)r.getDataType(), (int[])r.getShape());
        MAMath.copy((Array)rr, (Array)r);
        Section section = new Section(ranges);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        for (int i = 0; i < section.getRank(); ++i) {
            Range range = section.getRange(i);
            if (range.length() <= 1) continue;
            Dimension dim = this.dimensions.get(i).extract(range);
            dims.add(dim);
        }
        return new DimArray(rr, dims);
    }

    public String toString() {
        return this.array.toString();
    }
}

