/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.hysplit;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.Extent;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IStationDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.dataframe.Column;
import org.meteoinfo.dataframe.ColumnIndex;
import org.meteoinfo.dataframe.DataFrame;
import org.meteoinfo.dataframe.Index;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;

public class HYSPLITPartDataInfo
extends DataInfo
implements IStationDataInfo {
    private List<List<Integer>> _parameters = new ArrayList<List<Integer>>();
    private int skipNBytes = 4;

    public HYSPLITPartDataInfo() {
        this.setDataType(MeteoDataType.HYSPLIT_PARTICLE);
    }

    public int getSkipNBytes() {
        return this.skipNBytes;
    }

    public void setSkipNBytes(int value) {
        this.skipNBytes = value;
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        return false;
    }

    @Override
    public void readDataInfo(String fileName) {
        try {
            this.setFileName(fileName);
            RandomAccessFile br = new RandomAccessFile(fileName, "r");
            ArrayList<LocalDateTime> times = new ArrayList<LocalDateTime>();
            this._parameters = new ArrayList<List<Integer>>();
            ArrayList<Variable> variables = new ArrayList<Variable>();
            this.addAttribute(new Attribute("data_format", "HYSPLIT Particles"));
            int i = 0;
            String[] varNames = new String[]{"lat", "lon", "height", "sigma_h", "vel_w", "vel_v"};
            while (br.getFilePointer() < br.length() - 28L) {
                int pos = (int)br.getFilePointer();
                br.skipBytes(4);
                int particleNum = br.readInt();
                int pollutantNum = br.readInt();
                int year = br.readInt();
                int month = br.readInt();
                int day = br.readInt();
                int hour = br.readInt();
                year = year < 50 ? 2000 + year : 1900 + year;
                times.add(LocalDateTime.of(year, month, day, hour, 0, 0));
                ArrayList<Integer> data = new ArrayList<Integer>();
                data.add(particleNum);
                data.add(pollutantNum);
                data.add(pos);
                this._parameters.add(data);
                Dimension dim = new Dimension();
                dim.setName(String.format("pnum_t%d", i));
                dim.setValues(new float[particleNum]);
                this.addDimension(dim);
                for (String varName : varNames) {
                    Variable var = new Variable();
                    var.setStation(true);
                    var.setName(String.format("%s_t%d", varName, i));
                    var.setDimension(dim);
                    var.setDataType(DataType.FLOAT);
                    var.addAttribute(new Attribute("time_index", i));
                    switch (varName.toLowerCase()) {
                        case "lon": {
                            var.setDimVar(true);
                            var.addAttribute("long_name", "longitude");
                            var.addAttribute("units", "degrees_east");
                            break;
                        }
                        case "lat": {
                            var.setDimVar(true);
                            var.addAttribute("long_name", "latitude");
                            var.addAttribute("units", "degrees_north");
                            break;
                        }
                        case "height": {
                            var.setDimVar(true);
                            var.addAttribute("long_name", "height above ground");
                            var.addAttribute("units", "meter");
                            break;
                        }
                        case "sigma_h": {
                            var.setDimVar(true);
                            var.addAttribute("long_name", "horizontal puff size");
                            var.addAttribute("units", "meter");
                            break;
                        }
                        case "vel_w": {
                            var.setDimVar(true);
                            var.addAttribute("long_name", "current value for the turbulent velocity in the vertical");
                            var.addAttribute("units", "m/s");
                            break;
                        }
                        case "vel_v": {
                            var.setDimVar(true);
                            var.addAttribute("long_name", "current value for the turbulent velocity in the horizontal");
                            var.addAttribute("units", "m/s");
                        }
                    }
                    variables.add(var);
                }
                int len = (8 + pollutantNum * 4 + 60) * particleNum + 4;
                br.skipBytes(len += this.skipNBytes);
                ++i;
            }
            br.close();
            Array tArray = Array.factory((DataType)DataType.DATE, (int[])new int[]{times.size()});
            IndexIterator iter = tArray.getIndexIterator();
            for (LocalDateTime t : times) {
                iter.setDateNext(t);
            }
            Dimension tDim = new Dimension(DimensionType.T);
            tDim.setDimValue(tArray);
            this.setTimeDimension(tDim);
            this.addDimension(tDim);
            this.setVariables(variables);
        }
        catch (IOException ex) {
            Logger.getLogger(HYSPLITPartDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public Array realRead(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.realRead(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array realRead(String varName, int[] origin, int[] size, int[] stride) {
        try {
            Variable var = this.getVariable(varName);
            int timeIdx = (Integer)var.findAttribute("time_index").getNumericValue();
            int particleNum = this._parameters.get(timeIdx).get(0);
            int pollutantNum = this._parameters.get(timeIdx).get(1);
            int pos = this._parameters.get(timeIdx).get(2);
            Array r = Array.factory((DataType)var.getDataType(), (int[])new int[]{particleNum});
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            br.seek(pos);
            br.skipBytes(28 + this.skipNBytes);
            for (int i = 0; i < particleNum; ++i) {
                br.skipBytes(8);
                for (int j = 0; j < pollutantNum; ++j) {
                    br.skipBytes(4);
                }
                br.skipBytes(8);
                float lat = br.readFloat();
                float lon = br.readFloat();
                float alt = br.readFloat();
                float sigma_h = br.readFloat();
                float vel_w = br.readFloat();
                float vel_v = br.readFloat();
                if (varName.startsWith("lon")) {
                    r.setFloat(i, lon);
                } else if (varName.startsWith("lat")) {
                    r.setFloat(i, lat);
                } else if (varName.startsWith("height")) {
                    r.setFloat(i, alt);
                } else if (varName.startsWith("sigma_h")) {
                    r.setFloat(i, sigma_h);
                } else if (varName.startsWith("vel_w")) {
                    r.setFloat(i, vel_w);
                } else if (varName.startsWith("vel_v")) {
                    r.setFloat(i, vel_v);
                }
                br.skipBytes(28);
            }
            return r;
        }
        catch (IOException e) {
            return null;
        }
    }

    public DataFrame readDataFrame(int timeIdx) {
        try {
            int particleNum = this._parameters.get(timeIdx).get(0);
            int pollutantNum = this._parameters.get(timeIdx).get(1);
            int pos = this._parameters.get(timeIdx).get(2);
            ArrayList<Array> data = new ArrayList<Array>();
            ColumnIndex columns = new ColumnIndex();
            for (Variable var : this.variables) {
                if ((Integer)var.findAttribute("time_index").getNumericValue() != timeIdx) continue;
                columns.add((Object)new Column(var.getName(), var.getDataType()));
                data.add(Array.factory((DataType)var.getDataType(), (int[])new int[]{particleNum}));
            }
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            br.seek(pos);
            br.skipBytes(28 + this.skipNBytes);
            for (int i = 0; i < particleNum; ++i) {
                br.skipBytes(8);
                for (int j = 0; j < pollutantNum; ++j) {
                    br.skipBytes(4);
                }
                br.skipBytes(8);
                float lat = br.readFloat();
                float lon = br.readFloat();
                float alt = br.readFloat();
                float sigma_h = br.readFloat();
                float vel_w = br.readFloat();
                float vel_v = br.readFloat();
                ((Array)data.get(0)).setFloat(i, lat);
                ((Array)data.get(1)).setFloat(i, lon);
                ((Array)data.get(2)).setFloat(i, alt);
                ((Array)data.get(3)).setFloat(i, sigma_h);
                ((Array)data.get(4)).setFloat(i, vel_w);
                ((Array)data.get(5)).setFloat(i, vel_v);
                br.skipBytes(28);
            }
            Index index = Index.factory((int)particleNum);
            DataFrame df = new DataFrame(data, index, columns);
            return df;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public StationData getStationData(int timeIdx, String varName, int levelIdx) {
        try {
            StationData stationData = new StationData();
            ArrayList<String> stations = new ArrayList<String>();
            int particleNum = this._parameters.get(timeIdx).get(0);
            int pollutantNum = this._parameters.get(timeIdx).get(1);
            int pos = this._parameters.get(timeIdx).get(2);
            double[][] discreteData = new double[particleNum][6];
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            float minX = 0.0f;
            float maxX = 0.0f;
            float minY = 0.0f;
            float maxY = 0.0f;
            br.seek(pos);
            br.skipBytes(28 + this.skipNBytes);
            for (int i = 0; i < particleNum; ++i) {
                br.skipBytes(8);
                for (int j = 0; j < pollutantNum; ++j) {
                    br.skipBytes(4);
                }
                br.skipBytes(8);
                float lat = br.readFloat();
                float lon = br.readFloat();
                float alt = br.readFloat();
                float sigma_h = br.readFloat();
                float vel_w = br.readFloat();
                float vel_v = br.readFloat();
                discreteData[i][0] = lon;
                discreteData[i][1] = lat;
                discreteData[i][2] = alt;
                discreteData[i][3] = sigma_h;
                discreteData[i][4] = vel_w;
                discreteData[i][5] = vel_v;
                stations.add("P" + String.valueOf(i + 1));
                br.skipBytes(40);
                if (i == 0) {
                    maxX = minX = lon;
                    maxY = minY = lat;
                    continue;
                }
                if (minX > lon) {
                    minX = lon;
                } else if (maxX < lon) {
                    maxX = lon;
                }
                if (minY > lat) {
                    minY = lat;
                    continue;
                }
                if (!(maxY < lat)) continue;
                maxY = lat;
            }
            Extent dataExtent = new Extent();
            dataExtent.minX = minX;
            dataExtent.maxX = maxX;
            dataExtent.minY = minY;
            dataExtent.maxY = maxY;
            br.close();
            stationData.data = discreteData;
            stationData.dataExtent = dataExtent;
            stationData.stations = stations;
            return stationData;
        }
        catch (IOException ex) {
            Logger.getLogger(HYSPLITPartDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public StationInfoData getStationInfoData(int timeIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public StationModelData getStationModelData(int timeIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

