/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.radar;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.radar.BaseRadarDataInfo;
import org.meteoinfo.data.meteodata.radar.IRadarDataInfo;
import org.meteoinfo.data.meteodata.radar.RadarDataType;
import org.meteoinfo.data.meteodata.radar.RadialRecord;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.math.ArrayUtil;

public class CCRadarDataInfo
extends BaseRadarDataInfo
implements IRadarDataInfo {
    private List<CutConfig> cutConfigs;
    private int radarHeaderSize = 1024;
    private int perRadialSize = 3000;
    private int messageHeaderSize = 28;

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        return false;
    }

    void setScaleOffset(RadialRecord record) {
        switch (record.product) {
            case "dBZ": 
            case "V": 
            case "W": {
                record.scale = 0.1f;
                record.offset = 0.0f;
            }
        }
    }

    @Override
    void readDataInfo(InputStream is) {
        try {
            byte[] headerBytes = new byte[this.radarHeaderSize];
            is.read(headerBytes);
            byte[] bytes = Arrays.copyOf(headerBytes, RadarHeader.length);
            RadarHeader radarHeader = new RadarHeader(bytes);
            int sweepN = radarHeader.getSweepNumber();
            this.cutConfigs = new ArrayList<CutConfig>();
            int idx = RadarHeader.length;
            for (int i = 0; i < sweepN; ++i) {
                bytes = Arrays.copyOfRange(headerBytes, idx, idx + CutConfig.length);
                idx += CutConfig.length;
                CutConfig cutConfig = new CutConfig(bytes);
                this.cutConfigs.add(cutConfig);
                if (i != 0) continue;
                this.logResolution = cutConfig.usBindWidth;
                this.dopplerResolution = cutConfig.usBindWidth;
            }
            idx = 878;
            bytes = Arrays.copyOfRange(headerBytes, idx, idx + RadarHeader2.length);
            RadarHeader2 radarHeader2 = new RadarHeader2(bytes);
            ArrayList<String> products = new ArrayList<String>(Arrays.asList("dBZ", "V", "W"));
            for (String product : products) {
                RadialRecord record = new RadialRecord(product);
                record.setRadarDataType(RadarDataType.CC);
                record.setBinLength(2);
                record.setDataType(DataType.SHORT);
                this.setScaleOffset(record);
                this.recordMap.put(product, record);
            }
            for (int i = 0; i < sweepN; ++i) {
                CutConfig cutConfig = this.cutConfigs.get(i);
                int radialN = cutConfig.usBinNumber;
                float azimuth = 0.0f;
                float aDelta = 360.0f / (float)cutConfig.usRecordNumber;
                for (int j = 0; j < cutConfig.usRecordNumber; ++j) {
                    bytes = new byte[this.perRadialSize];
                    is.read(bytes);
                    idx = 0;
                    for (String product : products) {
                        RadialRecord record = (RadialRecord)this.recordMap.get(product);
                        if (j == 0) {
                            record.fixedElevation.add(Float.valueOf(cutConfig.getAngle()));
                            record.elevation.add(new ArrayList());
                            record.azimuth.add(new ArrayList());
                            record.azimuthMinIndex.add(0);
                            record.disResolution.add(Float.valueOf(cutConfig.usBindWidth));
                            record.distance.add(ArrayUtil.arrayRange1((Number)300, (int)radialN, (Number)cutConfig.usBindWidth));
                            record.newScanData();
                        }
                        record.elevation.get(record.elevation.size() - 1).add(Float.valueOf(cutConfig.getAngle()));
                        record.addAzimuth(azimuth);
                        byte[] data = Arrays.copyOfRange(bytes, idx, idx + 2 * radialN);
                        idx += 2 * radialN;
                        Array dataArray = Array.factory((DataType)record.getDataType(), (int[])new int[]{radialN});
                        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        for (int k = 0; k < radialN; ++k) {
                            dataArray.setShort(k, byteBuffer.getShort());
                        }
                        record.addDataArray(dataArray);
                    }
                    azimuth += aDelta;
                }
            }
            is.close();
            this.addAttribute(new Attribute("Country", radarHeader.cCountry));
            this.addAttribute(new Attribute("Province", radarHeader.cProvince));
            this.addAttribute(new Attribute("StationName", radarHeader.cStation));
            this.addAttribute(new Attribute("StationCode", radarHeader.cStationNumber));
            this.addAttribute(new Attribute("StationLongitude", Float.valueOf(radarHeader.getLongitude())));
            this.addAttribute(new Attribute("StationLatitude", Float.valueOf(radarHeader.getLatitude())));
            this.addAttribute(new Attribute("AntennaHeight", Float.valueOf(radarHeader.getHeight())));
            this.addAttribute(new Attribute("featureType", "RADIAL"));
            this.addAttribute(new Attribute("DataType", "Radial"));
            this.addAttribute(new Attribute("RadarDataType", "CC"));
            RadialRecord refRadialRecord = (RadialRecord)this.recordMap.get("dBZ");
            this.radialDim = new Dimension();
            this.radialDim.setName("radial");
            this.radialDim.setLength(refRadialRecord.getMaxRadials());
            this.addDimension(this.radialDim);
            this.scanDim = new Dimension();
            this.scanDim.setName("scan");
            this.scanDim.setLength(refRadialRecord.getScanNumber());
            this.addDimension(this.scanDim);
            this.gateRDim = new Dimension();
            this.gateRDim.setName("gateR");
            this.gateRDim.setLength(refRadialRecord.getGateNumber(0));
            this.addDimension(this.gateRDim);
            this.makeRefVariables(refRadialRecord);
            RadialRecord velRadialRecord = (RadialRecord)this.recordMap.get("V");
            this.gateVDim = new Dimension();
            this.gateVDim.setName("gateV");
            this.gateVDim.setLength(velRadialRecord.getGateNumber(0));
            this.addDimension(this.gateVDim);
            this.makeVelVariables(velRadialRecord);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RadarDataType getRadarDataType() {
        return RadarDataType.CC;
    }

    static class RadarHeader2 {
        public static int length = 146;
        public byte[] remain2;
        public int lAntennaG;
        public int lPower;
        public int lWavelength;
        public int usBeamH;
        public int usBeamL;
        public int usPolarization;
        public int usLogA;
        public int usLineA;
        public int usAGCP;
        public int usFreqMode;
        public int usFreqRepeat;
        public int usPPPPulse;
        public int usFFTPoint;
        public int usProcessType;
        public short ucClutterT;
        public short cSidelobe;
        public short ucVelocityT;
        public short ucFilderP;
        public short ucNoiseT;
        public short ucSQIT;
        public short ucIntensityC;
        public short ucIntensityR;
        public short ucCalNoise;
        public short ucCalPower;
        public short ucCalPulseWidth;
        public short ucCalWorkFreq;
        public short ucCalLog;
        public byte[] remain3;
        public int liDataOffset;
        public byte[] remain4;

        public RadarHeader2(byte[] bytes) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.position(2);
            this.lAntennaG = byteBuffer.getInt();
            this.lPower = byteBuffer.getInt();
            this.lWavelength = byteBuffer.getInt();
            this.usBeamH = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            this.usBeamL = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            this.usPolarization = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            this.usLogA = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            this.usLineA = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            this.usAGCP = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            this.usFreqMode = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            this.usFreqRepeat = DataType.unsignedShortToInt((short)byteBuffer.getShort());
        }
    }

    static class CutConfig {
        public static int length = 22;
        public int usMaxV;
        public int usMaxL;
        public int usBindWidth;
        public int usBinNumber;
        public int usRecordNumber;
        public int usArotate;
        public int usPrf1;
        public int usPrf2;
        public int usSpulseW;
        public short usAngle;
        public short cSweepStatus;
        public short cAmbiguousp;

        public CutConfig(byte[] bytes) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.usMaxV = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            this.usMaxL = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            this.usBindWidth = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            this.usBinNumber = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            this.usRecordNumber = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            this.usArotate = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            this.usPrf1 = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            this.usPrf2 = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            this.usSpulseW = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            this.usAngle = byteBuffer.getShort();
            this.cSweepStatus = DataType.unsignedByteToShort((byte)byteBuffer.get());
            this.cAmbiguousp = DataType.unsignedByteToShort((byte)byteBuffer.get());
        }

        public float getAngle() {
            return (float)this.usAngle / 100.0f;
        }
    }

    static class RadarHeader {
        public static int length = 218;
        public String cFileType;
        public String cCountry;
        public String cProvince;
        public String cStation;
        public String cStationNumber;
        public String cRadarType;
        public String cLongitude;
        public String cLatitude;
        public int lLongitudeValue;
        public int lLatitudeValue;
        public int lHeight;
        public short sMaxAngle;
        public short sOptAngle;
        public short ucSYear1;
        public short ucSYear2;
        public short ucSMonth;
        public short ucSDay;
        public short ucSHour;
        public short ucSMinute;
        public short ucSSecond;
        public short ucTimeFrom;
        public short ucEYear1;
        public short ucEYear2;
        public short ucEMonth;
        public short ucEDay;
        public short ucEHour;
        public short ucEMinute;
        public short ucESecond;
        public short ucScanMode;
        public int ulSmilliSecond;
        public short usRHIA;
        public short sRHIL;
        public short sRHIH;
        public int usEchoType;
        public int usProdCode;
        public short ucCalibration;
        public byte[] remain1;

        public RadarHeader(byte[] bytes) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            bytes = new byte[16];
            byteBuffer.get(bytes);
            this.cFileType = new String(bytes);
            bytes = new byte[30];
            byteBuffer.get(bytes);
            this.cCountry = new String(bytes, "GB2312");
            bytes = new byte[20];
            byteBuffer.get(bytes);
            this.cProvince = new String(bytes, "GB2312");
            bytes = new byte[40];
            byteBuffer.get(bytes);
            this.cStation = new String(bytes, "GB2312");
            bytes = new byte[10];
            byteBuffer.get(bytes);
            this.cStationNumber = new String(bytes, "GB2312");
            bytes = new byte[20];
            byteBuffer.get(bytes);
            this.cRadarType = new String(bytes, "GB2312");
            bytes = new byte[16];
            byteBuffer.get(bytes);
            this.cLongitude = new String(bytes, "GB2312");
            bytes = new byte[16];
            byteBuffer.get(bytes);
            this.cLatitude = new String(bytes, "GB2312");
            this.lLongitudeValue = byteBuffer.getInt();
            this.lLatitudeValue = byteBuffer.getInt();
            this.lHeight = byteBuffer.getInt();
            this.sMaxAngle = byteBuffer.getShort();
            this.sOptAngle = byteBuffer.getShort();
            this.ucSYear1 = DataType.unsignedByteToShort((byte)byteBuffer.get());
            this.ucSYear2 = DataType.unsignedByteToShort((byte)byteBuffer.get());
            this.ucSMonth = DataType.unsignedByteToShort((byte)byteBuffer.get());
            this.ucSDay = DataType.unsignedByteToShort((byte)byteBuffer.get());
            this.ucSHour = DataType.unsignedByteToShort((byte)byteBuffer.get());
            this.ucSMinute = DataType.unsignedByteToShort((byte)byteBuffer.get());
            this.ucSSecond = DataType.unsignedByteToShort((byte)byteBuffer.get());
            this.ucTimeFrom = DataType.unsignedByteToShort((byte)byteBuffer.get());
            this.ucEYear1 = DataType.unsignedByteToShort((byte)byteBuffer.get());
            this.ucEYear2 = DataType.unsignedByteToShort((byte)byteBuffer.get());
            this.ucEMonth = DataType.unsignedByteToShort((byte)byteBuffer.get());
            this.ucEDay = DataType.unsignedByteToShort((byte)byteBuffer.get());
            this.ucEHour = DataType.unsignedByteToShort((byte)byteBuffer.get());
            this.ucEMinute = DataType.unsignedByteToShort((byte)byteBuffer.get());
            this.ucESecond = DataType.unsignedByteToShort((byte)byteBuffer.get());
            this.ucScanMode = DataType.unsignedByteToShort((byte)byteBuffer.get());
            if (this.ucScanMode < 100 && this.ucScanMode != 10) {
                throw new IOException("Error reading CINRAD CC data: Unsupported product: RHI/FFT");
            }
            this.ulSmilliSecond = byteBuffer.getInt();
            this.usRHIA = byteBuffer.getShort();
            this.sRHIL = byteBuffer.getShort();
            this.sRHIH = byteBuffer.getShort();
            this.usEchoType = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            if (this.usEchoType != 16522) {
                throw new IOException("Error reading CINRAD CC data: Unsupported level 2 data");
            }
            this.usProdCode = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            if (this.usProdCode != 32771) {
                throw new IOException("Error reading CINRAD CC data: Unsupported product: RHI/FFT");
            }
            this.ucCalibration = DataType.unsignedByteToShort((byte)byteBuffer.get());
        }

        public float getLongitude() {
            return (float)this.lLongitudeValue / 3600000.0f;
        }

        public float getLatitude() {
            return (float)this.lLatitudeValue / 3600000.0f;
        }

        public float getHeight() {
            return (float)this.lHeight / 1000.0f;
        }

        public LocalDateTime getStartTime() {
            int sYear = this.ucSYear1 * 100 + this.ucSYear2;
            return LocalDateTime.of(sYear, this.ucSMonth, (int)this.ucSDay, (int)this.ucSHour, (int)this.ucSMinute, (int)this.ucSSecond);
        }

        public LocalDateTime getEndTime() {
            int eYear = this.ucEYear1 * 100 + this.ucEYear2;
            return LocalDateTime.of(eYear, this.ucEMonth, (int)this.ucEDay, (int)this.ucEHour, (int)this.ucEMinute, (int)this.ucESecond);
        }

        public int getSweepNumber() {
            int sweepN = 0;
            if (this.ucScanMode == 10) {
                sweepN = 1;
            } else if (this.ucScanMode >= 100) {
                sweepN = this.ucScanMode - 100;
            }
            return sweepN;
        }
    }
}

