/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray;

import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.ArrayChar;
import org.meteoinfo.ndarray.ArrayObject;
import org.meteoinfo.ndarray.ArrayStructureBak;
import org.meteoinfo.ndarray.ArrayStructureW;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.StructureData;
import org.meteoinfo.ndarray.StructureDataA;
import org.meteoinfo.ndarray.StructureMembers;

public class ArraySequenceNested
extends ArrayStructureBak {
    private int[] sequenceLen;
    private int[] sequenceOffset;
    private int total = 0;

    public ArraySequenceNested(StructureMembers members, int nseq) {
        super(members, new int[]{nseq});
        this.sequenceLen = new int[nseq];
    }

    @Override
    protected StructureData makeStructureData(ArrayStructureBak as, int index) {
        return new StructureDataA(as, index);
    }

    @Override
    public StructureData getStructureData(int index) {
        return new StructureDataA(this, index);
    }

    public void setSequenceLength(int outerIndex, int len) {
        this.sequenceLen[outerIndex] = len;
    }

    public int getSequenceLength(int outerIndex) {
        return this.sequenceLen[outerIndex];
    }

    public int getSequenceOffset(int outerIndex) {
        return this.sequenceOffset[outerIndex];
    }

    public void finish() {
        int i;
        this.sequenceOffset = new int[this.nelems];
        this.total = 0;
        for (i = 0; i < this.nelems; ++i) {
            this.sequenceOffset[i] = this.total;
            this.total += this.sequenceLen[i];
        }
        this.sdata = new StructureData[this.nelems];
        for (i = 0; i < this.nelems; ++i) {
            this.sdata[i] = new StructureDataA(this, this.sequenceOffset[i]);
        }
        for (StructureMembers.Member m : this.members.getMembers()) {
            int[] mShape = m.getShape();
            int[] shape = new int[mShape.length + 1];
            shape[0] = this.total;
            System.arraycopy(mShape, 0, shape, 1, mShape.length);
            Array data = ArraySequenceNested.factory(m.getDataType(), shape);
            m.setDataArray(data);
        }
    }

    public int getTotalNumberOfStructures() {
        return this.total;
    }

    public ArrayStructureBak flatten() {
        ArrayStructureW aw = new ArrayStructureW(this.getStructureMembers(), new int[]{this.total});
        for (int i = 0; i < this.total; ++i) {
            StructureDataA sdata = new StructureDataA(this, i);
            aw.setStructureData(sdata, i);
        }
        return aw;
    }

    @Override
    public double getScalarDouble(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.DOUBLE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be double");
        }
        Array data = m.getDataArray();
        return data.getDouble(recnum * m.getSize());
    }

    @Override
    public double[] getJavaArrayDouble(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.DOUBLE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be double");
        }
        int count = m.getSize();
        Array data = m.getDataArray();
        double[] pa = new double[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getDouble(recnum * count + i);
        }
        return pa;
    }

    @Override
    public float getScalarFloat(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.FLOAT) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be float");
        }
        Array data = m.getDataArray();
        return data.getFloat(recnum * m.getSize());
    }

    @Override
    public float[] getJavaArrayFloat(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.FLOAT) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be float");
        }
        int count = m.getSize();
        Array data = m.getDataArray();
        float[] pa = new float[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getFloat(recnum * count + i);
        }
        return pa;
    }

    @Override
    public byte getScalarByte(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.BYTE && m.getDataType() != DataType.ENUM1) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be byte");
        }
        Array data = m.getDataArray();
        return data.getByte(recnum * m.getSize());
    }

    @Override
    public byte[] getJavaArrayByte(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.BYTE && m.getDataType() != DataType.ENUM1) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be byte");
        }
        int count = m.getSize();
        Array data = m.getDataArray();
        byte[] pa = new byte[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getByte(recnum * count + i);
        }
        return pa;
    }

    @Override
    public short getScalarShort(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.SHORT && m.getDataType() != DataType.ENUM2) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be short");
        }
        Array data = m.getDataArray();
        return data.getShort(recnum * m.getSize());
    }

    @Override
    public short[] getJavaArrayShort(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.SHORT && m.getDataType() != DataType.ENUM2) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be short");
        }
        int count = m.getSize();
        Array data = m.getDataArray();
        short[] pa = new short[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getShort(recnum * count + i);
        }
        return pa;
    }

    @Override
    public int getScalarInt(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.INT && m.getDataType() != DataType.ENUM4) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be int");
        }
        Array data = m.getDataArray();
        return data.getInt(recnum * m.getSize());
    }

    @Override
    public int[] getJavaArrayInt(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.INT && m.getDataType() != DataType.ENUM4) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be int");
        }
        int count = m.getSize();
        Array data = m.getDataArray();
        int[] pa = new int[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getInt(recnum * count + i);
        }
        return pa;
    }

    @Override
    public long getScalarLong(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.LONG) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be long");
        }
        Array data = m.getDataArray();
        return data.getLong(recnum * m.getSize());
    }

    @Override
    public long[] getJavaArrayLong(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.LONG) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be long");
        }
        int count = m.getSize();
        Array data = m.getDataArray();
        long[] pa = new long[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getLong(recnum * count + i);
        }
        return pa;
    }

    @Override
    public char getScalarChar(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be char");
        }
        Array data = m.getDataArray();
        return data.getChar(recnum * m.getSize());
    }

    @Override
    public char[] getJavaArrayChar(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be char");
        }
        int count = m.getSize();
        Array data = m.getDataArray();
        char[] pa = new char[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getChar(recnum * count + i);
        }
        return pa;
    }

    @Override
    public String getScalarString(int recnum, StructureMembers.Member m) {
        if (m.getDataType() == DataType.CHAR) {
            ArrayChar data = (ArrayChar)m.getDataArray();
            return data.getString(recnum);
        }
        if (m.getDataType() == DataType.STRING) {
            ArrayObject data = (ArrayObject)m.getDataArray();
            return (String)data.getObject(recnum);
        }
        throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be String or char");
    }

    @Override
    public String[] getJavaArrayString(int recnum, StructureMembers.Member m) {
        int n = m.getSize();
        String[] result = new String[n];
        if (m.getDataType() == DataType.CHAR) {
            ArrayChar data = (ArrayChar)m.getDataArray();
            for (int i = 0; i < n; ++i) {
                result[i] = data.getString(recnum * n + i);
            }
            return result;
        }
        if (m.getDataType() == DataType.STRING) {
            Array data = m.getDataArray();
            for (int i = 0; i < n; ++i) {
                result[i] = (String)data.getObject(recnum * n + i);
            }
            return result;
        }
        throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be String or char");
    }

    @Override
    public StructureData getScalarStructure(int recnum, StructureMembers.Member m) {
        if (m.getDataType() == DataType.STRUCTURE) {
            ArrayStructureBak data = (ArrayStructureBak)m.getDataArray();
            return data.getStructureData(recnum * m.getSize());
        }
        throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be Structure");
    }

    @Override
    public ArrayStructureBak getArrayStructure(int recnum, StructureMembers.Member m) {
        if (m.getDataType() == DataType.STRUCTURE) {
            ArrayStructureBak data = (ArrayStructureBak)m.getDataArray();
            int count = m.getSize();
            StructureData[] sdata = new StructureData[count];
            for (int i = 0; i < count; ++i) {
                sdata[i] = data.getStructureData(recnum * count + i);
            }
            return new ArrayStructureW(data.getStructureMembers(), m.getShape(), sdata);
        }
        throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be Structure");
    }
}

