/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray.io.matlab;

import com.google.common.base.Charsets;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.util.Bytes;

public class MatLabUtil {
    public static DataType fromMatLabDataType(MatlabType matlabType) {
        switch (matlabType) {
            case Int8: 
            case Int16: 
            case Int32: {
                return DataType.INT;
            }
            case Int64: {
                return DataType.LONG;
            }
            case UInt8: 
            case UInt16: 
            case UInt32: {
                return DataType.UINT;
            }
            case UInt64: {
                return DataType.ULONG;
            }
            case Single: {
                return DataType.FLOAT;
            }
            case Double: {
                return DataType.DOUBLE;
            }
        }
        return DataType.OBJECT;
    }

    public static Array fromMatLabArray(Matrix matArray) {
        DataType dataType = MatLabUtil.fromMatLabDataType(matArray.getType());
        int[] shape = matArray.getDimensions();
        int ndim = shape.length;
        Array array = Array.factory(dataType, shape);
        Index index = array.getIndex();
        switch (dataType) {
            case INT: 
            case UINT: {
                int j;
                int[] current;
                int i = 0;
                while ((long)i < array.getSize()) {
                    array.setInt(index, matArray.getInt(i));
                    current = index.getCurrentCounter();
                    for (j = 0; j < ndim; ++j) {
                        if (current[j] < shape[j] - 1) {
                            current[j] = current[j] + 1;
                            break;
                        }
                        current[j] = 0;
                    }
                    index.set(current);
                    ++i;
                }
                break;
            }
            case LONG: 
            case ULONG: {
                int j;
                int[] current;
                int i = 0;
                while ((long)i < array.getSize()) {
                    array.setLong(index, matArray.getLong(i));
                    current = index.getCurrentCounter();
                    for (j = 0; j < ndim; ++j) {
                        if (current[j] < shape[j] - 1) {
                            current[j] = current[j] + 1;
                            break;
                        }
                        current[j] = 0;
                    }
                    index.set(current);
                    ++i;
                }
                break;
            }
            case FLOAT: {
                int j;
                int[] current;
                int i = 0;
                while ((long)i < array.getSize()) {
                    array.setFloat(index, matArray.getFloat(i));
                    current = index.getCurrentCounter();
                    for (j = 0; j < ndim; ++j) {
                        if (current[j] < shape[j] - 1) {
                            current[j] = current[j] + 1;
                            break;
                        }
                        current[j] = 0;
                    }
                    index.set(current);
                    ++i;
                }
                break;
            }
            case DOUBLE: {
                int j;
                int[] current;
                int i = 0;
                while ((long)i < array.getSize()) {
                    array.setDouble(index, matArray.getDouble(i));
                    current = index.getCurrentCounter();
                    for (j = 0; j < ndim; ++j) {
                        if (current[j] < shape[j] - 1) {
                            current[j] = current[j] + 1;
                            break;
                        }
                        current[j] = 0;
                    }
                    index.set(current);
                    ++i;
                }
                break;
            }
        }
        if (ndim >= 3) {
            int[] shapeIdx = new int[ndim];
            int idx = 0;
            int i = ndim - 1;
            while (i > 1) {
                shapeIdx[idx] = i--;
                ++idx;
            }
            shapeIdx[idx] = 0;
            shapeIdx[idx + 1] = 1;
            array = array.permute(shapeIdx);
        }
        return array;
    }

    public static String parseAsciiString(byte[] buffer) {
        return MatLabUtil.parseAsciiString(buffer, 0, buffer.length);
    }

    public static String parseAsciiString(byte[] buffer, int offset, int maxLength) {
        int length;
        for (length = Bytes.findFirst((byte[])buffer, (int)offset, (int)maxLength, (byte)0, (int)maxLength); length > 0 && buffer[length - 1] == 32; --length) {
        }
        return length == 0 ? "" : new String(buffer, offset, length, Charsets.US_ASCII);
    }
}

