/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.dataframe;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.dataframe.Column;
import org.meteoinfo.dataframe.DateTimeIndex;
import org.meteoinfo.dataframe.Index;
import org.meteoinfo.dataframe.IntIndex;
import org.meteoinfo.dataframe.SeriesGroupBy;
import org.meteoinfo.dataframe.impl.Grouping;
import org.meteoinfo.dataframe.impl.KeyFunction;
import org.meteoinfo.dataframe.impl.TimeFunction;
import org.meteoinfo.dataframe.impl.TimeFunctions;
import org.meteoinfo.dataframe.impl.Views;
import org.meteoinfo.dataframe.impl.WindowFunction;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.math.ArrayMath;

public class Series
implements Iterable {
    private Index index;
    private Array data;
    private String name;

    public Series(Array data, Index index, String name) {
        this.data = data;
        this.index = index;
        this.name = name;
    }

    public Series(Array data, List idxValue, String name) {
        this(data, Index.factory(idxValue), name);
    }

    public Series(Array data, String name) {
        this(data, new IntIndex((int)data.getSize()), name);
    }

    public Array getData() {
        return this.data;
    }

    public void setData(Array value) {
        this.data = value;
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index value) {
        this.index = value;
    }

    public void setIndex(List value) {
        this.index = Index.factory(value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object getValue(int i) {
        return this.data.getObject(i);
    }

    public Object getValueByIndex(Object idxValue) {
        Index idx;
        Object[] rii = this.index.getIndices(idxValue);
        List ii = (List)rii[0];
        List rIndex = (List)rii[1];
        if (ii.size() == 1) {
            if ((Integer)ii.get(0) >= 0) {
                return this.data.getObject(((Integer)ii.get(0)).intValue());
            }
            return Double.NaN;
        }
        Array ra = Array.factory((DataType)this.data.getDataType(), (int[])new int[]{ii.size()});
        for (int i = 0; i < ii.size(); ++i) {
            if ((Integer)ii.get(i) < 0) {
                if (!ra.getDataType().isNumeric()) continue;
                ra.setObject(i, (Object)Double.NaN);
                continue;
            }
            ra.setObject(i, this.data.getObject(((Integer)ii.get(i)).intValue()));
        }
        if (this.index instanceof DateTimeIndex && !(idxValue instanceof LocalDateTime)) {
            ArrayList<LocalDateTime> values = new ArrayList<LocalDateTime>();
            for (String v : rIndex) {
                values.add(JDateUtil.getDateTime((String)v));
            }
            idx = Index.factory(values);
        } else {
            idx = Index.factory(rIndex);
        }
        idx.format = this.index.format;
        return new Series(ra, idx, this.name);
    }

    public void setValue(int i, Object v) {
        this.data.setObject(i, v);
    }

    public void setValue(Series s, Object v) {
        for (int i = 0; i < this.size(); ++i) {
            if (!((Boolean)s.getValue(i)).booleanValue()) continue;
            this.data.setObject(i, v);
        }
    }

    public Series getValues(List<Integer> ii) {
        Array ra = Array.factory((DataType)this.data.getDataType(), (int[])new int[]{ii.size()});
        for (int i = 0; i < ii.size(); ++i) {
            ra.setObject(i, this.data.getObject(ii.get(i).intValue()));
        }
        Index idx = this.index.subIndex(ii);
        return new Series(ra, idx, this.name);
    }

    public Series getValues(Range range) {
        Array ra = Array.factory((DataType)this.data.getDataType(), (int[])new int[]{range.length()});
        int i = 0;
        for (int ii = range.first(); ii <= range.last(); ii += range.stride()) {
            ra.setObject(i, this.data.getObject(ii));
            ++i;
        }
        Index idx = this.index.subIndex(range.first(), range.last() + 1, range.stride());
        return new Series(ra, idx, this.name);
    }

    public Series getValueByIndex(List idxValues) {
        Index idx;
        Object[] rii = this.index.getIndices(idxValues);
        List ii = (List)rii[2];
        List rIndex = (List)rii[3];
        Array ra = Array.factory((DataType)this.data.getDataType(), (int[])new int[]{ii.size()});
        for (int i = 0; i < ii.size(); ++i) {
            if ((Integer)ii.get(i) < 0) {
                if (!ra.getDataType().isNumeric()) continue;
                ra.setObject(i, (Object)Double.NaN);
                continue;
            }
            ra.setObject(i, this.data.getObject(((Integer)ii.get(i)).intValue()));
        }
        if (this.index instanceof DateTimeIndex && rIndex.get(0) instanceof String) {
            ArrayList<LocalDateTime> values = new ArrayList<LocalDateTime>();
            for (String v : rIndex) {
                values.add(JDateUtil.getDateTime((String)v));
            }
            idx = Index.factory(values);
        } else {
            idx = Index.factory(rIndex);
        }
        idx.format = this.index.format;
        return new Series(ra, idx, this.name);
    }

    public Series getValueByIndex_bak(List idxValues) {
        Index idx;
        Object[] rii = this.index.getIndices(idxValues);
        List ii = (List)rii[0];
        List rIndex = (List)rii[1];
        Array ra = Array.factory((DataType)this.data.getDataType(), (int[])new int[]{ii.size()});
        for (int i = 0; i < ii.size(); ++i) {
            if ((Integer)ii.get(i) < 0) {
                if (!ra.getDataType().isNumeric()) continue;
                ra.setObject(i, (Object)Double.NaN);
                continue;
            }
            ra.setObject(i, this.data.getObject(((Integer)ii.get(i)).intValue()));
        }
        if (this.index instanceof DateTimeIndex && rIndex.get(0) instanceof String) {
            ArrayList<LocalDateTime> values = new ArrayList<LocalDateTime>();
            for (String v : rIndex) {
                values.add(JDateUtil.getDateTime((String)v));
            }
            idx = Index.factory(values);
        } else {
            idx = Index.factory(rIndex);
        }
        idx.format = this.index.format;
        return new Series(ra, idx, this.name);
    }

    public Object getIndexValue(int i) {
        return this.index.get(i);
    }

    public Iterator iterator() {
        return this.iterrows();
    }

    public ListIterator<List<Object>> iterrows() {
        return new Views.ListView(this).listIterator();
    }

    public int size() {
        return this.index.size();
    }

    public Series replace(Object toReplace, Object value) {
        Array a = this.data.copy();
        ArrayMath.replaceValue((Array)a, (Object)toReplace, (Object)value);
        return new Series(a, (Index)this.index.clone(), this.name);
    }

    public SeriesGroupBy groupBy(KeyFunction function) {
        return new SeriesGroupBy(new Grouping(this, function), this);
    }

    public SeriesGroupBy groupBy() {
        return new SeriesGroupBy(new Grouping(this), this);
    }

    public SeriesGroupBy groupBy(TimeFunction function) {
        return new SeriesGroupBy(new Grouping(this, function), this);
    }

    public SeriesGroupBy groupBy(String tStr) {
        TimeFunction function = TimeFunctions.factory(tStr);
        if (function == null) {
            return null;
        }
        return this.groupBy(function);
    }

    public SeriesGroupBy resample(WindowFunction function) {
        ((DateTimeIndex)this.index).setResamplPeriod(function.getPeriod());
        return new SeriesGroupBy(new Grouping(this, function), this);
    }

    public SeriesGroupBy resample(String pStr) {
        TemporalAmount period = JDateUtil.getPeriod((String)pStr);
        WindowFunction function = new WindowFunction(period);
        return this.resample(function);
    }

    public Object mean() {
        return ArrayMath.mean((Array)this.data);
    }

    public Object max() {
        return ArrayMath.max((Array)this.data);
    }

    public Object min() {
        return ArrayMath.min((Array)this.data);
    }

    public Object stdDev() throws InvalidRangeException {
        return ArrayMath.std((Array)this.data);
    }

    public Series equal(Number v) {
        Array rdata = ArrayMath.equal((Array)this.data, (Number)v);
        Series r = new Series(rdata, this.index, this.name);
        return r;
    }

    public Series equal(String v) {
        Array rdata = ArrayMath.equal((Array)this.data, (String)v);
        Series r = new Series(rdata, this.index, this.name);
        return r;
    }

    public Series lessThan(Number v) {
        Array rdata = ArrayMath.lessThan((Array)this.data, (Number)v);
        Series r = new Series(rdata, this.index, this.name);
        return r;
    }

    public Series lessThanOrEqual(Number v) {
        Array rdata = ArrayMath.lessThanOrEqual((Array)this.data, (Number)v);
        Series r = new Series(rdata, this.index, this.name);
        return r;
    }

    public Series greaterThan(Number v) {
        Array rdata = ArrayMath.greaterThan((Array)this.data, (Number)v);
        Series r = new Series(rdata, this.index, this.name);
        return r;
    }

    public Series greaterThanOrEqual(Number v) {
        Array rdata = ArrayMath.greaterThanOrEqual((Array)this.data, (Number)v);
        Series r = new Series(rdata, this.index, this.name);
        return r;
    }

    public Series isIn(List values) {
        Array rdata = ArrayMath.isIn((Array)this.data, (List)values);
        Series r = new Series(rdata, this.index, this.name);
        return r;
    }

    public String head(int n) {
        StringBuilder sb = new StringBuilder();
        int rn = this.index.size();
        if (n > rn) {
            n = rn;
        }
        for (int r = 0; r < n; ++r) {
            sb.append(this.index.toString(r));
            sb.append("  ");
            sb.append(this.data.getObject(r).toString());
            sb.append("\n");
        }
        if (n < rn) {
            sb.append("...");
        }
        return sb.toString();
    }

    public String tail(int n) {
        StringBuilder sb = new StringBuilder();
        int rn = this.index.size();
        if (n > rn) {
            n = rn;
        }
        for (int r = rn - n; r < rn; ++r) {
            sb.append(this.index.toString(r));
            sb.append("  ");
            sb.append(this.data.getObject(r).toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.head(100);
    }

    public void saveCSV(String fileName, String delimiter, String dateFormat, String floatFormat, boolean index) throws IOException {
        BufferedWriter sw = new BufferedWriter(new FileWriter(new File(fileName)));
        String str = "";
        String idxFormat = this.index.format;
        if (index) {
            str = this.index.getName();
            if (dateFormat != null && this.index instanceof DateTimeIndex) {
                idxFormat = dateFormat;
            }
        }
        str = str.isEmpty() ? this.name : str + delimiter + this.name;
        sw.write(str);
        DataType dtype = this.data.getDataType();
        Column col = new Column(this.name, dtype);
        String format = dtype == DataType.FLOAT || dtype == DataType.DOUBLE ? (floatFormat == null ? col.getFormat() : floatFormat) : col.getFormat();
        int i = 0;
        while ((long)i < this.data.getSize()) {
            String line = "";
            if (index) {
                line = this.index.toString(i, idxFormat).trim();
            }
            String vstr = format == null ? this.getValue(i).toString() : String.format(format, this.getValue(i));
            line = line.isEmpty() ? vstr : line + delimiter + vstr;
            sw.newLine();
            sw.write(line);
            ++i;
        }
        sw.flush();
        sw.close();
    }
}

