/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.imep.verification;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.GridDataSetting;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.meteodata.MeteoDataInfo;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.grads.GrADSDataInfo;
import org.meteoinfo.geo.analysis.InterpolationMethods;
import org.meteoinfo.geo.analysis.InterpolationSetting;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.mapdata.MapDataManage;
import org.meteoinfo.geo.util.GeoMathUtil;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteothink.imep.global.Globals;
import org.meteothink.imep.verification.ContinuousMethod;
import org.meteothink.imep.verification.DataSourceType;
import org.meteothink.imep.verification.Dataset;
import org.meteothink.imep.verification.DichotomousMethod;
import org.meteothink.imep.verification.MethodType;
import org.meteothink.imep.verification.MultiCategoryMethod;
import org.meteothink.imep.verification.StatType;
import org.meteothink.imep.verification.TimeSelect;
import org.meteothink.imep.verification.VerifyCategory;
import org.meteothink.imep.verification.VerifyMethod;
import org.meteothink.imep.verification.VerifyStat;
import org.meteothink.imep.verification.VerifyTable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VerifyGroup
implements Cloneable {
    private String _name;
    private Dataset _obsDataset = new Dataset("Observation");
    private Dataset _fcstDataset = new Dataset("Forecast");
    private VerifyMethod _verifyMethod = new DichotomousMethod();
    private VerifyCategory _verifyCategory = VerifyCategory.Spatial;
    private StatType _statType = StatType.StationStat;
    private TimeSelect _timeSelect = TimeSelect.All;
    private boolean _isAllTime = true;
    private List<Integer> _timeIndices = new ArrayList<Integer>();
    private List<LocalDateTime> _times = new ArrayList<LocalDateTime>();
    private String _outFilePath;
    private MeteoDataInfo _obsDataInfo;
    private MeteoDataInfo _fcstDataInfo;
    private int _timeZone = 0;
    private String stFilterFile = "";
    private String _dataMaskFile = "";
    private String _statRegionFile = "";
    private boolean _isDatasetOpened = false;
    private boolean outputCateData = false;

    public VerifyGroup(String name) {
        this._name = name;
        this._obsDataset.setDataSourceType(DataSourceType.Observation);
        this._fcstDataset.setDataSourceType(DataSourceType.Forecast);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Dataset getObsDataset() {
        return this._obsDataset;
    }

    public void setObsDataset(Dataset value) {
        this._obsDataset = value;
        this._isDatasetOpened = false;
    }

    public Dataset getFcstDataset() {
        return this._fcstDataset;
    }

    public void setFcstDataset(Dataset value) {
        this._fcstDataset = value;
        this._isDatasetOpened = false;
    }

    public VerifyMethod getVerifyMethod() {
        return this._verifyMethod;
    }

    public void setVerifyMethod(VerifyMethod value) {
        this._verifyMethod = value;
    }

    public VerifyCategory getVerifyCategory() {
        return this._verifyCategory;
    }

    public void setVerifyCategory(VerifyCategory value) {
        this._verifyCategory = value;
    }

    public StatType getStatType() {
        return this._statType;
    }

    public TimeSelect getTimeSelect() {
        return this._timeSelect;
    }

    public void setTimeSelect(TimeSelect value) {
        this._timeSelect = value;
    }

    public boolean isAllTime() {
        return this._isAllTime;
    }

    public void setAllTime(boolean value) {
        this._isAllTime = value;
    }

    public List<Integer> getTimeIndices() {
        return this._timeIndices;
    }

    public void setTimeIndices(List<Integer> value) {
        this._timeIndices = value;
    }

    public void setStatType(StatType value) {
        this._statType = value;
    }

    public List<LocalDateTime> getTimes() {
        return this._times;
    }

    public void setTimes(List<LocalDateTime> value) {
        this._times = value;
    }

    public LocalDateTime getStartTime() {
        return this._times.get(0);
    }

    public LocalDateTime getEndTime() {
        return this._times.get(this._times.size() - 1);
    }

    public int getTimeNum() {
        return this._times.size();
    }

    public String getOutFilePath() {
        return this._outFilePath;
    }

    public void setOutFilePath(String value) {
        this._outFilePath = value;
    }

    public int getTimeZone() {
        return this._timeZone;
    }

    public void setTimeZone(int value) {
        this._timeZone = value;
    }

    public String getStFilterFile() {
        return this.stFilterFile;
    }

    public void setStFilterFile(String value) {
        this.stFilterFile = value;
    }

    public String getDataMaskFile() {
        return this._dataMaskFile;
    }

    public void setDataMaskFile(String value) {
        this._dataMaskFile = value;
    }

    public String getStatRegionFile() {
        return this._statRegionFile;
    }

    public void setStatRegionFile(String value) {
        this._statRegionFile = value;
    }

    public boolean isDatasetOpened() {
        return this._isDatasetOpened;
    }

    public List<LocalDateTime> getFcstTimes() {
        if (!this._isDatasetOpened) {
            this.openDatasets();
        }
        return this._fcstDataInfo.getDataInfo().getTimes();
    }

    public MeteoDataInfo getObsDataInfo() {
        return this._obsDataInfo;
    }

    public MeteoDataInfo getFcstDataInfo() {
        return this._fcstDataInfo;
    }

    public void setTimesByFcstData(MeteoDataInfo fcstDataInfo) {
        this.setTimesByFcstData(fcstDataInfo, 0);
    }

    public void setTimesByFcstData(MeteoDataInfo fcstDataInfo, int sIdx) {
        this._times.clear();
        List times = fcstDataInfo.getDataInfo().getTimes();
        for (int i = sIdx; i < times.size(); ++i) {
            this._times.add(this.getVeriyTime((LocalDateTime)times.get(i), this._fcstDataset.getTimeZone()));
        }
    }

    public void setTimesByFcstData(MeteoDataInfo fcstDataInfo, int sIdx, int eIdx) {
        this._times.clear();
        List times = fcstDataInfo.getDataInfo().getTimes();
        for (int i = sIdx; i < eIdx; ++i) {
            this._times.add(this.getVeriyTime((LocalDateTime)times.get(i), this._fcstDataset.getTimeZone()));
        }
    }

    private LocalDateTime getVeriyTime(LocalDateTime time, int timeZone) {
        if (timeZone == this._timeZone) {
            return time;
        }
        return time.plusHours(this._timeZone - timeZone);
    }

    private LocalDateTime getTime(LocalDateTime time, int fromTimeZone, int toTimeZone) {
        if (fromTimeZone == toTimeZone) {
            return time;
        }
        return time.plusHours(toTimeZone - fromTimeZone);
    }

    public void openDatasets() {
        this._obsDataInfo = this._obsDataset.openData();
        this._fcstDataInfo = this._fcstDataset.openData();
        this._isDatasetOpened = true;
    }

    public List<LocalDateTime> getVerifyTimes() {
        ArrayList<LocalDateTime> times = new ArrayList();
        switch (this._timeSelect) {
            case All: {
                times = this._fcstDataInfo.getDataInfo().getTimes();
                break;
            }
            case TimeIndex: {
                for (int i : this._timeIndices) {
                    LocalDateTime time = (LocalDateTime)this._fcstDataInfo.getDataInfo().getTimes().get(i);
                    times.add(time);
                }
                break;
            }
            case TimeValue: {
                times = this._times;
            }
        }
        if (this._timeZone != this._fcstDataset.getTimeZone()) {
            ArrayList<LocalDateTime> ntimes = new ArrayList<LocalDateTime>();
            for (LocalDateTime time : times) {
                ntimes.add(this.getTime(time, this._fcstDataset.getTimeZone(), this._timeZone));
            }
            return ntimes;
        }
        return times;
    }

    public void run() throws IOException {
        block0 : switch (this._verifyCategory) {
            case Spatial: {
                switch (this._statType) {
                    case StationStat: {
                        this.run_Spatial_Station();
                        break block0;
                    }
                    case GridStat: {
                        this.run_Spatial_Grid();
                    }
                }
            }
        }
    }

    public void run_Spatial_Station() throws IOException {
        this.openDatasets();
        String verifyfn = this._outFilePath + File.separator + "Verify_" + this._name + "_Station_" + this._verifyMethod.getMethodType().toString() + ".csv";
        List<LocalDateTime> times = this.getVerifyTimes();
        switch (this._verifyMethod.getMethodType()) {
            case DICHOTOMOUS: 
            case MULTICATEGORY: {
                try {
                    BufferedWriter sw = new BufferedWriter(new FileWriter(new File(verifyfn)));
                    String[] sNames = VerifyMethod.getScoreNames(this._verifyMethod.getMethodType());
                    String sName = sNames[0];
                    for (int i = 1; i < sNames.length; ++i) {
                        sName = sName + "," + sNames[i];
                    }
                    String title = "Group,Time,Region," + sName;
                    sw.write(title);
                    sw.newLine();
                    for (LocalDateTime t : times) {
                        List<Object> results = this.run(t);
                        if (results == null) continue;
                        this.appendVerifyFile(sw, (List)results.get(0), t, sNames);
                    }
                    sw.flush();
                    sw.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            default: {
                try {
                    BufferedWriter sw = new BufferedWriter(new FileWriter(new File(verifyfn)));
                    String[] sNames = VerifyMethod.getScoreNames(this._verifyMethod.getMethodType());
                    String sName = sNames[0];
                    for (int i = 1; i < sNames.length; ++i) {
                        sName = sName + "," + sNames[i];
                    }
                    String title = "Group,Time,Region," + sName;
                    sw.write(title);
                    sw.newLine();
                    for (LocalDateTime t : times) {
                        List<Object> results = this.run(t);
                        if (results == null) continue;
                        this.appendVerifyFile(sw, (List)results.get(0), t, sNames);
                    }
                    sw.flush();
                    sw.close();
                    break;
                }
                catch (IOException ex) {
                    Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void run_Spatial_Station_saveCateData() throws IOException {
        this.openDatasets();
        String verifyfn = this._outFilePath + File.separator + "Verify_" + this._name + "_Station_" + this._verifyMethod.getMethodType().toString() + ".csv";
        List<LocalDateTime> times = this.getVerifyTimes();
        switch (this._verifyMethod.getMethodType()) {
            case DICHOTOMOUS: 
            case MULTICATEGORY: {
                String spctlfn = this._outFilePath + File.separator + "Spatial_" + this._name + "_Station_" + this._verifyMethod.getMethodType().toString() + ".ctl";
                String spdatafn = spctlfn.replace(".ctl", ".dat");
                GrADSDataInfo aDataInfo = new GrADSDataInfo();
                aDataInfo.setFileName(spctlfn);
                aDataInfo.DSET = spdatafn;
                aDataInfo.TITLE = "Spatial data";
                aDataInfo.DTYPE = "station";
                Variable var = new Variable();
                var.setName("Var");
                var.setUnits("n");
                var.setDescription("Spatial value");
                aDataInfo.VARDEF.addVar(var);
                aDataInfo.TDEF.Type = "LEVELS";
                aDataInfo.createDataFile(spdatafn);
                try {
                    BufferedWriter sw = new BufferedWriter(new FileWriter(new File(verifyfn)));
                    String[] sNames = VerifyMethod.getScoreNames(this._verifyMethod.getMethodType());
                    String sName = sNames[0];
                    for (int i = 1; i < sNames.length; ++i) {
                        sName = sName + "," + sNames[i];
                    }
                    String title = "Group,Time,Region," + sName;
                    sw.write(title);
                    sw.newLine();
                    aDataInfo.TDEF.times = times;
                    for (LocalDateTime t : times) {
                        List<Object> results = this.run(t);
                        if (results == null) continue;
                        this.appendVerifyFile(sw, (List)results.get(0), t, sNames);
                        if (results.size() <= 1) continue;
                        aDataInfo.writeStationData((StationData)results.get(1));
                    }
                    aDataInfo.closeDataFile();
                    aDataInfo.writeGrADSCTLFile();
                    sw.flush();
                    sw.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            default: {
                try {
                    BufferedWriter sw = new BufferedWriter(new FileWriter(new File(verifyfn)));
                    String[] sNames = VerifyMethod.getScoreNames(this._verifyMethod.getMethodType());
                    String sName = sNames[0];
                    for (int i = 1; i < sNames.length; ++i) {
                        sName = sName + "," + sNames[i];
                    }
                    String title = "Group,Time,Region," + sName;
                    sw.write(title);
                    sw.newLine();
                    for (LocalDateTime t : times) {
                        List<Object> results = this.run(t);
                        if (results == null) continue;
                        this.appendVerifyFile(sw, (List)results.get(0), t, sNames);
                    }
                    sw.flush();
                    sw.close();
                    break;
                }
                catch (IOException ex) {
                    Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void run_Spatial_Grid() throws IOException {
        this.openDatasets();
        String verifyfn = this._outFilePath + File.separator + "Verify_" + this._name + "_Station_" + this._verifyMethod.getMethodType().toString() + ".csv";
        List<LocalDateTime> times = this.getVerifyTimes();
        switch (this._verifyMethod.getMethodType()) {
            case DICHOTOMOUS: {
                String spctlfn = this._outFilePath + File.separator + "Spatial_" + this._name + "_Station_" + this._verifyMethod.getMethodType().toString() + ".ctl";
                String spdatafn = spctlfn.replace(".ctl", ".dat");
                GrADSDataInfo aDataInfo = new GrADSDataInfo();
                aDataInfo.setFileName(spctlfn);
                aDataInfo.DSET = spdatafn;
                aDataInfo.TITLE = "Spatial data";
                aDataInfo.DTYPE = "GRIDDED";
                Variable var = new Variable();
                var.setName("Var");
                var.setUnits("n");
                var.setDescription("Spatial value");
                aDataInfo.VARDEF.addVar(var);
                aDataInfo.TDEF.Type = "LEVELS";
                aDataInfo.createDataFile(spdatafn);
                try {
                    BufferedWriter sw = new BufferedWriter(new FileWriter(new File(verifyfn)));
                    String[] sNames = VerifyMethod.getScoreNames(this._verifyMethod.getMethodType());
                    String sName = sNames[0];
                    for (int i = 1; i < sNames.length; ++i) {
                        sName = sName + "," + sNames[i];
                    }
                    String title = "Group,Time,Region," + sName;
                    sw.write(title);
                    sw.newLine();
                    aDataInfo.TDEF.times = times;
                    int n = 0;
                    for (LocalDateTime t : times) {
                        List<Object> results = this.run(t);
                        if (results == null) continue;
                        this.appendVerifyFile(sw, (List)results.get(0), t, sNames);
                        if (results.size() <= 1) continue;
                        GridData gData = (GridData)results.get(1);
                        if (n == 0) {
                            aDataInfo.XDEF.Type = "LINEAR";
                            aDataInfo.XDEF.XNum = gData.getXNum();
                            aDataInfo.XDEF.XMin = (float)gData.getExtent().minX;
                            aDataInfo.XDEF.XDelt = (float)gData.getXDelta();
                            aDataInfo.YDEF.Type = "LINEAR";
                            aDataInfo.YDEF.YNum = gData.getYNum();
                            aDataInfo.YDEF.YMin = (float)gData.getExtent().minY;
                            aDataInfo.YDEF.YDelt = (float)gData.getYDelta();
                        }
                        aDataInfo.writeGridData(gData);
                        ++n;
                    }
                    aDataInfo.closeDataFile();
                    aDataInfo.writeGrADSCTLFile();
                    sw.flush();
                    sw.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            default: {
                try {
                    BufferedWriter sw = new BufferedWriter(new FileWriter(new File(verifyfn)));
                    String[] sNames = VerifyMethod.getScoreNames(this._verifyMethod.getMethodType());
                    String sName = sNames[0];
                    for (int i = 1; i < sNames.length; ++i) {
                        sName = sName + "," + sNames[i];
                    }
                    String title = "Group,Time,Region," + sName;
                    sw.write(title);
                    sw.newLine();
                    for (LocalDateTime t : times) {
                        List<Object> results = this.run(t);
                        this.appendVerifyFile(sw, (List)results.get(0), t, sNames);
                    }
                    sw.flush();
                    sw.close();
                    break;
                }
                catch (IOException ex) {
                    Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public List<Object> run(int timeIndex, List<LocalDateTime> times) {
        LocalDateTime time = times.get(timeIndex);
        return this.run(time);
    }

    public List<Object> run(int timeIndex) {
        LocalDateTime time = this.getVerifyTimes().get(timeIndex);
        return this.run(time);
    }

    public List<Object> run(LocalDateTime time) {
        LocalDateTime obsTime = this.getTime(time, this._timeZone, this._obsDataset.getTimeZone());
        LocalDateTime fcstTime = this.getTime(time, this._timeZone, this._fcstDataset.getTimeZone());
        Object obsData = this.getObsData(obsTime);
        if (obsData == null) {
            return null;
        }
        Object fcstData = this.getFcstData(fcstTime);
        if (fcstData == null) {
            return null;
        }
        return this.run((StationData)obsData, (GridData)fcstData, this._statType);
    }

    public StationData[] getVerifyData_Station(LocalDateTime time) {
        LocalDateTime obsTime = this.getTime(time, this._timeZone, this._obsDataset.getTimeZone());
        LocalDateTime fcstTime = this.getTime(time, this._timeZone, this._fcstDataset.getTimeZone());
        StationData od = (StationData)this.getObsData(obsTime);
        if (new File(this._dataMaskFile).exists()) {
            try {
                VectorLayer maskLayer = (VectorLayer)MapDataManage.loadLayer((String)this._dataMaskFile);
                od = GeoMathUtil.maskout((StationData)od, (PolygonShape)((PolygonShape)maskLayer.getShapes().get(0)));
            }
            catch (IOException ex) {
                Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        GridData fd = (GridData)this.getFcstData(fcstTime);
        StationData fds = fd.toStation(od);
        return new StationData[]{od, fds};
    }

    public StationData[] getVerifyData_Station(LocalDateTime time, String region) {
        LocalDateTime obsTime = this.getTime(time, this._timeZone, this._obsDataset.getTimeZone());
        LocalDateTime fcstTime = this.getTime(time, this._timeZone, this._fcstDataset.getTimeZone());
        StationData od = (StationData)this.getObsData(obsTime);
        if (new File(this._dataMaskFile).exists()) {
            try {
                VectorLayer maskLayer = (VectorLayer)MapDataManage.loadLayer((String)this._dataMaskFile);
                od = GeoMathUtil.maskout((StationData)od, (PolygonShape)((PolygonShape)maskLayer.getShapes().get(0)));
            }
            catch (IOException ex) {
                Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        GridData fd = (GridData)this.getFcstData(fcstTime);
        StationData fds = fd.toStation(od);
        if (new File(this._statRegionFile).exists()) {
            try {
                VectorLayer maskLayer = (VectorLayer)MapDataManage.loadLayer((String)this._statRegionFile);
                for (int i = 0; i < maskLayer.getShapeNum(); ++i) {
                    String tName = maskLayer.getCellValue("NAME", i).toString();
                    if (!tName.equals(region)) continue;
                    PolygonShape polygonShape = (PolygonShape)maskLayer.getShapes().get(i);
                    StationData maskObsData = GeoMathUtil.maskout((StationData)od, (PolygonShape)polygonShape);
                    StationData maskFcstData = GeoMathUtil.maskout((StationData)fds, (PolygonShape)polygonShape);
                    return new StationData[]{maskObsData, maskFcstData};
                }
            }
            catch (IOException ex) {
                Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return new StationData[]{od, fds};
    }

    private List<Object> run(StationData obsData, GridData fcstData, StatType statType) {
        if (new File(this.stFilterFile).exists()) {
            try {
                ArrayList<String> stations = new ArrayList<String>();
                BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.stFilterFile), "utf-8"));
                String line = sr.readLine();
                while (line != null) {
                    line = line.trim();
                    String[] dataArray = line.split("\\s+");
                    stations.addAll(Arrays.asList(dataArray));
                    line = sr.readLine();
                }
                sr.close();
                obsData = obsData.filter(stations);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (new File(this._dataMaskFile).exists()) {
            try {
                VectorLayer maskLayer = (VectorLayer)MapDataManage.loadLayer((String)this._dataMaskFile);
                obsData = GeoMathUtil.maskout((StationData)obsData, (PolygonShape)((PolygonShape)maskLayer.getShapes().get(0)));
            }
            catch (IOException ex) {
                Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        ArrayList<Object> results = new ArrayList<Object>();
        ArrayList<VerifyTable> tables = new ArrayList<VerifyTable>();
        switch (statType) {
            case StationStat: {
                StationData fstData = fcstData.toStation(obsData);
                VerifyTable table = VerifyStat.getVerifyTable(obsData, fstData, this._verifyMethod);
                table.setName("Whole Region");
                tables.add(table);
                if (new File(this._statRegionFile).exists()) {
                    try {
                        VectorLayer regionLayer = (VectorLayer)MapDataManage.loadLayer((String)this._statRegionFile);
                        for (int i = 0; i < regionLayer.getShapeNum(); ++i) {
                            PolygonShape polygonShape = (PolygonShape)regionLayer.getShapes().get(i);
                            StationData maskObsData = GeoMathUtil.maskout((StationData)obsData, (PolygonShape)polygonShape);
                            StationData maskFcstData = GeoMathUtil.maskout((StationData)fstData, (PolygonShape)polygonShape);
                            table = VerifyStat.getVerifyTable(maskObsData, maskFcstData, this._verifyMethod);
                            String tName = regionLayer.getCellValue("NAME", i).toString();
                            table.setName(tName);
                            tables.add(table);
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                results.add(tables);
                switch (this._verifyMethod.getMethodType()) {
                    case DICHOTOMOUS: 
                    case MULTICATEGORY: {
                        StationData cateData = VerifyStat.categorical(obsData, fstData, this._verifyMethod);
                        results.add(cateData);
                        break;
                    }
                    case CONTINUOUS: {
                        results.add(obsData);
                        results.add(fstData);
                    }
                }
                break;
            }
            case GridStat: {
                obsData = obsData.project(this._obsDataInfo.getProjectionInfo(), this._fcstDataInfo.getProjectionInfo());
                GridDataSetting gDataSet = fcstData.getGridDataSetting();
                InterpolationSetting interSet = new InterpolationSetting();
                interSet.setGridDataSetting(gDataSet);
                interSet.setInterpolationMethod(InterpolationMethods.IDW_NEIGHBORS);
                interSet.setMinPointNum(9);
                interSet.setMissingValue(obsData.missingValue);
                GridData ogridData = GeoMathUtil.interpolateData((StationData)obsData, (InterpolationSetting)interSet);
                tables = new ArrayList();
                VerifyTable table = VerifyStat.getVerifyTable(ogridData, fcstData, this._verifyMethod);
                table.setName("Whole Region");
                tables.add(table);
                if (new File(this._statRegionFile).exists()) {
                    try {
                        VectorLayer maskLayer = (VectorLayer)MapDataManage.loadLayer((String)this._statRegionFile);
                        for (int i = 0; i < maskLayer.getShapeNum(); ++i) {
                            PolygonShape polygonShape = (PolygonShape)maskLayer.getShapes().get(i);
                            GridData maskObsData = GeoMathUtil.maskout((GridData)ogridData, (PolygonShape)polygonShape);
                            GridData maskFcstData = GeoMathUtil.maskout((GridData)fcstData, (PolygonShape)polygonShape);
                            table = VerifyStat.getVerifyTable(maskObsData, maskFcstData, this._verifyMethod);
                            table.setName("Mask_" + String.valueOf(i));
                            tables.add(table);
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(VerifyGroup.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                results.add(tables);
                switch (this._verifyMethod.getMethodType()) {
                    case DICHOTOMOUS: 
                    case MULTICATEGORY: {
                        DichotomousMethod dMethod = (DichotomousMethod)this._verifyMethod;
                        GridData categData = VerifyStat.categorical(ogridData, fcstData, this._verifyMethod);
                        results.add(categData);
                    }
                }
            }
        }
        return results;
    }

    public static void saveVerifyFile(String fileName, List<VerifyTable> tables) {
        try {
            BufferedWriter sw = new BufferedWriter(new FileWriter(new File(fileName)));
            for (int i = 0; i < tables.size(); ++i) {
                VerifyTable table = tables.get(i);
                sw.write("***************************");
                sw.newLine();
                sw.write(table.getName());
                sw.newLine();
                String aStr = "Statistics,Score";
                sw.write(aStr);
                Map map = table.getVerifyResult();
                Set key = map.keySet();
                for (String s : key) {
                    aStr = s + "," + map.get(s).toString();
                    sw.newLine();
                    sw.write(aStr);
                }
                if (i >= tables.size() - 1) continue;
                sw.newLine();
            }
            sw.flush();
            sw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(StationData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public BufferedWriter createVerifyFile(String fileName) throws IOException {
        BufferedWriter sw = new BufferedWriter(new FileWriter(new File(fileName)));
        String[] sNames = VerifyMethod.getScoreNames(this._verifyMethod.getMethodType());
        String sName = sNames[0];
        for (int i = 1; i < sNames.length; ++i) {
            sName = sName + "," + sNames[i];
        }
        String title = "Group,Time,Region," + sName;
        sw.write(title);
        sw.newLine();
        return sw;
    }

    private void appendVerifyFile(BufferedWriter sw, List<VerifyTable> tables, LocalDateTime time, String[] sNames) {
        try {
            DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < tables.size(); ++i) {
                VerifyTable table = tables.get(i);
                String line = this._name + "," + format.format(time) + "," + table.getName();
                Map map = table.getVerifyResult();
                for (String s : sNames) {
                    line = line + "," + String.format("%1$.2f", map.get(s));
                }
                sw.write(line);
                sw.newLine();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(StationData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void appendVerifyFile(BufferedWriter sw, List<VerifyTable> tables, LocalDateTime time) {
        String[] sNames = VerifyMethod.getScoreNames(tables.get(0).getMethodType());
        this.appendVerifyFile(sw, tables, time, sNames);
    }

    public void closeVerifyFile(BufferedWriter sw) throws IOException {
        sw.close();
    }

    public static GrADSDataInfo createSpatialFile(String spctlfn) throws IOException {
        String spdatafn = spctlfn.replace(".ctl", ".dat");
        GrADSDataInfo aDataInfo = new GrADSDataInfo();
        aDataInfo.setFileName(spctlfn);
        aDataInfo.DSET = spdatafn;
        aDataInfo.TITLE = "Spatial data";
        aDataInfo.DTYPE = "station";
        Variable var = new Variable();
        var.setName("Var");
        var.setUnits("n");
        var.setDescription("Spatial value");
        aDataInfo.VARDEF.addVar(var);
        aDataInfo.TDEF.Type = "LEVELS";
        aDataInfo.createDataFile(spdatafn);
        return aDataInfo;
    }

    public Object getObsData(LocalDateTime time) {
        switch (this._obsDataset.getMeteoDataType()) {
            case MICAPS_1: 
            case MICAPS_120: {
                String mfn = this._obsDataset.getFileName(time);
                if (!new File(mfn).exists()) {
                    return null;
                }
                this._obsDataInfo = new MeteoDataInfo();
                this._obsDataInfo.openMICAPSData(mfn);
                StationData stData = this._obsDataInfo.getStationData(this._obsDataset.getVariableName());
                return stData;
            }
        }
        int timeIndex = this._obsDataInfo.getDataInfo().getTimes().indexOf(time);
        if (timeIndex < 0) {
            return null;
        }
        this._obsDataInfo.setTimeIndex(timeIndex);
        this._obsDataInfo.setLevelIndex(this._obsDataset.getLevelIndex());
        if (this._obsDataInfo.isGridData()) {
            GridData gData = this._obsDataInfo.getGridData(this._obsDataset.getVariableName());
            return gData;
        }
        if (this._obsDataInfo.isStationData()) {
            StationData stData = this._obsDataInfo.getStationData(this._obsDataset.getVariableName());
            return stData;
        }
        return null;
    }

    public Object getFcstData(LocalDateTime time) {
        int timeIndex = this._fcstDataInfo.getDataInfo().getTimes().indexOf(time);
        if (timeIndex < 0) {
            return null;
        }
        this._fcstDataInfo.setTimeIndex(timeIndex);
        this._fcstDataInfo.setLevelIndex(this._fcstDataset.getLevelIndex());
        if (this._fcstDataInfo.isGridData()) {
            GridData gData = this._fcstDataInfo.getGridData(this._fcstDataset.getVariableName());
            return gData;
        }
        if (this._fcstDataInfo.isStationData()) {
            StationData stData = this._fcstDataInfo.getStationData(this._fcstDataset.getVariableName());
            return stData;
        }
        return null;
    }

    public void exportToXML(Document doc, Element parent) {
        Object dMethod;
        Element group = doc.createElement("Group");
        Attr nameAttr = doc.createAttribute("Name");
        Attr verifyCategoryAttr = doc.createAttribute("VerifyCategory");
        Attr statTypeAttr = doc.createAttribute("StatisticType");
        Attr timeZoneAttr = doc.createAttribute("TimeZone");
        Attr outputDirAttr = doc.createAttribute("OutputDirectory");
        Attr dataMaskFileAttr = doc.createAttribute("DataMaskFile");
        Attr statRegionFileAttr = doc.createAttribute("StatRegionFile");
        nameAttr.setValue(this._name);
        verifyCategoryAttr.setValue(this._verifyCategory.toString());
        statTypeAttr.setValue(this._statType.toString());
        timeZoneAttr.setValue(Globals.getTimeZoneString(this._timeZone));
        outputDirAttr.setValue(this._outFilePath);
        dataMaskFileAttr.setValue(this._dataMaskFile);
        statRegionFileAttr.setValue(this._statRegionFile);
        group.setAttributeNode(nameAttr);
        group.setAttributeNode(verifyCategoryAttr);
        group.setAttributeNode(statTypeAttr);
        group.setAttributeNode(timeZoneAttr);
        group.setAttributeNode(outputDirAttr);
        group.setAttributeNode(dataMaskFileAttr);
        group.setAttributeNode(statRegionFileAttr);
        Element method = doc.createElement("Method");
        Attr methodType = doc.createAttribute("MethodType");
        methodType.setValue(this._verifyMethod.getMethodType().toString());
        method.setAttributeNode(methodType);
        Element parameter = doc.createElement("Parameter");
        switch (this._verifyMethod.getMethodType()) {
            case DICHOTOMOUS: {
                Attr minTthresholdAttr = doc.createAttribute("MinThreshold");
                Attr maxTthresholdAttr = doc.createAttribute("MaxThreshold");
                dMethod = (DichotomousMethod)this._verifyMethod;
                minTthresholdAttr.setValue(String.valueOf(((DichotomousMethod)dMethod).getDataRange().getMinThreshold()));
                maxTthresholdAttr.setValue(String.valueOf(((DichotomousMethod)dMethod).getDataRange().getMaxThreshold()));
                parameter.setAttributeNode(minTthresholdAttr);
                parameter.setAttributeNode(maxTthresholdAttr);
                break;
            }
            case MULTICATEGORY: {
                Attr values = doc.createAttribute("Values");
                MultiCategoryMethod mMethod = (MultiCategoryMethod)this._verifyMethod;
                values.setValue(mMethod.valuesToString());
                parameter.setAttributeNode(values);
                break;
            }
        }
        method.appendChild(parameter);
        group.appendChild(method);
        Element times = doc.createElement("Times");
        Attr timeSelAttr = doc.createAttribute("TimeSelect");
        timeSelAttr.setValue(this._timeSelect.toString());
        times.setAttributeNode(timeSelAttr);
        switch (this._timeSelect) {
            case TimeIndex: {
                dMethod = this._timeIndices.iterator();
                while (dMethod.hasNext()) {
                    int i = (Integer)dMethod.next();
                    Element time = doc.createElement("Time");
                    Attr idxAttr = doc.createAttribute("Index");
                    idxAttr.setValue(String.valueOf(i));
                    time.setAttributeNode(idxAttr);
                    times.appendChild(time);
                }
                break;
            }
            case TimeValue: {
                DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                for (LocalDateTime t : this._times) {
                    Element time = doc.createElement("Time");
                    Attr tvalueAttr = doc.createAttribute("Value");
                    tvalueAttr.setValue(format.format(t));
                    time.setAttributeNode(tvalueAttr);
                    times.appendChild(time);
                }
                break;
            }
        }
        group.appendChild(times);
        this._obsDataset.exportToXML(doc, group);
        this._fcstDataset.exportToXML(doc, group);
        parent.appendChild(group);
    }

    public void importFromXML(Node node) {
        this._name = node.getAttributes().getNamedItem("Name").getNodeValue();
        this._verifyCategory = VerifyCategory.valueOf(node.getAttributes().getNamedItem("VerifyCategory").getNodeValue());
        this._statType = StatType.valueOf(node.getAttributes().getNamedItem("StatisticType").getNodeValue());
        this._outFilePath = node.getAttributes().getNamedItem("OutputDirectory").getNodeValue();
        this._dataMaskFile = node.getAttributes().getNamedItem("DataMaskFile").getNodeValue();
        this._statRegionFile = node.getAttributes().getNamedItem("StatRegionFile").getNodeValue();
        this._timeZone = Globals.getTimeZone(node.getAttributes().getNamedItem("TimeZone").getNodeValue());
        Node methodNode = ((Element)node).getElementsByTagName("Method").item(0);
        MethodType methodType = MethodType.valueOf(methodNode.getAttributes().getNamedItem("MethodType").getNodeValue());
        Node parameterNode = ((Element)methodNode).getElementsByTagName("Parameter").item(0);
        switch (methodType) {
            case DICHOTOMOUS: {
                DichotomousMethod dMethod = new DichotomousMethod();
                Node minTNode = parameterNode.getAttributes().getNamedItem("MinThreshold");
                Node maxTNode = parameterNode.getAttributes().getNamedItem("MaxThreshold");
                if (minTNode != null && maxTNode != null) {
                    String minTstr = parameterNode.getAttributes().getNamedItem("MinThreshold").getNodeValue();
                    String maxTstr = parameterNode.getAttributes().getNamedItem("MaxThreshold").getNodeValue();
                    if (!minTstr.equalsIgnoreCase("null")) {
                        dMethod.getDataRange().setMinThreshold(Double.parseDouble(minTstr));
                    }
                    if (!maxTstr.equalsIgnoreCase("null")) {
                        dMethod.getDataRange().setMaxThreshold(Double.parseDouble(maxTstr));
                    }
                }
                this._verifyMethod = dMethod;
                break;
            }
            case MULTICATEGORY: {
                MultiCategoryMethod mMethod = new MultiCategoryMethod();
                mMethod.setValues(parameterNode.getAttributes().getNamedItem("Values").getNodeValue());
                this._verifyMethod = mMethod;
                break;
            }
            case CONTINUOUS: {
                this._verifyMethod = new ContinuousMethod();
            }
        }
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        Node timesNode = ((Element)node).getElementsByTagName("Times").item(0);
        this._timeSelect = TimeSelect.valueOf(timesNode.getAttributes().getNamedItem("TimeSelect").getNodeValue());
        switch (this._timeSelect) {
            case TimeIndex: {
                Node timeNode;
                NodeList timeNodeList = ((Element)timesNode).getElementsByTagName("Time");
                this._timeIndices.clear();
                for (int i = 0; i < timeNodeList.getLength(); ++i) {
                    timeNode = timeNodeList.item(i);
                    this._timeIndices.add(Integer.parseInt(timeNode.getAttributes().getNamedItem("Index").getNodeValue()));
                }
                break;
            }
            case TimeValue: {
                Node timeNode;
                NodeList timeNodeList = ((Element)timesNode).getElementsByTagName("Time");
                this._times.clear();
                for (int i = 0; i < timeNodeList.getLength(); ++i) {
                    timeNode = timeNodeList.item(i);
                    this._times.add(LocalDateTime.parse(timeNode.getAttributes().getNamedItem("Value").getNodeValue(), format));
                }
                break;
            }
        }
        if (!this._isAllTime) {
            // empty if block
        }
        this._obsDataset = new Dataset("Temp");
        this._obsDataset.setDataSourceType(DataSourceType.Observation);
        Node obsNode = ((Element)node).getElementsByTagName("ObservationDataset").item(0);
        this._obsDataset.importFromXML(obsNode);
        this._fcstDataset = new Dataset("Temp");
        this._fcstDataset.setDataSourceType(DataSourceType.Forecast);
        Node fcstNode = ((Element)node).getElementsByTagName("ForecastDataset").item(0);
        this._fcstDataset.importFromXML(fcstNode);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

