/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.jython;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.List;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.Complex;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;
import org.python.core.Py;
import org.python.core.PyComplex;
import org.python.core.PyObject;

public class JythonUtil {
    public static Complex toComplex(PyComplex v) {
        return new Complex(v.real, v.imag);
    }

    public static PyComplex toComplex(Complex v) {
        return new PyComplex(v.real(), v.imag());
    }

    public static Array toComplexArray(PyComplex data) {
        Array a = Array.factory((DataType)DataType.COMPLEX, (int[])new int[]{1});
        Complex d = new Complex(data.real, data.imag);
        a.setComplex(0, d);
        return a;
    }

    public static Array toComplexArray(List<Object> data) {
        if (data.get(0) instanceof List) {
            int ndim = data.size();
            int len = ((List)data.get(0)).size();
            Array a = Array.factory((DataType)DataType.COMPLEX, (int[])new int[]{ndim, len});
            for (int i = 0; i < ndim; ++i) {
                List d = (List)data.get(i);
                for (int j = 0; j < len; ++j) {
                    if (d.get(j) instanceof PyComplex) {
                        PyComplex pd = (PyComplex)d.get(j);
                        a.setComplex(i * len + j, new Complex(pd.real, pd.imag));
                        continue;
                    }
                    a.setComplex(i * len + j, new Complex(((Double)d.get(j)).doubleValue(), 0.0));
                }
            }
            return a;
        }
        Array a = Array.factory((DataType)DataType.COMPLEX, (int[])new int[]{data.size()});
        for (int i = 0; i < data.size(); ++i) {
            if (data.get(i) instanceof PyComplex) {
                PyComplex pd = (PyComplex)data.get(i);
                a.setComplex(i, new Complex(pd.real, pd.imag));
                continue;
            }
            a.setComplex(i, new Complex(((Double)data.get(i)).doubleValue(), 0.0));
        }
        return a;
    }

    public static LocalDateTime toDateTime(PyObject dt) {
        Calendar calendar = (Calendar)dt.__tojava__(Calendar.class);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        return localDateTime;
    }

    public static PyObject toDateTime(LocalDateTime dt) {
        Timestamp timestamp = Timestamp.valueOf(dt);
        return Py.newDatetime((Timestamp)timestamp);
    }

    public static Array toDateTime(Array a) {
        IndexIterator iterA = a.getIndexIterator();
        if (a.getDataType() == DataType.DATE) {
            Array r = Array.factory((DataType)DataType.OBJECT, (int[])a.getShape());
            IndexIterator interR = r.getIndexIterator();
            while (interR.hasNext()) {
                interR.setObjectNext((Object)JythonUtil.toDateTime(iterA.getDateNext()));
            }
            return r;
        }
        Array r = Array.factory((DataType)DataType.DATE, (int[])a.getShape());
        IndexIterator interR = r.getIndexIterator();
        while (interR.hasNext()) {
            interR.setDateNext(JythonUtil.toDateTime((PyObject)iterA.getObjectNext()));
        }
        return r;
    }
}

