/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.imep.verification;

import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.meteoinfo.data.meteodata.MeteoDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.grads.GrADSDataInfo;
import org.meteothink.imep.global.Globals;
import org.meteothink.imep.verification.DataSourceType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Dataset
implements Cloneable {
    private String _name;
    private DataSourceType _dataSource = DataSourceType.Observation;
    private MeteoDataType _meteoDataType = MeteoDataType.NETCDF;
    private String _varName;
    private int levelIndex = 0;
    private String _fileName;
    private int _timeZone = 0;
    private boolean bigEndian = false;

    public Dataset(String name) {
        this._name = name;
    }

    public Dataset(String name, DataSourceType dataSource, MeteoDataType meteoDataType, String varName, int level) {
        this(name);
        this._dataSource = dataSource;
        this._meteoDataType = meteoDataType;
        this._varName = varName;
    }

    public Dataset(String name, DataSourceType dataSource, MeteoDataType meteoDataType, String varName, String fileName, int level) {
        this(name, dataSource, meteoDataType, varName, level);
        this._fileName = fileName;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public DataSourceType getDataSourceType() {
        return this._dataSource;
    }

    public void setDataSourceType(DataSourceType value) {
        this._dataSource = value;
    }

    public MeteoDataType getMeteoDataType() {
        return this._meteoDataType;
    }

    public void setMeteoDataType(MeteoDataType value) {
        this._meteoDataType = value;
    }

    public String getVariableName() {
        return this._varName;
    }

    public void setVariableName(String value) {
        this._varName = value;
    }

    public int getLevelIndex() {
        return this.levelIndex;
    }

    public void setLevelIndex(int value) {
        this.levelIndex = value;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String value) {
        this._fileName = value;
    }

    public int getTimeZone() {
        return this._timeZone;
    }

    public void setTimeZone(int value) {
        this._timeZone = value;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public void setBigEndian(boolean value) {
        this.bigEndian = value;
    }

    public String getFileName(LocalDateTime time) {
        switch (this._meteoDataType) {
            case MICAPS_1: {
                String path = new File(this._fileName).getParent();
                DateTimeFormatter format = DateTimeFormatter.ofPattern("yyMMddHH");
                String fileName = path + File.separator + format.format(time) + ".000";
                return fileName;
            }
            case MICAPS_120: {
                String path = new File(this._fileName).getParent();
                DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMddHH");
                String fileName = path + File.separator + format.format(time) + ".000";
                return fileName;
            }
        }
        return this._fileName;
    }

    public MeteoDataInfo openData() {
        MeteoDataInfo mdi = new MeteoDataInfo();
        switch (this._meteoDataType) {
            case GRADS_GRID: {
                mdi.openGrADSData(this._fileName);
                ((GrADSDataInfo)mdi.getDataInfo()).setBigEndian(this.bigEndian);
                return mdi;
            }
            case NETCDF: 
            case GRIB1: 
            case GRIB2: {
                mdi.openNetCDFData(this._fileName);
                return mdi;
            }
        }
        if (this._meteoDataType.isMICAPS()) {
            mdi.openMICAPSData(this._fileName);
            return mdi;
        }
        return null;
    }

    public void exportToXML(Document doc, Element parent) {
        String elementName = "ObservationDataset";
        if (this._dataSource == DataSourceType.Forecast) {
            elementName = "ForecastDataset";
        }
        Element dataset = doc.createElement(elementName);
        Attr nameAttr = doc.createAttribute("Name");
        Attr dataSourceAttr = doc.createAttribute("DataSource");
        Attr dataTypeAttr = doc.createAttribute("DataType");
        Attr fileNameAttr = doc.createAttribute("FileName");
        Attr varNameAttr = doc.createAttribute("VariableName");
        Attr timeZoneAttr = doc.createAttribute("TimeZone");
        Attr bigEndianAttr = doc.createAttribute("BigEndian");
        Attr levIdxAttr = doc.createAttribute("LevelIndex");
        nameAttr.setValue(this._name);
        dataSourceAttr.setValue(this._dataSource.toString());
        dataTypeAttr.setValue(this._meteoDataType.toString());
        fileNameAttr.setValue(this._fileName);
        varNameAttr.setValue(this._varName);
        timeZoneAttr.setValue(Globals.getTimeZoneString(this._timeZone));
        bigEndianAttr.setValue(String.valueOf(this.bigEndian));
        levIdxAttr.setValue(String.valueOf(this.levelIndex));
        dataset.setAttributeNode(nameAttr);
        dataset.setAttributeNode(dataSourceAttr);
        dataset.setAttributeNode(dataTypeAttr);
        dataset.setAttributeNode(fileNameAttr);
        dataset.setAttributeNode(varNameAttr);
        dataset.setAttributeNode(timeZoneAttr);
        dataset.setAttributeNode(bigEndianAttr);
        dataset.setAttributeNode(levIdxAttr);
        parent.appendChild(dataset);
    }

    public void importFromXML(Node node) {
        try {
            this._name = node.getAttributes().getNamedItem("Name").getNodeValue();
            this._dataSource = DataSourceType.valueOf(node.getAttributes().getNamedItem("DataSource").getNodeValue());
            this._meteoDataType = MeteoDataType.valueOf((String)node.getAttributes().getNamedItem("DataType").getNodeValue());
            this._fileName = node.getAttributes().getNamedItem("FileName").getNodeValue();
            this._varName = node.getAttributes().getNamedItem("VariableName").getNodeValue();
            this._timeZone = Globals.getTimeZone(node.getAttributes().getNamedItem("TimeZone").getNodeValue());
            this.bigEndian = Boolean.parseBoolean(node.getAttributes().getNamedItem("BigEndian").getNodeValue());
            this.levelIndex = Integer.parseInt(node.getAttributes().getNamedItem("LevelIndex").getNodeValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

