/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.imep.verification;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.StationData;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteothink.imep.verification.ContingencyTable;
import org.meteothink.imep.verification.ContinuousTable;
import org.meteothink.imep.verification.DataRange;
import org.meteothink.imep.verification.DichotomousMethod;
import org.meteothink.imep.verification.MultiCategoryMethod;
import org.meteothink.imep.verification.MultiCategoryTable;
import org.meteothink.imep.verification.ScoreMethod;
import org.meteothink.imep.verification.ScoreTable;
import org.meteothink.imep.verification.VerifyMethod;
import org.meteothink.imep.verification.VerifyTable;

public class VerifyStat {
    public static GridData categorical(GridData obsData, GridData fcstData, VerifyMethod method) {
        GridData veriData = new GridData(obsData);
        int xnum = obsData.getXNum();
        int ynum = obsData.getYNum();
        double value = 0.0;
        switch (method.getMethodType()) {
            case DICHOTOMOUS: {
                DichotomousMethod dMethod = (DichotomousMethod)method;
                DataRange dataRange = dMethod.getDataRange();
                for (int i = 0; i < ynum; ++i) {
                    for (int j = 0; j < xnum; ++j) {
                        if (MIMath.doubleEquals((double)obsData.getDoubleValue(i, j), (double)obsData.getDoubleMissingValue())) {
                            value = 0.0;
                            continue;
                        }
                        if (MIMath.doubleEquals((double)fcstData.getDoubleValue(i, j), (double)value)) {
                            value = 0.0;
                            continue;
                        }
                        boolean bobs = dataRange.isValueIn(obsData.getDoubleValue(i, j));
                        boolean bfcst = dataRange.isValueIn(fcstData.getDoubleValue(i, j));
                        value = bobs && bfcst ? 1.0 : (bobs && !bfcst ? 2.0 : (!bobs && bfcst ? 3.0 : 4.0));
                        veriData.setValue(i, j, value);
                    }
                }
                break;
            }
        }
        return veriData;
    }

    public static GridData categorical(GridData obsData, GridData fcstData, double threshold, boolean isBigger) {
        GridData veriData = new GridData(obsData);
        int xnum = obsData.getXNum();
        int ynum = obsData.getYNum();
        double value = 0.0;
        for (int i = 0; i < ynum; ++i) {
            for (int j = 0; j < xnum; ++j) {
                boolean bfcst;
                boolean bobs;
                if (MIMath.doubleEquals((double)obsData.getDoubleValue(i, j), (double)obsData.getDoubleMissingValue())) {
                    value = 0.0;
                    continue;
                }
                if (MIMath.doubleEquals((double)fcstData.getDoubleValue(i, j), (double)value)) {
                    value = 0.0;
                    continue;
                }
                if (isBigger) {
                    bobs = obsData.getDoubleValue(i, j) >= threshold;
                    bfcst = fcstData.getDoubleValue(i, j) >= threshold;
                } else {
                    bobs = obsData.getDoubleValue(i, j) <= threshold;
                    boolean bl = bfcst = fcstData.getDoubleValue(i, j) <= threshold;
                }
                value = bobs && bfcst ? 1.0 : (bobs && !bfcst ? 2.0 : (!bobs && bfcst ? 3.0 : 4.0));
                veriData.setValue(i, j, value);
            }
        }
        return veriData;
    }

    public static Array categorical(Array obsData, Array fcstData, VerifyMethod method) {
        obsData = obsData.copyIfView();
        fcstData = fcstData.copyIfView();
        DichotomousMethod dMethod = (DichotomousMethod)method;
        DataRange dataRange = dMethod.getDataRange();
        return VerifyStat.categorical(obsData, fcstData, dataRange);
    }

    public static Array categorical(Array obsData, Array fcstData, DataRange dataRange) {
        obsData = obsData.copyIfView();
        fcstData = fcstData.copyIfView();
        Array cateData = Array.factory((DataType)DataType.INT, (int[])obsData.getShape());
        long stnum = obsData.getSize();
        int i = 0;
        while ((long)i < stnum) {
            int value;
            double v_obs = obsData.getDouble(i);
            double v_fcst = fcstData.getDouble(i);
            if (Double.isNaN(v_obs) || Double.isNaN(v_fcst)) {
                value = 0;
            } else {
                boolean bobs = dataRange.isValueIn(v_obs);
                boolean bfcst = dataRange.isValueIn(v_fcst);
                value = bobs && bfcst ? 1 : (bobs && !bfcst ? 2 : (!bobs && bfcst ? 3 : 4));
            }
            cateData.setInt(i, value);
            ++i;
        }
        return cateData;
    }

    public static StationData categorical(StationData obsData, StationData fcstData, VerifyMethod method) {
        StationData cateData = null;
        switch (method.getMethodType()) {
            case DICHOTOMOUS: {
                cateData = new StationData(obsData);
                DichotomousMethod dMethod = (DichotomousMethod)method;
                DataRange dataRange = dMethod.getDataRange();
                int stnum = obsData.getStNum();
                for (int i = 0; i < stnum; ++i) {
                    double value;
                    if (MIMath.doubleEquals((double)obsData.getValue(i), (double)obsData.missingValue)) {
                        value = 0.0;
                    } else if (MIMath.doubleEquals((double)fcstData.getValue(i), (double)fcstData.missingValue)) {
                        value = 0.0;
                    } else {
                        boolean bobs = dataRange.isValueIn(obsData.getValue(i));
                        boolean bfcst = dataRange.isValueIn(fcstData.getValue(i));
                        value = bobs && bfcst ? 1.0 : (bobs && !bfcst ? 2.0 : (!bobs && bfcst ? 3.0 : 4.0));
                    }
                    cateData.setValue(i, value);
                }
                break;
            }
            case MULTICATEGORY: {
                cateData = new StationData(obsData);
                MultiCategoryMethod mMethod = (MultiCategoryMethod)method;
                int stnum = obsData.getStNum();
                double[] values = mMethod.getCategoryValues();
                int vnum = mMethod.getCategoryNum();
                int i = 0;
                int j = 0;
                for (int s = 0; s < stnum; ++s) {
                    int k;
                    double obsValue = obsData.getValue(s);
                    double fcstValue = fcstData.getValue(s);
                    if (MIMath.doubleEquals((double)obsValue, (double)obsData.missingValue) || MIMath.doubleEquals((double)fcstValue, (double)fcstData.missingValue)) continue;
                    for (k = 0; k < vnum; ++k) {
                        if (k < vnum - 1) {
                            if (!(obsValue < values[k])) continue;
                            j = k;
                            break;
                        }
                        j = k;
                        break;
                    }
                    for (k = 0; k < vnum; ++k) {
                        if (k < vnum - 1) {
                            if (!(fcstValue < values[k])) continue;
                            i = k;
                            break;
                        }
                        i = k;
                        break;
                    }
                    cateData.setValue(s, (double)(++i * 10 + ++j));
                }
                break;
            }
        }
        return cateData;
    }

    public static StationData categorical(StationData obsData, StationData fcstData, double threshold, boolean isBigger) {
        StationData veriData = new StationData(obsData);
        int stnum = obsData.getStNum();
        for (int i = 0; i < stnum; ++i) {
            double value;
            if (MIMath.doubleEquals((double)obsData.getValue(i), (double)obsData.missingValue)) {
                value = 0.0;
            } else if (MIMath.doubleEquals((double)fcstData.getValue(i), (double)fcstData.missingValue)) {
                value = 0.0;
            } else {
                boolean bfcst;
                boolean bobs;
                if (isBigger) {
                    bobs = obsData.getValue(i) >= threshold;
                    bfcst = fcstData.getValue(i) >= threshold;
                } else {
                    bobs = obsData.getValue(i) <= threshold;
                    boolean bl = bfcst = fcstData.getValue(i) <= threshold;
                }
                value = bobs && bfcst ? 1.0 : (bobs && !bfcst ? 2.0 : (!bobs && bfcst ? 3.0 : 4.0));
            }
            veriData.setValue(i, value);
        }
        return veriData;
    }

    public static ContingencyTable aggregate(GridData veriData) {
        ContingencyTable outData = new ContingencyTable();
        for (int i = 0; i < veriData.getYNum(); ++i) {
            block7: for (int j = 0; j < veriData.getXNum(); ++j) {
                switch (veriData.getValue(i, j).intValue()) {
                    case 1: {
                        ++outData.hit;
                        continue block7;
                    }
                    case 2: {
                        ++outData.miss;
                        continue block7;
                    }
                    case 3: {
                        ++outData.falseAlarm;
                        continue block7;
                    }
                    case 4: {
                        ++outData.correctNegative;
                    }
                }
            }
        }
        return outData;
    }

    public static ContingencyTable aggregate(Array cateData) {
        ContingencyTable cTable = new ContingencyTable();
        int i = 0;
        while ((long)i < cateData.getSize()) {
            switch (cateData.getInt(i)) {
                case 1: {
                    ++cTable.hit;
                    break;
                }
                case 2: {
                    ++cTable.miss;
                    break;
                }
                case 3: {
                    ++cTable.falseAlarm;
                    break;
                }
                case 4: {
                    ++cTable.correctNegative;
                }
            }
            ++i;
        }
        return cTable;
    }

    public static VerifyTable aggregate(StationData veriData, VerifyMethod method) {
        switch (method.getMethodType()) {
            case DICHOTOMOUS: {
                ContingencyTable cTable = new ContingencyTable();
                block10: for (int i = 0; i < veriData.getStNum(); ++i) {
                    switch ((int)veriData.getValue(i)) {
                        case 1: {
                            ++cTable.hit;
                            continue block10;
                        }
                        case 2: {
                            ++cTable.miss;
                            continue block10;
                        }
                        case 3: {
                            ++cTable.falseAlarm;
                            continue block10;
                        }
                        case 4: {
                            ++cTable.correctNegative;
                        }
                    }
                }
                return cTable;
            }
            case MULTICATEGORY: {
                MultiCategoryTable mtable = new MultiCategoryTable();
                int vnum = ((MultiCategoryMethod)method).getCategoryNum();
                int[][] mvalues = new int[vnum][vnum];
                for (int s = 0; s < veriData.getStNum(); ++s) {
                    String value = String.valueOf((int)veriData.getValue(s));
                    int i = Integer.parseInt(value.substring(0, 1)) - 1;
                    int j = Integer.parseInt(value.substring(1)) - 1;
                    int[] nArray = mvalues[i];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                }
                mtable.setValues(mvalues);
            }
        }
        return null;
    }

    public static VerifyTable getVerifyTable(StationData obsData, StationData fcstData, VerifyMethod method) {
        VerifyTable table = null;
        switch (method.getMethodType()) {
            case DICHOTOMOUS: 
            case MULTICATEGORY: {
                StationData cateData = VerifyStat.categorical(obsData, fcstData, method);
                table = VerifyStat.aggregate(cateData, method);
                break;
            }
            case CONTINUOUS: {
                int stnum = obsData.getStNum();
                ArrayList<Double> obsValues = new ArrayList<Double>();
                ArrayList<Double> fcstValues = new ArrayList<Double>();
                for (int s = 0; s < stnum; ++s) {
                    double obsValue = obsData.getValue(s);
                    double fcstValue = fcstData.getValue(s);
                    if (MIMath.doubleEquals((double)obsValue, (double)obsData.missingValue) || MIMath.doubleEquals((double)fcstValue, (double)fcstData.missingValue)) continue;
                    obsValues.add(obsValue);
                    fcstValues.add(fcstValue);
                }
                int n = obsValues.size();
                double[] ovalues = new double[n];
                double[] fvalues = new double[n];
                for (int s = 0; s < n; ++s) {
                    ovalues[s] = (Double)obsValues.get(s);
                    fvalues[s] = (Double)fcstValues.get(s);
                }
                ContinuousTable ctable = new ContinuousTable();
                ctable.setFcstValues(fvalues);
                ctable.setObsValues(ovalues);
                table = ctable;
            }
        }
        return table;
    }

    public static VerifyTable getVerifyTable(Array obsData, Array fcstData, VerifyMethod method) {
        obsData = obsData.copyIfView();
        fcstData = fcstData.copyIfView();
        VerifyTable table = null;
        switch (method.getMethodType()) {
            case DICHOTOMOUS: 
            case MULTICATEGORY: {
                Array cateData = VerifyStat.categorical(obsData, fcstData, method);
                table = VerifyStat.aggregate(cateData);
                break;
            }
            case SCORE: {
                long stnum = obsData.getSize();
                ScoreMethod scoreMethod = (ScoreMethod)method;
                ScoreTable scoreTable = new ScoreTable(scoreMethod.getObsRanges());
                int s = 0;
                while ((long)s < stnum) {
                    int idx;
                    double obsValue = obsData.getDouble(s);
                    double fcstValue = fcstData.getDouble(s);
                    if (!Double.isNaN(obsValue) && !Double.isNaN(fcstValue) && (idx = scoreMethod.getObsRangeIdx(obsValue)) >= 0) {
                        int score = scoreMethod.getScore(idx, fcstValue);
                        scoreTable.addScore(idx, score);
                    }
                    ++s;
                }
                table = scoreTable;
                break;
            }
            case CONTINUOUS: {
                long stnum = obsData.getSize();
                ArrayList<Double> obsValues = new ArrayList<Double>();
                ArrayList<Double> fcstValues = new ArrayList<Double>();
                int s = 0;
                while ((long)s < stnum) {
                    double obsValue = obsData.getDouble(s);
                    double fcstValue = fcstData.getDouble(s);
                    if (!Double.isNaN(obsValue) && !Double.isNaN(fcstValue)) {
                        obsValues.add(obsValue);
                        fcstValues.add(fcstValue);
                    }
                    ++s;
                }
                int n = obsValues.size();
                double[] ovalues = new double[n];
                double[] fvalues = new double[n];
                for (int s2 = 0; s2 < n; ++s2) {
                    ovalues[s2] = (Double)obsValues.get(s2);
                    fvalues[s2] = (Double)fcstValues.get(s2);
                }
                ContinuousTable ctable = new ContinuousTable();
                ctable.setFcstValues(fvalues);
                ctable.setObsValues(ovalues);
                table = ctable;
            }
        }
        return table;
    }

    public static VerifyTable getVerifyTable(GridData obsData, GridData fcstData, VerifyMethod method) {
        VerifyTable table = null;
        switch (method.getMethodType()) {
            case DICHOTOMOUS: {
                GridData cateData = VerifyStat.categorical(obsData, fcstData, method);
                table = VerifyStat.aggregate(cateData);
                break;
            }
            case MULTICATEGORY: {
                MultiCategoryMethod mMethod = (MultiCategoryMethod)method;
                int ynum = obsData.getYNum();
                int xnum = obsData.getXNum();
                double[] values = mMethod.getCategoryValues();
                int vnum = mMethod.getCategoryNum();
                int i = 0;
                int j = 0;
                int[][] mvalues = new int[vnum][vnum];
                for (int m = 0; m < ynum; ++m) {
                    for (int n = 0; n < xnum; ++n) {
                        int k;
                        double obsValue = obsData.getDoubleValue(m, n);
                        double fcstValue = fcstData.getDoubleValue(m, n);
                        if (MIMath.doubleEquals((double)obsValue, (double)obsData.getDoubleMissingValue()) || MIMath.doubleEquals((double)fcstValue, (double)fcstData.getDoubleMissingValue())) continue;
                        for (k = 0; k < vnum; ++k) {
                            if (k < vnum - 1) {
                                if (!(obsValue < values[k])) continue;
                                j = k;
                                break;
                            }
                            j = k;
                            break;
                        }
                        for (k = 0; k < vnum; ++k) {
                            if (k < vnum - 1) {
                                if (!(fcstValue < values[k])) continue;
                                i = k;
                                break;
                            }
                            i = k;
                            break;
                        }
                        int[] nArray = mvalues[i];
                        int n2 = j;
                        nArray[n2] = nArray[n2] + 1;
                    }
                }
                MultiCategoryTable mtable = new MultiCategoryTable();
                mtable.setValues(mvalues);
                table = mtable;
                break;
            }
            case CONTINUOUS: {
                int ynum = obsData.getYNum();
                int xnum = obsData.getXNum();
                ArrayList<Double> obsValues = new ArrayList<Double>();
                ArrayList<Double> fcstValues = new ArrayList<Double>();
                for (int m = 0; m < ynum; ++m) {
                    for (int n = 0; n < xnum; ++n) {
                        double obsValue = obsData.getDoubleValue(m, n);
                        double fcstValue = fcstData.getDoubleValue(m, n);
                        if (MIMath.doubleEquals((double)obsValue, (double)obsData.getDoubleMissingValue()) || MIMath.doubleEquals((double)fcstValue, (double)fcstData.getDoubleMissingValue())) continue;
                        obsValues.add(obsValue);
                        fcstValues.add(fcstValue);
                    }
                }
                int n = obsValues.size();
                double[] ovalues = new double[n];
                double[] fvalues = new double[n];
                for (int s = 0; s < n; ++s) {
                    ovalues[s] = (Double)obsValues.get(s);
                    fvalues[s] = (Double)fcstValues.get(s);
                }
                ContinuousTable ctable = new ContinuousTable();
                ctable.setFcstValues(fvalues);
                ctable.setObsValues(ovalues);
                table = ctable;
            }
        }
        return table;
    }

    public static VerifyTable getVerifyTable(List<Number> obsData, List<Number> fcstData, VerifyMethod method) {
        VerifyTable table = null;
        int n = obsData.size();
        switch (method.getMethodType()) {
            case DICHOTOMOUS: {
                DichotomousMethod dMethod = (DichotomousMethod)method;
                DataRange dataRange = dMethod.getDataRange();
                ContingencyTable cTable = new ContingencyTable();
                for (int i = 0; i < n; ++i) {
                    boolean bobs = dataRange.isValueIn(obsData.get(i).doubleValue());
                    boolean bfcst = dataRange.isValueIn(fcstData.get(i).doubleValue());
                    if (bobs && bfcst) {
                        ++cTable.hit;
                        continue;
                    }
                    if (bobs && !bfcst) {
                        ++cTable.miss;
                        continue;
                    }
                    if (!bobs && bfcst) {
                        ++cTable.falseAlarm;
                        continue;
                    }
                    ++cTable.correctNegative;
                }
                table = cTable;
                break;
            }
            case MULTICATEGORY: {
                MultiCategoryMethod mMethod = (MultiCategoryMethod)method;
                MultiCategoryTable mtable = new MultiCategoryTable();
                int vnum = mMethod.getCategoryNum();
                int[][] mvalues = new int[vnum][vnum];
                double[] values = mMethod.getCategoryValues();
                int i = 0;
                int j = 0;
                for (int s = 0; s < n; ++s) {
                    int k;
                    double obsValue = obsData.get(s).doubleValue();
                    double fcstValue = fcstData.get(s).doubleValue();
                    for (k = 0; k < vnum; ++k) {
                        if (k < vnum - 1) {
                            if (!(obsValue < values[k])) continue;
                            j = k;
                            break;
                        }
                        j = k;
                        break;
                    }
                    for (k = 0; k < vnum; ++k) {
                        if (k < vnum - 1) {
                            if (!(fcstValue < values[k])) continue;
                            i = k;
                            break;
                        }
                        i = k;
                        break;
                    }
                    int[] nArray = mvalues[i];
                    int n2 = j;
                    nArray[n2] = nArray[n2] + 1;
                }
                mtable.setValues(mvalues);
                table = mtable;
                break;
            }
            case CONTINUOUS: {
                ContinuousTable ctable;
                table = ctable = new ContinuousTable(obsData, fcstData);
            }
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeVerifyFile(List<VerifyTable> tables, String fileName) {
        BufferedWriter sw = null;
        try {
            sw = new BufferedWriter(new FileWriter(new File(fileName)));
            String sName = tables.get(0).getScoreNames();
            String[] sNames = sName.split(",");
            String title = "ID," + sName;
            sw.write(title);
            sw.newLine();
            for (int i = 0; i < tables.size(); ++i) {
                VerifyTable table = tables.get(i);
                String line = table.getName();
                Map map = table.getVerifyResult();
                for (String s : sNames) {
                    line = line + "," + String.format("%1$.2f", map.get(s));
                }
                sw.write(line);
                sw.newLine();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VerifyStat.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                sw.flush();
                sw.close();
            }
            catch (IOException ex) {
                Logger.getLogger(VerifyStat.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeVerifyFile(List<VerifyTable> tables, List<LocalDateTime> times, String fileName) {
        BufferedWriter sw = null;
        try {
            sw = new BufferedWriter(new FileWriter(new File(fileName)));
            String sName = tables.get(0).getScoreNames();
            String[] sNames = sName.split(",");
            String title = "Time,Region," + sName;
            sw.write(title);
            sw.newLine();
            DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < tables.size(); ++i) {
                VerifyTable table = tables.get(i);
                LocalDateTime time = times.get(i);
                String line = format.format(time) + "," + table.getName();
                Map map = table.getVerifyResult();
                for (String s : sNames) {
                    Object v = map.get(s);
                    line = v instanceof Float ? line + "," + String.format("%1$.2f", v) : line + "," + String.valueOf(v);
                }
                sw.write(line);
                sw.newLine();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VerifyStat.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                sw.flush();
                sw.close();
            }
            catch (IOException ex) {
                Logger.getLogger(VerifyStat.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

