/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.layer;

import com.l2fprod.common.beans.BaseBeanInfo;
import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.GenericFileFilter;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.colors.ColorMap;
import org.meteoinfo.common.util.GlobalUtil;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.geo.layer.ImageLayer;
import org.meteoinfo.geo.layer.LayerDrawType;
import org.meteoinfo.geo.layer.LayerTypes;
import org.meteoinfo.geo.layer.WorldFilePara;
import org.meteoinfo.geo.mapdata.MapDataManage;
import org.meteoinfo.geometry.colors.Normalize;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.projection.ProjectionInfo;

public class RasterLayer
extends ImageLayer {
    private GridArray _gridData;
    private GridArray _originGridData = null;
    private boolean _isProjected = false;
    private List<Color> _colors;
    private double missingValue = Double.NaN;
    private Color missingColor = Color.white;

    public RasterLayer() {
        this._layerType = LayerTypes.RASTER_LAYER;
        this.setShapeType(ShapeTypes.IMAGE);
    }

    @Override
    public void setLegendScheme(LegendScheme ls) {
        super.setLegendScheme(ls);
        if (ls == null) {
            this.updateImage(ls);
        } else if (ls.getBreakNum() < 200) {
            this.updateImage(ls);
        } else {
            this.setPaletteByLegend();
        }
    }

    public GridArray getGridData() {
        return this._gridData;
    }

    public void setGridData(GridArray gdata) {
        this._gridData = gdata;
        this.updateGridData();
    }

    public boolean isProjected() {
        return this._isProjected;
    }

    public void setProjected(boolean istrue) {
        this._isProjected = istrue;
    }

    public double getMissingValue() {
        return this.missingValue;
    }

    public void setMissingValue(double value) {
        this.missingValue = value;
    }

    public Color getMissingColor() {
        return this.missingColor;
    }

    public void setMissingColor(Color value) {
        this.missingColor = value;
    }

    public double getCellValue(int iIdx, int jIdx) {
        return this._gridData.getDoubleValue(iIdx, jIdx);
    }

    public void updateImage(LegendScheme als) {
        BufferedImage image;
        if (this._gridData.getData().getRank() <= 2) {
            image = this.getImageFromGridData(this._gridData, als);
        } else {
            image = this.getRGBImage(this._gridData);
            super.setLegendScheme(null);
        }
        this.setImage(image);
    }

    public void updateImage() {
        BufferedImage image = this.getImageFromGridData(this._gridData, this.getLegendScheme());
        this.setImage(image);
    }

    private BufferedImage getRGBImage(GridArray gdata) {
        int width = gdata.getXNum();
        int height = gdata.getYNum();
        BufferedImage image = new BufferedImage(width, height, 2);
        Index index = gdata.getData().getIndex();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int r = gdata.getData().getInt(index);
                index.incr();
                int g = gdata.getData().getInt(index);
                index.incr();
                int b = gdata.getData().getInt(index);
                index.incr();
                image.setRGB(j, height - i - 1, new Color(r, g, b).getRGB());
            }
        }
        return image;
    }

    private BufferedImage getImageFromGridData(GridArray gdata, LegendScheme ls) {
        int width = gdata.getXNum();
        int height = gdata.getYNum();
        BufferedImage aImage = new BufferedImage(width, height, 2);
        if (ls.getColorMap() == null) {
            Color color;
            int breakNum = ls.getBreakNum();
            double[] breakValue = new double[breakNum];
            Color[] breakColor = new Color[breakNum];
            Color undefColor = this.missingColor;
            Color defaultColor = ((ColorBreak)ls.getLegendBreaks().get(breakNum - 1)).getColor();
            for (int i = 0; i < breakNum; ++i) {
                breakValue[i] = Double.parseDouble(((ColorBreak)ls.getLegendBreaks().get(i)).getEndValue().toString());
                breakColor[i] = color = ((ColorBreak)ls.getLegendBreaks().get(i)).getColor();
                if (((ColorBreak)ls.getLegendBreaks().get(i)).isNoData()) {
                    undefColor = color;
                    continue;
                }
                defaultColor = color;
            }
            Array data = gdata.getData().copyIfView();
            double[] values = ls.getValues();
            int n = values.length;
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    double value = data.getDouble(i * width + j);
                    if (Double.isNaN(value) || MIMath.doubleEquals((double)value, (double)gdata.missingValue)) {
                        color = undefColor;
                    } else {
                        int idx = Arrays.binarySearch(values, value);
                        if (ls.getLegendType() == LegendType.UNIQUE_VALUE) {
                            color = idx < 0 || idx >= n ? undefColor : ls.getLegendBreak(idx).getColor();
                        } else {
                            if (idx < 0) {
                                idx = idx == -1 ? 0 : (idx == -n - 1 ? n - 1 : -idx - 2);
                            } else if (idx == n - 1) {
                                idx = n - 2;
                            }
                            color = ls.getLegendBreak(idx).getColor();
                        }
                    }
                    aImage.setRGB(j, height - i - 1, color.getRGB());
                }
            }
        } else {
            ColorMap colorMap = ls.getColorMap();
            int n = colorMap.getColorCount();
            Normalize normalize = ls.getNormalize();
            Color fillColor = colorMap.getFillColor();
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    Color color;
                    double v = gdata.getDoubleValue(i, j);
                    if (Double.isNaN(v) || MIMath.doubleEquals((double)v, (double)gdata.missingValue)) {
                        color = fillColor;
                    } else {
                        int idx = (int)(normalize.apply((Number)v).floatValue() * (float)n);
                        if (idx < 0) {
                            idx = 0;
                        } else if (idx >= n) {
                            idx = n - 1;
                        }
                        color = colorMap.getColor(idx);
                    }
                    aImage.setRGB(j, height - i - 1, color.getRGB());
                }
            }
        }
        return aImage;
    }

    private BufferedImage getImageFromGridData(GridArray gdata, List<Color> colors) {
        int width = gdata.getXNum();
        int height = gdata.getYNum();
        BufferedImage aImage = new BufferedImage(width, height, 2);
        int n = colors.size();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int oneValue = gdata.getValue(i, j).intValue();
                Color oneColor = colors.get(oneValue);
                aImage.setRGB(j, height - i - 1, oneColor.getRGB());
            }
        }
        return aImage;
    }

    @Override
    public void setPalette(String aFile) {
        List<Color> colors = this.getColorsFromPaletteFile(aFile);
        BufferedImage image = this.getImageFromGridData(this._gridData, colors);
        this.setImage(image);
        LegendScheme ls = new LegendScheme(ShapeTypes.IMAGE);
        ls.importFromPaletteFile_Unique(aFile);
        this.setLegendScheme(ls);
    }

    public void setPaletteByLegend() {
        this._colors = this.getLegendScheme().getColors();
        BufferedImage image = this.getImageFromGridData(this._gridData, this._colors);
        this.setImage(image);
    }

    public void updateGridData() {
        WorldFilePara aWFP = new WorldFilePara();
        aWFP.xUL = this._gridData.xArray[0] - this._gridData.getXDelt() / 2.0;
        aWFP.yUL = this._gridData.yArray[this._gridData.getYNum() - 1] + this._gridData.getYDelt() / 2.0;
        aWFP.xScale = this._gridData.getXDelt();
        aWFP.yScale = -this._gridData.getYDelt();
        aWFP.xRotate = 0.0;
        aWFP.yRotate = 0.0;
        this.setWorldFilePara(aWFP);
        this.updateExtent();
    }

    private void updateExtent() {
        double XBR = (double)this._gridData.getXNum() * this.getWorldFilePara().xScale + this.getWorldFilePara().xUL;
        double YBR = (double)this._gridData.getYNum() * this.getWorldFilePara().yScale + this.getWorldFilePara().yUL;
        Extent aExtent = new Extent();
        aExtent.minX = this.getWorldFilePara().xUL;
        aExtent.minY = YBR;
        aExtent.maxX = XBR;
        aExtent.maxY = this.getWorldFilePara().yUL;
        this.setExtent(aExtent);
    }

    public void updateOriginData() {
        this._originGridData = (GridArray)this._gridData.clone();
        this._isProjected = true;
    }

    public void getOriginData() {
        this._gridData = (GridArray)this._originGridData.clone();
    }

    @Override
    public void saveFile() {
        File aFile = new File(this.getFileName());
        if (aFile.exists()) {
            this.saveFile(aFile.getAbsolutePath());
        } else {
            JFileChooser aDlg = new JFileChooser();
            String curDir = System.getProperty("user.dir");
            aDlg.setCurrentDirectory(new File(curDir));
            String[] fileExts = new String[]{"bil"};
            GenericFileFilter pFileFilter = new GenericFileFilter(fileExts, "BIL File (*.bil)");
            aDlg.addChoosableFileFilter((FileFilter)pFileFilter);
            aDlg.setFileFilter((FileFilter)pFileFilter);
            fileExts = new String[]{"grd"};
            pFileFilter = new GenericFileFilter(fileExts, "Surfer ASCII Grid File (*.grd)");
            aDlg.addChoosableFileFilter((FileFilter)pFileFilter);
            fileExts = new String[]{"asc"};
            pFileFilter = new GenericFileFilter(fileExts, "ESRI ASCII Grid File (*.asc)");
            aDlg.addChoosableFileFilter((FileFilter)pFileFilter);
            aDlg.setAcceptAllFileFilterUsed(false);
            if (0 == aDlg.showSaveDialog(null)) {
                aFile = aDlg.getSelectedFile();
                System.setProperty("user.dir", aFile.getParent());
                String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
                String fileName = aFile.getAbsolutePath();
                if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                    fileName = fileName + "." + extent;
                }
                this.saveFile(fileName);
            }
        }
    }

    @Override
    public void saveFile(String fileName) {
        this.saveFile(fileName, this.getProjInfo());
    }

    public void saveFile(String fileName, ProjectionInfo projInfo) {
        int n;
        File aFile = new File(fileName);
        if (aFile.exists() && (n = JOptionPane.showConfirmDialog(null, "Overwirte the existing file?", "Overwrite confirm", 0)) == 1) {
            return;
        }
        try {
            String ext;
            this.setFileName(fileName);
            switch (ext = GlobalUtil.getFileExtension((String)fileName)) {
                case "bil": {
                    this._gridData.saveAsBILFile(fileName);
                    break;
                }
                case "grd": {
                    this._gridData.saveAsSurferASCIIFile(fileName);
                    break;
                }
                case "asc": {
                    this._gridData.saveAsESRIASCIIFile(fileName);
                    break;
                }
                default: {
                    return;
                }
            }
            if (!this.getProjInfo().isLonLat()) {
                String projFn = fileName.substring(0, fileName.length() - 3) + "prj";
                MapDataManage.writeProjFile(projFn, projInfo);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(RasterLayer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static class RasterLayerBeanBeanInfo
    extends BaseBeanInfo {
        public RasterLayerBeanBeanInfo() {
            super(RasterLayerBean.class);
            this.addProperty("fileName").setCategory("Read only").setReadOnly().setDisplayName("File name");
            this.addProperty("layerType").setCategory("Read only").setReadOnly().setDisplayName("Layer type");
            this.addProperty("layerDrawType").setCategory("Read only").setReadOnly().setDisplayName("Layer draw type");
            this.addProperty("handle").setCategory("Read only").setReadOnly().setDisplayName("Handle");
            this.addProperty("layerName").setCategory("Editable").setDisplayName("Layer name");
            this.addProperty("visible").setCategory("Editable").setDisplayName("Visible");
            this.addProperty("maskout").setCategory("Editable").setDisplayName("Is maskout");
            ExtendedPropertyDescriptor e = this.addProperty("interpolation");
            e.setCategory("Editable").setPropertyEditorClass(ImageLayer.InterpolationEditor.class);
            e.setDisplayName("Interpolation");
        }
    }

    public class RasterLayerBean {
        RasterLayerBean() {
        }

        public LayerTypes getLayerType() {
            return RasterLayer.this.getLayerType();
        }

        public LayerDrawType getLayerDrawType() {
            return RasterLayer.this.getLayerDrawType();
        }

        public void setLayerDrawType(LayerDrawType ldt) {
            RasterLayer.this.setLayerDrawType(ldt);
        }

        public String getFileName() {
            return RasterLayer.this.getFileName();
        }

        public void setFileName(String fn) {
            RasterLayer.this.setFileName(fn);
        }

        public int getHandle() {
            return RasterLayer.this.getHandle();
        }

        public String getLayerName() {
            return RasterLayer.this.getLayerName();
        }

        public void setLayerName(String name) {
            RasterLayer.this.setLayerName(name);
        }

        public boolean isMaskout() {
            return RasterLayer.this.isMaskout();
        }

        public void setMaskout(boolean value) {
            RasterLayer.this.setMaskout(value);
        }

        public boolean isVisible() {
            return RasterLayer.this.isVisible();
        }

        public void setVisible(boolean value) {
            RasterLayer.this.setVisible(value);
        }

        public String getInterpolation() {
            if (RasterLayer.this.interp == RenderingHints.VALUE_INTERPOLATION_BILINEAR) {
                return "bilinear";
            }
            if (RasterLayer.this.interp == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
                return "bicubic";
            }
            return "nearest";
        }

        public void setInterpolation(String value) {
            switch (value) {
                case "nearest": {
                    RasterLayer.this.interp = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                    break;
                }
                case "bilinear": {
                    RasterLayer.this.interp = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
                    break;
                }
                case "bicubic": {
                    RasterLayer.this.interp = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
                }
            }
        }
    }
}

