/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.legend;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.GenericFileFilter;
import org.meteoinfo.common.PointF;
import org.meteoinfo.data.mapdata.webmap.WebMapProvider;
import org.meteoinfo.geo.gui.FrmProperty;
import org.meteoinfo.geo.layer.FrmLabelSet;
import org.meteoinfo.geo.layer.FrmLayerProperty;
import org.meteoinfo.geo.layer.LayerTypes;
import org.meteoinfo.geo.layer.MapLayer;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.layer.WebMapLayer;
import org.meteoinfo.geo.layout.MapLayout;
import org.meteoinfo.geo.legend.GroupNode;
import org.meteoinfo.geo.legend.ItemNode;
import org.meteoinfo.geo.legend.LayerNode;
import org.meteoinfo.geo.legend.LegendNode;
import org.meteoinfo.geo.legend.MapFrame;
import org.meteoinfo.geo.legend.NodeTypes;
import org.meteoinfo.geo.mapdata.FrmAttriData;
import org.meteoinfo.geo.mapdata.MapDataManage;
import org.meteoinfo.geo.mapview.MapView;
import org.meteoinfo.geo.mapview.MapViewUndoRedo;
import org.meteoinfo.geometry.legend.ChartBreak;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.Constants;
import org.meteoinfo.geometry.legend.MarkerType;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.render.java2d.Draw;
import org.meteoinfo.ui.event.ActiveMapFrameChangedEvent;
import org.meteoinfo.ui.event.IActiveMapFrameChangedListener;
import org.meteoinfo.ui.event.ILayersUpdatedListener;
import org.meteoinfo.ui.event.IMapFramesUpdatedListener;
import org.meteoinfo.ui.event.INodeSelectedListener;
import org.meteoinfo.ui.event.LayersUpdatedEvent;
import org.meteoinfo.ui.event.MapFramesUpdatedEvent;
import org.meteoinfo.ui.event.NodeSelectedEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LayersLegend
extends JPanel {
    private EventListenerList _listeners = new EventListenerList();
    private BufferedImage _paintImage = new BufferedImage(10, 10, 2);
    public FrmLayerProperty frmLayerProp;
    private JScrollBar _vScrollBar;
    private MapLayout _mapLayout;
    private ItemNode _selectedNode;
    private Color _selectedBackColor = new Color(75, 110, 175);
    private Color _selectedForeColor = Color.white;
    private Point _mouseDownPos = new Point(0, 0);
    private ItemNode _dragNode = null;
    private MapFrame _currentMapFrame;
    private List<MapFrame> _mapFrames = new ArrayList<MapFrame>();
    private boolean _dragMode = false;
    private int _dragPosY;
    private LookAndFeel laf = UIManager.getLookAndFeel();

    public LayersLegend() {
        this.setBackground(this.laf.getDefaults().getColor("List.background"));
        this._selectedBackColor = this.laf.getDefaults().getColor("List.selectionBackground");
        this._selectedForeColor = this.laf.getDefaults().getColor("List.selectionForeground");
        this.setLayout(new BorderLayout());
        this.setDoubleBuffered(true);
        this.initComponents();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LayersLegend.this.onMouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                LayersLegend.this.onMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                try {
                    LayersLegend.this.onMouseReleased(e);
                }
                catch (CloneNotSupportedException ex) {
                    Logger.getLogger(LayersLegend.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                LayersLegend.this.onMouseDragged(e);
            }
        });
        MapFrame mf = new MapFrame();
        mf.setActive(true);
        this.addMapFrame(mf);
        this._mapLayout = null;
        this.frmLayerProp = null;
    }

    private void initComponents() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LayersLegend.this.onComponentResized(e);
            }
        });
        this._vScrollBar = new JScrollBar(1);
        this._vScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                LayersLegend.this.onScrollValueChanged(e);
            }
        });
        this.add((Component)this._vScrollBar, "East");
        this._vScrollBar.setLocation(this.getWidth() - this._vScrollBar.getWidth(), 0);
        this._vScrollBar.setSize(this._vScrollBar.getWidth(), this.getHeight());
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
    }

    public ItemNode getSelectedNode() {
        return this._selectedNode;
    }

    public void setSelectedNode(ItemNode aNode) {
        this._selectedNode = aNode;
        this.fireNodeSelectedEvent();
    }

    public MapFrame getCurrentMapFrame() {
        return this.getMapFrame(this._selectedNode);
    }

    public MapFrame getActiveMapFrame() {
        for (MapFrame mf : this._mapFrames) {
            if (!mf.isActive()) continue;
            return mf;
        }
        return null;
    }

    public List<MapFrame> getMapFrames() {
        return this._mapFrames;
    }

    public void setMapFrames(List<MapFrame> mfs) {
        this._mapFrames = mfs;
    }

    public MapLayout getMapLayout() {
        return this._mapLayout;
    }

    public void setMapLayout(MapLayout ml) {
        this._mapLayout = ml;
        this._mapLayout.updateMapFrames(this._mapFrames);
        this._mapLayout.addActiveMapFrameChangedListener(new IActiveMapFrameChangedListener(){

            public void activeMapFrameChangedEvent(ActiveMapFrameChangedEvent event) {
                LayersLegend.this.setActiveMapFrame(LayersLegend.this._mapLayout.getActiveMapFrame());
            }
        });
        this._mapLayout.addMapFramesUpdatedListener(new IMapFramesUpdatedListener(){

            public void mapFramesUpdatedEvent(MapFramesUpdatedEvent event) {
                if (LayersLegend.this._mapLayout != null) {
                    LayersLegend.this._mapFrames = LayersLegend.this._mapLayout.getMapFrames();
                    LayersLegend.this.paintGraphics();
                }
            }
        });
    }

    public void addMapFramesUpdatedListener(IMapFramesUpdatedListener listener) {
        this._listeners.add(IMapFramesUpdatedListener.class, listener);
    }

    public void removeMapFramesUpdatedListener(IMapFramesUpdatedListener listener) {
        this._listeners.remove(IMapFramesUpdatedListener.class, listener);
    }

    public void fireMapFramesUpdatedEvent() {
        this.fireMapFramesUpdatedEvent(new MapFramesUpdatedEvent((Object)this));
    }

    private void fireMapFramesUpdatedEvent(MapFramesUpdatedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IMapFramesUpdatedListener.class) continue;
            ((IMapFramesUpdatedListener)listeners[i + 1]).mapFramesUpdatedEvent(event);
        }
    }

    public void addNodeSelectedListener(INodeSelectedListener listener) {
        this._listeners.add(INodeSelectedListener.class, listener);
    }

    public void removeNodeSelectedListener(INodeSelectedListener listener) {
        this._listeners.remove(INodeSelectedListener.class, listener);
    }

    public void fireNodeSelectedEvent() {
        this.fireNodeSelectedEvent(new NodeSelectedEvent((Object)this));
    }

    private void fireNodeSelectedEvent(NodeSelectedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != INodeSelectedListener.class) continue;
            ((INodeSelectedListener)listeners[i + 1]).nodeSelectedEvent(event);
        }
    }

    public void addActiveMapFrameChangedListener(IActiveMapFrameChangedListener listener) {
        this._listeners.add(IActiveMapFrameChangedListener.class, listener);
    }

    public void removeActiveMapFrameChangedListener(IActiveMapFrameChangedListener listener) {
        this._listeners.remove(IActiveMapFrameChangedListener.class, listener);
    }

    public void fireActiveMapFrameChangedEvent() {
        this.fireActiveMapFrameChangedEvent(new ActiveMapFrameChangedEvent((Object)this));
    }

    private void fireActiveMapFrameChangedEvent(ActiveMapFrameChangedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IActiveMapFrameChangedListener.class) continue;
            ((IActiveMapFrameChangedListener)listeners[i + 1]).activeMapFrameChangedEvent(event);
        }
        this.paintGraphics();
    }

    public void onScrollValueChanged(AdjustmentEvent e) {
        this._vScrollBar.setValue(e.getValue());
        this.paintGraphics();
    }

    public void onComponentResized(ComponentEvent e) {
        this._vScrollBar.setLocation(this.getWidth() - this._vScrollBar.getWidth(), 0);
        this._vScrollBar.setSize(this._vScrollBar.getWidth(), this.getHeight());
        this.paintGraphics();
    }

    public void onMouseClicked(MouseEvent e) {
        int clickTimes = e.getClickCount();
        if (clickTimes == 1) {
            MousePos mPos = new MousePos();
            ItemNode aNode = this.getNodeByPosition(e.getX(), e.getY(), mPos);
            if (aNode == null) {
                return;
            }
            this.selectNode(aNode);
            switch (aNode.getNodeType()) {
                case GROUP_NODE: {
                    this.onGroupMouseClicked(e);
                    break;
                }
                case LAYER_NODE: {
                    this.onLayerMouseClicked(e);
                    break;
                }
                case MAP_FRAME_NODE: {
                    this.onMapFrameMouseClicked(e);
                }
            }
            this.paintGraphics();
        } else if (clickTimes == 2) {
            MousePos mPos = new MousePos();
            ItemNode aNode = this.getNodeByPosition(e.getX(), e.getY(), mPos);
            if (aNode != null) {
                switch (aNode.getNodeType()) {
                    case LAYER_NODE: {
                        this.onPropertiesClick(null);
                        break;
                    }
                    case GROUP_NODE: {
                        FrmProperty pFrm = new FrmProperty((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), true, false);
                        pFrm.setObject((GroupNode)aNode.new GroupNode.GroupNodeBean());
                        pFrm.setLocationRelativeTo(this);
                        pFrm.setVisible(true);
                        break;
                    }
                    case MAP_FRAME_NODE: {
                        FrmProperty pFrm = new FrmProperty((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), true, false);
                        pFrm.setObject(new MapFrame.MapFrameBean((MapFrame)aNode));
                        pFrm.setLocationRelativeTo(this);
                        pFrm.setVisible(true);
                    }
                }
            }
        }
    }

    public void onMousePressed(MouseEvent e) {
        this._mouseDownPos.x = e.getX();
        this._mouseDownPos.y = e.getY();
        MousePos mPos = new MousePos();
        mPos.curTop = 0;
        mPos.inItem = false;
        this._dragNode = this.getNodeByPosition(e.getX(), e.getY(), mPos);
    }

    public void onMouseReleased(MouseEvent e) throws CloneNotSupportedException {
        this._dragMode = false;
        if (e.getButton() == 1 && this._dragNode != null) {
            MousePos mPos = new MousePos();
            mPos.inItem = false;
            mPos.curTop = 0;
            ItemNode aNode = this.getNodeByPosition(e.getX(), e.getY(), mPos);
            if (aNode != null && aNode != this._dragNode) {
                MapFrame mapFrame;
                MapFrame fromMF = this.getMapFrame(this._dragNode);
                if (fromMF == (mapFrame = this.getMapFrame(aNode))) {
                    if (this._dragNode.getNodeType() == NodeTypes.GROUP_NODE) {
                        ((GroupNode)this._dragNode).getMapFrame().removeNode(this._dragNode);
                        if (aNode.getNodeType() == NodeTypes.MAP_FRAME_NODE) {
                            mapFrame.addNode(this._dragNode);
                        } else {
                            int idx = mapFrame.getNodes().indexOf(aNode);
                            if (idx < 0) {
                                idx = 0;
                            }
                            mapFrame.addNode(idx, this._dragNode);
                        }
                    } else if (this._dragNode.getNodeType() == NodeTypes.LAYER_NODE) {
                        if (((LayerNode)this._dragNode).getGroupHandle() >= 0) {
                            GroupNode sGroup = mapFrame.getGroupByHandle(((LayerNode)this._dragNode).getGroupHandle());
                            sGroup.removeLayer((LayerNode)this._dragNode);
                        } else {
                            mapFrame.removeNode(this._dragNode);
                        }
                        switch (aNode.getNodeType()) {
                            case MAP_FRAME_NODE: {
                                mapFrame.addNode(this._dragNode);
                                break;
                            }
                            case GROUP_NODE: {
                                ((GroupNode)aNode).addLayer((LayerNode)this._dragNode);
                                break;
                            }
                            case LAYER_NODE: {
                                if (((LayerNode)aNode).getGroupHandle() >= 0) {
                                    GroupNode dGroup = mapFrame.getGroupByHandle(((LayerNode)aNode).getGroupHandle());
                                    dGroup.addLayer(dGroup.getLayerIndex((LayerNode)aNode), (LayerNode)this._dragNode);
                                    break;
                                }
                                int idx = mapFrame.getNodes().indexOf(aNode);
                                if (idx < 0) {
                                    idx = 0;
                                }
                                mapFrame.addNode(idx, this._dragNode);
                            }
                        }
                    }
                    mapFrame.reOrderMapViewLayers();
                } else if (this._dragNode.getNodeType() == NodeTypes.GROUP_NODE) {
                    GroupNode newGN = new GroupNode(this._dragNode.getText());
                    for (LayerNode aLN : ((GroupNode)this._dragNode).getLayers()) {
                        LayerNode bLN = (LayerNode)aLN.clone();
                        newGN.addLayer(bLN);
                    }
                    if (aNode.getNodeType() == NodeTypes.MAP_FRAME_NODE) {
                        mapFrame.addGroupNode(newGN);
                    } else {
                        int idx = mapFrame.getNodes().indexOf(aNode);
                        mapFrame.addGroupNode(idx, newGN);
                    }
                } else if (this._dragNode.getNodeType() == NodeTypes.LAYER_NODE) {
                    LayerNode aLN = (LayerNode)((LayerNode)this._dragNode).clone();
                    switch (aNode.getNodeType()) {
                        case MAP_FRAME_NODE: {
                            mapFrame.addLayerNode(aLN);
                            break;
                        }
                        case GROUP_NODE: {
                            mapFrame.addLayerNode(aLN, (GroupNode)aNode);
                            break;
                        }
                        case LAYER_NODE: {
                            if (((LayerNode)aNode).getGroupHandle() >= 0) {
                                GroupNode dGroup = mapFrame.getGroupByHandle(((LayerNode)aNode).getGroupHandle());
                                mapFrame.addLayerNode(dGroup.getLayerIndex((LayerNode)aNode), aLN, dGroup);
                                break;
                            }
                            int idx = mapFrame.getNodes().indexOf(aNode);
                            mapFrame.addLayerNode(idx, aLN);
                        }
                    }
                }
            }
            this.paintGraphics();
        }
    }

    public void onMouseDragged(MouseEvent e) {
        this._dragMode = true;
        if (this._dragNode != null) {
            MousePos mPos = new MousePos();
            mPos.curTop = 0;
            mPos.inItem = false;
            ItemNode aNode = this.getNodeByPosition(e.getX(), e.getY(), mPos);
            if (aNode != null && aNode != this._dragNode) {
                if (this._dragNode.getNodeType() == NodeTypes.GROUP_NODE && aNode.getNodeType() == NodeTypes.LAYER_NODE && ((LayerNode)aNode).getGroupHandle() != -1) {
                    return;
                }
                this._dragPosY = mPos.curTop + aNode.getHeight();
                if (aNode.getNodeType() == NodeTypes.LAYER_NODE) {
                    this._dragPosY = mPos.curTop + aNode.getDrawHeight();
                }
            }
            this.repaint();
        }
    }

    private void onGroupMouseClicked(MouseEvent e) {
        MousePos mPos = new MousePos();
        GroupNode aNode = (GroupNode)this.getNodeByPositionEx(e.getX(), e.getY(), mPos);
        if (mPos.inExpansionBox) {
            if (e.getButton() == 1) {
                if (aNode.isExpanded()) {
                    aNode.collapse();
                } else {
                    aNode.expand();
                }
                this.paintGraphics();
            }
        } else if (mPos.inCheckBox) {
            if (e.getButton() == 1) {
                switch (aNode.getCheckStatus()) {
                    case 0: 
                    case 2: {
                        aNode.setCheckStatus(1);
                        aNode.setChecked(true);
                        break;
                    }
                    default: {
                        aNode.setCheckStatus(0);
                        aNode.setChecked(false);
                    }
                }
                for (LayerNode aLN : aNode.getLayers()) {
                    aLN.setChecked(aNode.isChecked());
                    MapLayer aLayer = aLN.getMapFrame().getMapView().getLayerByHandle(aLN.getLayerHandle());
                    aLayer.setVisible(aNode.isChecked());
                }
                this.paintGraphics();
                aNode.getMapFrame().fireLayersUpdatedEvent();
                aNode.getMapFrame().getMapView().paintLayers();
            }
        } else if (e.getButton() == 3) {
            this._currentMapFrame = this.getMapFrame(aNode);
            JPopupMenu mnuGroup = new JPopupMenu();
            JMenuItem newGroupMI = new JMenuItem("New Group");
            newGroupMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayersLegend.this.onAddGroupClick(e);
                }
            });
            mnuGroup.add(newGroupMI);
            JMenuItem removeGroupMI = new JMenuItem("Remove Group");
            removeGroupMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayersLegend.this.onRemoveGroupClick(e);
                }
            });
            mnuGroup.add(removeGroupMI);
            mnuGroup.show(this, e.getX(), e.getY());
        }
    }

    private void onLayerMouseClicked(MouseEvent e) {
        MousePos mPos = new MousePos();
        ItemNode aNode = this.getNodeByPositionEx(e.getX(), e.getY(), mPos);
        LayerNode aLN = (LayerNode)aNode;
        MapLayer aLayerObj = aLN.getMapLayer();
        if (mPos.inExpansionBox) {
            if (e.getButton() == 1) {
                if (aNode.isExpanded()) {
                    aNode.collapse();
                } else {
                    aNode.expand();
                }
                aLayerObj.setExpanded(aNode.isExpanded());
                aLN.getMapFrame().fireLayersUpdatedEvent();
            }
        } else if (mPos.inCheckBox) {
            if (e.getButton() == 1) {
                aNode.setChecked(!aNode.isChecked());
                aLayerObj.setVisible(aNode.isChecked());
                aLN.getMapFrame().fireLayersUpdatedEvent();
                aLN.getMapFrame().getMapView().paintLayers();
            }
        } else if (e.getButton() == 3) {
            JPopupMenu mnuLayer = new JPopupMenu();
            JMenuItem removeLayerMI = new JMenuItem("Remove Layer");
            removeLayerMI.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/delete.svg"));
            removeLayerMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayersLegend.this.onRemoveLayerClick(e);
                }
            });
            mnuLayer.add(removeLayerMI);
            switch (aLayerObj.getLayerType()) {
                case VECTOR_LAYER: 
                case RASTER_LAYER: {
                    if (new File(aLayerObj.getFileName()).exists()) break;
                    JMenuItem saveLayerMI = new JMenuItem("Save Layer");
                    saveLayerMI.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayersLegend.this.onSaveLayerClick(e);
                        }
                    });
                    mnuLayer.add(saveLayerMI);
                }
            }
            mnuLayer.addSeparator();
            if (aLayerObj.getLayerType() == LayerTypes.VECTOR_LAYER) {
                JMenuItem attrTableMI = new JMenuItem("Attribute Table");
                attrTableMI.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/table.svg"));
                attrTableMI.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayersLegend.this.onAttrTableClick(e);
                    }
                });
                mnuLayer.add(attrTableMI);
                mnuLayer.addSeparator();
            }
            JMenuItem zoomToLayerMI = new JMenuItem("Zoom To Layer");
            zoomToLayerMI.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/find.svg"));
            zoomToLayerMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayersLegend.this.onZoomToLayerClick(e);
                }
            });
            mnuLayer.add(zoomToLayerMI);
            JMenu visScaleMenu = new JMenu("Visible Scale");
            JMenuItem minVisScaleMI = new JMenuItem("Set Minimum Scale");
            minVisScaleMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayersLegend.this.onMinVisScaleClick(e);
                }
            });
            visScaleMenu.add(minVisScaleMI);
            JMenuItem maxVisScaleMI = new JMenuItem("Set Maximum Scale");
            maxVisScaleMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayersLegend.this.onMaxVisScaleClick(e);
                }
            });
            visScaleMenu.add(maxVisScaleMI);
            JMenuItem removeVisScaleMI = new JMenuItem("Remove Visible Scale");
            removeVisScaleMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayersLegend.this.onRemoveVisScaleClick(e);
                }
            });
            if (aLayerObj.getVisibleScale().isVisibleScaleEnabled()) {
                removeVisScaleMI.setEnabled(true);
            } else {
                removeVisScaleMI.setEnabled(false);
            }
            visScaleMenu.add(removeVisScaleMI);
            mnuLayer.add(visScaleMenu);
            mnuLayer.addSeparator();
            if (aLayerObj.getLayerType() == LayerTypes.VECTOR_LAYER) {
                JMenuItem labelMI = new JMenuItem("Label");
                labelMI.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/label.svg"));
                labelMI.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayersLegend.this.onLabelClick(e);
                    }
                });
                mnuLayer.add(labelMI);
                mnuLayer.addSeparator();
            }
            JMenuItem propMI = new JMenuItem("Properties");
            propMI.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/properties.svg"));
            propMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayersLegend.this.onPropertiesClick(e);
                }
            });
            mnuLayer.add(propMI);
            mnuLayer.show(this, e.getX(), e.getY());
        }
    }

    private void onMapFrameMouseClicked(MouseEvent e) {
        MousePos mPos = new MousePos();
        MapFrame aNode = (MapFrame)this.getNodeByPositionEx(e.getX(), e.getY(), mPos);
        this._currentMapFrame = this.getMapFrame(aNode);
        if (mPos.inExpansionBox) {
            if (e.getButton() == 1) {
                if (aNode.isExpanded()) {
                    aNode.collapse();
                } else {
                    aNode.expand();
                }
                this.paintGraphics();
            }
        } else if (e.getButton() == 3) {
            JPopupMenu mnuMapFrame = new JPopupMenu();
            JMenuItem newGroupMI = new JMenuItem("New Group");
            newGroupMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayersLegend.this.onAddGroupClick(e);
                }
            });
            mnuMapFrame.add(newGroupMI);
            JMenuItem addLayerMI = new JMenuItem("Add Layer");
            addLayerMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayersLegend.this.onAddLayerClick(e);
                }
            });
            mnuMapFrame.add(addLayerMI);
            JMenuItem addWebLayerMI = new JMenuItem("Add Web Layer");
            addWebLayerMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayersLegend.this.onAddWebLayerClick(e);
                }
            });
            mnuMapFrame.add(addWebLayerMI);
            mnuMapFrame.add(new JSeparator());
            JMenuItem activeMI = new JMenuItem("Active");
            activeMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayersLegend.this.onMapFrameActiveClick(e);
                }
            });
            mnuMapFrame.add(activeMI);
            if (this._mapFrames.size() > 1) {
                mnuMapFrame.add(new JSeparator());
                JMenuItem removeMapFrameMI = new JMenuItem("Remove Map Frame");
                removeMapFrameMI.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayersLegend.this.onRemoveMapFrameClick(e);
                    }
                });
                mnuMapFrame.add(removeMapFrameMI);
            }
            mnuMapFrame.show(this, e.getX(), e.getY());
        }
    }

    private void onAddLayerClick(ActionEvent e) {
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(new File("D:\\GeoData\\WORLD"));
        String[] fileExts = new String[]{"shp", "wmp"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Supported Formats");
        aDlg.setFileFilter((FileFilter)mapFileFilter);
        fileExts = new String[]{"shp"};
        mapFileFilter = new GenericFileFilter(fileExts, "Shape File (*.shp)");
        aDlg.addChoosableFileFilter((FileFilter)mapFileFilter);
        if (0 == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            try {
                MapLayer aLayer = MapDataManage.loadLayer(aFile.getAbsolutePath());
                this._currentMapFrame.addLayer(aLayer);
            }
            catch (IOException ex) {
                Logger.getLogger(LayersLegend.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(LayersLegend.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void onAddWebLayerClick(ActionEvent e) {
        WebMapLayer layer = new WebMapLayer();
        layer.setWebMapProvider(WebMapProvider.OpenStreetMap);
        ProjectionInfo proj = this._currentMapFrame.getMapView().getProjection().getProjInfo();
        if (proj.getProjectionName() != ProjectionNames.Mercator && JOptionPane.showConfirmDialog(null, "Not mercator projection! If project?", "Conform", 0) == 0) {
            ProjectionInfo toProj = ProjectionInfo.factory((String)"+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0");
            this._currentMapFrame.getMapView().projectLayers(toProj);
        }
        this._currentMapFrame.addLayer(0, layer);
    }

    private void onAddGroupClick(ActionEvent e) {
        this._currentMapFrame.addNewGroup("New Group");
        this.paintGraphics();
    }

    private void onRemoveGroupClick(ActionEvent e) {
        if (this._selectedNode.getNodeType() == NodeTypes.GROUP_NODE) {
            GroupNode aGN = (GroupNode)this._selectedNode;
            aGN.getMapFrame().removeGroup(aGN);
        }
        this.paintGraphics();
    }

    private void onRemoveLayerClick(ActionEvent e) {
        if (this._selectedNode.getNodeType() == NodeTypes.LAYER_NODE) {
            LayerNode aLN = (LayerNode)this._selectedNode;
            aLN.getMapFrame().removeLayer(aLN);
        }
        this.paintGraphics();
    }

    private void onSaveLayerClick(ActionEvent e) {
        if (this._selectedNode.getNodeType() == NodeTypes.LAYER_NODE) {
            LayerNode aLN = (LayerNode)this._selectedNode;
            MapLayer aLayer = aLN.getMapLayer();
            if (aLN.getMapFrame().getMapView().getProjection().getProjInfo().equals(aLayer.getProjInfo())) {
                aLayer.saveFile();
            } else {
                try {
                    MapLayer bLayer = (MapLayer)aLayer.clone();
                    bLayer.setProjInfo(aLN.getMapFrame().getMapView().getProjection().getProjInfo());
                    bLayer.saveFile();
                    aLayer.setFileName(bLayer.getFileName());
                }
                catch (CloneNotSupportedException ex) {
                    Logger.getLogger(LayersLegend.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void onAttrTableClick(ActionEvent e) {
        LayerNode aLN = (LayerNode)this._selectedNode;
        MapLayer aLayer = aLN.getMapFrame().getMapView().getLayerByHandle(aLN.getLayerHandle());
        if (aLayer.getLayerType() == LayerTypes.VECTOR_LAYER) {
            JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(this);
            FrmAttriData frm = new FrmAttriData();
            frm.setLayer((VectorLayer)aLayer);
            frm.setLocationRelativeTo(frame);
            frm.setVisible(true);
        }
    }

    private void onEditClick(LayerNode aLN) {
        aLN.setEditing(!aLN.isEditing());
        this.paintGraphics();
    }

    private void onPropertiesClick(ActionEvent e) {
        LayerNode aLN = (LayerNode)this._selectedNode;
        MapLayer aLayer = aLN.getMapFrame().getMapView().getLayerByHandle(aLN.getLayerHandle());
        if (this.frmLayerProp == null) {
            JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(this);
            this.frmLayerProp = new FrmLayerProperty((Frame)frame, false);
            this.frmLayerProp.setMapLayer(aLayer);
            this.frmLayerProp.setMapFrame(this.getCurrentMapFrame());
            this.frmLayerProp.setLocationRelativeTo(frame);
            this.frmLayerProp.setVisible(true);
        } else {
            this.frmLayerProp.setMapLayer(aLayer);
            this.frmLayerProp.setMapFrame(this.getCurrentMapFrame());
            this.frmLayerProp.setVisible(true);
        }
    }

    private void onZoomToLayerClick(ActionEvent e) {
        LayerNode aLN = (LayerNode)this._selectedNode;
        MapLayer aLayer = aLN.getMapFrame().getMapView().getLayerByHandle(aLN.getLayerHandle());
        MapView mapView = aLN.getMapFrame().getMapView();
        Extent oldExtent = (Extent)mapView.getViewExtent().clone();
        aLN.getMapFrame().getMapView().zoomToExtent(aLayer.getExtent());
        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
        Objects.requireNonNull(mapViewUndoRedo);
        MapViewUndoRedo.ZoomEdit edit = new MapViewUndoRedo.ZoomEdit(mapViewUndoRedo, mapView, oldExtent, (Extent)mapView.getViewExtent().clone());
        mapView.fireUndoEditEvent(edit);
    }

    private void onMinVisScaleClick(ActionEvent e) {
        LayerNode aLN = (LayerNode)this._selectedNode;
        MapLayer aLayer = aLN.getMapFrame().getMapView().getLayerByHandle(aLN.getLayerHandle());
        aLayer.getVisibleScale().setEnableMinVisScale(true);
        aLayer.getVisibleScale().setMinVisScale(aLN.getMapFrame().getMapView().getGeoScale());
        this.paintGraphics();
        aLN.getMapFrame().getMapView().paintLayers();
    }

    private void onMaxVisScaleClick(ActionEvent e) {
        LayerNode aLN = (LayerNode)this._selectedNode;
        MapLayer aLayer = aLN.getMapFrame().getMapView().getLayerByHandle(aLN.getLayerHandle());
        aLayer.getVisibleScale().setEnableMaxVisScale(true);
        aLayer.getVisibleScale().setMaxVisScale(aLN.getMapFrame().getMapView().getGeoScale());
        this.paintGraphics();
        aLN.getMapFrame().getMapView().paintLayers();
    }

    private void onRemoveVisScaleClick(ActionEvent e) {
        LayerNode aLN = (LayerNode)this._selectedNode;
        MapLayer aLayer = aLN.getMapFrame().getMapView().getLayerByHandle(aLN.getLayerHandle());
        aLayer.getVisibleScale().setEnableMinVisScale(false);
        aLayer.getVisibleScale().setEnableMaxVisScale(false);
        this.paintGraphics();
        aLN.getMapFrame().getMapView().paintLayers();
    }

    private void onLabelClick(ActionEvent e) {
        VectorLayer layer;
        LayerNode aLN = (LayerNode)this._selectedNode;
        MapLayer aLayer = aLN.getMapFrame().getMapView().getLayerByHandle(aLN.getLayerHandle());
        if (aLayer.getLayerType() == LayerTypes.VECTOR_LAYER && (layer = (VectorLayer)aLayer).getShapeNum() > 0) {
            JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(this);
            FrmLabelSet aFrmLabel = new FrmLabelSet((Frame)frame, false, this.getActiveMapFrame().getMapView());
            aFrmLabel.setLayer(layer);
            aFrmLabel.setLocationRelativeTo(frame);
            aFrmLabel.setVisible(true);
        }
    }

    private void onMapFrameActiveClick(ActionEvent e) {
        this.setActiveMapFrame(this._currentMapFrame);
    }

    private void onRemoveMapFrameClick(ActionEvent e) {
        this.removeMapFrame(this._currentMapFrame);
    }

    private ItemNode getNodeByPosition(int x, int y, MousePos mPos) {
        List<ItemNode> nodes;
        if (y < 0) {
            if (this._vScrollBar.getValue() == 0) {
                return this._mapFrames.get(0);
            }
            return null;
        }
        ItemNode aIN = null;
        mPos.inItem = false;
        mPos.curTop = 0;
        if (this._vScrollBar.isVisible()) {
            mPos.curTop = -this._vScrollBar.getValue();
        }
        for (MapFrame mapFrame : this._mapFrames) {
            if (y > mPos.curTop && y < mPos.curTop + mapFrame.getHeight()) {
                return mapFrame;
            }
            mPos.curTop += mapFrame.getHeight() + Constants.ITEM_PAD;
            for (int i = mapFrame.getNodes().size() - 1; i >= 0; --i) {
                if (mapFrame.getNodes().get(i).getNodeType() == NodeTypes.LAYER_NODE) {
                    if (y > mPos.curTop && y < mPos.curTop + mapFrame.getNodes().get(i).getDrawHeight()) {
                        if (y < mPos.curTop + mapFrame.getNodes().get(i).getHeight()) {
                            mPos.inItem = true;
                        }
                        return mapFrame.getNodes().get(i);
                    }
                    mPos.curTop += mapFrame.getNodes().get(i).getDrawHeight() + Constants.ITEM_PAD;
                    continue;
                }
                GroupNode gNode = (GroupNode)mapFrame.getNodes().get(i);
                if (y > mPos.curTop && y < mPos.curTop + gNode.getHeight()) {
                    return gNode;
                }
                mPos.curTop += gNode.getHeight() + Constants.ITEM_PAD;
                if (!gNode.isExpanded()) continue;
                for (int j = gNode.getLayers().size() - 1; j >= 0; --j) {
                    LayerNode aLN = gNode.getLayers().get(j);
                    if (y > mPos.curTop && y < mPos.curTop + aLN.getDrawHeight()) {
                        if (y < mPos.curTop + mapFrame.getNodes().get(i).getHeight()) {
                            mPos.inItem = true;
                        }
                        return aLN;
                    }
                    mPos.curTop += aLN.getDrawHeight() + Constants.ITEM_PAD;
                }
            }
        }
        if (aIN == null && y < this.getHeight() && (nodes = this._mapFrames.get(this._mapFrames.size() - 1).getNodes()) != null && nodes.size() > 0) {
            ItemNode selNode = this._mapFrames.get(this._mapFrames.size() - 1).getNodes().get(0);
            mPos.curTop = mPos.curTop - selNode.getDrawHeight() - Constants.ITEM_PAD;
            return selNode;
        }
        return aIN;
    }

    private ItemNode getNodeByPositionEx(int x, int y, MousePos mPos) {
        ItemNode aIN = this.getNodeByPosition(x, y, mPos);
        if (aIN != null) {
            int leftPad = Constants.MAPFRAME_LEFT_PAD;
            if (aIN.getNodeType() == NodeTypes.MAP_FRAME_NODE) {
                mPos.inExpansionBox = x > leftPad && x < leftPad + Constants.EXPAND_BOX_SIZE;
                mPos.inCheckBox = x > leftPad + Constants.EXPAND_BOX_SIZE + Constants.CHECK_LEFT_PAD && x < leftPad + Constants.EXPAND_BOX_SIZE + Constants.CHECK_LEFT_PAD + Constants.CHECK_BOX_SIZE;
            } else if (aIN.getNodeType() == NodeTypes.GROUP_NODE) {
                mPos.inExpansionBox = x > (leftPad += Constants.ITEM_LEFT_PAD) && x < leftPad + Constants.EXPAND_BOX_SIZE;
                mPos.inCheckBox = x > leftPad + Constants.EXPAND_BOX_SIZE + Constants.CHECK_LEFT_PAD && x < leftPad + Constants.EXPAND_BOX_SIZE + Constants.CHECK_LEFT_PAD + Constants.CHECK_BOX_SIZE;
            } else if (aIN.getNodeType() == NodeTypes.LAYER_NODE && mPos.inItem) {
                leftPad += Constants.ITEM_LEFT_PAD;
                if (((LayerNode)aIN).getGroupHandle() >= 0) {
                    leftPad += Constants.ITEM_LEFT_PAD;
                }
                mPos.inExpansionBox = x > leftPad && x < leftPad + Constants.EXPAND_BOX_SIZE;
                mPos.inCheckBox = x > leftPad + Constants.EXPAND_BOX_SIZE + Constants.CHECK_LEFT_PAD && x < leftPad + Constants.EXPAND_BOX_SIZE + Constants.CHECK_LEFT_PAD + Constants.CHECK_BOX_SIZE;
            }
        }
        return aIN;
    }

    public void setActiveMapFrame(MapFrame mapFrame) {
        if (mapFrame == null) {
            return;
        }
        for (MapFrame mf : this._mapFrames) {
            mf.setActive(false);
        }
        mapFrame.setActive(true);
        this.fireActiveMapFrameChangedEvent();
    }

    public String getNewMapFrameName() {
        ArrayList<String> names = new ArrayList<String>();
        for (MapFrame mf : this._mapFrames) {
            if (!mf.getText().contains("New Map Frame")) continue;
            names.add(mf.getText());
        }
        String name = "New Map Frame";
        if (names.size() > 0) {
            for (int i = 1; i <= 100 && names.contains(name = "New Map Frame " + String.valueOf(i)); ++i) {
            }
        }
        return name;
    }

    public final void addMapFrame(MapFrame mf) {
        mf.addLayersUpdatedListener(new ILayersUpdatedListener(){

            public void layersUpdatedEvent(LayersUpdatedEvent luEvent) {
                LayersLegend.this.paintGraphics();
            }
        });
        mf.setLegend(this);
        this._mapFrames.add(mf);
        if (this._mapLayout != null) {
            this._mapLayout.updateMapFrames(this._mapFrames);
            this._mapLayout.paintGraphics();
        }
        this.fireMapFramesUpdatedEvent();
    }

    public void removeMapFrame(MapFrame mapFrame) {
        this._mapFrames.remove(mapFrame);
        if (mapFrame.isActive()) {
            this._mapFrames.get(0).setActive(true);
            this.fireActiveMapFrameChangedEvent();
        }
        if (this._mapLayout != null) {
            this._mapLayout.updateMapFrames(this._mapFrames);
            this._mapLayout.paintGraphics();
        }
        this.paintGraphics();
        this.fireMapFramesUpdatedEvent();
    }

    private MapFrame getMapFrame(ItemNode aNode) {
        MapFrame mf = null;
        switch (aNode.getNodeType()) {
            case MAP_FRAME_NODE: {
                mf = (MapFrame)aNode;
                break;
            }
            case LAYER_NODE: {
                mf = ((LayerNode)aNode).getMapFrame();
                break;
            }
            case GROUP_NODE: {
                mf = ((GroupNode)aNode).getMapFrame();
            }
        }
        return mf;
    }

    public MapFrame getMapFrame(String text) {
        for (MapFrame mf : this._mapFrames) {
            if (!mf.getText().equalsIgnoreCase(text)) continue;
            return mf;
        }
        return null;
    }

    public void selectNode(ItemNode aNode) {
        this._selectedNode = aNode;
        for (MapFrame mf : this._mapFrames) {
            mf.setSelected(false);
            mf.unSelectNodes();
        }
        aNode.setSelected(true);
        MapFrame aMF = this.getMapFrame(aNode);
        if (aNode.getNodeType() == NodeTypes.LAYER_NODE) {
            aMF.getMapView().setSelectedLayerHandle(((LayerNode)aNode).getLayerHandle());
        } else {
            aMF.getMapView().setSelectedLayerHandle(-1);
        }
        this.fireNodeSelectedEvent();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        g2.setColor(this.getBackground());
        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintGraphics(g2);
        if (this._dragMode) {
            g2.setColor(Color.black);
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawLine(Constants.ITEM_LEFT_PAD, this._dragPosY, this.getWidth() - Constants.ITEM_RIGHT_PAD, this._dragPosY);
        }
    }

    public void paintGraphics() {
        Rectangle rect;
        if (this.getWidth() < 10 || this.getHeight() < 10) {
            return;
        }
        this._paintImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D g = this._paintImage.createGraphics();
        int totalHeight = this.calcTotalDrawHeight();
        if (totalHeight > this.getHeight()) {
            int sHeight = totalHeight - this.getHeight() + 20;
            this._vScrollBar.setMinimum(0);
            this._vScrollBar.setMaximum(totalHeight);
            this._vScrollBar.setVisibleAmount(totalHeight - sHeight);
            this._vScrollBar.setUnitIncrement(totalHeight / 10);
            this._vScrollBar.setBlockIncrement(totalHeight / 5);
            if (!this._vScrollBar.isVisible()) {
                this._vScrollBar.setValue(0);
                this._vScrollBar.setVisible(true);
            }
            rect = new Rectangle(0, -this._vScrollBar.getValue(), this.getWidth() - this._vScrollBar.getWidth(), totalHeight);
        } else {
            this._vScrollBar.setVisible(false);
            rect = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        rect.y += Constants.ITEM_PAD;
        for (MapFrame mapFrame : this._mapFrames) {
            this.drawMapFrame(g, mapFrame, new Point(Constants.MAPFRAME_LEFT_PAD, rect.y));
            rect.y += mapFrame.getDrawHeight() + Constants.ITEM_PAD * 2;
        }
        this.repaint();
    }

    public void paintGraphics(Graphics2D g) {
        Rectangle rect;
        if (this.getWidth() < 10 || this.getHeight() < 10) {
            return;
        }
        int totalHeight = this.calcTotalDrawHeight();
        if (totalHeight > this.getHeight()) {
            int sHeight = totalHeight - this.getHeight() + 20;
            this._vScrollBar.setMinimum(0);
            this._vScrollBar.setMaximum(totalHeight);
            this._vScrollBar.setVisibleAmount(totalHeight - sHeight);
            this._vScrollBar.setUnitIncrement(totalHeight / 10);
            this._vScrollBar.setBlockIncrement(totalHeight / 5);
            if (!this._vScrollBar.isVisible()) {
                this._vScrollBar.setValue(0);
                this._vScrollBar.setVisible(true);
            }
            rect = new Rectangle(0, -this._vScrollBar.getValue(), this.getWidth() - this._vScrollBar.getWidth(), totalHeight);
        } else {
            this._vScrollBar.setVisible(false);
            rect = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        rect.y += Constants.ITEM_PAD;
        for (MapFrame mapFrame : this._mapFrames) {
            this.drawMapFrame(g, mapFrame, new Point(Constants.MAPFRAME_LEFT_PAD, rect.y));
            rect.y += mapFrame.getDrawHeight() + Constants.ITEM_PAD * 2;
        }
    }

    private int calcTotalDrawHeight() {
        int height = 0;
        for (MapFrame mapFrame : this._mapFrames) {
            height += mapFrame.getDrawHeight() + Constants.ITEM_PAD * 2;
        }
        return height -= Constants.ITEM_PAD * 2;
    }

    private void drawMapFrame(Graphics2D g, MapFrame aMapFrame, Point sP) {
        if (aMapFrame.isSelected()) {
            Rectangle rect = new Rectangle(0, sP.y, this.getWidth(), aMapFrame.getHeight());
            g.setColor(this._selectedBackColor);
            g.fill(rect);
        }
        g.setColor(this.getForeground());
        if (aMapFrame.getNodes().size() > 0) {
            this.drawExpansionBox(g, new Point(sP.x, sP.y + Constants.EXPAND_BOX_TOP_PAD), aMapFrame.isExpanded());
        }
        FlatSVGIcon icon = new FlatSVGIcon("org/meteoinfo/icons/layers.svg");
        icon.paintIcon((Component)this, (Graphics)g, sP.x + Constants.EXPAND_BOX_SIZE + Constants.CHECK_LEFT_PAD, sP.y);
        Font newFont = this.getFont();
        if (aMapFrame.isActive()) {
            newFont = new Font(newFont.getFontName(), 1, newFont.getSize());
        }
        g.setFont(newFont);
        g.drawString(aMapFrame.getText(), sP.x + Constants.EXPAND_BOX_SIZE + Constants.CHECK_LEFT_PAD + Constants.CHECK_BOX_SIZE + Constants.TEXT_LEFT_PAD * 2, sP.y + aMapFrame.getHeight() - 4);
        if (aMapFrame.isExpanded()) {
            sP.x += Constants.ITEM_LEFT_PAD;
            sP.y += aMapFrame.getHeight() + Constants.ITEM_PAD;
            for (int i = aMapFrame.getNodes().size() - 1; i >= 0; --i) {
                ItemNode aTN = aMapFrame.getNodes().get(i);
                if (aTN.getNodeType() == NodeTypes.GROUP_NODE) {
                    if (sP.y + aTN.getDrawHeight() < this.getY()) {
                        sP.y += aTN.getDrawHeight() + Constants.ITEM_PAD;
                        continue;
                    }
                    Point dP = new Point(sP.x, sP.y);
                    this.drawGroupNode(g, (GroupNode)aTN, dP);
                } else {
                    LayerNode aLN = (LayerNode)aTN;
                    if (sP.y + aLN.getDrawHeight() < this.getY()) {
                        sP.y += aLN.getDrawHeight() + Constants.ITEM_PAD;
                        continue;
                    }
                    Point dP = new Point(sP.x, sP.y);
                    this.drawLayerNode(g, (LayerNode)aTN, dP);
                }
                sP.y += aTN.getDrawHeight() + Constants.ITEM_PAD;
                if (sP.y >= this.getY() + this.getHeight()) break;
            }
        }
    }

    private void drawGroupNode(Graphics2D g, GroupNode groupNode, Point sP) {
        if (groupNode.isSelected()) {
            Rectangle rect = new Rectangle(0, sP.y, this.getWidth(), groupNode.getHeight());
            g.setColor(this._selectedBackColor);
            g.fill(rect);
        }
        g.setColor(this.getForeground());
        if (groupNode.getLayers().size() > 0) {
            this.drawExpansionBox(g, new Point(sP.x, sP.y + Constants.EXPAND_BOX_TOP_PAD), groupNode.isExpanded());
        }
        groupNode.updateCheckStatus();
        this.drawCheckBox(g, new Point(sP.x + Constants.EXPAND_BOX_SIZE + Constants.CHECK_LEFT_PAD, sP.y + Constants.CHECK_TOP_PAD), groupNode.getCheckStatus());
        g.setFont(this.getFont());
        g.drawString(groupNode.getText(), sP.x + Constants.EXPAND_BOX_SIZE + Constants.CHECK_LEFT_PAD + Constants.CHECK_BOX_SIZE + Constants.TEXT_LEFT_PAD, sP.y + groupNode.getHeight() - 4);
        if (groupNode.isExpanded()) {
            sP.y += Constants.ITEM_HEIGHT + Constants.ITEM_PAD;
            sP.x += Constants.ITEM_LEFT_PAD;
            for (int j = groupNode.getLayers().size() - 1; j >= 0; --j) {
                LayerNode layerNode = groupNode.getLayers().get(j);
                Point dP = new Point(sP.x, sP.y);
                this.drawLayerNode(g, layerNode, dP);
                sP.y += layerNode.getDrawHeight() + Constants.ITEM_PAD;
            }
        }
    }

    private void drawLayerNode(Graphics2D g, LayerNode layerNode, Point sP) {
        Rectangle rect;
        g.setColor(this.getForeground());
        if (layerNode.isSelected()) {
            rect = new Rectangle(0, sP.y, this.getWidth(), layerNode.getHeight());
            g.setColor(this._selectedBackColor);
            g.fill(rect);
        }
        if (layerNode.isEditing()) {
            rect = new Rectangle(0, sP.y, this.getWidth(), layerNode.getHeight());
            g.setColor(Color.red);
            g.draw(rect);
        }
        if (layerNode.isSelected()) {
            g.setColor(this._selectedForeColor);
        } else {
            g.setColor(this.getForeground());
        }
        if (layerNode.getLegendNodes().size() > 0) {
            this.drawExpansionBox(g, new Point(sP.x, sP.y + Constants.EXPAND_BOX_TOP_PAD), layerNode.isExpanded());
        }
        int checkStatus = 0;
        if (layerNode.isChecked()) {
            checkStatus = 1;
        }
        this.drawCheckBox(g, new Point(sP.x + Constants.EXPAND_BOX_SIZE + Constants.CHECK_LEFT_PAD, sP.y + Constants.CHECK_TOP_PAD), checkStatus);
        g.setFont(this.getFont());
        g.drawString(layerNode.getText(), sP.x + Constants.EXPAND_BOX_SIZE + Constants.CHECK_LEFT_PAD + Constants.CHECK_BOX_SIZE + Constants.TEXT_LEFT_PAD, sP.y + layerNode.getHeight() - 4);
        if (layerNode.isExpanded()) {
            sP.x += Constants.ITEM_LEFT_PAD;
            sP.y = sP.y + layerNode.getHeight() + Constants.ITEM_PAD;
            for (LegendNode aLN : layerNode.getLegendNodes()) {
                Rectangle rect2 = new Rectangle(sP.x, sP.y, 40, aLN.getHeight());
                this.drawLegendNode(aLN, rect2, g);
                sP.y = sP.y + aLN.getHeight() + Constants.ITEM_PAD;
            }
        }
    }

    private void drawLegendNode(LegendNode aLN, Rectangle rect, Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PointF aP = new PointF(0.0f, 0.0f);
        String caption = "";
        block0 : switch (aLN.getLegendBreak().getBreakType()) {
            case POINT_BREAK: {
                PointBreak aPB = (PointBreak)aLN.getLegendBreak();
                caption = aPB.getCaption();
                aP.X = rect.x + rect.width / 2;
                aP.Y = rect.y + rect.height / 2;
                if (!aPB.isDrawShape()) break;
                if (aPB.getMarkerType() == MarkerType.CHARACTER) {
                    Draw.drawPoint((PointF)aP, (PointBreak)aPB, (Graphics2D)g);
                    break;
                }
                Draw.drawPoint((PointF)aP, (PointBreak)aPB, (Graphics2D)g);
                break;
            }
            case POLYLINE_BREAK: {
                PolylineBreak aPLB = (PolylineBreak)aLN.getLegendBreak();
                caption = aPLB.getCaption();
                aP.X = rect.x + rect.width / 2;
                aP.Y = rect.y + rect.height / 2;
                float width = rect.width / 3 * 2;
                float height = rect.height / 3 * 2;
                Draw.drawPolylineSymbol((PointF)aP, (float)width, (float)height, (PolylineBreak)aPLB, (Graphics2D)g);
                break;
            }
            case POLYGON_BREAK: {
                PolygonBreak aPGB = (PolygonBreak)aLN.getLegendBreak();
                caption = aPGB.getCaption();
                aP.X = rect.x + rect.width / 2;
                aP.Y = rect.y + rect.height / 2;
                float width = rect.width / 3 * 2;
                float height = rect.height / 5 * 4;
                if (!aPGB.isDrawShape()) break;
                Draw.drawPolygonSymbol((PointF)aP, (float)width, (float)height, (PolygonBreak)aPGB, (Graphics2D)g);
                break;
            }
            case COLOR_BREAK: {
                ColorBreak aCB = aLN.getLegendBreak();
                caption = aCB.getCaption();
                aP.X = rect.x + rect.width / 2;
                aP.Y = rect.y + rect.height / 2;
                float width = rect.width / 3 * 2;
                float height = rect.height / 3 * 2;
                Draw.drawPolygonSymbol((PointF)aP, (Color)aCB.getColor(), (Color)Color.black, (float)width, (float)height, (Boolean)true, (Boolean)true, (Graphics2D)g);
                break;
            }
            case CHART_BREAK: {
                ChartBreak aChB = (ChartBreak)aLN.getLegendBreak();
                aP.X = rect.x;
                aP.Y = rect.y + rect.height - 5;
                switch (aChB.getChartType()) {
                    case BAR_CHART: {
                        Draw.drawBarChartSymbol((PointF)aP, (ChartBreak)aChB, (Graphics2D)g, (boolean)true);
                        break block0;
                    }
                    case PIE_CHART: {
                        Draw.drawPieChartSymbol((PointF)aP, (ChartBreak)aChB, (Graphics2D)g, null);
                    }
                }
            }
        }
        int x = rect.x + rect.width + 5;
        int y = rect.y + rect.height * 3 / 4;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setFont(this.getFont());
        g.setColor(this.getForeground());
        g.drawString(caption, x, y);
    }

    private void drawExpansionBox(Graphics2D g, Point sP, boolean expanded) {
        int size = 8;
        int gap = 2;
        Rectangle rect = new Rectangle(sP.x, sP.y, size, size);
        g.draw(rect);
        GeneralPath path = new GeneralPath();
        path.moveTo(sP.x + gap, sP.y + size / 2);
        path.lineTo(sP.x + size - gap, sP.y + size / 2);
        if (!expanded) {
            path.moveTo(sP.x + size / 2, sP.y + gap);
            path.lineTo(sP.x + size / 2, sP.y + size - gap);
        }
        g.draw(path);
    }

    private void drawCheckBox(Graphics2D g, Point sP, int checkStatus) {
        int size = 10;
        Rectangle rect = new Rectangle(sP.x, sP.y, size, size);
        g.draw(rect);
        if (checkStatus == 2) {
            g.setColor(Color.lightGray);
            g.fill(rect);
            g.setColor(this.getForeground());
        }
        switch (checkStatus) {
            case 1: 
            case 2: {
                GeneralPath path = new GeneralPath();
                path.moveTo(sP.x + 2, sP.y + 6);
                path.lineTo(sP.x + 5, sP.y + 8);
                path.moveTo(sP.x + 5, sP.y + 8);
                path.lineTo(sP.x + 8, sP.y + 2);
                g.draw(path);
            }
        }
    }

    public void exportProjectXML(Document m_Doc, Element parent, String projectFilePath) {
        Element mapFrames = m_Doc.createElement("MapFrames");
        for (MapFrame mf : this._mapFrames) {
            mf.exportProjectXML(m_Doc, mapFrames, projectFilePath);
        }
        parent.appendChild(mapFrames);
    }

    public void importProjectXML(String fileName) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new File(fileName));
        Element root = doc.getDocumentElement();
        Properties property = System.getProperties();
        String path = System.getProperty("user.dir");
        property.setProperty("user.dir", new File(fileName).getAbsolutePath());
        String pPath = new File(fileName).getParent();
        this.getActiveMapFrame().getMapView().setLockViewUpdate(true);
        this.importProjectXML(pPath, root);
        this.getActiveMapFrame().getMapView().setLockViewUpdate(false);
        this.paintGraphics();
        this.getActiveMapFrame().getMapView().paintLayers();
        property.setProperty("user.dir", path);
    }

    public void importProjectXML(String pPath, Element parent) {
        this._mapFrames.clear();
        Element mapFrames = (Element)parent.getElementsByTagName("MapFrames").item(0);
        if (mapFrames == null) {
            MapFrame mf = new MapFrame(this);
            mf.importProjectXML(pPath, parent);
            mf.addLayersUpdatedListener(new ILayersUpdatedListener(){

                public void layersUpdatedEvent(LayersUpdatedEvent event) {
                    LayersLegend.this.paintGraphics();
                }
            });
            mf.setActive(true);
            this._mapFrames.add(mf);
        } else {
            NodeList mfNodes = mapFrames.getElementsByTagName("MapFrame");
            for (int i = 0; i < mfNodes.getLength(); ++i) {
                Node mapFrame = mfNodes.item(i);
                MapFrame mf = new MapFrame(this);
                mf.importProjectXML(pPath, (Element)mapFrame);
                mf.addLayersUpdatedListener(new ILayersUpdatedListener(){

                    public void layersUpdatedEvent(LayersUpdatedEvent event) {
                        LayersLegend.this.paintGraphics();
                    }
                });
                mf.setLegend(this);
                this._mapFrames.add(mf);
            }
        }
    }

    class MousePos {
        public boolean inItem = false;
        public int curTop = 0;
        public boolean inCheckBox = false;
        public boolean inExpansionBox = false;

        MousePos() {
        }
    }
}

