/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.common;

import java.awt.Rectangle;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.common.PointD;

public class Extent
implements Cloneable {
    public double minX;
    public double maxX;
    public double minY;
    public double maxY;

    public Extent() {
    }

    public Extent(double xMin, double xMax, double yMin, double yMax) {
        this.minX = xMin;
        this.maxX = xMax;
        this.minY = yMin;
        this.maxY = yMax;
    }

    public Extent(Extent aExtent) {
        this.minX = aExtent.minX;
        this.maxX = aExtent.maxX;
        this.minY = aExtent.minY;
        this.maxY = aExtent.maxY;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }

    public boolean include(Extent bExtent) {
        return this.minX <= bExtent.minX && this.maxX >= bExtent.maxX && this.minY <= bExtent.minY && this.maxY >= bExtent.maxY;
    }

    public boolean intersects(Extent bET) {
        return !(this.maxX < bET.minX || this.maxY < bET.minY || bET.maxX < this.minX || bET.maxY < this.minY);
    }

    public Rectangle convertToRectangle() {
        return new Rectangle((int)this.minX, (int)this.minY, (int)this.getWidth(), (int)this.getHeight());
    }

    public PointD getCenterPoint() {
        return new PointD((this.maxX - this.minX) / 2.0 + this.minX, (this.maxY - this.minY) / 2.0 + this.minY);
    }

    public Extent shift(double dx, double dy) {
        return new Extent(this.minX + dx, this.maxX + dx, this.minY + dy, this.maxY + dy);
    }

    public Extent extend(double ratio) {
        double dx = this.getWidth() * ratio;
        double dy = this.getHeight() * ratio;
        return this.extend(dx, dy);
    }

    public Extent extend(double dx, double dy) {
        return new Extent(this.minX - dx, this.maxX + dx, this.minY - dy, this.maxY + dy);
    }

    public boolean isNaN() {
        return Double.isNaN(this.minX) || Double.isNaN(this.maxX) || Double.isNaN(this.minY) || Double.isNaN(this.maxY);
    }

    public boolean is3D() {
        return false;
    }

    public Extent3D to3D() {
        Extent3D ex3d = new Extent3D(this.minX, this.maxX, this.minY, this.maxY, 0.0, 0.0);
        return ex3d;
    }

    public void asNonZero() {
        double width = this.getWidth();
        double height = this.getHeight();
        if (width == 0.0) {
            double v = height / 2.0;
            this.minX -= v;
            this.maxX += v;
        } else if (height == 0.0) {
            double v = width / 2.0;
            this.minY -= v;
            this.maxY += v;
        }
    }

    public Extent union(Extent ex) {
        Extent cET = new Extent();
        if (this.isNaN()) {
            return (Extent)ex.clone();
        }
        if (ex.isNaN()) {
            return (Extent)this.clone();
        }
        cET.minX = Math.min(this.minX, ex.minX);
        cET.minY = Math.min(this.minY, ex.minY);
        cET.maxX = Math.max(this.maxX, ex.maxX);
        cET.maxY = Math.max(this.maxY, ex.maxY);
        return cET;
    }

    public Object clone() {
        return new Extent(this.minX, this.maxX, this.minY, this.maxY);
    }
}

