/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.angle;

import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import org.apache.commons.numbers.angle.Reduce;

public abstract class Angle
implements DoubleSupplier {
    public static final double TWO_PI = Math.PI * 2;
    public static final double PI_OVER_TWO = 1.5707963267948966;
    private static final double TURN_TO_DEG = 360.0;
    private static final double RAD_TO_DEG = 57.29577951308232;
    private static final double DEG_TO_RAD = Math.PI / 180;
    private final double value;

    private Angle(double value) {
        this.value = value;
    }

    @Override
    public double getAsDouble() {
        return this.value;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    public boolean equals(Object other) {
        return other != null && this.getClass().equals(other.getClass()) && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(((Angle)other).value);
    }

    public abstract Turn toTurn();

    public abstract Rad toRad();

    public abstract Deg toDeg();

    private static final class Normalizer
    implements DoubleUnaryOperator {
        private final double lo;
        private final double hi;
        private final double period;
        private final Reduce reduce;

        Normalizer(double lo, double period) {
            this.period = period;
            this.lo = lo;
            this.hi = lo + period;
            this.reduce = new Reduce(lo, period);
        }

        @Override
        public double applyAsDouble(double a) {
            if (this.lo <= a && a < this.hi) {
                return a;
            }
            double normalized = this.reduce.applyAsDouble(a) + this.lo;
            return normalized < this.hi ? normalized : Math.max(this.lo, normalized - this.period);
        }
    }

    public static final class Deg
    extends Angle {
        public static final Deg ZERO = Deg.of(0.0);
        public static final DoubleUnaryOperator WITHIN_0_AND_360 = Deg.normalizer(0.0);

        private Deg(double angle) {
            super(angle);
        }

        public static Deg of(double angle) {
            return new Deg(angle);
        }

        @Override
        public Turn toTurn() {
            return Turn.of(this.getAsDouble() / 360.0);
        }

        @Override
        public Rad toRad() {
            return Rad.of(this.getAsDouble() * (Math.PI / 180));
        }

        @Override
        public Deg toDeg() {
            return this;
        }

        public static DoubleUnaryOperator normalizer(double lo) {
            return new Normalizer(lo, 360.0);
        }
    }

    public static final class Rad
    extends Angle {
        public static final Rad ZERO = Rad.of(0.0);
        public static final Rad PI = Rad.of(Math.PI);
        public static final Rad TWO_PI = Rad.of(Math.PI * 2);
        public static final DoubleUnaryOperator WITHIN_0_AND_2PI = Rad.normalizer(0.0);
        public static final DoubleUnaryOperator WITHIN_MINUS_PI_AND_PI = Rad.normalizer(-Math.PI);

        private Rad(double angle) {
            super(angle);
        }

        public static Rad of(double angle) {
            return new Rad(angle);
        }

        @Override
        public Turn toTurn() {
            return Turn.of(this.getAsDouble() / (Math.PI * 2));
        }

        @Override
        public Rad toRad() {
            return this;
        }

        @Override
        public Deg toDeg() {
            return Deg.of(this.getAsDouble() * 57.29577951308232);
        }

        public static DoubleUnaryOperator normalizer(double lo) {
            return new Normalizer(lo, Math.PI * 2);
        }
    }

    public static final class Turn
    extends Angle {
        public static final Turn ZERO = Turn.of(0.0);
        public static final DoubleUnaryOperator WITHIN_0_AND_1 = Turn.normalizer(0.0);

        private Turn(double angle) {
            super(angle);
        }

        public static Turn of(double angle) {
            return new Turn(angle);
        }

        @Override
        public Turn toTurn() {
            return this;
        }

        @Override
        public Rad toRad() {
            return Rad.of(this.getAsDouble() * (Math.PI * 2));
        }

        @Override
        public Deg toDeg() {
            return Deg.of(this.getAsDouble() * 360.0);
        }

        public static DoubleUnaryOperator normalizer(double lo) {
            return new Normalizer(lo, 1.0);
        }
    }
}

