/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.colors;

import org.meteoinfo.geometry.colors.Normalize;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;

public class LogNorm
extends Normalize {
    private double min;
    private double max;

    public LogNorm(double minValue, double maxValue) {
        this(minValue, maxValue, false);
    }

    public LogNorm(double minValue, double maxValue, boolean clip) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.clip = clip;
        this.min = Math.log10(minValue);
        this.max = Math.log10(maxValue);
    }

    @Override
    public Number apply(Number value) {
        double range = this.max - this.min;
        double v = value.doubleValue();
        v = Math.log10(v);
        v = (v - this.min) / range;
        if (this.clip) {
            if (v < 0.0) {
                v = 0.0;
            } else if (v > 1.0) {
                v = 1.0;
            }
        }
        return v;
    }

    @Override
    public Array apply(Array a) {
        this.autoScaleNull(a);
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])a.getShape());
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = r.getIndexIterator();
        double range = this.max - this.min;
        if (this.clip) {
            while (iterA.hasNext()) {
                double v = Math.log10(iterA.getDoubleNext());
                if ((v = (v - this.min) / range) < 0.0) {
                    v = 0.0;
                } else if (v > 1.0) {
                    v = 1.0;
                }
                iterR.setDoubleNext(v);
            }
        } else {
            while (iterA.hasNext()) {
                double v = iterA.getDoubleNext();
                v = (v - this.min) / range;
                iterR.setDoubleNext(v);
            }
        }
        return r;
    }

    @Override
    public double inverse(double v) {
        return Math.pow(10.0, this.min + v * (this.max - this.min));
    }

    @Override
    public Array inverse(Array a) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])a.getShape());
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = r.getIndexIterator();
        double range = this.max - this.min;
        while (iterA.hasNext()) {
            double v = iterA.getDoubleNext();
            v = Math.pow(10.0, this.min + v * range);
            iterR.setDoubleNext(v);
        }
        return r;
    }
}

