/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.colors;

import java.awt.Color;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.colors.ColorMap;
import org.meteoinfo.geometry.colors.Normalize;
import org.meteoinfo.geometry.colors.OpacityTransferFunction;
import org.meteoinfo.geometry.legend.LegendFactory;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class TransferFunction {
    private OpacityTransferFunction opacityTransferFunction;
    private ColorMap colorMap;
    private Normalize normalize;

    public TransferFunction() {
        this.opacityTransferFunction = new OpacityTransferFunction();
        this.normalize = new Normalize();
        this.colorMap = new ColorMap();
    }

    public TransferFunction(OpacityTransferFunction opacityTransferFunction, ColorMap colorMap, Normalize normalize) {
        this.opacityTransferFunction = opacityTransferFunction;
        this.colorMap = colorMap;
        this.normalize = normalize;
    }

    public TransferFunction(OpacityTransferFunction opacityTransferFunction, ColorMap colorMap) {
        this(opacityTransferFunction, colorMap, new Normalize());
    }

    public TransferFunction(ColorMap colorMap, Normalize normalize) {
        this(new OpacityTransferFunction(), colorMap, normalize);
    }

    public TransferFunction(ColorMap colorMap) {
        this(colorMap, new Normalize());
    }

    public OpacityTransferFunction getOpacityTransferFunction() {
        return this.opacityTransferFunction;
    }

    public void setOpacityTransferFunction(OpacityTransferFunction value) {
        this.opacityTransferFunction = value;
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public void setColorMap(ColorMap value) {
        this.colorMap = value;
    }

    public Normalize getNormalize() {
        return this.normalize;
    }

    public void setNormalize(Normalize value) {
        this.normalize = value;
    }

    public Color getColor(double v) {
        float ratio = this.normalize.apply(v).floatValue();
        Color c = this.colorMap.map((double)ratio);
        float alpha = this.opacityTransferFunction.getOpacity(ratio);
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(alpha * 255.0f));
    }

    public LegendScheme toLegendScheme(double min, double max) {
        if (min == max) {
            return LegendFactory.createSingleSymbolLegendScheme(ShapeTypes.IMAGE);
        }
        double[] values = MIMath.getIntervalValues((double)min, (double)max);
        int n = values.length;
        Color[] colors = new Color[n + 1];
        colors[0] = this.getColor(min);
        for (int i = 1; i < n + 1; ++i) {
            colors[i] = this.getColor(values[i - 1]);
        }
        LegendScheme ls = LegendFactory.createGraduatedLegendScheme(values, colors, ShapeTypes.IMAGE, min, max);
        ls.setColorMap(this.colorMap);
        ls.setNormalize(this.normalize);
        return ls;
    }

    public LegendScheme toLegendScheme(double min, double max, int n) {
        if (min == max) {
            return LegendFactory.createSingleSymbolLegendScheme(ShapeTypes.IMAGE);
        }
        double[] values = MIMath.getIntervalValues((double)min, (double)max, (int)n);
        Color[] colors = new Color[n + 1];
        colors[0] = this.getColor(min);
        for (int i = 1; i < n + 1; ++i) {
            colors[i] = this.getColor(values[i - 1]);
        }
        LegendScheme ls = LegendFactory.createGraduatedLegendScheme(values, colors, ShapeTypes.IMAGE, min, max);
        ls.setColorMap(this.colorMap);
        ls.setNormalize(this.normalize);
        return ls;
    }
}

