/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.legend;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.PointF;
import org.meteoinfo.geometry.legend.AlignType;
import org.meteoinfo.geometry.legend.BreakTypes;
import org.meteoinfo.geometry.legend.ChartTypes;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class ChartBreak
extends ColorBreak {
    private ChartTypes _chartType;
    private List<Float> _chartData;
    private int _xShift;
    private int _yShift;
    private LegendScheme _legendScheme;
    private int _maxSize;
    private int _minSize;
    private float _maxValue;
    private float _minValue;
    private int _barWidth;
    private AlignType _alignType;
    private boolean _view3D;
    private int _thickness;
    private int _shpIdx;
    private boolean drawLabel;
    private Font labelFont;
    private Color labelColor;
    private int decimalDigits;

    public ChartBreak(ChartTypes chartType) {
        this.setBreakType(BreakTypes.CHART_BREAK);
        this._chartType = chartType;
        this._chartData = new ArrayList<Float>();
        this._xShift = 0;
        this._yShift = 0;
        this._legendScheme = new LegendScheme(ShapeTypes.POLYGON);
        this._maxSize = 50;
        this._minSize = 10;
        this._barWidth = 10;
        this._alignType = AlignType.CENTER;
        this._view3D = false;
        this._thickness = 5;
        this._shpIdx = 0;
        this.drawLabel = false;
        this.labelFont = new Font("Arial", 0, 12);
        this.labelColor = Color.black;
        this.decimalDigits = 0;
    }

    public ChartTypes getChartType() {
        return this._chartType;
    }

    public void setChartType(ChartTypes cType) {
        this._chartType = cType;
    }

    public List<Float> getChartData() {
        return this._chartData;
    }

    public void setChartData(List<Float> cData) {
        this._chartData = cData;
    }

    public int getItemNum() {
        return this._chartData.size();
    }

    public float getDataSum() {
        float sum = 0.0f;
        for (float d : this._chartData) {
            sum += d;
        }
        return sum;
    }

    public int getXShift() {
        return this._xShift;
    }

    public void setXShift(int xshift) {
        this._xShift = xshift;
    }

    public int getYShift() {
        return this._yShift;
    }

    public void setYShift(int yshift) {
        this._yShift = yshift;
    }

    public LegendScheme getLegendScheme() {
        return this._legendScheme;
    }

    public void setLegendScheme(LegendScheme ls) {
        this._legendScheme = ls;
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public void setMaxSize(int maxSize) {
        this._maxSize = maxSize;
    }

    public int getMinSize() {
        return this._minSize;
    }

    public void setMinSize(int minSize) {
        this._minSize = minSize;
    }

    public float getMaxValue() {
        return this._maxValue;
    }

    public void setMaxValue(float maxValue) {
        this._maxValue = maxValue;
    }

    public float getMinValue() {
        return this._minValue;
    }

    public void setMinValue(float minValue) {
        this._minValue = minValue;
    }

    public int getBarWidth() {
        return this._barWidth;
    }

    public void setBarWidth(int width) {
        this._barWidth = width;
    }

    public AlignType getAlignType() {
        return this._alignType;
    }

    public void setAlignType(AlignType atype) {
        this._alignType = atype;
    }

    public boolean isView3D() {
        return this._view3D;
    }

    public void setView3D(boolean v3d) {
        this._view3D = v3d;
    }

    public int getThickness() {
        return this._thickness;
    }

    public void setThickness(int thickness) {
        this._thickness = thickness;
    }

    public int getShapeIndex() {
        return this._shpIdx;
    }

    public void setShapeIndex(int sIdx) {
        this._shpIdx = sIdx;
    }

    public boolean isDrawLabel() {
        return this.drawLabel;
    }

    public void setDrawLabel(boolean value) {
        this.drawLabel = value;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font value) {
        this.labelFont = value;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color value) {
        this.labelColor = value;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setDecimalDigits(int value) {
        this.decimalDigits = value;
    }

    public List<Integer> getBarHeights() {
        ArrayList<Integer> heights = new ArrayList<Integer>();
        for (int i = 0; i < this._chartData.size(); ++i) {
            int h = this._minSize == 0 ? (int)(this._chartData.get(i).floatValue() / this._maxValue * (float)this._maxSize) : (int)((this._chartData.get(i).floatValue() - this._minValue) / (this._maxValue - this._minValue) * (float)(this._maxSize - this._minSize) + (float)this._minSize);
            heights.add(h);
        }
        return heights;
    }

    public int getWidth() {
        int width = 0;
        switch (this._chartType) {
            case BAR_CHART: {
                width = this._barWidth * this._chartData.size();
                if (!this._view3D) break;
                width += this._thickness;
                break;
            }
            case PIE_CHART: {
                width = this._minSize == this._maxSize ? this._maxSize : (this._minSize == 0 ? (int)(this.getDataSum() / this._maxValue * (float)this._maxSize) : (int)((this.getDataSum() - this._minValue) / (this._maxValue - this._minValue) * (float)(this._maxSize - this._minSize) + (float)this._minSize));
            }
        }
        return width;
    }

    public int getHeight() {
        int height = 0;
        switch (this._chartType) {
            case BAR_CHART: {
                height = Collections.max(this.getBarHeights());
                break;
            }
            case PIE_CHART: {
                height = this._minSize == this._maxSize ? this._maxSize : (this._minSize == 0 ? (int)(this.getDataSum() / this._maxValue * (float)this._maxSize) : (int)((this.getDataSum() - this._minValue) / (this._maxValue - this._minValue) * (float)(this._maxSize - this._minSize) + (float)this._minSize));
                if (!this._view3D) break;
                height = height * 2 / 3;
            }
        }
        if (this._view3D) {
            height += this._thickness;
        }
        return height;
    }

    public List<List<Float>> getPieAngles() {
        ArrayList<List<Float>> angles = new ArrayList<List<Float>>();
        float sum = this.getDataSum();
        float startAngle = 0.0f;
        for (Float value : this._chartData) {
            float sweepAngle = value.floatValue() / sum * 360.0f;
            ArrayList<Float> ssa = new ArrayList<Float>();
            ssa.add(Float.valueOf(startAngle));
            ssa.add(Float.valueOf(sweepAngle));
            angles.add(ssa);
            if (!((startAngle += sweepAngle) > 360.0f)) continue;
            startAngle -= 360.0f;
        }
        return angles;
    }

    public List<Float> getPieRatios() {
        ArrayList<Float> ratios = new ArrayList<Float>();
        float sum = this.getDataSum();
        for (Float value : this._chartData) {
            float ratio = value.floatValue() / sum;
            ratios.add(Float.valueOf(ratio));
        }
        return ratios;
    }

    @Override
    public Object clone() {
        ChartBreak aCB = new ChartBreak(this._chartType);
        aCB.setCaption(this.getCaption());
        aCB.setAlignType(this._alignType);
        aCB.setBarWidth(this._barWidth);
        aCB.setChartData(new ArrayList<Float>(this._chartData));
        aCB.setColor(this.getColor());
        aCB.setDrawShape(this.isDrawShape());
        aCB.setLegendScheme(this._legendScheme);
        aCB.setMaxSize(this._maxSize);
        aCB.setMaxValue(this._maxValue);
        aCB.setMinSize(this._minSize);
        aCB.setMinValue(this._minValue);
        aCB.setThickness(this._thickness);
        aCB.setView3D(this._view3D);
        aCB.setXShift(this._xShift);
        aCB.setYShift(this._yShift);
        aCB.setDrawLabel(this.drawLabel);
        aCB.setLabelColor(this.labelColor);
        aCB.setLabelFont(this.labelFont);
        aCB.setDecimalDigits(this.decimalDigits);
        return aCB;
    }

    public ChartBreak getSampleChartBreak() {
        ChartBreak aCB = (ChartBreak)this.clone();
        switch (aCB.getChartType()) {
            case BAR_CHART: {
                float min = aCB.getMaxValue() / (float)aCB.getItemNum();
                float dv = (aCB.getMaxValue() - min) / (float)aCB.getItemNum();
                for (int i = 0; i < aCB.getItemNum(); ++i) {
                    aCB.getChartData().set(i, Float.valueOf(min + dv * (float)i));
                }
                break;
            }
            case PIE_CHART: {
                float sum = aCB.getMaxValue();
                float data = sum / (float)aCB.getItemNum();
                for (int i = 0; i < aCB.getItemNum(); ++i) {
                    aCB.getChartData().set(i, Float.valueOf(data));
                }
                aCB.setMinSize(aCB._maxSize);
            }
        }
        return aCB;
    }

    public Extent getDrawExtent(PointF aPoint) {
        int width = this.getWidth();
        int height = this.getHeight();
        switch (this._alignType) {
            case CENTER: {
                aPoint.X -= (float)(width / 2);
                aPoint.Y += (float)(height / 2);
                break;
            }
            case LEFT: {
                aPoint.X -= (float)width;
                aPoint.Y += (float)(height / 2);
                break;
            }
            case RIGHT: {
                aPoint.Y += (float)(height / 2);
            }
        }
        aPoint.X += (float)this._xShift;
        aPoint.Y -= (float)this._yShift;
        Extent aExtent = new Extent();
        aExtent.minX = aPoint.X;
        aExtent.maxX = aPoint.X + (float)width;
        aExtent.minY = aPoint.Y - (float)height;
        aExtent.maxY = aPoint.Y;
        return aExtent;
    }
}

