/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.shape;

import java.util.ArrayList;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class EllipseShape
extends PolygonShape {
    protected float angle = 0.0f;

    public EllipseShape() {
    }

    public EllipseShape(double x, double y, double width, double height) {
        ArrayList<PointD> points = new ArrayList<PointD>();
        points.add(new PointD(x - width * 0.5, y - height * 0.5));
        points.add(new PointD(x - width * 0.5, y + height * 0.5));
        points.add(new PointD(x + width * 0.5, y + height * 0.5));
        points.add(new PointD(x + width * 0.5, y - height * 0.5));
        super.setPoints(points);
    }

    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.ELLIPSE;
    }

    public PointD getCenter() {
        return this.getExtent().getCenterPoint();
    }

    public double getWidth() {
        return this.getExtent().getWidth();
    }

    public double getHeight() {
        return this.getExtent().getHeight();
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float value) {
        this.angle = value;
    }

    public double getA() {
        return this.getWidth() / 2.0;
    }

    public double getB() {
        return this.getHeight() / 2.0;
    }

    public boolean contains(PointD p) {
        PointD center = this.getCenter();
        double a = this.getA();
        double b = this.getB();
        double r = Math.pow(p.X - center.X, 2.0) / Math.pow(a, 2.0) + Math.pow(p.Y - center.Y, 2.0) / Math.pow(b, 2.0);
        return r <= 1.0;
    }

    @Override
    public Object clone() {
        EllipseShape aPGS = new EllipseShape();
        aPGS.setExtent(this.getExtent());
        aPGS.setPoints(this.getPoints());
        aPGS.setVisible(this.isVisible());
        aPGS.setSelected(this.isSelected());
        return aPGS;
    }
}

