/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import us.hebi.matlab.mat.format.BufferAllocator;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.format.Mat5Serializable;
import us.hebi.matlab.mat.format.Mat5Type;
import us.hebi.matlab.mat.format.Mat5WriteUtil;
import us.hebi.matlab.mat.format.McosFileWrapper;
import us.hebi.matlab.mat.format.McosObject;
import us.hebi.matlab.mat.format.McosReference;
import us.hebi.matlab.mat.format.McosRegistry;
import us.hebi.matlab.mat.types.AbstractArray;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Sink;
import us.hebi.matlab.mat.types.Sources;

public final class Mat5Subsystem
extends AbstractArray
implements Mat5Serializable {
    private ByteBuffer buffer;
    private BufferAllocator bufferAllocator;
    private Mat5File subFile;

    Mat5Subsystem(int[] dims, ByteBuffer buffer, BufferAllocator bufferAllocator) {
        super(dims);
        this.buffer = buffer;
        this.bufferAllocator = bufferAllocator;
    }

    @Override
    public MatlabType getType() {
        return MatlabType.UInt8;
    }

    public ByteBuffer getBuffer() {
        return this.buffer.slice();
    }

    @Override
    public int getMat5Size(String name) {
        return 8 + Mat5WriteUtil.computeArrayHeaderSize(name, this) + Mat5Type.UInt8.computeSerializedSize(this.getNumElements());
    }

    @Override
    public void writeMat5(String name, boolean isGlobal, Sink sink) throws IOException {
        Mat5WriteUtil.writeMatrixTag(name, this, sink);
        Mat5WriteUtil.writeArrayHeader(name, isGlobal, this, sink);
        Mat5Type.UInt8.writeByteBufferWithTag(this.buffer.slice(), sink);
    }

    void processReferences(McosRegistry mcosRegistry) throws IOException {
        if (mcosRegistry.getReferences().isEmpty()) {
            return;
        }
        this.subFile = Mat5.newReader(Sources.wrap(this.buffer.slice())).setMcosRegistry(mcosRegistry).setBufferAllocator(this.bufferAllocator).disableSubsystemProcessing().setReducedHeader(true).readMat();
        McosFileWrapper fileWrapper = (McosFileWrapper)this.subFile.getStruct(0).get("MCOS");
        List<McosObject> objects = fileWrapper.parseObjects(mcosRegistry);
        objects.add(0, null);
        for (McosReference reference : mcosRegistry.getReferences()) {
            reference.setReferences(objects);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.subFile != null) {
            this.subFile.close();
        }
        this.bufferAllocator.release(this.buffer);
        this.buffer = null;
        this.bufferAllocator = null;
        this.subFile = null;
    }

    @Override
    protected int subHashCode() {
        return this.buffer.hashCode();
    }

    @Override
    protected boolean subEqualsGuaranteedSameClass(Object otherGuaranteedSameClass) {
        Mat5Subsystem other = (Mat5Subsystem)otherGuaranteedSameClass;
        return other.buffer.equals(this.buffer);
    }
}

