/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.blas;

import java.util.logging.Logger;
import org.meteoinfo.math.blas.BLAS;
import org.meteoinfo.math.blas.LAPACK;
import org.meteoinfo.math.blas.openblas.OpenBLAS;

public abstract class LinearAlgebra
implements BLAS,
LAPACK {
    public static LinearAlgebra engine = new OpenBLAS();

    public static void setEngine(String engineName) {
        if (engineName.equalsIgnoreCase("mkl")) {
            LinearAlgebra la = LinearAlgebra.MKL();
            if (la != null) {
                engine = la;
            }
        } else {
            engine = new OpenBLAS();
        }
    }

    static LinearAlgebra MKL() {
        Logger logger = Logger.getLogger("LAPACK.class");
        try {
            Class<?> clazz = Class.forName("org.meteoinfo.math.blas.mkl.MKL");
            logger.info("mkl module is available.");
            return (LinearAlgebra)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.info(String.format("Failed to create MKL instance: %s", e));
            return null;
        }
    }
}

