/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.interpolate;

import org.apache.commons.math4.legacy.linear.Array2DRowRealMatrix;
import org.apache.commons.math4.legacy.linear.ArrayRealVector;
import org.apache.commons.math4.legacy.linear.DecompositionSolver;
import org.apache.commons.math4.legacy.linear.RealMatrix;
import org.apache.commons.math4.legacy.linear.RealVector;
import org.apache.commons.math4.legacy.linear.SingularValueDecomposition;
import org.meteoinfo.math.interpolate.variogram.PowerVariogram;
import org.meteoinfo.math.interpolate.variogram.Variogram;

public class KrigingInterpolation {
    private final double[][] x;
    private final Variogram variogram;
    private final double[] yvi;

    public KrigingInterpolation(double[][] x, double[] y) {
        this(x, y, new PowerVariogram(x, y), null);
    }

    public KrigingInterpolation(double[][] x, double[] y, Variogram variogram, double[] error) {
        int i;
        this.x = x;
        this.variogram = variogram;
        int n = x.length;
        double[] yv = new double[n + 1];
        Array2DRowRealMatrix v = new Array2DRowRealMatrix(n + 1, n + 1);
        for (i = 0; i < n; ++i) {
            yv[i] = y[i];
            for (int j = i; j < n; ++j) {
                double var = variogram.evaluate(this.rdist(x[i], x[j]));
                v.setEntry(i, j, var);
                v.setEntry(j, i, var);
            }
            v.setEntry(n, i, 1.0);
            v.setEntry(i, n, 1.0);
        }
        yv[n] = 0.0;
        v.setEntry(n, n, 0.0);
        if (error != null) {
            for (i = 0; i < n; ++i) {
                v.setEntry(i, i, v.getEntry(i, i) - error[i] * error[i]);
            }
        }
        DecompositionSolver solver = new SingularValueDecomposition((RealMatrix)v).getSolver();
        ArrayRealVector constants = new ArrayRealVector(yv, false);
        RealVector solution = solver.solve((RealVector)constants);
        this.yvi = solution.toArray();
    }

    public double interpolate(double ... x) {
        if (x.length != this.x[0].length) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.x[0].length));
        }
        int n = this.x.length;
        double y = this.yvi[n];
        for (int i = 0; i < n; ++i) {
            y += this.yvi[i] * this.variogram.evaluate(this.rdist(x, this.x[i]));
        }
        return y;
    }

    private double rdist(double[] x1, double[] x2) {
        double d = 0.0;
        for (int i = 0; i < x1.length; ++i) {
            double t = x1[i] - x2[i];
            d += t * t;
        }
        return Math.sqrt(d);
    }

    public String toString() {
        return String.format("Kriging Interpolation(%s)", this.variogram);
    }
}

