/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.interpolate;

import org.meteoinfo.math.interpolate.InterpolationMethod;
import org.meteoinfo.math.interpolate.RectLinearInterpolator3D;
import org.meteoinfo.math.interpolate.RectNearestInterpolator3D;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.Index3D;
import org.meteoinfo.ndarray.math.ArrayUtil;

public abstract class RectInterpolator3D {
    protected Array xa;
    protected Array ya;
    protected Array za;
    protected Array va;

    public RectInterpolator3D(Array xa, Array ya, Array za, Array va) {
        this.xa = xa.copyIfView();
        this.ya = ya.copyIfView();
        this.za = za.copyIfView();
        this.va = va;
    }

    public static RectInterpolator3D factory(Array xa, Array ya, Array za, Array va, InterpolationMethod method) {
        if (method == InterpolationMethod.NEAREST) {
            return new RectNearestInterpolator3D(xa, ya, za, va);
        }
        return new RectLinearInterpolator3D(xa, ya, za, va);
    }

    public static int[] gridIndex(Array xdim, Array ydim, Array zdim, double x, double y, double z) {
        if (xdim.getRank() == 1) {
            int zIdx;
            int yIdx;
            int xn = (int)xdim.getSize();
            int yn = (int)ydim.getSize();
            int zn = (int)zdim.getSize();
            int xIdx = ArrayUtil.getDimIndex((Array)xdim, (Number)x);
            if (xIdx == -1 || xIdx == -(xn + 1)) {
                return null;
            }
            if (xIdx < 0) {
                xIdx = -xIdx - 2;
            }
            if ((yIdx = ArrayUtil.getDimIndex((Array)ydim, (Number)y)) == -1 || yIdx == -(yn + 1)) {
                return null;
            }
            if (yIdx < 0) {
                yIdx = -yIdx - 2;
            }
            if ((zIdx = ArrayUtil.getDimIndex((Array)zdim, (Number)z)) == -1 || zIdx == -(zn + 1)) {
                return null;
            }
            if (zIdx < 0) {
                zIdx = -zIdx - 2;
            }
            if (xIdx == xn - 1) {
                xIdx = xn - 2;
            }
            if (yIdx == yn - 1) {
                yIdx = yn - 2;
            }
            if (zIdx == zn - 1) {
                zIdx = zn - 2;
            }
            return new int[]{zIdx, yIdx, xIdx};
        }
        int xIdx = -1;
        int yIdx = -1;
        int zIdx = -1;
        int[] shape = xdim.getShape();
        int zn = shape[0];
        int yn = shape[1];
        int xn = shape[2];
        Index3D index = new Index3D(shape);
        for (int k = 0; k < zn - 1; ++k) {
            for (int i = 0; i < yn - 1; ++i) {
                for (int j = 0; j < xn - 1; ++j) {
                    index = index.set(k, i, j);
                    double z1 = zdim.getDouble((Index)index);
                    index = index.set(k + 1, i, j);
                    double z2 = zdim.getDouble((Index)index);
                    if (!(z >= z1) || !(z < z2)) continue;
                    index = index.set(k, i, j);
                    double y1 = ydim.getDouble((Index)index);
                    index = index.set(k, i + 1, j);
                    double y2 = ydim.getDouble((Index)index);
                    if (!(y >= y1) || !(y < y2)) continue;
                    index = index.set(k, i, j);
                    double x1 = xdim.getDouble((Index)index);
                    index = index.set(k, i, j + 1);
                    double x2 = xdim.getDouble((Index)index);
                    if (!(x >= x1) || !(x < x2)) continue;
                    zIdx = k;
                    yIdx = i;
                    xIdx = j;
                }
            }
        }
        if (zIdx >= 0 && yIdx >= 0 && xIdx >= 0) {
            return new int[]{zIdx, yIdx, xIdx};
        }
        return null;
    }

    public abstract double interpolate(double var1, double var3, double var5);

    public Array interpolate(Array newX, Array newY, Array newZ) {
        newX = newX.copyIfView();
        newY = newY.copyIfView();
        newZ = newZ.copyIfView();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])newX.getShape());
        int k = 0;
        while ((long)k < r.getSize()) {
            double z = newZ.getDouble(k);
            double y = newY.getDouble(k);
            double x = newX.getDouble(k);
            double v = this.interpolate(x, y, z);
            r.setDouble(k, v);
            ++k;
        }
        return r;
    }
}

