/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.stats;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;

public class Jenks {
    private LinkedList<Double> list = Lists.newLinkedList();

    public void addValue(double value) {
        this.list.add(value);
    }

    public void addValues(double ... values) {
        for (double value : values) {
            this.addValue(value);
        }
    }

    public void addValues(Array values) {
        IndexIterator vIter = values.getIndexIterator();
        while (vIter.hasNext()) {
            this.addValue(vIter.getDoubleNext());
        }
    }

    public Breaks computeBreaks() {
        double[] list = this.toSortedArray();
        int uniqueValues = this.countUnique(list);
        if (uniqueValues <= 3) {
            return this.computeBreaks(list, uniqueValues);
        }
        Breaks lastBreaks = this.computeBreaks(list, 2);
        double lastGvf = lastBreaks.gvf();
        double lastImprovement = lastGvf - this.computeBreaks(list, 1).gvf();
        for (int i = 3; i <= Math.min(6, uniqueValues); ++i) {
            Breaks breaks = this.computeBreaks(list, 2);
            double gvf = breaks.gvf();
            double marginalImprovement = gvf - lastGvf;
            if (marginalImprovement < lastImprovement) {
                return lastBreaks;
            }
            lastBreaks = breaks;
            lastGvf = gvf;
            lastImprovement = marginalImprovement;
        }
        return lastBreaks;
    }

    private double[] toSortedArray() {
        double[] values = new double[this.list.size()];
        for (int i = 0; i != values.length; ++i) {
            values[i] = this.list.get(i);
        }
        Arrays.sort(values);
        return values;
    }

    private int countUnique(double[] sortedList) {
        int count = 1;
        for (int i = 1; i < sortedList.length; ++i) {
            if (sortedList[i] == sortedList[i - 1]) continue;
            ++count;
        }
        return count;
    }

    public Breaks computeBreaks(int numclass) {
        return this.computeBreaks(this.toSortedArray(), numclass, new Identity());
    }

    private Breaks computeBreaks(double[] list, int numclass) {
        return this.computeBreaks(list, numclass, new Identity());
    }

    private Breaks computeBreaks(double[] list, int numclass, DoubleFunction transform) {
        int numdata = list.length;
        if (numdata == 0) {
            return new Breaks(new double[0], new int[0]);
        }
        double[][] mat1 = new double[numdata + 1][numclass + 1];
        double[][] mat2 = new double[numdata + 1][numclass + 1];
        for (int i = 1; i <= numclass; ++i) {
            mat1[1][i] = 1.0;
            mat2[1][i] = 0.0;
            for (int j = 2; j <= numdata; ++j) {
                mat2[j][i] = Double.MAX_VALUE;
            }
        }
        double v = 0.0;
        for (int l = 2; l <= numdata; ++l) {
            double s1 = 0.0;
            double s2 = 0.0;
            double w = 0.0;
            for (int m = 1; m <= l; ++m) {
                int i3 = l - m + 1;
                double val = transform.apply(list[i3 - 1]);
                v = (s2 += val * val) - (s1 += val) * s1 / (w += 1.0);
                int i4 = i3 - 1;
                if (i4 == 0) continue;
                for (int j = 2; j <= numclass; ++j) {
                    if (!(mat2[l][j] >= v + mat2[i4][j - 1])) continue;
                    mat1[l][j] = i3;
                    mat2[l][j] = v + mat2[i4][j - 1];
                }
            }
            mat1[l][1] = 1.0;
            mat2[l][1] = v;
        }
        int k = numdata;
        int[] kclass = new int[numclass];
        kclass[numclass - 1] = list.length - 1;
        for (int j = numclass; j >= 2; --j) {
            int id;
            kclass[j - 2] = id = (int)mat1[k][j] - 2;
            k = (int)mat1[k][j] - 1;
        }
        return new Breaks(list, kclass);
    }

    public static class Breaks {
        private double[] sortedValues;
        private int[] breaks;

        private Breaks(double[] sortedValues, int[] breaks) {
            this.sortedValues = sortedValues;
            this.breaks = breaks;
        }

        public double gvf() {
            double sdam = this.sumOfSquareDeviations(this.sortedValues);
            double sdcm = 0.0;
            for (int i = 0; i != this.numClasses(); ++i) {
                sdcm += this.sumOfSquareDeviations(this.classList(i));
            }
            return (sdam - sdcm) / sdam;
        }

        private double sumOfSquareDeviations(double[] values) {
            double mean = this.mean(values);
            double sum = 0.0;
            for (int i = 0; i != values.length; ++i) {
                double sqDev = Math.pow(values[i] - mean, 2.0);
                sum += sqDev;
            }
            return sum;
        }

        public double[] getValues() {
            return this.sortedValues;
        }

        private double[] classList(int i) {
            int classStart = i == 0 ? 0 : this.breaks[i - 1] + 1;
            int classEnd = this.breaks[i];
            double[] list = new double[classEnd - classStart + 1];
            for (int j = classStart; j <= classEnd; ++j) {
                list[j - classStart] = this.sortedValues[j];
            }
            return list;
        }

        public List<Array> getGroups() {
            ArrayList<Array> groups = new ArrayList<Array>();
            int n = this.numClasses();
            for (int i = 0; i < n; ++i) {
                double[] values = this.classList(i);
                groups.add(Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{values.length}, (Object)values));
            }
            return groups;
        }

        public double getClassMin(int classIndex) {
            if (classIndex == 0) {
                return this.sortedValues[0];
            }
            return this.sortedValues[this.breaks[classIndex - 1] + 1];
        }

        public double getClassMax(int classIndex) {
            return this.sortedValues[this.breaks[classIndex]];
        }

        public int getClassCount(int classIndex) {
            if (classIndex == 0) {
                return this.breaks[0] + 1;
            }
            return this.breaks[classIndex] - this.breaks[classIndex - 1];
        }

        private double mean(double[] values) {
            double sum = 0.0;
            for (int i = 0; i != values.length; ++i) {
                sum += values[i];
            }
            return sum / (double)values.length;
        }

        public int numClasses() {
            return this.breaks.length;
        }

        public Array getClassValues() {
            double[] classValues = new double[this.breaks.length + 1];
            classValues[0] = this.sortedValues[0];
            for (int i = 0; i < this.breaks.length; ++i) {
                classValues[i + 1] = this.getClassMax(i);
            }
            return Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{classValues.length}, (Object)classValues);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i != this.numClasses(); ++i) {
                if (this.getClassMin(i) == this.getClassMax(i)) {
                    sb.append(this.getClassMin(i));
                } else {
                    sb.append(this.getClassMin(i)).append(" - ").append(this.getClassMax(i));
                }
                sb.append(" (" + this.getClassCount(i) + ")");
                sb.append(" = ").append(Arrays.toString(this.classList(i)));
                sb.append("\n");
            }
            return sb.toString();
        }

        public String printClusters() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i != this.numClasses(); ++i) {
                if (this.getClassMin(i) == this.getClassMax(i)) {
                    sb.append(this.getClassMin(i));
                } else {
                    sb.append(this.getClassMin(i)).append(" - ").append(this.getClassMax(i));
                }
                sb.append(" (" + this.getClassCount(i) + ");");
            }
            return sb.toString();
        }

        public int classOf(double value) {
            for (int i = 0; i != this.numClasses(); ++i) {
                if (!(value <= this.getClassMax(i))) continue;
                return i;
            }
            return this.numClasses() - 1;
        }

        public Array classOf(Array values) {
            Array r = Array.factory((DataType)DataType.INT, (int[])values.getShape());
            IndexIterator vIter = values.getIndexIterator();
            IndexIterator rIter = r.getIndexIterator();
            while (vIter.hasNext()) {
                rIter.setIntNext(this.classOf(vIter.getDoubleNext()));
            }
            return r;
        }

        public static void main(String[] args) {
            Jenks jenks = new Jenks();
            jenks.addValue(1.0);
            jenks.addValue(2.0);
            jenks.addValue(2.0);
            jenks.addValue(2.0);
            jenks.addValue(3.0);
        }
    }

    public static class Identity
    implements DoubleFunction {
        @Override
        public double apply(double x) {
            return x;
        }
    }

    private static class Log10
    implements DoubleFunction {
        private Log10() {
        }

        @Override
        public double apply(double x) {
            return Math.log10(x);
        }
    }

    private static interface DoubleFunction {
        public double apply(double var1);
    }
}

