/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.meteoinfo.table.RowHeaderTableModel;

public class RowHeaderRenderer1
extends JLabel
implements TableCellRenderer,
ListSelectionListener {
    private JTable _refTable;
    private JTable _tableShow;

    public RowHeaderRenderer1(JTable refTable, JTable tableShow) {
        this._refTable = refTable;
        this._tableShow = tableShow;
        ListSelectionModel listModel = this._refTable.getSelectionModel();
        listModel.addListSelectionListener(this);
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int rowCount = this._refTable.getRowCount();
        ((RowHeaderTableModel)table.getModel()).setRowCount(rowCount);
        JTableHeader header = this._refTable.getTableHeader();
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        this.setBackground(header.getBackground());
        if (this.isSelect(row)) {
            this.setForeground(Color.white);
            this.setBackground(Color.lightGray);
        } else {
            this.setForeground(header.getForeground());
        }
        this.setFont(header.getFont());
        this.setText(String.valueOf(rowCount - row - 1));
        return this;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this._tableShow.repaint();
    }

    private boolean isSelect(int row) {
        int[] sel = this._refTable.getSelectedRows();
        for (int i = 0; i < sel.length; ++i) {
            if (sel[i] != row) continue;
            return true;
        }
        return false;
    }
}

