/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.table.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.table.DataRow;
import org.meteoinfo.table.DataTable;

public class TableUtil {
    public static List<String> getFormats(String formatSpec) {
        String[] colFormats;
        if (formatSpec == null) {
            return null;
        }
        ArrayList<String> formats = new ArrayList<String>();
        for (String colFormat : colFormats = formatSpec.split("%")) {
            if (colFormat.isEmpty()) continue;
            if (colFormat.substring(0, 1).equals("{")) {
                int eidx = colFormat.indexOf("}");
                colFormat = colFormat.substring(1, eidx);
            } else {
                colFormat = "%" + colFormat;
            }
            formats.add(colFormat);
        }
        return formats;
    }

    public static DataType toDataTypes(String dt) {
        if (dt.contains("%")) {
            dt = dt.split("%")[1];
        }
        switch (dt.toLowerCase()) {
            case "c": 
            case "s": 
            case "string": {
                return DataType.STRING;
            }
            case "i": 
            case "int": {
                return DataType.INT;
            }
            case "f": 
            case "float": {
                return DataType.FLOAT;
            }
            case "d": 
            case "double": {
                return DataType.DOUBLE;
            }
        }
        if (dt.substring(0, 1).equals("{")) {
            return DataType.DATE;
        }
        return DataType.STRING;
    }

    public static String getDateFormat(String dt) {
        int sidx = dt.indexOf("{");
        int eidx = dt.indexOf("}");
        String formatStr = dt.substring(sidx + 1, eidx);
        return formatStr;
    }

    public static DataTable ave_Month(List<Array> data, List<String> colNames, List<LocalDateTime> time) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("YearMonth", DataType.STRING);
        for (String col : colNames) {
            rTable.addColumn(col, DataType.DOUBLE);
        }
        List<String> yms = TableUtil.getYearMonths(time);
        for (String ym : yms) {
            int year = Integer.parseInt(ym.substring(0, 4));
            int month = Integer.parseInt(ym.substring(4));
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)ym);
            int col = 0;
            for (Array a : data) {
                ArrayList<Double> values = new ArrayList<Double>();
                for (int i = 0; i < time.size(); ++i) {
                    double v;
                    LocalDateTime ldt = time.get(i);
                    if (ldt.getYear() != year || ldt.getMonthValue() != month || Double.isNaN(v = a.getDouble(i))) continue;
                    values.add(v);
                }
                nRow.setValue(colNames.get(col), (Object)MIMath.mean(values));
                ++col;
            }
        }
        return rTable;
    }

    public static List<String> getYearMonths(List<LocalDateTime> time) {
        ArrayList<String> yms = new ArrayList<String>();
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMM");
        for (LocalDateTime t : time) {
            String ym = format.format(t);
            if (yms.contains(ym)) continue;
            yms.add(ym);
        }
        return yms;
    }
}

