/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math4.legacy.analysis.BivariateFunction;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.ChartText3D;
import org.meteoinfo.chart.graphic.MeshGraphic;
import org.meteoinfo.chart.graphic.Model;
import org.meteoinfo.chart.graphic.ParticleGraphics;
import org.meteoinfo.chart.graphic.TriMeshGraphic;
import org.meteoinfo.chart.graphic.VolumeGraphic;
import org.meteoinfo.chart.graphic.pipe.PipeShape;
import org.meteoinfo.chart.jogl.mc.CallbackMC;
import org.meteoinfo.chart.jogl.mc.MarchingCubes;
import org.meteoinfo.chart.shape.TextureShape;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.XAlign;
import org.meteoinfo.common.YAlign;
import org.meteoinfo.common.colors.ColorMap;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.XYListDataset;
import org.meteoinfo.data.analysis.Statistics;
import org.meteoinfo.data.meteodata.StationModel;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.geometry.colors.Normalize;
import org.meteoinfo.geometry.colors.OpacityTransferFunction;
import org.meteoinfo.geometry.colors.TransferFunction;
import org.meteoinfo.geometry.geoprocess.GeoComputation;
import org.meteoinfo.geometry.geoprocess.GeometryUtil;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.graphic.GraphicCollection3D;
import org.meteoinfo.geometry.graphic.ImageGraphic;
import org.meteoinfo.geometry.legend.ArrowLineBreak;
import org.meteoinfo.geometry.legend.ArrowPolygonBreak;
import org.meteoinfo.geometry.legend.BarBreak;
import org.meteoinfo.geometry.legend.BreakTypes;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.ColorBreakCollection;
import org.meteoinfo.geometry.legend.LegendManage;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.legend.LineStyles;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PointStyle;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.legend.StreamlineBreak;
import org.meteoinfo.geometry.shape.ArcShape;
import org.meteoinfo.geometry.shape.BarShape;
import org.meteoinfo.geometry.shape.CapPolylineShape;
import org.meteoinfo.geometry.shape.CubicShape;
import org.meteoinfo.geometry.shape.CurveLineShape;
import org.meteoinfo.geometry.shape.CylinderShape;
import org.meteoinfo.geometry.shape.ImageShape;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PointZShape;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolygonZShape;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.geometry.shape.RectangleShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.geometry.shape.StationModelShape;
import org.meteoinfo.geometry.shape.WindArrow;
import org.meteoinfo.geometry.shape.WindArrow3D;
import org.meteoinfo.geometry.shape.WindBarb;
import org.meteoinfo.math.interpolate.InterpUtil;
import org.meteoinfo.math.interpolate.InterpolationMethod;
import org.meteoinfo.math.interpolate.RectNearestInterpolator3D;
import org.meteoinfo.math.meteo.MeteoMath;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.Index2D;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.ndarray.math.ArrayUtil;
import org.meteoinfo.ndarray.util.BigDecimalUtil;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.render.java2d.ContourDraw;
import org.meteoinfo.render.java2d.Draw;
import wcontour.Contour;
import wcontour.global.Point3D;
import wcontour.global.PolyLine;
import wcontour.global.PolyLine3D;
import wcontour.global.Polygon;

public class GraphicFactory {
    public static GraphicCollection createLineString(Array xdata, Array ydata, ColorBreak cb) {
        PolylineShape pls;
        GraphicCollection gc = new GraphicCollection();
        ArrayList<PointD> points = new ArrayList<PointD>();
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (Double.isNaN(y) || Double.isNaN(x) || Double.isInfinite(y) || Double.isInfinite(x)) {
                if (points.isEmpty()) continue;
                if (points.size() == 1) {
                    points.add((PointD)((PointD)points.get(0)).clone());
                }
                pls = new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
                points = new ArrayList();
                continue;
            }
            points.add(new PointD(x, y));
        }
        if (!points.isEmpty()) {
            if (points.size() == 1) {
                points.add((PointD)((PointD)points.get(0)).clone());
            }
            pls = new PolylineShape();
            pls.setPoints(points);
            gc.add(new Graphic((Shape)pls, cb));
        }
        return gc;
    }

    public static GraphicCollection createLineString(Array xdata, Array ydata, ColorBreak cb, boolean iscurve) {
        GraphicCollection gc = new GraphicCollection();
        ArrayList<PointD> points = new ArrayList<PointD>();
        if (xdata.getRank() == 1) {
            Object pls;
            IndexIterator xIter = xdata.getIndexIterator();
            IndexIterator yIter = ydata.getIndexIterator();
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                if (Double.isNaN(y) || Double.isNaN(x) || Double.isInfinite(y) || Double.isInfinite(x)) {
                    if (points.isEmpty()) continue;
                    if (points.size() == 1) {
                        points.add((PointD)((PointD)points.get(0)).clone());
                    }
                    pls = iscurve ? new CurveLineShape() : new PolylineShape();
                    pls.setPoints(points);
                    gc.add(new Graphic((Shape)pls, cb));
                    points = new ArrayList();
                    continue;
                }
                points.add(new PointD(x, y));
            }
            if (!points.isEmpty()) {
                if (points.size() == 1) {
                    points.add((PointD)((PointD)points.get(0)).clone());
                }
                pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
            }
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            Index2D xIndex = (Index2D)xdata.getIndex();
            Index2D yIndex = (Index2D)ydata.getIndex();
            for (int i = 0; i < xn; ++i) {
                Object pls;
                points = new ArrayList();
                for (int j = 0; j < yn; ++j) {
                    xIndex.set(j, i);
                    yIndex.set(j, i);
                    double x = xdata.getDouble((Index)xIndex);
                    double y = ydata.getDouble((Index)yIndex);
                    if (Double.isNaN(y) || Double.isNaN(x)) {
                        if (points.isEmpty()) continue;
                        if (points.size() == 1) {
                            points.add((PointD)((PointD)points.get(0)).clone());
                        }
                        pls = iscurve ? new CurveLineShape() : new PolylineShape();
                        pls.setPoints(points);
                        gc.add(new Graphic((Shape)pls, cb));
                        points = new ArrayList();
                        continue;
                    }
                    points.add(new PointD(x, y));
                }
                if (points.size() <= 1) continue;
                pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
            }
        }
        return gc;
    }

    public static GraphicCollection createLineString(Array xdata, Array ydata, List<ColorBreak> cbs, boolean iscurve) {
        GraphicCollection gc = new GraphicCollection();
        if (xdata.getRank() == 1) {
            ColorBreak cb;
            Object pls;
            IndexIterator xIter = xdata.getIndexIterator();
            IndexIterator yIter = ydata.getIndexIterator();
            ArrayList<PointD> points = new ArrayList<PointD>();
            int i = 0;
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                if (Double.isNaN(y) || Double.isNaN(x)) {
                    if (points.isEmpty()) continue;
                    if (points.size() == 1) {
                        points.add((PointD)((PointD)points.get(0)).clone());
                    }
                    pls = iscurve ? new CurveLineShape() : new PolylineShape();
                    pls.setPoints(points);
                    cb = cbs.get(i);
                    gc.add(new Graphic((Shape)pls, cb));
                    points = new ArrayList();
                    ++i;
                    continue;
                }
                points.add(new PointD(x, y));
            }
            if (points.size() > 1) {
                pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                cb = cbs.get(i);
                gc.add(new Graphic((Shape)pls, cb));
            }
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            Index2D xIndex = (Index2D)xdata.getIndex();
            Index2D yIndex = (Index2D)ydata.getIndex();
            for (int i = 0; i < xn; ++i) {
                Object pls;
                ArrayList<PointD> points = new ArrayList<PointD>();
                ColorBreak cb = cbs.get(i);
                for (int j = 0; j < yn; ++j) {
                    xIndex.set(j, i);
                    yIndex.set(j, i);
                    double x = xdata.getDouble((Index)xIndex);
                    double y = ydata.getDouble((Index)yIndex);
                    if (Double.isNaN(y) || Double.isNaN(x)) {
                        if (points.isEmpty()) continue;
                        if (points.size() == 1) {
                            points.add((PointD)((PointD)points.get(0)).clone());
                        }
                        pls = iscurve ? new CurveLineShape() : new PolylineShape();
                        pls.setPoints(points);
                        gc.add(new Graphic((Shape)pls, cb));
                        points = new ArrayList();
                        continue;
                    }
                    points.add(new PointD(x, y));
                }
                if (points.size() <= 1) continue;
                pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
            }
        }
        gc.setSingleLegend(false);
        return gc;
    }

    public static GraphicCollection createLineString(Array xdata, Array ydata, Array cdata, LegendScheme ls, boolean iscurve) {
        GraphicCollection gc = new GraphicCollection();
        if (xdata.getRank() == 1) {
            Object pls;
            IndexIterator xIter = xdata.getIndexIterator();
            IndexIterator yIter = ydata.getIndexIterator();
            IndexIterator cIter = cdata.getIndexIterator();
            ArrayList<PointD> points = new ArrayList<PointD>();
            ColorBreakCollection cbc = new ColorBreakCollection();
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                double c = cIter.getDoubleNext();
                ColorBreak cb = ls.findLegendBreak((Number)c);
                if (Double.isNaN(y) || Double.isNaN(x)) {
                    if (points.isEmpty()) continue;
                    if (points.size() == 1) {
                        points.add((PointD)((PointD)points.get(0)).clone());
                    }
                    pls = iscurve ? new CurveLineShape() : new PolylineShape();
                    pls.setPoints(points);
                    gc.add(new Graphic((Shape)pls, (ColorBreak)cbc));
                    points = new ArrayList();
                    cbc = new ColorBreakCollection();
                    continue;
                }
                points.add(new PointD(x, y));
                cbc.add(cb);
            }
            if (points.size() > 1) {
                pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, (ColorBreak)cbc));
            }
            gc.setLegendScheme(ls);
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            Index2D xIndex = (Index2D)xdata.getIndex();
            Index2D yIndex = (Index2D)ydata.getIndex();
            Index2D cIndex = (Index2D)cdata.getIndex();
            for (int i = 0; i < xn; ++i) {
                ArrayList<PointD> points = new ArrayList<PointD>();
                ColorBreakCollection cbc = new ColorBreakCollection();
                for (int j = 0; j < yn; ++j) {
                    xIndex.set(j, i);
                    yIndex.set(j, i);
                    cIndex.set(j, i);
                    double x = xdata.getDouble((Index)xIndex);
                    double y = ydata.getDouble((Index)yIndex);
                    double c = cdata.getDouble((Index)cIndex);
                    ColorBreak cb = ls.findLegendBreak((Number)c);
                    points.add(new PointD(x, y));
                    cbc.add(cb);
                }
                if (points.size() <= 1) continue;
                Object pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, (ColorBreak)cbc));
            }
            gc.setLegendScheme(ls);
            gc.setSingleLegend(false);
        }
        return gc;
    }

    public static GraphicCollection createLineString(XYListDataset data, List<ColorBreak> cbs) {
        GraphicCollection gc = new GraphicCollection();
        for (int i = 0; i < data.getSeriesCount(); ++i) {
            ArrayList<PointD> points = new ArrayList<PointD>();
            for (int j = 0; j < data.getItemCount(i); ++j) {
                double x = data.getX(i, j);
                double y = data.getY(i, j);
                points.add(new PointD(x, y));
            }
            PolylineShape pls = new PolylineShape();
            pls.setPoints(points);
            gc.add(new Graphic((Shape)pls, cbs.get(i)));
        }
        gc.setSingleLegend(false);
        return gc;
    }

    public static GraphicCollection createLineString3D(Array xdata, Array ydata, Array zdata, ColorBreak cb) {
        GraphicCollection3D gc = new GraphicCollection3D();
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        double z = 0.0;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        boolean fixZ = false;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z = zdata.getDouble(0);
        }
        if (xdata.getRank() == 1) {
            PolylineZShape pls;
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                if (!fixZ) {
                    z = zIter.getDoubleNext();
                }
                if (Double.isNaN(y) || Double.isNaN(x) || Double.isNaN(z)) {
                    if (points.isEmpty()) continue;
                    if (points.size() == 1) {
                        points.add((PointZ)((PointZ)points.get(0)).clone());
                    }
                    pls = new PolylineZShape();
                    pls.setPoints(points);
                    gc.add(new Graphic((Shape)pls, cb));
                    points = new ArrayList();
                    continue;
                }
                points.add(new PointZ(x, y, z));
            }
            if (points.size() > 1) {
                pls = new PolylineZShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
            }
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            for (int j = 0; j < yn; ++j) {
                PolylineZShape pls;
                for (int i = 0; i < xn; ++i) {
                    double x = xIter.getDoubleNext();
                    double y = yIter.getDoubleNext();
                    if (!fixZ) {
                        z = zIter.getDoubleNext();
                    }
                    if (Double.isNaN(y) || Double.isNaN(x)) {
                        if (points.isEmpty()) continue;
                        if (points.size() == 1) {
                            points.add((PointZ)((PointZ)points.get(0)).clone());
                        }
                        pls = new PolylineZShape();
                        pls.setPoints(points);
                        gc.add(new Graphic((Shape)pls, cb));
                        points = new ArrayList();
                        continue;
                    }
                    points.add(new PointZ(x, y, z));
                }
                if (points.size() <= 1) continue;
                pls = new PolylineZShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
                points = new ArrayList();
            }
        }
        return gc;
    }

    public static GraphicCollection createLineString3D(Array xdata, Array ydata, Array zdata, List<ColorBreak> cbs) {
        GraphicCollection3D gc = new GraphicCollection3D();
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        double z = 0.0;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        boolean fixZ = false;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z = zdata.getDouble(0);
        }
        if (xdata.getRank() == 1) {
            ColorBreak cb;
            PolylineZShape pls;
            int i = 0;
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                if (!fixZ) {
                    z = zIter.getDoubleNext();
                }
                if (Double.isNaN(y) || Double.isNaN(x)) {
                    if (points.isEmpty()) continue;
                    if (points.size() == 1) {
                        points.add((PointZ)((PointZ)points.get(0)).clone());
                    }
                    pls = new PolylineZShape();
                    pls.setPoints(points);
                    cb = cbs.get(i);
                    gc.add(new Graphic((Shape)pls, cb));
                    points = new ArrayList();
                    ++i;
                    continue;
                }
                points.add(new PointZ(x, y, z));
            }
            if (points.size() > 1) {
                pls = new PolylineZShape();
                pls.setPoints(points);
                cb = cbs.get(i);
                gc.add(new Graphic((Shape)pls, cb));
            }
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            for (int j = 0; j < yn; ++j) {
                PolylineZShape pls;
                ColorBreak cb = cbs.get(j);
                for (int i = 0; i < xn; ++i) {
                    double x = xIter.getDoubleNext();
                    double y = yIter.getDoubleNext();
                    if (!fixZ) {
                        z = zIter.getDoubleNext();
                    }
                    if (Double.isNaN(y) || Double.isNaN(x)) {
                        if (points.isEmpty()) continue;
                        if (points.size() == 1) {
                            points.add((PointZ)((PointZ)points.get(0)).clone());
                        }
                        pls = new PolylineZShape();
                        pls.setPoints(points);
                        gc.add(new Graphic((Shape)pls, cb));
                        points = new ArrayList();
                        continue;
                    }
                    points.add(new PointZ(x, y, z));
                }
                if (points.size() <= 1) continue;
                pls = new PolylineZShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
                points = new ArrayList();
            }
        }
        return gc;
    }

    public static GraphicCollection3D lineString3DToPipe(GraphicCollection3D lines, float radius, int steps) {
        for (Graphic graphic : lines.getGraphics()) {
            PolylineZShape shape = (PolylineZShape)graphic.getShape();
            PipeShape pipeShape = new PipeShape(shape, radius, steps);
            graphic.setShape((Shape)pipeShape);
        }
        return lines;
    }

    public static GraphicCollection createLineString3D(Array xdata, Array ydata, Array zdata, Array mdata, LegendScheme ls) {
        GraphicCollection3D gc = new GraphicCollection3D();
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        double z = 0.0;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        IndexIterator mIter = mdata.getIndexIterator();
        boolean fixZ = false;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z = zdata.getDouble(0);
        }
        if (xdata.getRank() == 1) {
            PolylineZShape pls;
            ColorBreakCollection cbs = new ColorBreakCollection();
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                if (!fixZ) {
                    z = zIter.getDoubleNext();
                }
                double m = mIter.getDoubleNext();
                ColorBreak cb = ls.findLegendBreak((Number)m);
                if (Double.isNaN(y) || Double.isNaN(x)) {
                    if (points.isEmpty()) continue;
                    if (points.size() == 1) {
                        points.add((PointZ)((PointZ)points.get(0)).clone());
                    }
                    pls = new PolylineZShape();
                    pls.setPoints(points);
                    gc.add(new Graphic((Shape)pls, (ColorBreak)cbs));
                    points = new ArrayList();
                    cbs = new ColorBreakCollection();
                    continue;
                }
                points.add(new PointZ(x, y, z, m));
                cbs.add(cb);
            }
            if (points.size() > 1) {
                pls = new PolylineZShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, (ColorBreak)cbs));
            }
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            for (int j = 0; j < yn; ++j) {
                PolylineZShape pls;
                ColorBreakCollection cbs = new ColorBreakCollection();
                for (int i = 0; i < xn; ++i) {
                    double x = xIter.getDoubleNext();
                    double y = yIter.getDoubleNext();
                    if (!fixZ) {
                        z = zIter.getDoubleNext();
                    }
                    double m = mIter.getDoubleNext();
                    ColorBreak cb = ls.findLegendBreak((Number)m);
                    if (Double.isNaN(y) || Double.isNaN(x)) {
                        if (points.isEmpty()) continue;
                        if (points.size() == 1) {
                            points.add((PointZ)((PointZ)points.get(0)).clone());
                        }
                        pls = new PolylineZShape();
                        pls.setPoints(points);
                        gc.add(new Graphic((Shape)pls, (ColorBreak)cbs));
                        points = new ArrayList();
                        cbs = new ColorBreakCollection();
                        continue;
                    }
                    points.add(new PointZ(x, y, z, m));
                    cbs.add(cb);
                }
                if (points.size() <= 1) continue;
                pls = new PolylineZShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, (ColorBreak)cbs));
                points = new ArrayList();
            }
        }
        gc.setLegendScheme(ls);
        return gc;
    }

    public static GraphicCollection createErrorLineString(Array xdata, Array ydata, Array xErrorLeft, Array xErrorRight, Array yErrorBottom, Array yErrorUp, ColorBreak cb, PolylineBreak ecb, float capSize) {
        PolylineShape pls;
        IndexIterator yeuIter;
        GraphicCollection gc = new GraphicCollection();
        ArrayList<PointD> points = new ArrayList<PointD>();
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator xelIter = xErrorLeft == null ? null : xErrorLeft.getIndexIterator();
        IndexIterator xerIter = xErrorRight == null ? null : xErrorRight.getIndexIterator();
        IndexIterator yebIter = yErrorBottom == null ? null : yErrorBottom.getIndexIterator();
        IndexIterator indexIterator = yeuIter = yErrorUp == null ? null : yErrorUp.getIndexIterator();
        while (xIter.hasNext()) {
            CapPolylineShape epls;
            ArrayList<PointD> eps;
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (Double.isNaN(y) || Double.isNaN(x)) {
                if (points.isEmpty()) continue;
                if (points.size() == 1) {
                    points.add((PointD)((PointD)points.get(0)).clone());
                }
                pls = new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
                points = new ArrayList();
                if (yebIter != null) {
                    yebIter.next();
                    yeuIter.next();
                }
                if (xelIter == null) continue;
                xelIter.next();
                xerIter.next();
                continue;
            }
            points.add(new PointD(x, y));
            if (yebIter != null) {
                double yerrB = yebIter.getDoubleNext();
                double yerrU = yeuIter.getDoubleNext();
                eps = new ArrayList<PointD>();
                eps.add(new PointD(x, y + yerrU));
                eps.add(new PointD(x, y - yerrB));
                epls = new CapPolylineShape();
                epls.setCapLen(capSize);
                epls.setPoints(eps);
                gc.add(new Graphic((Shape)epls, (ColorBreak)ecb));
            }
            if (xelIter == null) continue;
            double xerrL = xelIter.getDoubleNext();
            double xerrR = xerIter.getDoubleNext();
            eps = new ArrayList();
            eps.add(new PointD(x - xerrL, y));
            eps.add(new PointD(x + xerrR, y));
            epls = new CapPolylineShape();
            epls.setCapLen(capSize);
            epls.setCapAngle(90.0f);
            epls.setPoints(eps);
            gc.add(new Graphic((Shape)epls, (ColorBreak)ecb));
        }
        if (!points.isEmpty()) {
            if (points.size() == 1) {
                points.add((PointD)((PointD)points.get(0)).clone());
            }
            pls = new PolylineShape();
            pls.setPoints(points);
            gc.add(new Graphic((Shape)pls, cb));
        }
        gc.setSingleLegend(false);
        PolylineBreak lb = (PolylineBreak)ecb.clone();
        if (cb instanceof PolylineBreak) {
            lb.setDrawSymbol(((PolylineBreak)cb).isDrawSymbol());
        } else {
            lb.setSymbol((PointBreak)cb);
            lb.setCaption(cb.getCaption());
        }
        gc.setLegendBreak((ColorBreak)lb);
        return gc;
    }

    public static GraphicCollection createErrorLineString_bak1(Array xdata, Array ydata, Array xErrorLeft, Array xErrorRight, Array yErrorBottom, Array yErrorUp, ColorBreak cb, ColorBreak ecb, Double capSize) {
        PolylineShape pls;
        GraphicCollection gc = new GraphicCollection();
        ArrayList<PointD> points = new ArrayList<PointD>();
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator xelIter = xErrorLeft == null ? null : xErrorLeft.getIndexIterator();
        IndexIterator xerIter = xErrorRight == null ? null : xErrorRight.getIndexIterator();
        IndexIterator yebIter = yErrorBottom == null ? null : yErrorBottom.getIndexIterator();
        IndexIterator yeuIter = yErrorUp == null ? null : yErrorUp.getIndexIterator();
        double width = capSize == null ? (ArrayMath.getMaximum((Array)xdata) - ArrayMath.getMinimum((Array)xdata)) / (double)xdata.getSize() * 0.1 : capSize * 0.5;
        while (xIter.hasNext()) {
            PolylineShape epls;
            ArrayList<PointD> eps;
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (Double.isNaN(y) || Double.isNaN(x)) {
                if (points.isEmpty()) continue;
                if (points.size() == 1) {
                    points.add((PointD)((PointD)points.get(0)).clone());
                }
                pls = new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
                points = new ArrayList();
                if (yebIter != null) {
                    yebIter.next();
                    yeuIter.next();
                }
                if (xelIter == null) continue;
                xelIter.next();
                xerIter.next();
                continue;
            }
            points.add(new PointD(x, y));
            if (yErrorBottom != null) {
                double yerrB = yebIter.getDoubleNext();
                double yerrU = yeuIter.getDoubleNext();
                eps = new ArrayList<PointD>();
                eps.add(new PointD(x, y + yerrU));
                eps.add(new PointD(x, y - yerrB));
                epls = new PolylineShape();
                epls.setPoints(eps);
                gc.add(new Graphic((Shape)epls, ecb));
                eps = new ArrayList();
                eps.add(new PointD(x - width, y + yerrU));
                eps.add(new PointD(x + width, y + yerrU));
                epls = new PolylineShape();
                epls.setPoints(eps);
                gc.add(new Graphic((Shape)epls, ecb));
                eps = new ArrayList();
                eps.add(new PointD(x - width, y - yerrB));
                eps.add(new PointD(x + width, y - yerrB));
                epls = new PolylineShape();
                epls.setPoints(eps);
                gc.add(new Graphic((Shape)epls, ecb));
            }
            if (xErrorLeft == null) continue;
            double xerrL = xelIter.getDoubleNext();
            double xerrR = xerIter.getDoubleNext();
            eps = new ArrayList();
            eps.add(new PointD(x - xerrL, y));
            eps.add(new PointD(x + xerrR, y));
            epls = new PolylineShape();
            epls.setPoints(eps);
            gc.add(new Graphic((Shape)epls, ecb));
            eps = new ArrayList();
            eps.add(new PointD(x - xerrL, y - width));
            eps.add(new PointD(x - xerrL, y + width));
            epls = new PolylineShape();
            epls.setPoints(eps);
            gc.add(new Graphic((Shape)epls, ecb));
            eps = new ArrayList();
            eps.add(new PointD(x + xerrR, y - width));
            eps.add(new PointD(x + xerrR, y + width));
            epls = new PolylineShape();
            epls.setPoints(eps);
            gc.add(new Graphic((Shape)epls, ecb));
        }
        if (!points.isEmpty()) {
            if (points.size() == 1) {
                points.add((PointD)((PointD)points.get(0)).clone());
            }
            pls = new PolylineShape();
            pls.setPoints(points);
            gc.add(new Graphic((Shape)pls, cb));
        }
        gc.setSingleLegend(false);
        return gc;
    }

    public static GraphicCollection createStepLineString(Array xdata, Array ydata, ColorBreak cb, String where) {
        GraphicCollection gc = new GraphicCollection();
        ArrayList<PointD> points = new ArrayList<PointD>();
        if (!xdata.getIndexPrivate().isFastIterator()) {
            xdata = xdata.copy();
        }
        if (!ydata.getIndexPrivate().isFastIterator()) {
            ydata = ydata.copy();
        }
        switch (where) {
            case "mid": {
                PolylineShape pls;
                int i = 0;
                while ((long)i < xdata.getSize() - 1L) {
                    double x1 = xdata.getDouble(i);
                    double x2 = xdata.getDouble(i + 1);
                    double y1 = ydata.getDouble(i);
                    double y2 = ydata.getDouble(i + 1);
                    if (Double.isNaN(y1) || Double.isNaN(x1) || Double.isNaN(x2)) {
                        if (!points.isEmpty() && points.size() > 1) {
                            pls = new PolylineShape();
                            pls.setPoints(points);
                            gc.add(new Graphic((Shape)pls, cb));
                            points = new ArrayList();
                        }
                    } else {
                        double x = x1 + (x2 - x1) * 0.5;
                        if (i == 0) {
                            points.add(new PointD(x1, y1));
                            points.add(new PointD(x, y1));
                            points.add(new PointD(x, y2));
                        } else if ((long)i == xdata.getSize() - 2L) {
                            points.add(new PointD(x, y1));
                            points.add(new PointD(x, y2));
                            points.add(new PointD(x2, y2));
                        } else {
                            points.add(new PointD(x, y1));
                            points.add(new PointD(x, y2));
                        }
                    }
                    ++i;
                }
                if (points.size() <= 1) break;
                pls = new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
                break;
            }
            case "post": {
                PolylineShape pls;
                int i = 0;
                while ((long)i < xdata.getSize() - 1L) {
                    double x1 = xdata.getDouble(i);
                    double x2 = xdata.getDouble(i + 1);
                    double y = ydata.getDouble(i);
                    if (Double.isNaN(y) || Double.isNaN(x1) || Double.isNaN(x2)) {
                        if (!points.isEmpty() && points.size() > 1) {
                            pls = new PolylineShape();
                            pls.setPoints(points);
                            gc.add(new Graphic((Shape)pls, cb));
                            points = new ArrayList();
                        }
                    } else {
                        points.add(new PointD(x1, y));
                        points.add(new PointD(x2, y));
                        if ((long)i == xdata.getSize() - 2L) {
                            points.add(new PointD(x2, ydata.getDouble(i + 1)));
                        }
                    }
                    ++i;
                }
                if (points.size() <= 1) break;
                pls = new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
                break;
            }
            default: {
                PolylineShape pls;
                int i = 0;
                while ((long)i < xdata.getSize() - 1L) {
                    double x1 = xdata.getDouble(i);
                    double x2 = xdata.getDouble(i + 1);
                    double y = ydata.getDouble(i + 1);
                    if (Double.isNaN(y) || Double.isNaN(x1) || Double.isNaN(x2)) {
                        if (!points.isEmpty() && points.size() > 1) {
                            pls = new PolylineShape();
                            pls.setPoints(points);
                            gc.add(new Graphic((Shape)pls, cb));
                            points = new ArrayList();
                        }
                    } else {
                        if (i == 0) {
                            points.add(new PointD(x1, ydata.getDouble(i)));
                        }
                        points.add(new PointD(x1, y));
                        points.add(new PointD(x2, y));
                    }
                    ++i;
                }
                if (points.size() <= 1) break;
                pls = new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
            }
        }
        return gc;
    }

    public static GraphicCollection createGraphics(Array xdata, Array ydata, ColorBreak cb) {
        GraphicCollection graphics = new GraphicCollection();
        if (cb instanceof PolylineBreak) {
            graphics.add((Graphic)GraphicFactory.createLineString(xdata, ydata, cb));
        } else {
            IndexIterator xIter = xdata.getIndexIterator();
            IndexIterator yIter = ydata.getIndexIterator();
            while (xIter.hasNext()) {
                PointShape ps = new PointShape();
                ps.setPoint(new PointD(xIter.getDoubleNext(), yIter.getDoubleNext()));
                graphics.add(new Graphic((Shape)ps, cb));
            }
        }
        return graphics;
    }

    public static Graphic createPoint(float x, float y, PointBreak pb) {
        PointShape ps = new PointShape();
        ps.setPoint(new PointD((double)x, (double)y));
        return new Graphic((Shape)ps, (ColorBreak)pb);
    }

    public static GraphicCollection createPoints(Array xdata, Array ydata, PointBreak pb) {
        GraphicCollection graphics = new GraphicCollection();
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        while (xIter.hasNext()) {
            PointShape ps = new PointShape();
            ps.setPoint(new PointD(xIter.getDoubleNext(), yIter.getDoubleNext()));
            graphics.add(new Graphic((Shape)ps, (ColorBreak)pb));
        }
        return graphics;
    }

    public static GraphicCollection createPoints(Array xdata, Array ydata, List<ColorBreak> cbs) {
        GraphicCollection graphics = new GraphicCollection();
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        if ((long)cbs.size() == xdata.getSize()) {
            int i = 0;
            while (xIter.hasNext()) {
                PointShape ps = new PointShape();
                ps.setPoint(new PointD(xIter.getDoubleNext(), yIter.getDoubleNext()));
                graphics.add(new Graphic((Shape)ps, cbs.get(i)));
                ++i;
            }
            graphics.setSingleLegend(false);
            LegendScheme ls = new LegendScheme();
            ls.setLegendBreaks(cbs);
            ls.setLegendType(LegendType.UNIQUE_VALUE);
            ls.setShapeType(ShapeTypes.POINT);
            graphics.setLegendScheme(ls);
        } else {
            while (xIter.hasNext()) {
                PointShape ps = new PointShape();
                ps.setPoint(new PointD(xIter.getDoubleNext(), yIter.getDoubleNext()));
                graphics.add(new Graphic((Shape)ps, cbs.get(0)));
            }
            LegendScheme ls = new LegendScheme();
            ls.setLegendBreaks(cbs);
            ls.setLegendType(LegendType.SINGLE_SYMBOL);
            ls.setShapeType(ShapeTypes.POINT);
            graphics.setLegendScheme(ls);
        }
        return graphics;
    }

    public static GraphicCollection createPoints(Array xdata, Array ydata, Array zdata, LegendScheme ls) {
        GraphicCollection graphics = new GraphicCollection();
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        if (ls.getLegendType() == LegendType.UNIQUE_VALUE && xdata.getSize() == (long)ls.getBreakNum()) {
            int i = 0;
            while (xIter.hasNext()) {
                PointShape ps = new PointShape();
                ps.setPoint(new PointD(xIter.getDoubleNext(), yIter.getDoubleNext()));
                double z = zIter.getDoubleNext();
                ColorBreak cb = ls.getLegendBreak(i);
                graphics.add(new Graphic((Shape)ps, cb));
                ++i;
            }
        } else {
            while (xIter.hasNext()) {
                PointShape ps = new PointShape();
                ps.setPoint(new PointD(xIter.getDoubleNext(), yIter.getDoubleNext()));
                double z = zIter.getDoubleNext();
                ColorBreak cb = ls.findLegendBreak((Number)z);
                if (cb == null) continue;
                graphics.add(new Graphic((Shape)ps, cb));
            }
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createPoints3D(Array xdata, Array ydata, Array zdata, ColorBreak cb) {
        ArrayList<ColorBreak> cbs = new ArrayList<ColorBreak>();
        cbs.add(cb);
        return GraphicFactory.createPoints3D(xdata, ydata, zdata, cbs);
    }

    public static GraphicCollection createPoints3D(Array xdata, Array ydata, Array zdata, List<ColorBreak> cbs) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        boolean fixZ = false;
        double z = 0.0;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z = zdata.getDouble(0);
        }
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        if ((long)cbs.size() == xdata.getSize()) {
            int i = 0;
            while (xIter.hasNext()) {
                PointZShape ps = new PointZShape();
                if (fixZ) {
                    ps.setPoint((PointD)new PointZ(xIter.getDoubleNext(), yIter.getDoubleNext(), z));
                } else {
                    ps.setPoint((PointD)new PointZ(xIter.getDoubleNext(), yIter.getDoubleNext(), zIter.getDoubleNext()));
                }
                graphics.add(new Graphic((Shape)ps, cbs.get(i)));
                ++i;
            }
            graphics.setSingleLegend(false);
            LegendScheme ls = new LegendScheme();
            ls.setLegendBreaks(cbs);
            ls.setLegendType(LegendType.UNIQUE_VALUE);
            ls.setShapeType(ShapeTypes.POINT);
            graphics.setLegendScheme(ls);
        } else {
            while (xIter.hasNext()) {
                PointZShape ps = new PointZShape();
                if (fixZ) {
                    ps.setPoint((PointD)new PointZ(xIter.getDoubleNext(), yIter.getDoubleNext(), z));
                } else {
                    ps.setPoint((PointD)new PointZ(xIter.getDoubleNext(), yIter.getDoubleNext(), zIter.getDoubleNext()));
                }
                graphics.add(new Graphic((Shape)ps, cbs.get(0)));
                LegendScheme ls = new LegendScheme();
                ls.setLegendBreaks(cbs);
                ls.setLegendType(LegendType.SINGLE_SYMBOL);
                ls.setShapeType(ShapeTypes.POINT);
                graphics.setLegendScheme(ls);
            }
        }
        return graphics;
    }

    public static GraphicCollection createPoints3D(Array xdata, Array ydata, Array zdata, Array cdata, LegendScheme ls) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        boolean fixZ = false;
        double z = 0.0;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z = zdata.getDouble(0);
        }
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        IndexIterator cIter = cdata.getIndexIterator();
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            double c = cIter.getDoubleNext();
            if (!fixZ) {
                z = zIter.getDoubleNext();
            }
            if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z) || Double.isNaN(c)) continue;
            PointZShape ps = new PointZShape();
            ps.setPoint((PointD)new PointZ(x, y, z));
            ColorBreak cb = ls.findLegendBreak((Number)c);
            graphics.add(new Graphic((Shape)ps, cb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createTexts3D(Array xa, Array ya, Array za, Array sa, ChartText3D text) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        IndexIterator xIter = xa.getIndexIterator();
        IndexIterator yIter = ya.getIndexIterator();
        IndexIterator zIter = za.getIndexIterator();
        IndexIterator sIter = sa.getIndexIterator();
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            double z = zIter.getDoubleNext();
            String s = sIter.getStringNext();
            ChartText3D text3D = (ChartText3D)((Object)text.clone());
            text3D.setText(s);
            text3D.setPoint(x, y, z);
            graphics.add(new Graphic((Shape)text3D, null));
        }
        return graphics;
    }

    public static GraphicCollection[] createStems3D(Array xdata, Array ydata, Array zdata, List<ColorBreak> cbs, PolylineBreak plb, double bottom, boolean sameStemColor) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        GraphicCollection3D stemlines = new GraphicCollection3D();
        boolean fixZ = false;
        double z0 = 0.0;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z0 = zdata.getDouble(0);
        }
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        if ((long)cbs.size() == xdata.getSize()) {
            int i = 0;
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                if (Double.isNaN(x) || Double.isNaN(y)) continue;
                PointZShape ps = new PointZShape();
                ArrayList<PointZ> pzs = new ArrayList<PointZ>();
                if (fixZ) {
                    ps.setPoint((PointD)new PointZ(x, y, z0));
                    pzs.add(new PointZ(x, y, bottom));
                    pzs.add(new PointZ(x, y, z0));
                } else {
                    double z = zIter.getDoubleNext();
                    if (Double.isNaN(z)) continue;
                    ps.setPoint((PointD)new PointZ(x, y, z));
                    pzs.add(new PointZ(x, y, bottom));
                    pzs.add(new PointZ(x, y, z));
                }
                graphics.add(new Graphic((Shape)ps, cbs.get(i)));
                PolylineZShape pls = new PolylineZShape();
                pls.setPoints(pzs);
                if (sameStemColor) {
                    PolylineBreak nplb = (PolylineBreak)plb.clone();
                    nplb.setColor(cbs.get(i).getColor());
                    stemlines.add(new Graphic((Shape)pls, (ColorBreak)nplb));
                } else {
                    stemlines.add(new Graphic((Shape)pls, (ColorBreak)plb));
                }
                ++i;
            }
            graphics.setSingleLegend(false);
            LegendScheme ls = new LegendScheme();
            ls.setLegendBreaks(cbs);
            ls.setLegendType(LegendType.UNIQUE_VALUE);
            ls.setShapeType(ShapeTypes.POINT);
            graphics.setLegendScheme(ls);
        } else {
            while (xIter.hasNext()) {
                PointZShape ps = new PointZShape();
                ArrayList<PointZ> pzs = new ArrayList<PointZ>();
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                if (fixZ) {
                    ps.setPoint((PointD)new PointZ(x, y, z0));
                    pzs.add(new PointZ(x, y, bottom));
                    pzs.add(new PointZ(x, y, z0));
                } else {
                    double z = zIter.getDoubleNext();
                    ps.setPoint((PointD)new PointZ(x, y, z));
                    pzs.add(new PointZ(x, y, bottom));
                    pzs.add(new PointZ(x, y, z));
                }
                graphics.add(new Graphic((Shape)ps, cbs.get(0)));
                PolylineZShape pls = new PolylineZShape();
                pls.setPoints(pzs);
                if (sameStemColor) {
                    PolylineBreak nplb = (PolylineBreak)plb.clone();
                    nplb.setColor(cbs.get(0).getColor());
                    stemlines.add(new Graphic((Shape)pls, (ColorBreak)nplb));
                    continue;
                }
                stemlines.add(new Graphic((Shape)pls, (ColorBreak)plb));
            }
            LegendScheme ls = new LegendScheme();
            ls.setLegendBreaks(cbs);
            ls.setLegendType(LegendType.SINGLE_SYMBOL);
            ls.setShapeType(ShapeTypes.POINT);
            graphics.setLegendScheme(ls);
        }
        return new GraphicCollection[]{stemlines, graphics};
    }

    public static GraphicCollection[] createStems3D(Array xdata, Array ydata, Array zdata, Array cdata, LegendScheme ls, PolylineBreak plb, double bottom, boolean sameStemColor) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        GraphicCollection3D stemlines = new GraphicCollection3D();
        boolean fixZ = false;
        double z0 = 0.0;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z0 = zdata.getDouble(0);
        }
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        IndexIterator cIter = cdata.getIndexIterator();
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (Double.isNaN(x) || Double.isNaN(y)) continue;
            PointZShape ps = new PointZShape();
            ArrayList<PointZ> pzs = new ArrayList<PointZ>();
            if (fixZ) {
                ps.setPoint((PointD)new PointZ(x, y, z0));
                pzs.add(new PointZ(x, y, bottom));
                pzs.add(new PointZ(x, y, z0));
            } else {
                double z = zIter.getDoubleNext();
                if (Double.isNaN(z)) continue;
                ps.setPoint((PointD)new PointZ(x, y, z));
                pzs.add(new PointZ(x, y, bottom));
                pzs.add(new PointZ(x, y, z));
            }
            double c = cIter.getDoubleNext();
            ColorBreak cb = ls.findLegendBreak((Number)c);
            graphics.add(new Graphic((Shape)ps, cb));
            PolylineZShape pls = new PolylineZShape();
            pls.setPoints(pzs);
            if (sameStemColor) {
                PolylineBreak nplb = (PolylineBreak)plb.clone();
                nplb.setColor(cb.getColor());
                stemlines.add(new Graphic((Shape)pls, (ColorBreak)nplb));
                continue;
            }
            stemlines.add(new Graphic((Shape)pls, (ColorBreak)plb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return new GraphicCollection[]{stemlines, graphics};
    }

    public static Graphic createPolygon(Array xa, Array ya, PolygonBreak pgb) {
        int n = (int)xa.getSize();
        ArrayList<PointD> points = new ArrayList<PointD>();
        IndexIterator xIter = xa.getIndexIterator();
        IndexIterator yIter = ya.getIndexIterator();
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            PointD p = new PointD(x, y);
            points.add(p);
        }
        if (points.size() > 2) {
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(points);
            Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pgb);
            return graphic;
        }
        return null;
    }

    public static Graphic createPolygon(Array xy, PolygonBreak pgb) {
        int n = xy.getShape()[0];
        ArrayList<PointD> points = new ArrayList<PointD>();
        IndexIterator iter = xy.getIndexIterator();
        while (iter.hasNext()) {
            double x = iter.getDoubleNext();
            double y = iter.getDoubleNext();
            PointD p = new PointD(x, y);
            points.add(p);
        }
        if (points.size() > 2) {
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(points);
            Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pgb);
            return graphic;
        }
        return null;
    }

    public static GraphicCollection createPolygons(Array xa, Array ya, PolygonBreak pgb) {
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)xa.getSize();
        ArrayList<PointD> points = new ArrayList<PointD>();
        if (xa.getRank() == 1) {
            Graphic aGraphic;
            PolygonShape pgs;
            IndexIterator xIter = xa.getIndexIterator();
            IndexIterator yIter = ya.getIndexIterator();
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                if (Double.isNaN(x)) {
                    if (points.size() > 2) {
                        pgs = new PolygonShape();
                        pgs.setPoints(points);
                        aGraphic = new Graphic((Shape)pgs, (ColorBreak)pgb);
                        graphics.add(aGraphic);
                    }
                    points = new ArrayList();
                    continue;
                }
                PointD p = new PointD(x, y);
                points.add(p);
            }
            if (points.size() > 2) {
                pgs = new PolygonShape();
                pgs.setPoints(points);
                aGraphic = new Graphic((Shape)pgs, (ColorBreak)pgb);
                graphics.add(aGraphic);
            }
        } else {
            int[] shape = xa.getShape();
            int nRow = shape[0];
            int nCol = shape[1];
            for (int i = 0; i < nCol; ++i) {
                points = new ArrayList();
                for (int j = 0; j < nRow; ++j) {
                    int idx = j * nCol + i;
                    double x = xa.getDouble(idx);
                    double y = ya.getDouble(idx);
                    points.add(new PointD(x, y));
                }
                PolygonShape pgs = new PolygonShape();
                pgs.setPoints(points);
                graphics.add(new Graphic((Shape)pgs, (ColorBreak)pgb));
            }
        }
        return graphics;
    }

    public static GraphicCollection3D createPolygons3D(Array xa, Array ya, Array za, PolygonBreak pgb) {
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        GraphicCollection3D graphics = new GraphicCollection3D();
        int n = (int)xa.getSize();
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        if (xa.getRank() == 1) {
            IndexIterator xIter = xa.getIndexIterator();
            IndexIterator yIter = ya.getIndexIterator();
            IndexIterator zIter = za.getIndexIterator();
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                double z = zIter.getDoubleNext();
                points.add(new PointZ(x, y, z));
            }
            if (points.size() > 2) {
                PolygonZShape pgs = new PolygonZShape();
                pgs.setPoints(points);
                Graphic aGraphic = new Graphic((Shape)pgs, (ColorBreak)pgb);
                graphics.add(aGraphic);
            }
        } else {
            int[] shape = xa.getShape();
            int nRow = shape[0];
            int nCol = shape[1];
            for (int i = 0; i < nCol; ++i) {
                points = new ArrayList();
                for (int j = 0; j < nRow; ++j) {
                    int idx = j * nCol + i;
                    double x = xa.getDouble(idx);
                    double y = ya.getDouble(idx);
                    double z = za.getDouble(idx);
                    points.add(new PointZ(x, y, z));
                }
                PolygonZShape pgs = new PolygonZShape();
                pgs.setPoints(points);
                graphics.add(new Graphic((Shape)pgs, (ColorBreak)pgb));
            }
        }
        return graphics;
    }

    public static GraphicCollection3D createPolygons3D(Array xa, Array ya, Array za, List<PolygonBreak> pgbs) {
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        GraphicCollection3D graphics = new GraphicCollection3D();
        int n = (int)xa.getSize();
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        if (xa.getRank() == 1) {
            IndexIterator xIter = xa.getIndexIterator();
            IndexIterator yIter = ya.getIndexIterator();
            IndexIterator zIter = za.getIndexIterator();
            int ii = 0;
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                double z = zIter.getDoubleNext();
                points.add(new PointZ(x, y, z));
            }
            if (points.size() > 2) {
                points.add((PointZ)((PointZ)points.get(0)).clone());
                PolygonZShape pgs = new PolygonZShape();
                pgs.setPoints(points);
                Graphic aGraphic = new Graphic((Shape)pgs, (ColorBreak)pgbs.get(ii));
                graphics.add(aGraphic);
                ++ii;
            }
        } else {
            int[] shape = xa.getShape();
            int nRow = shape[0];
            int nCol = shape[1];
            for (int i = 0; i < nCol; ++i) {
                points = new ArrayList();
                for (int j = 0; j < nRow; ++j) {
                    int idx = j * nCol + i;
                    double x = xa.getDouble(idx);
                    double y = ya.getDouble(idx);
                    double z = za.getDouble(idx);
                    points.add(new PointZ(x, y, z));
                }
                points.add((PointZ)((PointZ)points.get(0)).clone());
                PolygonZShape pgs = new PolygonZShape();
                pgs.setPoints(points);
                graphics.add(new Graphic((Shape)pgs, (ColorBreak)pgbs.get(i)));
            }
        }
        return graphics;
    }

    public static GraphicCollection3D createPolygons3D(Array faces, Array vertices, PolygonBreak polygonBreak) {
        faces = faces.copyIfView();
        vertices = vertices.copyIfView();
        GraphicCollection3D graphics = new GraphicCollection3D();
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        if (faces.getRank() == 1) {
            IndexIterator fIter = faces.getIndexIterator();
            Index index = vertices.getIndex();
            while (fIter.hasNext()) {
                int vIdx = fIter.getIntNext() - 1;
                index.set0(vIdx);
                double x = vertices.getDouble(index.set1(0));
                double y = vertices.getDouble(index.set1(1));
                double z = vertices.getDouble(index.set1(2));
                points.add(new PointZ(x, y, z));
            }
            if (points.size() > 2) {
                points.add((PointZ)((PointZ)points.get(0)).clone());
                PolygonZShape pgs = new PolygonZShape();
                pgs.setPoints(points);
                Graphic aGraphic = new Graphic((Shape)pgs, (ColorBreak)polygonBreak);
                graphics.add(aGraphic);
            }
        } else {
            int[] shape = faces.getShape();
            int nRow = shape[0];
            int nCol = shape[1];
            Index fIndex = faces.getIndex();
            Index vIndex = vertices.getIndex();
            for (int i = 0; i < nRow; ++i) {
                fIndex.set0(i);
                points = new ArrayList();
                for (int j = 0; j < nCol; ++j) {
                    fIndex.set1(j);
                    int vIdx = faces.getInt(fIndex) - 1;
                    vIndex.set0(vIdx);
                    double x = vertices.getDouble(vIndex.set1(0));
                    double y = vertices.getDouble(vIndex.set1(1));
                    double z = vertices.getDouble(vIndex.set1(2));
                    points.add(new PointZ(x, y, z));
                }
                points.add((PointZ)((PointZ)points.get(0)).clone());
                PolygonZShape pgs = new PolygonZShape();
                pgs.setPoints(points);
                graphics.add(new Graphic((Shape)pgs, (ColorBreak)polygonBreak));
            }
        }
        return graphics;
    }

    public static GraphicCollection createStationModel(StationModelData stationModelData, LegendScheme ls, boolean isSurface) {
        GraphicCollection graphics = new GraphicCollection();
        for (int i = 0; i < stationModelData.getDataNum(); ++i) {
            StationModel sm = (StationModel)stationModelData.getData().get(i);
            float windDir = (float)sm.getWindDirection();
            float windSpeed = (float)sm.getWindSpeed();
            if (MIMath.doubleEquals((double)windDir, (double)stationModelData.getMissingValue()) || MIMath.doubleEquals((double)windSpeed, (double)stationModelData.getMissingValue())) continue;
            PointD aPoint = new PointD();
            aPoint.X = (float)sm.getLongitude();
            aPoint.Y = (float)sm.getLatitude();
            int weather = (int)sm.getWeather();
            int cCover = (int)sm.getCloudCover();
            int temp = (int)sm.getTemperature();
            int dewPoint = (int)sm.getDewPoint();
            int pressure = (int)sm.getPressure();
            if (isSurface && !MIMath.doubleEquals((double)sm.getPressure(), (double)stationModelData.getMissingValue())) {
                String pStr = String.valueOf((int)(sm.getPressure() * 10.0));
                if (pStr.length() < 3) {
                    pressure = (int)stationModelData.getMissingValue();
                } else {
                    pStr = pStr.substring(pStr.length() - 3);
                    pressure = Integer.parseInt(pStr);
                }
            }
            StationModelShape aSM = Draw.calStationModel((float)windDir, (float)windSpeed, (double)0.0, (float)12.0f, (PointD)aPoint, (int)weather, (int)temp, (int)dewPoint, (int)pressure, (int)cCover);
            graphics.add(new Graphic((Shape)aSM, new ColorBreak()));
        }
        graphics.setLegendScheme(ls);
        graphics.setAvoidCollision(true);
        return graphics;
    }

    public static GraphicCollection createWireframe(Array xa, Array ya, Array za, PolylineBreak pb) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        int[] shape = xa.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        if (!xa.getIndexPrivate().isFastIterator()) {
            xa = xa.copy();
        }
        if (!ya.getIndexPrivate().isFastIterator()) {
            ya = ya.copy();
        }
        if (!za.getIndexPrivate().isFastIterator()) {
            za = za.copy();
        }
        for (int i = 0; i < rowNum - 1; ++i) {
            for (int j = 0; j < colNum - 1; ++j) {
                int idx1 = i * colNum + j;
                int idx2 = i * colNum + j + 1;
                int idx3 = (i + 1) * colNum + j;
                int idx4 = (i + 1) * colNum + j + 1;
                double z1 = za.getDouble(idx1);
                double z2 = za.getDouble(idx2);
                double z3 = za.getDouble(idx3);
                double z4 = za.getDouble(idx4);
                double z = (z1 + z2 + z3 + z4) / 4.0;
                PolylineZShape ps = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                points.add(new PointZ(xa.getDouble(idx1), ya.getDouble(idx1), z1));
                points.add(new PointZ(xa.getDouble(idx3), ya.getDouble(idx3), z3));
                points.add(new PointZ(xa.getDouble(idx4), ya.getDouble(idx4), z4));
                points.add(new PointZ(xa.getDouble(idx2), ya.getDouble(idx2), z2));
                points.add((PointZ)((PointZ)points.get(0)).clone());
                ps.setPoints(points);
                Graphic graphic = new Graphic((Shape)ps, (ColorBreak)pb);
                graphics.add(graphic);
            }
        }
        return graphics;
    }

    public static GraphicCollection createWireframe(Array xa, Array ya, Array za, LegendScheme ls) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        int[] shape = xa.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        if (!xa.getIndexPrivate().isFastIterator()) {
            xa = xa.copy();
        }
        if (!ya.getIndexPrivate().isFastIterator()) {
            ya = ya.copy();
        }
        if (!za.getIndexPrivate().isFastIterator()) {
            za = za.copy();
        }
        for (int i = 0; i < rowNum - 1; ++i) {
            for (int j = 0; j < colNum - 1; ++j) {
                int idx1 = i * colNum + j;
                int idx2 = i * colNum + j + 1;
                int idx3 = (i + 1) * colNum + j;
                int idx4 = (i + 1) * colNum + j + 1;
                double z1 = za.getDouble(idx1);
                double z2 = za.getDouble(idx2);
                double z3 = za.getDouble(idx3);
                double z4 = za.getDouble(idx4);
                PolylineZShape ps = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                points.add(new PointZ(xa.getDouble(idx1), ya.getDouble(idx1), z1));
                points.add(new PointZ(xa.getDouble(idx3), ya.getDouble(idx3), z3));
                ps.setPoints(points);
                double z = (z1 + z3) * 0.5;
                ps.setValue(z);
                PolylineBreak pb = (PolylineBreak)ls.findLegendBreak((Number)z);
                Graphic graphic = new Graphic((Shape)ps, (ColorBreak)pb);
                graphics.add(graphic);
                ps = new PolylineZShape();
                points = new ArrayList();
                points.add(new PointZ(xa.getDouble(idx3), ya.getDouble(idx3), z3));
                points.add(new PointZ(xa.getDouble(idx4), ya.getDouble(idx4), z4));
                ps.setPoints(points);
                z = (z3 + z4) * 0.5;
                ps.setValue(z);
                pb = (PolylineBreak)ls.findLegendBreak((Number)z);
                graphic = new Graphic((Shape)ps, (ColorBreak)pb);
                graphics.add(graphic);
                ps = new PolylineZShape();
                points = new ArrayList();
                points.add(new PointZ(xa.getDouble(idx4), ya.getDouble(idx4), z4));
                points.add(new PointZ(xa.getDouble(idx2), ya.getDouble(idx2), z2));
                ps.setPoints(points);
                z = (z4 + z2) * 0.5;
                ps.setValue(z);
                pb = (PolylineBreak)ls.findLegendBreak((Number)z);
                graphic = new Graphic((Shape)ps, (ColorBreak)pb);
                graphics.add(graphic);
                ps = new PolylineZShape();
                points = new ArrayList();
                points.add(new PointZ(xa.getDouble(idx2), ya.getDouble(idx2), z2));
                points.add(new PointZ(xa.getDouble(idx1), ya.getDouble(idx1), z1));
                ps.setPoints(points);
                z = (z1 + z2) * 0.5;
                ps.setValue(z);
                pb = (PolylineBreak)ls.findLegendBreak((Number)z);
                graphic = new Graphic((Shape)ps, (ColorBreak)pb);
                graphics.add(graphic);
            }
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createMeshPolygons(Array xa, Array ya, Array za, LegendScheme ls) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        int[] shape = xa.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        for (int i = 0; i < rowNum - 1; ++i) {
            for (int j = 0; j < colNum - 1; ++j) {
                int idx1 = i * colNum + j;
                int idx2 = i * colNum + j + 1;
                int idx3 = (i + 1) * colNum + j;
                int idx4 = (i + 1) * colNum + j + 1;
                double z1 = za.getDouble(idx1);
                double z2 = za.getDouble(idx2);
                double z3 = za.getDouble(idx3);
                double z4 = za.getDouble(idx4);
                double z = (z1 + z2 + z3 + z4) / 4.0;
                PolygonZShape ps = new PolygonZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                points.add(new PointZ(xa.getDouble(idx1), ya.getDouble(idx1), z1));
                points.add(new PointZ(xa.getDouble(idx3), ya.getDouble(idx3), z3));
                points.add(new PointZ(xa.getDouble(idx4), ya.getDouble(idx4), z4));
                points.add(new PointZ(xa.getDouble(idx2), ya.getDouble(idx2), z2));
                points.add((PointZ)((PointZ)points.get(0)).clone());
                ps.setPoints(points);
                ps.highValue = ps.lowValue = z;
                PolygonBreak pb = (PolygonBreak)ls.findLegendBreak((Number)z);
                Graphic graphic = new Graphic((Shape)ps, (ColorBreak)pb);
                graphics.add(graphic);
            }
        }
        graphics.setAllQuads(true);
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static Graphic createRectangle(List<Number> pos, List<Number> curvature, PolygonBreak pgb) {
        RectangleShape rect = new RectangleShape(pos.get(0).doubleValue(), pos.get(1).doubleValue(), pos.get(2).doubleValue(), pos.get(3).doubleValue());
        if (curvature != null) {
            rect.setRoundX(curvature.get(0).doubleValue());
            rect.setRoundY(curvature.get(1).doubleValue());
        }
        Graphic graphic = new Graphic((Shape)rect, (ColorBreak)pgb);
        return graphic;
    }

    public static GraphicCollection createBars(Array xdata, Array ydata, boolean autoWidth, Array widths, boolean drawError, Array error, boolean drawBottom, Array bottom, List<BarBreak> bbs) {
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)xdata.getSize();
        BarBreak bb = bbs.get(0);
        PolylineBreak ebreak = new PolylineBreak();
        ebreak.setColor(bb.getErrorColor());
        ebreak.setWidth(bb.getErrorSize());
        float capeSize = bb.getCapSize();
        double width = widths.getDouble(0);
        if (autoWidth && xdata.getSize() > 1L) {
            width = (xdata.getDouble(1) - xdata.getDouble(0)) * width;
        }
        double bot = 0.0;
        if (drawBottom) {
            bot = bottom.getDouble(0);
        }
        double miny = 0.0;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        int i = 0;
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (drawBottom) {
                if (bottom.getSize() > (long)i) {
                    bot = bottom.getDouble(i);
                }
                miny = bot;
                y += miny;
            }
            if (widths.getSize() > 1L && widths.getSize() > (long)i) {
                width = widths.getDouble(i);
            }
            ArrayList<PointD> pList = new ArrayList<PointD>();
            pList.add(new PointD(x, miny));
            pList.add(new PointD(x, y));
            pList.add(new PointD(x + width, y));
            pList.add(new PointD(x + width, miny));
            pList.add(new PointD(x, miny));
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(pList);
            if (bbs.size() > i) {
                bb = bbs.get(i);
            }
            graphics.add(new Graphic((Shape)pgs, (ColorBreak)bb));
            if (drawError) {
                double e = error.getDouble(i);
                pList = new ArrayList();
                pList.add(new PointD(x + width * 0.5, y - e));
                pList.add(new PointD(x + width * 0.5, y + e));
                CapPolylineShape pls = new CapPolylineShape();
                pls.setPoints(pList);
                pls.setCapLen(capeSize);
                graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
            }
            ++i;
        }
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection createHBars(Array ydata, Array xdata, boolean autoHeight, Array heights, boolean drawError, Array error, boolean drawLeft, Array left, List<BarBreak> bbs) {
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)ydata.getSize();
        BarBreak bb = bbs.get(0);
        PolylineBreak ebreak = new PolylineBreak();
        ebreak.setColor(bb.getErrorColor());
        ebreak.setWidth(bb.getErrorSize());
        double height = heights.getDouble(0);
        if (autoHeight && ydata.getSize() > 1L) {
            height = (ydata.getDouble(1) - ydata.getDouble(0)) * height;
        }
        double bot = 0.0;
        if (drawLeft) {
            bot = left.getDouble(0);
        }
        double minx = 0.0;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        int i = 0;
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (drawLeft) {
                if (left.getSize() > (long)i) {
                    bot = left.getDouble(i);
                }
                minx = bot;
                x += minx;
            }
            if (heights.getSize() > 1L && heights.getSize() > (long)i) {
                height = heights.getDouble(i);
            }
            ArrayList<PointD> pList = new ArrayList<PointD>();
            pList.add(new PointD(minx, y));
            pList.add(new PointD(x, y));
            pList.add(new PointD(x, y + height));
            pList.add(new PointD(minx, y + height));
            pList.add(new PointD(minx, y));
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(pList);
            if (bbs.size() > i) {
                bb = bbs.get(i);
            }
            graphics.add(new Graphic((Shape)pgs, (ColorBreak)bb));
            if (drawError) {
                double e = error.getDouble(i);
                pList = new ArrayList();
                pList.add(new PointD(x - e, y + height * 0.5));
                pList.add(new PointD(x + e, y + height * 0.5));
                PolylineShape pls = new PolylineShape();
                pls.setPoints(pList);
                graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
                pList = new ArrayList();
                pList.add(new PointD(x - e, y + height * 0.25));
                pList.add(new PointD(x - e, y + height * 0.75));
                pls = new PolylineShape();
                pls.setPoints(pList);
                graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
                pList = new ArrayList();
                pList.add(new PointD(x + e, y + height * 0.25));
                pList.add(new PointD(x + e, y + height * 0.75));
                pls = new PolylineShape();
                pls.setPoints(pList);
                graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
            }
            ++i;
        }
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection createBars1(Array xdata, Array ydata, boolean autoWidth, Array widths, boolean drawError, Array error, boolean drawBottom, Array bottom, List<BarBreak> bbs) {
        ArrayList<PointD> pList;
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)xdata.getSize();
        BarBreak bb = bbs.get(0);
        PolylineBreak ebreak = new PolylineBreak();
        ebreak.setColor(bb.getErrorColor());
        ebreak.setWidth(bb.getErrorSize());
        double width = widths.getDouble(0);
        if (autoWidth && xdata.getSize() > 1L) {
            width = (xdata.getDouble(1) - xdata.getDouble(0)) * width;
        }
        double bot = 0.0;
        if (drawBottom) {
            bot = bottom.getDouble(0);
        }
        double miny = 0.0;
        boolean baseLine = false;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        int i = 0;
        while (xIter.hasNext()) {
            double x1;
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (drawBottom) {
                if (bottom.getSize() > (long)i) {
                    bot = bottom.getDouble(i);
                }
                miny = bot;
                y += miny;
            }
            if (y < miny) {
                baseLine = true;
            }
            if (widths.getSize() > 1L && widths.getSize() > (long)i) {
                width = widths.getDouble(i);
            }
            pList = new ArrayList();
            pList.add(new PointD(x, miny));
            for (x1 = x; x1 < x + width; x1 += width / 100.0) {
                pList.add(new PointD(x1, y));
            }
            pList.add(new PointD(x + width, y));
            for (x1 = x + width; x1 > x; x1 -= width / 20.0) {
                pList.add(new PointD(x1, miny));
            }
            pList.add(new PointD(x, miny));
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(pList);
            if (bbs.size() > i) {
                bb = bbs.get(i);
            }
            graphics.add(new Graphic((Shape)pgs, (ColorBreak)bb));
            if (drawError) {
                double e = error.getDouble(i);
                pList = new ArrayList();
                pList.add(new PointD(x + width * 0.5, y - e));
                pList.add(new PointD(x + width * 0.5, y + e));
                PolylineShape pls = new PolylineShape();
                pls.setPoints(pList);
                graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
                pList = new ArrayList();
                pList.add(new PointD(x + width * 0.25, y - e));
                pList.add(new PointD(x + width * 0.75, y - e));
                pls = new PolylineShape();
                pls.setPoints(pList);
                graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
                pList = new ArrayList();
                pList.add(new PointD(x + width * 0.25, y + e));
                pList.add(new PointD(x + width * 0.75, y + e));
                pls = new PolylineShape();
                pls.setPoints(pList);
                graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
            }
            ++i;
        }
        if (baseLine) {
            pList = new ArrayList<PointD>();
            double x1 = xdata.getDouble(0);
            double x2 = xdata.getDouble((int)xdata.getSize() - 1);
            x1 -= x2 - x1;
            x2 += x2 - x1;
            pList.add(new PointD(x1, miny));
            pList.add(new PointD(x2, miny));
            PolylineShape pls = new PolylineShape();
            pls.setPoints(pList);
            ebreak = new PolylineBreak();
            ebreak.setColor(Color.black);
            graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
        }
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection3D createBars3D(Array xdata, Array ydata, Array zdata, boolean autoWidth, Array widths, Array bottom, List<BarBreak> bbs) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        int n = (int)xdata.getSize();
        BarBreak bb = bbs.get(0);
        double width = widths.getDouble(0);
        if (autoWidth && xdata.getSize() > 1L) {
            width = (xdata.getDouble(1) - xdata.getDouble(0)) * width;
        }
        double bot = 0.0;
        double minz = 0.0;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        int i = 0;
        double hw = width * 0.5;
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            double z = zIter.getDoubleNext();
            if (Double.isNaN(z)) continue;
            if (widths.getSize() > 1L && widths.getSize() > (long)i) {
                width = widths.getDouble(i);
                hw = width * 0.5;
            }
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            pList.add(new PointZ(x + hw, y + hw, minz));
            pList.add(new PointZ(x + hw, y - hw, minz));
            pList.add(new PointZ(x + hw, y + hw, z));
            pList.add(new PointZ(x + hw, y - hw, z));
            pList.add(new PointZ(x - hw, y + hw, minz));
            pList.add(new PointZ(x - hw, y - hw, minz));
            pList.add(new PointZ(x - hw, y + hw, z));
            pList.add(new PointZ(x - hw, y - hw, z));
            CubicShape cs = new CubicShape();
            cs.setPoints(pList);
            if (bbs.size() > i) {
                bb = bbs.get(i);
            }
            graphics.add(new Graphic((Shape)cs, (ColorBreak)bb));
            ++i;
        }
        LegendScheme ls = new LegendScheme();
        for (BarBreak barBreak : bbs) {
            ls.addLegendBreak((ColorBreak)barBreak);
        }
        graphics.setLegendScheme(ls);
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection3D createBars3D(Array xdata, Array ydata, Array zdata, Array cdata, boolean autoWidth, Array widths, Array bottom, LegendScheme ls) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        int n = (int)xdata.getSize();
        double width = widths.getDouble(0);
        if (autoWidth && xdata.getSize() > 1L) {
            width = (xdata.getDouble(1) - xdata.getDouble(0)) * width;
        }
        double bot = 0.0;
        double minz = 0.0;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        IndexIterator cIter = cdata.getIndexIterator();
        int i = 0;
        double hw = width * 0.5;
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            double z = zIter.getDoubleNext();
            double v = cIter.getDoubleNext();
            if (Double.isNaN(z)) continue;
            if (widths.getSize() > 1L && widths.getSize() > (long)i) {
                width = widths.getDouble(i);
                hw = width * 0.5;
            }
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            pList.add(new PointZ(x + hw, y + hw, minz));
            pList.add(new PointZ(x + hw, y - hw, minz));
            pList.add(new PointZ(x + hw, y + hw, z));
            pList.add(new PointZ(x + hw, y - hw, z));
            pList.add(new PointZ(x - hw, y + hw, minz));
            pList.add(new PointZ(x - hw, y - hw, minz));
            pList.add(new PointZ(x - hw, y + hw, z));
            pList.add(new PointZ(x - hw, y - hw, z));
            CubicShape cs = new CubicShape();
            cs.setPoints(pList);
            BarBreak bb = new BarBreak((PolygonBreak)ls.findLegendBreak((Number)v));
            graphics.add(new Graphic((Shape)cs, (ColorBreak)bb));
            ++i;
        }
        graphics.setLegendScheme(ls);
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection3D createCylinderBars3D(Array xdata, Array ydata, Array zdata, boolean autoWidth, Array widths, Array bottom, List<BarBreak> bbs) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        int n = (int)xdata.getSize();
        BarBreak bb = bbs.get(0);
        double width = widths.getDouble(0);
        if (autoWidth && xdata.getSize() > 1L) {
            width = (xdata.getDouble(1) - xdata.getDouble(0)) * width;
        }
        double bot = 0.0;
        double minz = 0.0;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        int i = 0;
        double hw = width * 0.5;
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            double z = zIter.getDoubleNext();
            if (widths.getSize() > 1L && widths.getSize() > (long)i) {
                width = widths.getDouble(i);
                hw = width * 0.5;
            }
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            pList.add(new PointZ(x, y, minz));
            pList.add(new PointZ(x, y, z));
            CylinderShape cs = new CylinderShape(pList, hw);
            if (bbs.size() > i) {
                bb = bbs.get(i);
            }
            graphics.add(new Graphic((Shape)cs, (ColorBreak)bb));
            ++i;
        }
        LegendScheme ls = new LegendScheme();
        for (BarBreak barBreak : bbs) {
            ls.addLegendBreak((ColorBreak)barBreak);
        }
        graphics.setLegendScheme(ls);
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection3D createCylinderBars3D(Array xdata, Array ydata, Array zdata, Array cdata, boolean autoWidth, Array widths, Array bottom, LegendScheme ls) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        int n = (int)xdata.getSize();
        double width = widths.getDouble(0);
        if (autoWidth && xdata.getSize() > 1L) {
            width = (xdata.getDouble(1) - xdata.getDouble(0)) * width;
        }
        double bot = 0.0;
        double minz = 0.0;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        IndexIterator cIter = cdata.getIndexIterator();
        int i = 0;
        double hw = width * 0.5;
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            double z = zIter.getDoubleNext();
            double v = cIter.getDoubleNext();
            if (widths.getSize() > 1L && widths.getSize() > (long)i) {
                width = widths.getDouble(i);
                hw = width * 0.5;
            }
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            pList.add(new PointZ(x, y, minz));
            pList.add(new PointZ(x, y, z));
            CylinderShape cs = new CylinderShape(pList, hw);
            BarBreak bb = new BarBreak((PolygonBreak)ls.findLegendBreak((Number)v));
            graphics.add(new Graphic((Shape)cs, (ColorBreak)bb));
            ++i;
        }
        graphics.setLegendScheme(ls);
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection createHistBars(Array data, int bins, List<BarBreak> bbs) {
        List r = ArrayUtil.histogram((Array)data, (int)bins);
        Array xdata = (Array)r.get(1);
        Array ydata = (Array)r.get(0);
        return GraphicFactory.createHistBars(data, xdata, ydata, bbs);
    }

    public static GraphicCollection createHistBars(Array data, Array bins, List<BarBreak> bbs) {
        List r = ArrayUtil.histogram((Array)data, (Array)bins);
        Array xdata = (Array)r.get(1);
        Array ydata = (Array)r.get(0);
        return GraphicFactory.createHistBars(data, xdata, ydata, bbs);
    }

    public static GraphicCollection createHistBars(Array data, Array xdata, Array ydata, List<BarBreak> bbs) {
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)ydata.getSize();
        BarBreak bb = bbs.get(0);
        if (!xdata.getIndexPrivate().isFastIterator()) {
            xdata = xdata.copy();
        }
        if (!ydata.getIndexPrivate().isFastIterator()) {
            ydata = ydata.copy();
        }
        for (int i = 0; i < n; ++i) {
            double x = (xdata.getDouble(i + 1) + xdata.getDouble(i)) * 0.5;
            double width = xdata.getDouble(i + 1) - xdata.getDouble(i);
            double y = ydata.getDouble(i);
            BarShape bs = new BarShape();
            bs.setPoint(new PointD(x, y));
            bs.setAutoWidth(false);
            bs.setWidth(width);
            bs.setDrawBottom(false);
            if (bbs.size() > i) {
                bb = bbs.get(i);
            }
            graphics.add(new Graphic((Shape)bs, (ColorBreak)bb));
        }
        if (bbs.size() == 1) {
            graphics.setSingleLegend(true);
        } else {
            graphics.setSingleLegend(false);
        }
        return graphics;
    }

    public static GraphicCollection createStems(Array xdata, Array ydata, PolylineBreak plb, PointBreak pb, PolylineBreak bplb, double bottom) {
        ArrayList<PointD> pList;
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)xdata.getSize();
        double miny = bottom;
        boolean baseLine = false;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (Double.isNaN(x) || Double.isNaN(y)) continue;
            if (y < miny) {
                baseLine = true;
            }
            pList = new ArrayList();
            pList.add(new PointD(x, miny));
            pList.add(new PointD(x, y));
            PolylineShape pls = new PolylineShape();
            pls.setPoints(pList);
            graphics.add(new Graphic((Shape)pls, (ColorBreak)plb));
            PointShape ps = new PointShape();
            ps.setPoint(new PointD(x, y));
            graphics.add(new Graphic((Shape)ps, (ColorBreak)pb));
        }
        if (baseLine) {
            pList = new ArrayList<PointD>();
            Index xIdx = xdata.getIndex();
            xIdx.setCurrentCounter(0);
            double x1 = xdata.getDouble(xIdx);
            xIdx.setCurrentCounter((int)xdata.getSize() - 1);
            double x2 = xdata.getDouble(xIdx);
            pList.add(new PointD(x1, miny));
            pList.add(new PointD(x2, miny));
            PolylineShape pls = new PolylineShape();
            pls.setPoints(pList);
            graphics.add(new Graphic((Shape)pls, (ColorBreak)bplb));
        }
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static Graphic createImage(BufferedImage image) {
        ImageShape ishape = new ImageShape();
        ishape.setPoint(new PointD(0.0, 0.0));
        ishape.setImage(image);
        ishape.setExtent(new Extent(0.0, (double)image.getWidth(), 0.0, (double)image.getHeight()));
        return new Graphic((Shape)ishape, new ColorBreak());
    }

    public static Graphic createImage(Array gdata, List<Number> extent) {
        return GraphicFactory.createImage(gdata, extent, false);
    }

    public static Graphic createImage(Array gdata, List<Number> extent, boolean yReverse) {
        double maxy;
        double miny;
        double maxx;
        double minx;
        int j;
        boolean isAlpha;
        int width = gdata.getShape()[1];
        int height = gdata.getShape()[0];
        Color undefColor = Color.white;
        BufferedImage aImage = new BufferedImage(width, height, 2);
        Index index = gdata.getIndex();
        boolean bl = isAlpha = gdata.getShape()[2] == 4;
        if (gdata.getDataType() == DataType.FLOAT || gdata.getDataType() == DataType.DOUBLE) {
            if (isAlpha) {
                for (int i = 0; i < height; ++i) {
                    for (j = 0; j < width; ++j) {
                        float r = gdata.getFloat(index.set(i, j, 0));
                        float g = gdata.getFloat(index.set(i, j, 1));
                        float b = gdata.getFloat(index.set(i, j, 2));
                        float a = gdata.getFloat(index.set(i, j, 3));
                        Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) || Double.isNaN(a) ? undefColor : new Color(r, g, b, a);
                        if (yReverse) {
                            aImage.setRGB(j, i, color.getRGB());
                            continue;
                        }
                        aImage.setRGB(j, height - i - 1, color.getRGB());
                    }
                }
            } else {
                for (int i = 0; i < height; ++i) {
                    for (int j2 = 0; j2 < width; ++j2) {
                        float r = gdata.getFloat(index.set(i, j2, 0));
                        float g = gdata.getFloat(index.set(i, j2, 1));
                        float b = gdata.getFloat(index.set(i, j2, 2));
                        Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) ? undefColor : new Color(r, g, b);
                        if (yReverse) {
                            aImage.setRGB(j2, i, color.getRGB());
                            continue;
                        }
                        aImage.setRGB(j2, height - i - 1, color.getRGB());
                    }
                }
            }
        } else if (isAlpha) {
            for (int i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    int r = gdata.getInt(index.set(i, j, 0));
                    int g = gdata.getInt(index.set(i, j, 1));
                    int b = gdata.getInt(index.set(i, j, 2));
                    int a = gdata.getInt(index.set(i, j, 3));
                    Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) || Double.isNaN(a) ? undefColor : new Color(r, g, b, a);
                    if (yReverse) {
                        aImage.setRGB(j, i, color.getRGB());
                        continue;
                    }
                    aImage.setRGB(j, height - i - 1, color.getRGB());
                }
            }
        } else {
            for (int i = 0; i < height; ++i) {
                for (int j3 = 0; j3 < width; ++j3) {
                    int r = gdata.getInt(index.set(i, j3, 0));
                    int g = gdata.getInt(index.set(i, j3, 1));
                    int b = gdata.getInt(index.set(i, j3, 2));
                    Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) ? undefColor : new Color(r, g, b);
                    if (yReverse) {
                        aImage.setRGB(j3, i, color.getRGB());
                        continue;
                    }
                    aImage.setRGB(j3, height - i - 1, color.getRGB());
                }
            }
        }
        ImageShape ishape = new ImageShape();
        if (extent == null) {
            minx = 0.0;
            maxx = width;
            miny = 0.0;
            maxy = height;
        } else {
            minx = extent.get(0).doubleValue();
            maxx = extent.get(1).doubleValue();
            miny = extent.get(2).doubleValue();
            maxy = extent.get(3).doubleValue();
        }
        ishape.setPoint(new PointD(minx, miny));
        ishape.setImage(aImage);
        ishape.setExtent(new Extent(minx, maxx, miny, maxy));
        return new Graphic((Shape)ishape, new ColorBreak());
    }

    public static Graphic createImage(List<Array> data, List<Number> extent) {
        return GraphicFactory.createImage(data, extent, false);
    }

    public static Graphic createImage(List<Array> data, List<Number> extent, boolean yReverse) {
        double maxy;
        double miny;
        double maxx;
        double minx;
        int j;
        Index aindex;
        int width = data.get(0).getShape()[1];
        int height = data.get(0).getShape()[0];
        Color undefColor = Color.white;
        BufferedImage aImage = new BufferedImage(width, height, 2);
        boolean isAlpha = data.size() == 4;
        Array rdata = data.get(0);
        Array gdata = data.get(1);
        Array bdata = data.get(2);
        Index rindex = rdata.getIndex();
        Index gindex = gdata.getIndex();
        Index bindex = bdata.getIndex();
        if (rdata.getDataType() == DataType.FLOAT || rdata.getDataType() == DataType.DOUBLE) {
            if (isAlpha) {
                Array adata = data.get(3);
                aindex = adata.getIndex();
                for (int i = 0; i < height; ++i) {
                    for (j = 0; j < width; ++j) {
                        float r = rdata.getFloat(rindex.set(i, j));
                        float g = gdata.getFloat(gindex.set(i, j));
                        float b = bdata.getFloat(bindex.set(i, j));
                        float a = adata.getFloat(aindex.set(i, j));
                        Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) || Double.isNaN(a) ? undefColor : new Color(r, g, b, a);
                        if (yReverse) {
                            aImage.setRGB(j, i, color.getRGB());
                            continue;
                        }
                        aImage.setRGB(j, height - i - 1, color.getRGB());
                    }
                }
            } else {
                for (int i = 0; i < height; ++i) {
                    for (int j2 = 0; j2 < width; ++j2) {
                        float r = rdata.getFloat(rindex.set(i, j2));
                        float g = gdata.getFloat(gindex.set(i, j2));
                        float b = bdata.getFloat(bindex.set(i, j2));
                        Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) ? undefColor : new Color(r, g, b);
                        if (yReverse) {
                            aImage.setRGB(j2, i, color.getRGB());
                            continue;
                        }
                        aImage.setRGB(j2, height - i - 1, color.getRGB());
                    }
                }
            }
        } else if (isAlpha) {
            Array adata = data.get(3);
            aindex = adata.getIndex();
            for (int i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    int r = rdata.getInt(rindex.set(i, j));
                    int g = gdata.getInt(gindex.set(i, j));
                    int b = bdata.getInt(bindex.set(i, j));
                    int a = adata.getInt(aindex.set(i, j));
                    Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) || Double.isNaN(a) ? undefColor : new Color(r, g, b, a);
                    if (yReverse) {
                        aImage.setRGB(j, i, color.getRGB());
                        continue;
                    }
                    aImage.setRGB(j, height - i - 1, color.getRGB());
                }
            }
        } else {
            for (int i = 0; i < height; ++i) {
                for (int j3 = 0; j3 < width; ++j3) {
                    int r = rdata.getInt(rindex.set(i, j3));
                    int g = gdata.getInt(gindex.set(i, j3));
                    int b = bdata.getInt(bindex.set(i, j3));
                    Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) ? undefColor : new Color(r, g, b);
                    if (yReverse) {
                        aImage.setRGB(j3, i, color.getRGB());
                        continue;
                    }
                    aImage.setRGB(j3, height - i - 1, color.getRGB());
                }
            }
        }
        ImageShape ishape = new ImageShape();
        if (extent == null) {
            minx = 0.0;
            maxx = width;
            miny = 0.0;
            maxy = height;
        } else {
            minx = extent.get(0).doubleValue();
            maxx = extent.get(1).doubleValue();
            miny = extent.get(2).doubleValue();
            maxy = extent.get(3).doubleValue();
        }
        ishape.setPoint(new PointD(minx, miny));
        ishape.setImage(aImage);
        ishape.setExtent(new Extent(minx, maxx, miny, maxy));
        return new Graphic((Shape)ishape, new ColorBreak());
    }

    public static GraphicCollection createImage(Array x, Array y, List<Array> data, double offset, String zdir, String interpolation) {
        Graphic gg = GraphicFactory.createImage(data, null);
        if (interpolation != null) {
            ((ImageShape)gg.getShape()).setInterpolation(interpolation);
        }
        ImageShape shape = (ImageShape)gg.getShape();
        Extent extent = new Extent(x.getDouble(0), x.getDouble((int)x.getSize() - 1), y.getDouble(0), y.getDouble((int)y.getSize() - 1));
        Extent3D ex3 = new Extent3D();
        ArrayList<PointZ> coords = new ArrayList<PointZ>();
        switch (zdir.toLowerCase()) {
            case "x": {
                ex3 = new Extent3D(offset, offset, extent.minX, extent.maxX, extent.minY, extent.maxY);
                coords.add(new PointZ(offset, extent.minX, extent.minY));
                coords.add(new PointZ(offset, extent.maxX, extent.minY));
                coords.add(new PointZ(offset, extent.maxX, extent.maxY));
                coords.add(new PointZ(offset, extent.minX, extent.maxY));
                break;
            }
            case "y": {
                ex3 = new Extent3D(extent.minX, extent.maxX, offset, offset, extent.minY, extent.maxY);
                coords.add(new PointZ(extent.minX, offset, extent.minY));
                coords.add(new PointZ(extent.maxX, offset, extent.minY));
                coords.add(new PointZ(extent.maxX, offset, extent.maxY));
                coords.add(new PointZ(extent.minX, offset, extent.maxY));
                break;
            }
            case "z": {
                ex3 = new Extent3D(extent.minX, extent.maxX, extent.minY, extent.maxY, offset, offset);
                coords.add(new PointZ(extent.minX, extent.minY, offset));
                coords.add(new PointZ(extent.maxX, extent.minY, offset));
                coords.add(new PointZ(extent.maxX, extent.maxY, offset));
                coords.add(new PointZ(extent.minX, extent.maxY, offset));
            }
        }
        shape.setExtent((Extent)ex3);
        shape.setCoords(coords);
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZDir(zdir);
        graphics.setZValue(offset);
        graphics.add(gg);
        return graphics;
    }

    public static BufferedImage createImage(Array gdata, LegendScheme ls) {
        gdata = gdata.copyIfView();
        int width = gdata.getShape()[1];
        int height = gdata.getShape()[0];
        int breakNum = ls.getBreakNum();
        double[] breakValue = new double[breakNum];
        Color[] breakColor = new Color[breakNum];
        Color undefColor = Color.white;
        for (int i = 0; i < breakNum; ++i) {
            breakValue[i] = Double.parseDouble(((ColorBreak)ls.getLegendBreaks().get(i)).getEndValue().toString());
            breakColor[i] = ((ColorBreak)ls.getLegendBreaks().get(i)).getColor();
            if (!((ColorBreak)ls.getLegendBreaks().get(i)).isNoData()) continue;
            undefColor = ((ColorBreak)ls.getLegendBreaks().get(i)).getColor();
        }
        Color defaultColor = breakColor[breakNum - 1];
        BufferedImage aImage = new BufferedImage(width, height, 2);
        Index index = gdata.getIndex();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                Color oneColor;
                index.set(i, j);
                double oneValue = gdata.getDouble(index);
                if (Double.isNaN(oneValue)) {
                    oneColor = undefColor;
                } else {
                    int k;
                    oneColor = defaultColor;
                    if (ls.getLegendType() == LegendType.GRADUATED_COLOR) {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (!(oneValue < breakValue[k])) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    } else {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (oneValue != breakValue[k]) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    }
                }
                aImage.setRGB(j, i, oneColor.getRGB());
            }
        }
        return aImage;
    }

    public static Graphic createImage(Array gdata, LegendScheme ls, List<Number> extent) {
        double maxy;
        double miny;
        double maxx;
        double minx;
        int width = gdata.getShape()[1];
        int height = gdata.getShape()[0];
        int breakNum = ls.getBreakNum();
        double[] breakValue = new double[breakNum];
        Color[] breakColor = new Color[breakNum];
        Color undefColor = Color.white;
        for (int i = 0; i < breakNum; ++i) {
            breakValue[i] = Double.parseDouble(((ColorBreak)ls.getLegendBreaks().get(i)).getEndValue().toString());
            breakColor[i] = ((ColorBreak)ls.getLegendBreaks().get(i)).getColor();
            if (!((ColorBreak)ls.getLegendBreaks().get(i)).isNoData()) continue;
            undefColor = ((ColorBreak)ls.getLegendBreaks().get(i)).getColor();
        }
        Color defaultColor = breakColor[breakNum - 1];
        BufferedImage aImage = new BufferedImage(width, height, 2);
        Index index = gdata.getIndex();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                Color oneColor;
                index.set(i, j);
                double oneValue = gdata.getDouble(index);
                if (Double.isNaN(oneValue)) {
                    oneColor = undefColor;
                } else {
                    int k;
                    oneColor = defaultColor;
                    if (ls.getLegendType() == LegendType.GRADUATED_COLOR) {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (!(oneValue < breakValue[k])) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    } else {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (oneValue != breakValue[k]) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    }
                }
                aImage.setRGB(j, height - i - 1, oneColor.getRGB());
            }
        }
        ImageShape ishape = new ImageShape();
        if (extent == null) {
            minx = 0.0;
            maxx = width;
            miny = 0.0;
            maxy = height;
        } else {
            minx = extent.get(0).doubleValue();
            maxx = extent.get(1).doubleValue();
            miny = extent.get(2).doubleValue();
            maxy = extent.get(3).doubleValue();
        }
        ishape.setPoint(new PointD(minx, miny));
        ishape.setImage(aImage);
        ishape.setExtent(new Extent(minx, maxx, miny, maxy));
        return new Graphic((Shape)ishape, new ColorBreak());
    }

    public static Graphic createImage(GridArray gdata, LegendScheme ls) {
        int width = gdata.getXNum();
        int height = gdata.getYNum();
        int breakNum = ls.getBreakNum();
        double[] breakValue = new double[breakNum];
        Color[] breakColor = new Color[breakNum];
        Color undefColor = Color.white;
        for (int i = 0; i < breakNum; ++i) {
            breakValue[i] = Double.parseDouble(((ColorBreak)ls.getLegendBreaks().get(i)).getEndValue().toString());
            breakColor[i] = ((ColorBreak)ls.getLegendBreaks().get(i)).getColor();
            if (!((ColorBreak)ls.getLegendBreaks().get(i)).isNoData()) continue;
            undefColor = ((ColorBreak)ls.getLegendBreaks().get(i)).getColor();
        }
        Color defaultColor = breakColor[breakNum - 1];
        BufferedImage aImage = new BufferedImage(width, height, 2);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                Color oneColor;
                double oneValue = gdata.getDoubleValue(i, j);
                if (Double.isNaN(oneValue) || MIMath.doubleEquals((double)oneValue, (double)gdata.missingValue)) {
                    oneColor = undefColor;
                } else {
                    int k;
                    oneColor = defaultColor;
                    if (ls.getLegendType() == LegendType.GRADUATED_COLOR) {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (!(oneValue < breakValue[k])) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    } else {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (oneValue != breakValue[k]) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    }
                }
                aImage.setRGB(j, height - i - 1, oneColor.getRGB());
            }
        }
        ImageShape ishape = new ImageShape();
        double xdelta = BigDecimalUtil.mul((double)gdata.getXDelt(), (double)0.5);
        double xmin = BigDecimalUtil.sub((double)gdata.xArray[0], (double)xdelta);
        double xmax = BigDecimalUtil.add((double)gdata.getXMax(), (double)xdelta);
        double ydelta = BigDecimalUtil.mul((double)gdata.getYDelt(), (double)0.5);
        double ymin = BigDecimalUtil.sub((double)gdata.yArray[0], (double)ydelta);
        double ymax = BigDecimalUtil.add((double)gdata.getYMax(), (double)ydelta);
        ishape.setPoint(new PointD(xmin, ymin));
        ishape.setImage(aImage);
        ishape.setExtent(new Extent(xmin, xmax, ymin, ymax));
        return new ImageGraphic(ishape, ls);
    }

    public static Graphic createImage(GridArray gdata, LegendScheme ls, List<Number> extent) {
        double ymax;
        double ymin;
        double xmax;
        double xmin;
        int j;
        int width = gdata.getXNum();
        int height = gdata.getYNum();
        BufferedImage aImage = new BufferedImage(width, height, 2);
        if (ls.getColorMap() == null) {
            int breakNum = ls.getValidBreakNum();
            double[] breakValue = new double[breakNum];
            Color[] breakColor = new Color[breakNum];
            Color undefColor = Color.white;
            int idx = 0;
            for (ColorBreak cb : ls.getLegendBreaks()) {
                if (cb.isNoData()) {
                    undefColor = cb.getColor();
                    continue;
                }
                breakValue[idx] = Double.parseDouble(cb.getEndValue().toString());
                breakColor[idx] = cb.getColor();
                ++idx;
            }
            Color defaultColor = breakColor[breakNum - 1];
            for (int i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    Color oneColor;
                    double oneValue = gdata.getDoubleValue(i, j);
                    if (Double.isNaN(oneValue) || MIMath.doubleEquals((double)oneValue, (double)gdata.missingValue)) {
                        oneColor = undefColor;
                    } else {
                        int k;
                        oneColor = defaultColor;
                        if (ls.getLegendType() == LegendType.GRADUATED_COLOR) {
                            for (k = 0; k < breakNum - 1; ++k) {
                                if (!(oneValue < breakValue[k])) continue;
                                oneColor = breakColor[k];
                                break;
                            }
                        } else {
                            for (k = 0; k < breakNum - 1; ++k) {
                                if (oneValue != breakValue[k]) continue;
                                oneColor = breakColor[k];
                                break;
                            }
                        }
                    }
                    aImage.setRGB(j, height - i - 1, oneColor.getRGB());
                }
            }
        } else {
            ColorMap colorMap = ls.getColorMap();
            int n = colorMap.getColorCount();
            Normalize normalize = ls.getNormalize();
            Color fillColor = colorMap.getFillColor();
            for (int i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    Color color;
                    double v = gdata.getDoubleValue(i, j);
                    if (Double.isNaN(v) || MIMath.doubleEquals((double)v, (double)gdata.missingValue)) {
                        color = fillColor;
                    } else {
                        int idx = (int)(normalize.apply((Number)v).floatValue() * (float)n);
                        if (idx < 0) {
                            idx = 0;
                        } else if (idx >= n) {
                            idx = n - 1;
                        }
                        color = colorMap.getColor(idx);
                    }
                    aImage.setRGB(j, height - i - 1, color.getRGB());
                }
            }
        }
        ImageShape ishape = new ImageShape();
        if (extent == null) {
            double xdelta = BigDecimalUtil.mul((double)gdata.getXDelt(), (double)0.5);
            xmin = BigDecimalUtil.sub((double)gdata.xArray[0], (double)xdelta);
            xmax = BigDecimalUtil.add((double)gdata.getXMax(), (double)xdelta);
            double ydelta = BigDecimalUtil.mul((double)gdata.getYDelt(), (double)0.5);
            ymin = BigDecimalUtil.sub((double)gdata.yArray[0], (double)ydelta);
            ymax = BigDecimalUtil.add((double)gdata.getYMax(), (double)ydelta);
        } else {
            xmin = extent.get(0).doubleValue();
            xmax = extent.get(1).doubleValue();
            ymin = extent.get(2).doubleValue();
            ymax = extent.get(3).doubleValue();
        }
        ishape.setPoint(new PointD(xmin, ymin));
        ishape.setImage(aImage);
        ishape.setExtent(new Extent(xmin, xmax, ymin, ymax));
        return new ImageGraphic(ishape, ls);
    }

    public static Graphic createImage(Array data, Array xa, Array ya, LegendScheme ls, List<Number> extent) {
        double ymax;
        double ymin;
        double xmax;
        double xmin;
        int j;
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        if (xa.getDouble(1) - xa.getDouble(0) < 0.0) {
            xa = xa.flip(0);
            data = data.flip(1);
        }
        if (ya.getDouble(1) - ya.getDouble(0) < 0.0) {
            ya = ya.flip(0);
            data = data.flip(0);
        }
        int width = (int)xa.getSize();
        int height = (int)ya.getSize();
        BufferedImage aImage = new BufferedImage(width, height, 2);
        if (ls.getColorMap() == null) {
            int breakNum = ls.getValidBreakNum();
            double[] breakValue = new double[breakNum];
            Color[] breakColor = new Color[breakNum];
            Color undefColor = Color.white;
            int idx = 0;
            for (ColorBreak cb : ls.getLegendBreaks()) {
                if (cb.isNoData()) {
                    undefColor = cb.getColor();
                    continue;
                }
                breakValue[idx] = Double.parseDouble(cb.getEndValue().toString());
                breakColor[idx] = cb.getColor();
                ++idx;
            }
            Color defaultColor = breakColor[breakNum - 1];
            for (int i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    Color oneColor;
                    double oneValue = data.getDouble(i * width + j);
                    if (Double.isNaN(oneValue)) {
                        oneColor = undefColor;
                    } else {
                        int k;
                        oneColor = defaultColor;
                        if (ls.getLegendType() == LegendType.GRADUATED_COLOR) {
                            for (k = 0; k < breakNum - 1; ++k) {
                                if (!(oneValue < breakValue[k])) continue;
                                oneColor = breakColor[k];
                                break;
                            }
                        } else {
                            for (k = 0; k < breakNum - 1; ++k) {
                                if (oneValue != breakValue[k]) continue;
                                oneColor = breakColor[k];
                                break;
                            }
                        }
                    }
                    aImage.setRGB(j, height - i - 1, oneColor.getRGB());
                }
            }
        } else {
            ColorMap colorMap = ls.getColorMap();
            int n = colorMap.getColorCount();
            Normalize normalize = ls.getNormalize();
            Color fillColor = colorMap.getFillColor();
            for (int i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    Color color;
                    double v = data.getDouble(i * width + j);
                    if (Double.isNaN(v)) {
                        color = fillColor;
                    } else {
                        int idx = (int)(normalize.apply((Number)v).floatValue() * (float)n);
                        if (idx < 0) {
                            idx = 0;
                        } else if (idx >= n) {
                            idx = n - 1;
                        }
                        color = colorMap.getColor(idx);
                    }
                    aImage.setRGB(j, height - i - 1, color.getRGB());
                }
            }
        }
        ImageShape ishape = new ImageShape();
        if (extent == null) {
            double xdelta = BigDecimalUtil.mul((double)(xa.getDouble(1) - xa.getDouble(0)), (double)0.5);
            xmin = BigDecimalUtil.sub((double)xa.getDouble(0), (double)xdelta);
            xmax = BigDecimalUtil.add((double)xa.getDouble(width - 1), (double)xdelta);
            double ydelta = BigDecimalUtil.mul((double)(ya.getDouble(1) - ya.getDouble(0)), (double)0.5);
            ymin = BigDecimalUtil.sub((double)ya.getDouble(0), (double)ydelta);
            ymax = BigDecimalUtil.add((double)ya.getDouble(height - 1), (double)ydelta);
        } else {
            xmin = extent.get(0).doubleValue();
            xmax = extent.get(1).doubleValue();
            ymin = extent.get(2).doubleValue();
            ymax = extent.get(3).doubleValue();
        }
        ishape.setPoint(new PointD(xmin, ymin));
        ishape.setImage(aImage);
        ishape.setExtent(new Extent(xmin, xmax, ymin, ymax));
        return new ImageGraphic(ishape, ls);
    }

    public static GraphicCollection createImage(Array data, Array xa, Array ya, Number missingValue, LegendScheme ls, double offset, String zdir, List<Number> sePoint, String interpolation) {
        GridArray gridArray = new GridArray(data, xa, ya, missingValue);
        return GraphicFactory.createImage(gridArray, ls, offset, zdir, sePoint, interpolation);
    }

    public static GraphicCollection createImage(GridArray gdata, LegendScheme ls, double offset, String zdir, List<Number> sePoint, String interpolation) {
        Graphic gg = GraphicFactory.createImage(gdata, ls);
        if (interpolation != null) {
            ((ImageShape)gg.getShape()).setInterpolation(interpolation);
        }
        ImageShape shape = (ImageShape)gg.getShape();
        Extent extent = shape.getExtent();
        Extent3D ex3 = new Extent3D();
        ArrayList<PointZ> coords = new ArrayList<PointZ>();
        switch (zdir.toLowerCase()) {
            case "x": {
                ex3 = new Extent3D(offset, offset, extent.minX, extent.maxX, extent.minY, extent.maxY);
                coords.add(new PointZ(offset, extent.minX, extent.minY));
                coords.add(new PointZ(offset, extent.maxX, extent.minY));
                coords.add(new PointZ(offset, extent.maxX, extent.maxY));
                coords.add(new PointZ(offset, extent.minX, extent.maxY));
                break;
            }
            case "y": {
                ex3 = new Extent3D(extent.minX, extent.maxX, offset, offset, extent.minY, extent.maxY);
                coords.add(new PointZ(extent.minX, offset, extent.minY));
                coords.add(new PointZ(extent.maxX, offset, extent.minY));
                coords.add(new PointZ(extent.maxX, offset, extent.maxY));
                coords.add(new PointZ(extent.minX, offset, extent.maxY));
                break;
            }
            case "xy": {
                ex3 = new Extent3D(sePoint.get(0).doubleValue(), sePoint.get(2).doubleValue(), sePoint.get(1).doubleValue(), sePoint.get(3).doubleValue(), extent.minY, extent.maxY);
                coords.add(new PointZ(sePoint.get(0).doubleValue(), sePoint.get(1).doubleValue(), extent.minY));
                coords.add(new PointZ(sePoint.get(2).doubleValue(), sePoint.get(1).doubleValue(), extent.minY));
                coords.add(new PointZ(sePoint.get(2).doubleValue(), sePoint.get(3).doubleValue(), extent.maxY));
                coords.add(new PointZ(sePoint.get(0).doubleValue(), sePoint.get(3).doubleValue(), extent.maxY));
                break;
            }
            case "z": {
                ex3 = new Extent3D(extent.minX, extent.maxX, extent.minY, extent.maxY, offset, offset);
                coords.add(new PointZ(extent.minX, extent.minY, offset));
                coords.add(new PointZ(extent.maxX, extent.minY, offset));
                coords.add(new PointZ(extent.maxX, extent.maxY, offset));
                coords.add(new PointZ(extent.minX, extent.maxY, offset));
            }
        }
        shape.setExtent((Extent)ex3);
        shape.setCoords(coords);
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZDir(zdir);
        graphics.setZValue(offset);
        graphics.setSEPoint(sePoint);
        graphics.add(gg);
        graphics.setLegendScheme(ls);
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection createTexture(String fileName, BufferedImage image, Extent extent, double offset, double xshift, String interpolation) throws IOException {
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZDir("z");
        graphics.setZValue(offset);
        TextureShape ishape = new TextureShape();
        ishape.setFileName(fileName);
        ishape.setImage(image);
        Extent3D ex3 = new Extent3D(extent.minX + xshift, extent.maxX + xshift, extent.minY, extent.maxY, offset, offset);
        ArrayList<PointZ> coords = new ArrayList<PointZ>();
        coords.add(new PointZ(extent.minX + xshift, extent.minY, offset));
        coords.add(new PointZ(extent.maxX + xshift, extent.minY, offset));
        coords.add(new PointZ(extent.maxX + xshift, extent.maxY, offset));
        coords.add(new PointZ(extent.minX + xshift, extent.maxY, offset));
        ishape.setExtent((Extent)ex3);
        ishape.setCoords(coords);
        Graphic gg = new Graphic((Shape)ishape, new ColorBreak());
        if (interpolation != null) {
            ((ImageShape)gg.getShape()).setInterpolation(interpolation);
        }
        graphics.add(gg);
        return graphics;
    }

    public static GraphicCollection createContourLines(Array xa, Array ya, Array va, LegendScheme ls, boolean isSmooth) {
        double missingValue;
        double[][] data;
        Object[] cbs;
        List ContourLines;
        ls = ls.convertTo(ShapeTypes.POLYLINE);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        int[] shape = va.getShape();
        int[][] S1 = new int[shape[0]][shape[1]];
        double[] x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
        double[] y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
        if (x[1] - x[0] < 0.0) {
            ArrayUtils.reverse((double[])x);
            va = va.flip(1);
        }
        if (y[1] - y[0] < 0.0) {
            ArrayUtils.reverse((double[])y);
            va = va.flip(0);
        }
        if ((ContourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])(data = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)va, (double)(missingValue = -9999.0))), (double[])cValues, (double[])x, (double[])y, (double)missingValue, (int[][])S1))[0]).isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        ColorBreak cbb = ls.findLegendBreak((Number)0);
        GraphicCollection graphics = new GraphicCollection();
        for (int i = 0; i < ContourLines.size(); ++i) {
            int j;
            PolyLine aLine = (PolyLine)ContourLines.get(i);
            double v = aLine.Value;
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<PointD> pList = new ArrayList<PointD>();
            for (j = 0; j < aLine.PointList.size(); ++j) {
                PointD aPoint = new PointD();
                aPoint.X = ((wcontour.global.PointD)aLine.PointList.get((int)j)).X;
                aPoint.Y = ((wcontour.global.PointD)aLine.PointList.get((int)j)).Y;
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(v);
            aPolyline.setExtent(GeometryUtil.getPointsExtent(pList));
            block0 : switch (ls.getLegendType()) {
                case UNIQUE_VALUE: {
                    for (j = 0; j < ls.getBreakNum(); ++j) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(j);
                        if (!MIMath.doubleEquals((double)v, (double)Double.parseDouble(cb.getStartValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
                case GRADUATED_COLOR: {
                    int blNum = 0;
                    for (int j2 = 0; j2 < ls.getBreakNum(); ++j2) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(j2);
                        if (!(MIMath.doubleEquals((double)v, (double)Double.parseDouble(cb.getStartValue().toString())) || v > Double.parseDouble(cb.getStartValue().toString()) && v < Double.parseDouble(cb.getEndValue().toString())) && (++blNum != ls.getBreakNum() || v != Double.parseDouble(cb.getEndValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
            }
            graphics.add(new Graphic((Shape)aPolyline, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourLines(Array xa, Array ya, Array va, double offset, String zdir, LegendScheme ls, boolean isSmooth) {
        double missingValue;
        double[][] data;
        Object[] cbs;
        List ContourLines;
        ls = ls.convertTo(ShapeTypes.POLYLINE);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        int[] shape = va.getShape();
        int[][] S1 = new int[shape[0]][shape[1]];
        double[] x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
        double[] y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
        if (x[1] - x[0] < 0.0) {
            ArrayUtils.reverse((double[])x);
            va = va.flip(1);
        }
        if (y[1] - y[0] < 0.0) {
            ArrayUtils.reverse((double[])y);
            va = va.flip(0);
        }
        if ((ContourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])(data = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)va, (double)(missingValue = -9999.0))), (double[])cValues, (double[])x, (double[])y, (double)missingValue, (int[][])S1))[0]).isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZValue(offset);
        zdir = zdir.toLowerCase();
        graphics.setZDir(zdir);
        for (int i = 0; i < ContourLines.size(); ++i) {
            PolyLine aLine = (PolyLine)ContourLines.get(i);
            double v = aLine.Value;
            PolylineZShape aPolyline = new PolylineZShape();
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.X = offset;
                        aPoint.Y = ((wcontour.global.PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Z = ((wcontour.global.PointD)aLine.PointList.get((int)j)).Y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "y": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.Y = offset;
                        aPoint.X = ((wcontour.global.PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Z = ((wcontour.global.PointD)aLine.PointList.get((int)j)).Y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "z": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.X = ((wcontour.global.PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Y = ((wcontour.global.PointD)aLine.PointList.get((int)j)).Y;
                        aPoint.Z = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(v);
            aPolyline.setExtent(GeometryUtil.getPointsExtent(pList));
            ColorBreak cbb = ls.findLegendBreak((Number)v);
            graphics.add(new Graphic((Shape)aPolyline, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourLines3D(Array xa, Array ya, Array za, LegendScheme ls, boolean isSmooth) {
        double missingValue;
        double[][] data;
        Object[] cbs;
        List ContourLines;
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        ls = ls.convertTo(ShapeTypes.POLYLINE);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        int[] shape = za.getShape();
        int[][] S1 = new int[shape[0]][shape[1]];
        double[] x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
        double[] y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
        if (x[1] - x[0] < 0.0) {
            ArrayUtils.reverse((double[])x);
            za = za.flip(1);
        }
        if (y[1] - y[0] < 0.0) {
            ArrayUtils.reverse((double[])y);
            za = za.flip(0);
        }
        if ((ContourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])(data = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)za, (double)(missingValue = -9999.0))), (double[])cValues, (double[])x, (double[])y, (double)missingValue, (int[][])S1))[0]).isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        GraphicCollection3D graphics = new GraphicCollection3D();
        BivariateFunction interpolator = InterpUtil.getBiInterpFunc((Array)xa, (Array)ya, (Array)za.transpose(0, 1), (String)"linear");
        for (int i = 0; i < ContourLines.size(); ++i) {
            PolyLine aLine = (PolyLine)ContourLines.get(i);
            double v = aLine.Value;
            PolylineZShape aPolyline = new PolylineZShape();
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            for (int j = 0; j < aLine.PointList.size(); ++j) {
                PointZ aPoint = new PointZ();
                aPoint.X = ((wcontour.global.PointD)aLine.PointList.get((int)j)).X;
                aPoint.Y = ((wcontour.global.PointD)aLine.PointList.get((int)j)).Y;
                aPoint.Z = interpolator.value(aPoint.X, aPoint.Y);
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(v);
            ColorBreak cbb = ls.findLegendBreak((Number)v);
            graphics.add(new Graphic((Shape)aPolyline, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourLines(Array xa, Array ya, Array va, double offset, String zdir, LegendScheme ls, boolean isSmooth, List<Number> sePoint) {
        double missingValue;
        double[][] data;
        Object[] cbs;
        List ContourLines;
        ls = ls.convertTo(ShapeTypes.POLYLINE);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        int[] shape = va.getShape();
        int[][] S1 = new int[shape[0]][shape[1]];
        double[] xx = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
        double[] yy = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
        if (xx[1] - xx[0] < 0.0) {
            ArrayUtils.reverse((double[])xx);
            va = va.flip(1);
        }
        if (yy[1] - yy[0] < 0.0) {
            ArrayUtils.reverse((double[])yy);
            va = va.flip(0);
        }
        if ((ContourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])(data = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)va, (double)(missingValue = -9999.0))), (double[])cValues, (double[])xx, (double[])yy, (double)missingValue, (int[][])S1))[0]).isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZValue(offset);
        graphics.setSEPoint(sePoint);
        zdir = zdir.toLowerCase();
        graphics.setZDir(zdir);
        double xs = sePoint.get(0).doubleValue();
        double ys = sePoint.get(1).doubleValue();
        double xe = sePoint.get(2).doubleValue();
        double ye = sePoint.get(3).doubleValue();
        for (int i = 0; i < ContourLines.size(); ++i) {
            PolyLine aLine = (PolyLine)ContourLines.get(i);
            double v = aLine.Value;
            PolylineZShape aPolyline = new PolylineZShape();
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.X = offset;
                        aPoint.Y = ((wcontour.global.PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Z = ((wcontour.global.PointD)aLine.PointList.get((int)j)).Y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "y": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.Y = offset;
                        aPoint.X = ((wcontour.global.PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Z = ((wcontour.global.PointD)aLine.PointList.get((int)j)).Y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "xy": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        double x = ((wcontour.global.PointD)aLine.PointList.get((int)j)).X;
                        double y = ((wcontour.global.PointD)aLine.PointList.get((int)j)).Y;
                        aPoint = new PointZ();
                        aPoint.X = x;
                        aPoint.Y = ys + (ye - ys) * (x - xs) / (xe - xs);
                        aPoint.Z = y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "z": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.X = ((wcontour.global.PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Y = ((wcontour.global.PointD)aLine.PointList.get((int)j)).Y;
                        aPoint.Z = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(v);
            aPolyline.setExtent(GeometryUtil.getPointsExtent(pList));
            ColorBreak cbb = ls.findLegendBreak((Number)v);
            graphics.add(new Graphic((Shape)aPolyline, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourLines(GridData gridData, LegendScheme ls, boolean isSmooth) {
        Object[] cbs;
        List ContourLines;
        ls = ls.convertTo(ShapeTypes.POLYLINE);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        int[][] S1 = new int[gridData.getYNum()][gridData.getXNum()];
        double[] x = gridData.getXArray();
        double[] y = gridData.getYArray();
        if (gridData.getXDelta() < 0.0) {
            ArrayUtils.reverse((double[])x);
            gridData.xReverse();
        }
        if (gridData.getYDelta() < 0.0) {
            ArrayUtils.reverse((double[])y);
            gridData.yReverse();
        }
        if ((ContourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])gridData.getData(), (double[])cValues, (double[])x, (double[])y, (double)gridData.getDoubleMissingValue(), (int[][])S1))[0]).isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        ColorBreak cbb = ls.findLegendBreak((Number)0);
        GraphicCollection graphics = new GraphicCollection();
        for (int i = 0; i < ContourLines.size(); ++i) {
            int j;
            PolyLine aLine = (PolyLine)ContourLines.get(i);
            double v = aLine.Value;
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<PointD> pList = new ArrayList<PointD>();
            for (j = 0; j < aLine.PointList.size(); ++j) {
                PointD aPoint = new PointD();
                aPoint.X = ((wcontour.global.PointD)aLine.PointList.get((int)j)).X;
                aPoint.Y = ((wcontour.global.PointD)aLine.PointList.get((int)j)).Y;
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(v);
            aPolyline.setExtent(GeometryUtil.getPointsExtent(pList));
            block0 : switch (ls.getLegendType()) {
                case UNIQUE_VALUE: {
                    for (j = 0; j < ls.getBreakNum(); ++j) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(j);
                        if (!MIMath.doubleEquals((double)v, (double)Double.parseDouble(cb.getStartValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
                case GRADUATED_COLOR: {
                    int blNum = 0;
                    for (int j2 = 0; j2 < ls.getBreakNum(); ++j2) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(j2);
                        if (!(MIMath.doubleEquals((double)v, (double)Double.parseDouble(cb.getStartValue().toString())) || v > Double.parseDouble(cb.getStartValue().toString()) && v < Double.parseDouble(cb.getEndValue().toString())) && (++blNum != ls.getBreakNum() || v != Double.parseDouble(cb.getEndValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
            }
            graphics.add(new Graphic((Shape)aPolyline, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourLines(GridData gridData, double offset, String zdir, LegendScheme ls, boolean isSmooth) {
        Object[] cbs;
        List ContourLines;
        ls = ls.convertTo(ShapeTypes.POLYLINE);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        int[][] S1 = new int[gridData.getYNum()][gridData.getXNum()];
        double[] x = gridData.getXArray();
        double[] y = gridData.getYArray();
        if (gridData.getXDelta() < 0.0) {
            ArrayUtils.reverse((double[])x);
            gridData.xReverse();
        }
        if (gridData.getYDelta() < 0.0) {
            ArrayUtils.reverse((double[])y);
            gridData.yReverse();
        }
        if ((ContourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])gridData.getData(), (double[])cValues, (double[])x, (double[])y, (double)gridData.getDoubleMissingValue(), (int[][])S1))[0]).isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZValue(offset);
        zdir = zdir.toLowerCase();
        graphics.setZDir(zdir);
        for (int i = 0; i < ContourLines.size(); ++i) {
            PolyLine aLine = (PolyLine)ContourLines.get(i);
            double v = aLine.Value;
            PolylineZShape aPolyline = new PolylineZShape();
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.X = offset;
                        aPoint.Y = ((wcontour.global.PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Z = ((wcontour.global.PointD)aLine.PointList.get((int)j)).Y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "y": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.Y = offset;
                        aPoint.X = ((wcontour.global.PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Z = ((wcontour.global.PointD)aLine.PointList.get((int)j)).Y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "z": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.X = ((wcontour.global.PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Y = ((wcontour.global.PointD)aLine.PointList.get((int)j)).Y;
                        aPoint.Z = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(v);
            aPolyline.setExtent(GeometryUtil.getPointsExtent(pList));
            ColorBreak cbb = ls.findLegendBreak((Number)v);
            graphics.add(new Graphic((Shape)aPolyline, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourLines(GridData gridData, double offset, String zdir, LegendScheme ls, boolean isSmooth, List<Number> sePoint) {
        Object[] cbs;
        List ContourLines;
        ls = ls.convertTo(ShapeTypes.POLYLINE);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        int[][] S1 = new int[gridData.getYNum()][gridData.getXNum()];
        double[] xArray = gridData.getXArray();
        double[] yArray = gridData.getYArray();
        if (gridData.getXDelta() < 0.0) {
            ArrayUtils.reverse((double[])xArray);
            gridData.xReverse();
        }
        if (gridData.getYDelta() < 0.0) {
            ArrayUtils.reverse((double[])yArray);
            gridData.yReverse();
        }
        if ((ContourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])gridData.getData(), (double[])cValues, (double[])xArray, (double[])yArray, (double)gridData.getDoubleMissingValue(), (int[][])S1))[0]).isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZValue(offset);
        graphics.setSEPoint(sePoint);
        zdir = zdir.toLowerCase();
        graphics.setZDir(zdir);
        double xs = sePoint.get(0).doubleValue();
        double ys = sePoint.get(1).doubleValue();
        double xe = sePoint.get(2).doubleValue();
        double ye = sePoint.get(3).doubleValue();
        for (int i = 0; i < ContourLines.size(); ++i) {
            PolyLine aLine = (PolyLine)ContourLines.get(i);
            double v = aLine.Value;
            PolylineZShape aPolyline = new PolylineZShape();
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.X = offset;
                        aPoint.Y = ((wcontour.global.PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Z = ((wcontour.global.PointD)aLine.PointList.get((int)j)).Y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "y": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.Y = offset;
                        aPoint.X = ((wcontour.global.PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Z = ((wcontour.global.PointD)aLine.PointList.get((int)j)).Y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "xy": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        double x = ((wcontour.global.PointD)aLine.PointList.get((int)j)).X;
                        double y = ((wcontour.global.PointD)aLine.PointList.get((int)j)).Y;
                        aPoint = new PointZ();
                        aPoint.X = x;
                        aPoint.Y = ys + (ye - ys) * (x - xs) / (xe - xs);
                        aPoint.Z = y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "z": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.X = ((wcontour.global.PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Y = ((wcontour.global.PointD)aLine.PointList.get((int)j)).Y;
                        aPoint.Z = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(v);
            aPolyline.setExtent(GeometryUtil.getPointsExtent(pList));
            ColorBreak cbb = ls.findLegendBreak((Number)v);
            graphics.add(new Graphic((Shape)aPolyline, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static List<GraphicCollection3D> contourSlice(Array data, Array xa, Array ya, Array za, List<Number> xSlice, List<Number> ySlice, List<Number> zSlice, LegendScheme ls, boolean isSmooth) throws InvalidRangeException {
        ColorBreak cb;
        ArrayList<PointZ> points;
        PolylineZShape shape;
        GraphicCollection3D graphics;
        int[][] S1;
        double[][] grid;
        Object[] cbs;
        List contourLines;
        Array r;
        int s;
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        ArrayList<GraphicCollection3D> sgs = new ArrayList<GraphicCollection3D>();
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        double[] xx = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
        double[] yy = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
        double[] zz = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)za);
        int dim1 = (int)za.getSize();
        int dim2 = (int)ya.getSize();
        for (s = 0; s < xSlice.size(); ++s) {
            double x = xSlice.get(s).doubleValue();
            r = ArrayUtil.slice((Array)data, (int)2, (Array)xa, (double)x);
            if (r == null || (contourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])(grid = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)r)), (double[])cValues, (double[])yy, (double[])zz, (double)Double.NaN, (int[][])(S1 = new int[dim1][dim2])))[0]).isEmpty()) continue;
            if (isSmooth) {
                contourLines = Contour.smoothLines((List)contourLines);
            }
            graphics = new GraphicCollection3D();
            for (PolyLine line : contourLines) {
                shape = new PolylineZShape();
                points = new ArrayList<PointZ>();
                for (wcontour.global.PointD p : line.PointList) {
                    points.add(new PointZ(x, p.X, p.Y));
                }
                shape.setPoints(points);
                shape.setValue(line.Value);
                cb = ls.findLegendBreak((Number)line.Value);
                graphics.add(new Graphic((Shape)shape, cb));
            }
            graphics.setLegendScheme(ls);
            sgs.add(graphics);
        }
        dim1 = (int)za.getSize();
        dim2 = (int)xa.getSize();
        for (s = 0; s < ySlice.size(); ++s) {
            double y = ySlice.get(s).doubleValue();
            r = ArrayUtil.slice((Array)data, (int)1, (Array)ya, (double)y);
            if (r == null || (contourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])(grid = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)r)), (double[])cValues, (double[])xx, (double[])zz, (double)Double.NaN, (int[][])(S1 = new int[dim1][dim2])))[0]).isEmpty()) continue;
            if (isSmooth) {
                contourLines = Contour.smoothLines((List)contourLines);
            }
            graphics = new GraphicCollection3D();
            for (PolyLine line : contourLines) {
                shape = new PolylineZShape();
                points = new ArrayList();
                for (wcontour.global.PointD p : line.PointList) {
                    points.add(new PointZ(p.X, y, p.Y));
                }
                shape.setPoints(points);
                shape.setValue(line.Value);
                cb = ls.findLegendBreak((Number)line.Value);
                graphics.add(new Graphic((Shape)shape, cb));
            }
            graphics.setLegendScheme(ls);
            sgs.add(graphics);
        }
        dim1 = (int)ya.getSize();
        dim2 = (int)xa.getSize();
        for (s = 0; s < zSlice.size(); ++s) {
            double z = zSlice.get(s).doubleValue();
            r = ArrayUtil.slice((Array)data, (int)0, (Array)za, (double)z);
            if (r == null || (contourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])(grid = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)r)), (double[])cValues, (double[])xx, (double[])yy, (double)Double.NaN, (int[][])(S1 = new int[dim1][dim2])))[0]).isEmpty()) continue;
            if (isSmooth) {
                contourLines = Contour.smoothLines((List)contourLines);
            }
            graphics = new GraphicCollection3D();
            for (PolyLine line : contourLines) {
                shape = new PolylineZShape();
                points = new ArrayList();
                for (wcontour.global.PointD p : line.PointList) {
                    points.add(new PointZ(p.X, p.Y, z));
                }
                shape.setPoints(points);
                shape.setValue(line.Value);
                cb = ls.findLegendBreak((Number)line.Value);
                graphics.add(new Graphic((Shape)shape, cb));
            }
            graphics.setLegendScheme(ls);
            sgs.add(graphics);
        }
        return sgs;
    }

    public static GraphicCollection3D contourSlice(Array data, Array xa, Array ya, Array za, Array xSlice, Array ySlice, Array zSlice, LegendScheme ls, boolean isSmooth) throws InvalidRangeException {
        int[][] S1;
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        xSlice = xSlice.copyIfView();
        ySlice = ySlice.copyIfView();
        zSlice = zSlice.copyIfView();
        RectNearestInterpolator3D interpolator3D = new RectNearestInterpolator3D(xa, ya, za, data);
        Array r = interpolator3D.interpolate(xSlice, ySlice, zSlice);
        int[] shape = r.getShape();
        int dim1 = shape[0];
        int dim2 = shape[1];
        int[] origin = new int[2];
        Array xa1d = xSlice.section(origin, new int[]{1, dim2}).copy();
        Array ya1d = ySlice.section(origin, new int[]{dim1, 1}).copy();
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        double[] xx = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa1d);
        double[] yy = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya1d);
        double[][] grid = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)r);
        Object[] cbs = ContourDraw.tracingContourLines((double[][])grid, (double[])cValues, (double[])xx, (double[])yy, (double)Double.NaN, (int[][])(S1 = new int[dim1][dim2]));
        List contourLines = (List)cbs[0];
        if (contourLines.isEmpty()) {
            return null;
        }
        if (isSmooth) {
            contourLines = Contour.smoothLines((List)contourLines);
        }
        BivariateFunction interpolator = InterpUtil.getBiInterpFunc((Array)xa1d, (Array)ya1d, (Array)zSlice.transpose(0, 1), (String)"linear");
        GraphicCollection3D graphics = new GraphicCollection3D();
        for (PolyLine line : contourLines) {
            PolylineZShape pls = new PolylineZShape();
            ArrayList<PointZ> points = new ArrayList<PointZ>();
            for (wcontour.global.PointD p : line.PointList) {
                points.add(new PointZ(p.X, p.Y, interpolator.value(p.X, p.Y)));
            }
            pls.setPoints(points);
            pls.setValue(line.Value);
            ColorBreak cb = ls.findLegendBreak((Number)line.Value);
            graphics.add(new Graphic((Shape)pls, cb));
        }
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection3D contourSlice(Array data, Array xa, Array ya, Array za, List<Number> xySlice, InterpolationMethod method, LegendScheme ls, boolean isSmooth) throws InvalidRangeException {
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        double[] zz = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)za);
        double missingValue = -9999.0;
        Array[] rxy = InterpUtil.sliceXY((Array)xa, (Array)ya, (Array)za, (Array)data, xySlice, (InterpolationMethod)method);
        Array r = rxy[0];
        if (r != null) {
            int[][] S1;
            Array xs = rxy[1];
            double[] xx = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xs);
            int[] rShape = r.getShape();
            int dim1 = rShape[0];
            int dim2 = rShape[1];
            double x1 = xySlice.get(0).doubleValue();
            double y1 = xySlice.get(1).doubleValue();
            double x2 = xySlice.get(2).doubleValue();
            double y2 = xySlice.get(3).doubleValue();
            double minData = ArrayMath.getMinimum((Array)r);
            double maxData = ArrayMath.getMaximum((Array)r);
            double[][] grid = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)r, (double)missingValue);
            Object[] cbs = ContourDraw.tracingContourLines((double[][])grid, (double[])cValues, (double[])xx, (double[])zz, (double)missingValue, (int[][])(S1 = new int[dim1][dim2]));
            List contourLines = (List)cbs[0];
            if (!contourLines.isEmpty()) {
                if (isSmooth) {
                    contourLines = Contour.smoothLines((List)contourLines);
                }
                GraphicCollection3D graphics = new GraphicCollection3D();
                for (PolyLine line : contourLines) {
                    PolylineZShape shape = new PolylineZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    for (wcontour.global.PointD p : line.PointList) {
                        double x = p.X;
                        double y = p.Y;
                        PointZ pz = new PointZ();
                        pz.X = x;
                        pz.Y = y1 + (y2 - y1) * (x - x1) / (x2 - x1);
                        pz.Z = y;
                        points.add(pz);
                    }
                    shape.setPoints(points);
                    shape.setValue(line.Value);
                    ColorBreak cb = ls.findLegendBreak((Number)line.Value);
                    graphics.add(new Graphic((Shape)shape, cb));
                }
                graphics.setLegendScheme(ls);
                return graphics;
            }
        }
        return null;
    }

    public static List<GraphicCollection3D> contourfSlice(Array data, Array xa, Array ya, Array za, List<Number> xSlice, List<Number> ySlice, List<Number> zSlice, LegendScheme ls, boolean isSmooth) throws InvalidRangeException {
        ColorBreak cb;
        int valueIdx;
        ArrayList<PointZ> points;
        PolygonZShape shape;
        GraphicCollection3D graphics;
        List contourPolygons;
        List borders;
        List contourLines;
        Object[] cbs;
        int[][] S1;
        double[][] grid;
        double maxData;
        double minData;
        Array r;
        int s;
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        ArrayList<GraphicCollection3D> sgs = new ArrayList<GraphicCollection3D>();
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        double[] xx = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
        double[] yy = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
        double[] zz = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)za);
        double missingValue = -9999.0;
        int dim1 = (int)za.getSize();
        int dim2 = (int)ya.getSize();
        for (s = 0; s < xSlice.size(); ++s) {
            double x = xSlice.get(s).doubleValue();
            r = ArrayUtil.slice((Array)data, (int)2, (Array)xa, (double)x);
            if (r == null) continue;
            minData = ArrayMath.getMinimum((Array)r);
            maxData = ArrayMath.getMaximum((Array)r);
            grid = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)r, (double)missingValue);
            cbs = ContourDraw.tracingContourLines((double[][])grid, (double[])cValues, (double[])yy, (double[])zz, (double)missingValue, (int[][])(S1 = new int[dim1][dim2]));
            contourLines = (List)cbs[0];
            if (contourLines.isEmpty()) continue;
            borders = (List)cbs[1];
            if (isSmooth) {
                contourLines = Contour.smoothLines((List)contourLines);
            }
            contourPolygons = ContourDraw.tracingPolygons((double[][])grid, (List)contourLines, (List)borders, (double[])cValues);
            graphics = new GraphicCollection3D();
            for (Polygon polygon : contourPolygons) {
                shape = new PolygonZShape();
                points = new ArrayList<PointZ>();
                for (wcontour.global.PointD p : polygon.OutLine.PointList) {
                    points.add(new PointZ(x, p.X, p.Y));
                }
                if (!GeoComputation.isClockwise(points)) {
                    Collections.reverse(points);
                }
                shape.setPoints(points);
                shape.lowValue = polygon.LowValue;
                shape.highValue = polygon.HighValue;
                if (polygon.HasHoles()) {
                    for (PolyLine holeLine : polygon.HoleLines) {
                        points = new ArrayList();
                        for (wcontour.global.PointD p : holeLine.PointList) {
                            points.add(new PointZ(x, p.X, p.Y));
                        }
                        shape.addHole(points, 0);
                    }
                }
                if ((valueIdx = Arrays.binarySearch(cValues, polygon.LowValue)) < 0) {
                    valueIdx = -valueIdx;
                }
                shape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
                if (!polygon.IsHighCenter && polygon.HighValue == polygon.LowValue) {
                    shape.highValue = polygon.LowValue;
                    shape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
                }
                cb = ls.findLegendBreak((Number)shape.lowValue);
                graphics.add(new Graphic((Shape)shape, cb));
            }
            graphics.setLegendScheme(ls);
            sgs.add(graphics);
        }
        dim1 = (int)za.getSize();
        dim2 = (int)xa.getSize();
        for (s = 0; s < ySlice.size(); ++s) {
            double y = ySlice.get(s).doubleValue();
            r = ArrayUtil.slice((Array)data, (int)1, (Array)ya, (double)y);
            if (r == null) continue;
            minData = ArrayMath.getMinimum((Array)r);
            maxData = ArrayMath.getMaximum((Array)r);
            grid = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)r, (double)missingValue);
            cbs = ContourDraw.tracingContourLines((double[][])grid, (double[])cValues, (double[])xx, (double[])zz, (double)missingValue, (int[][])(S1 = new int[dim1][dim2]));
            contourLines = (List)cbs[0];
            if (contourLines.isEmpty()) continue;
            borders = (List)cbs[1];
            if (isSmooth) {
                contourLines = Contour.smoothLines((List)contourLines);
            }
            contourPolygons = ContourDraw.tracingPolygons((double[][])grid, (List)contourLines, (List)borders, (double[])cValues);
            graphics = new GraphicCollection3D();
            for (Polygon polygon : contourPolygons) {
                shape = new PolygonZShape();
                points = new ArrayList();
                for (wcontour.global.PointD p : polygon.OutLine.PointList) {
                    points.add(new PointZ(p.X, y, p.Y));
                }
                if (!GeoComputation.isClockwise(points)) {
                    Collections.reverse(points);
                }
                shape.setPoints(points);
                shape.lowValue = polygon.LowValue;
                shape.highValue = polygon.HighValue;
                if (polygon.HasHoles()) {
                    for (PolyLine holeLine : polygon.HoleLines) {
                        points = new ArrayList();
                        for (wcontour.global.PointD p : holeLine.PointList) {
                            points.add(new PointZ(p.X, y, p.Y));
                        }
                        shape.addHole(points, 0);
                    }
                }
                if ((valueIdx = Arrays.binarySearch(cValues, polygon.LowValue)) < 0) {
                    valueIdx = -valueIdx;
                }
                shape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
                if (!polygon.IsHighCenter && polygon.HighValue == polygon.LowValue) {
                    shape.highValue = polygon.LowValue;
                    shape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
                }
                cb = ls.findLegendBreak((Number)shape.lowValue);
                graphics.add(new Graphic((Shape)shape, cb));
            }
            graphics.setLegendScheme(ls);
            sgs.add(graphics);
        }
        dim1 = (int)ya.getSize();
        dim2 = (int)xa.getSize();
        for (s = 0; s < zSlice.size(); ++s) {
            double z = zSlice.get(s).doubleValue();
            r = ArrayUtil.slice((Array)data, (int)0, (Array)za, (double)z);
            if (r == null) continue;
            minData = ArrayMath.getMinimum((Array)r);
            maxData = ArrayMath.getMaximum((Array)r);
            grid = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)r, (double)missingValue);
            cbs = ContourDraw.tracingContourLines((double[][])grid, (double[])cValues, (double[])xx, (double[])yy, (double)missingValue, (int[][])(S1 = new int[dim1][dim2]));
            contourLines = (List)cbs[0];
            if (contourLines.isEmpty()) continue;
            borders = (List)cbs[1];
            if (isSmooth) {
                contourLines = Contour.smoothLines((List)contourLines);
            }
            contourPolygons = ContourDraw.tracingPolygons((double[][])grid, (List)contourLines, (List)borders, (double[])cValues);
            graphics = new GraphicCollection3D();
            for (Polygon polygon : contourPolygons) {
                shape = new PolygonZShape();
                points = new ArrayList();
                for (wcontour.global.PointD p : polygon.OutLine.PointList) {
                    points.add(new PointZ(p.X, p.Y, z));
                }
                if (!GeoComputation.isClockwise(points)) {
                    Collections.reverse(points);
                }
                shape.setPoints(points);
                shape.lowValue = polygon.LowValue;
                shape.highValue = polygon.HighValue;
                if (polygon.HasHoles()) {
                    for (PolyLine holeLine : polygon.HoleLines) {
                        points = new ArrayList();
                        for (wcontour.global.PointD p : holeLine.PointList) {
                            points.add(new PointZ(p.X, p.Y, z));
                        }
                        shape.addHole(points, 0);
                    }
                }
                if ((valueIdx = Arrays.binarySearch(cValues, polygon.LowValue)) < 0) {
                    valueIdx = -valueIdx;
                }
                shape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
                if (!polygon.IsHighCenter && polygon.HighValue == polygon.LowValue) {
                    shape.highValue = polygon.LowValue;
                    shape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
                }
                cb = ls.findLegendBreak((Number)shape.lowValue);
                graphics.add(new Graphic((Shape)shape, cb));
            }
            graphics.setLegendScheme(ls);
            sgs.add(graphics);
        }
        return sgs;
    }

    public static GraphicCollection3D contourfSlice(Array data, Array xa, Array ya, Array za, List<Number> xySlice, InterpolationMethod method, LegendScheme ls, boolean isSmooth) throws InvalidRangeException {
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        double[] zz = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)za);
        double missingValue = -9999.0;
        Array[] rxy = InterpUtil.sliceXY((Array)xa, (Array)ya, (Array)za, (Array)data, xySlice, (InterpolationMethod)method);
        Array r = rxy[0];
        if (r != null) {
            int[][] S1;
            Array xs = rxy[1];
            double[] xx = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xs);
            int[] rShape = r.getShape();
            int dim1 = rShape[0];
            int dim2 = rShape[1];
            double x1 = xySlice.get(0).doubleValue();
            double y1 = xySlice.get(1).doubleValue();
            double x2 = xySlice.get(2).doubleValue();
            double y2 = xySlice.get(3).doubleValue();
            double minData = ArrayMath.getMinimum((Array)r);
            double maxData = ArrayMath.getMaximum((Array)r);
            double[][] grid = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)r, (double)missingValue);
            Object[] cbs = ContourDraw.tracingContourLines((double[][])grid, (double[])cValues, (double[])xx, (double[])zz, (double)missingValue, (int[][])(S1 = new int[dim1][dim2]));
            List contourLines = (List)cbs[0];
            if (!contourLines.isEmpty()) {
                List borders = (List)cbs[1];
                if (isSmooth) {
                    contourLines = Contour.smoothLines((List)contourLines);
                }
                List contourPolygons = ContourDraw.tracingPolygons((double[][])grid, (List)contourLines, (List)borders, (double[])cValues);
                GraphicCollection3D graphics = new GraphicCollection3D();
                for (Polygon polygon : contourPolygons) {
                    int valueIdx;
                    PointZ pz;
                    double y;
                    double x;
                    PolygonZShape shape = new PolygonZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    for (wcontour.global.PointD p : polygon.OutLine.PointList) {
                        x = p.X;
                        y = p.Y;
                        pz = new PointZ();
                        pz.X = x;
                        pz.Y = y1 + (y2 - y1) * (x - x1) / (x2 - x1);
                        pz.Z = y;
                        points.add(pz);
                    }
                    if (!GeoComputation.isClockwise(points)) {
                        Collections.reverse(points);
                    }
                    shape.setPoints(points);
                    shape.lowValue = polygon.LowValue;
                    shape.highValue = polygon.HighValue;
                    if (polygon.HasHoles()) {
                        for (PolyLine holeLine : polygon.HoleLines) {
                            points = new ArrayList();
                            for (wcontour.global.PointD p : holeLine.PointList) {
                                x = p.X;
                                y = p.Y;
                                pz = new PointZ();
                                pz.X = x;
                                pz.Y = y1 + (y2 - y1) * (x - x1) / (x2 - x1);
                                pz.Z = y;
                                points.add(pz);
                            }
                            shape.addHole(points, 0);
                        }
                    }
                    if ((valueIdx = Arrays.binarySearch(cValues, polygon.LowValue)) < 0) {
                        valueIdx = -valueIdx;
                    }
                    shape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
                    if (!polygon.IsHighCenter && polygon.HighValue == polygon.LowValue) {
                        shape.highValue = polygon.LowValue;
                        shape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
                    }
                    ColorBreak cb = ls.findLegendBreak((Number)shape.lowValue);
                    graphics.add(new Graphic((Shape)shape, cb));
                }
                graphics.setLegendScheme(ls);
                return graphics;
            }
        }
        return null;
    }

    public static GraphicCollection createContourPolygons(GridData gridData, LegendScheme ls, boolean isSmooth) {
        ls = ls.convertTo(ShapeTypes.POLYGON);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        double[] maxmin = new double[2];
        gridData.getMaxMinValue(maxmin);
        double maxData = maxmin[0];
        double minData = maxmin[1];
        int[][] S1 = new int[gridData.getYNum()][gridData.getXNum()];
        double[] xArray = gridData.getXArray();
        double[] yArray = gridData.getYArray();
        if (gridData.getXDelta() < 0.0) {
            ArrayUtils.reverse((double[])xArray);
            gridData.xReverse();
        }
        if (gridData.getYDelta() < 0.0) {
            ArrayUtils.reverse((double[])yArray);
            gridData.yReverse();
        }
        Object[] cbs = ContourDraw.tracingContourLines((double[][])gridData.getData(), (double[])cValues, (double[])xArray, (double[])yArray, (double)gridData.getDoubleMissingValue(), (int[][])S1);
        List contourLines = (List)cbs[0];
        List borders = (List)cbs[1];
        if (isSmooth) {
            contourLines = Contour.smoothLines((List)contourLines);
        }
        List contourPolygons = ContourDraw.tracingPolygons((double[][])gridData.getData(), (List)contourLines, (List)borders, (double[])cValues);
        ColorBreak cbb = ls.findLegendBreak((Number)0);
        GraphicCollection graphics = new GraphicCollection();
        for (int i = 0; i < contourPolygons.size(); ++i) {
            int valueIdx;
            PointD aPoint;
            Polygon poly = (Polygon)contourPolygons.get(i);
            double v = poly.LowValue;
            ArrayList<PointD> pList = new ArrayList<PointD>();
            for (Object pointList : poly.OutLine.PointList) {
                aPoint = new PointD();
                aPoint.X = ((wcontour.global.PointD)pointList).X;
                aPoint.Y = ((wcontour.global.PointD)pointList).Y;
                pList.add(aPoint);
            }
            if (!GeoComputation.isClockwise(pList)) {
                Collections.reverse(pList);
            }
            PolygonShape aPolygonShape = new PolygonShape();
            aPolygonShape.setPoints(pList);
            aPolygonShape.setExtent(GeometryUtil.getPointsExtent(pList));
            aPolygonShape.lowValue = v;
            if (poly.HasHoles()) {
                for (PolyLine holeLine : poly.HoleLines) {
                    pList = new ArrayList();
                    for (wcontour.global.PointD pointList : holeLine.PointList) {
                        aPoint = new PointD();
                        aPoint.X = pointList.X;
                        aPoint.Y = pointList.Y;
                        pList.add(aPoint);
                    }
                    aPolygonShape.addHole(pList, 0);
                }
            }
            if ((valueIdx = Arrays.binarySearch(cValues, v)) < 0) {
                valueIdx = -valueIdx;
            }
            aPolygonShape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
            if (!poly.IsHighCenter && poly.HighValue == poly.LowValue) {
                aPolygonShape.highValue = v;
                aPolygonShape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
            }
            v = aPolygonShape.lowValue;
            block0 : switch (ls.getLegendType()) {
                case UNIQUE_VALUE: {
                    for (int j = 0; j < ls.getBreakNum(); ++j) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(j);
                        if (!MIMath.doubleEquals((double)v, (double)Double.parseDouble(cb.getStartValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
                case GRADUATED_COLOR: {
                    int blNum = 0;
                    for (int j = 0; j < ls.getBreakNum(); ++j) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(j);
                        if (!(MIMath.doubleEquals((double)v, (double)Double.parseDouble(cb.getStartValue().toString())) || v > Double.parseDouble(cb.getStartValue().toString()) && v < Double.parseDouble(cb.getEndValue().toString())) && (++blNum != ls.getBreakNum() || v != Double.parseDouble(cb.getEndValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
            }
            graphics.add(new Graphic((Shape)aPolygonShape, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourPolygons_bak(Array xa, Array ya, Array va, LegendScheme ls, boolean isSmooth) {
        ls = ls.convertTo(ShapeTypes.POLYGON);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        double minData = ArrayMath.min((Array)va).doubleValue();
        double maxData = ArrayMath.max((Array)va).doubleValue();
        int[] shape = va.getShape();
        int[][] S1 = new int[shape[0]][shape[1]];
        double[] x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
        double[] y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
        if (x[1] - x[0] < 0.0) {
            ArrayUtils.reverse((double[])x);
            va = va.flip(1);
        }
        if (y[1] - y[0] < 0.0) {
            ArrayUtils.reverse((double[])y);
            va = va.flip(0);
        }
        double missingValue = -9999.0;
        double[][] data = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)va, (double)missingValue);
        Object[] cbs = ContourDraw.tracingContourLines((double[][])data, (double[])cValues, (double[])x, (double[])y, (double)missingValue, (int[][])S1);
        List contourLines = (List)cbs[0];
        List borders = (List)cbs[1];
        if (isSmooth) {
            contourLines = Contour.smoothLines((List)contourLines);
        }
        List contourPolygons = ContourDraw.tracingPolygons((double[][])data, (List)contourLines, (List)borders, (double[])cValues);
        ColorBreak cbb = ls.findLegendBreak((Number)0);
        GraphicCollection graphics = new GraphicCollection();
        for (int i = 0; i < contourPolygons.size(); ++i) {
            int valueIdx;
            PointD aPoint;
            Polygon poly = (Polygon)contourPolygons.get(i);
            double v = poly.LowValue;
            ArrayList<PointD> pList = new ArrayList<PointD>();
            for (Object pointList : poly.OutLine.PointList) {
                aPoint = new PointD();
                aPoint.X = ((wcontour.global.PointD)pointList).X;
                aPoint.Y = ((wcontour.global.PointD)pointList).Y;
                pList.add(aPoint);
            }
            if (!GeoComputation.isClockwise(pList)) {
                Collections.reverse(pList);
            }
            PolygonShape aPolygonShape = new PolygonShape();
            aPolygonShape.setPoints(pList);
            aPolygonShape.setExtent(GeometryUtil.getPointsExtent(pList));
            aPolygonShape.lowValue = v;
            if (poly.HasHoles()) {
                for (PolyLine holeLine : poly.HoleLines) {
                    pList = new ArrayList();
                    for (wcontour.global.PointD pointList : holeLine.PointList) {
                        aPoint = new PointD();
                        aPoint.X = pointList.X;
                        aPoint.Y = pointList.Y;
                        pList.add(aPoint);
                    }
                    aPolygonShape.addHole(pList, 0);
                }
            }
            if ((valueIdx = Arrays.binarySearch(cValues, v)) < 0) {
                valueIdx = -valueIdx;
            }
            aPolygonShape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
            if (!poly.IsHighCenter && poly.HighValue == poly.LowValue) {
                aPolygonShape.highValue = v;
                aPolygonShape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
            }
            v = aPolygonShape.lowValue;
            block0 : switch (ls.getLegendType()) {
                case UNIQUE_VALUE: {
                    for (int j = 0; j < ls.getBreakNum(); ++j) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(j);
                        if (!MIMath.doubleEquals((double)v, (double)Double.parseDouble(cb.getStartValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
                case GRADUATED_COLOR: {
                    int blNum = 0;
                    for (int j = 0; j < ls.getBreakNum(); ++j) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(j);
                        if (!(MIMath.doubleEquals((double)v, (double)Double.parseDouble(cb.getStartValue().toString())) || v > Double.parseDouble(cb.getStartValue().toString()) && v < Double.parseDouble(cb.getEndValue().toString())) && (++blNum != ls.getBreakNum() || v != Double.parseDouble(cb.getEndValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
            }
            graphics.add(new Graphic((Shape)aPolygonShape, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    /*
     * Unable to fully structure code
     */
    public static GraphicCollection createContourPolygons(Array xa, Array ya, Array va, LegendScheme ls, boolean isSmooth) {
        minData = ArrayMath.min((Array)va).doubleValue();
        maxData = ArrayMath.max((Array)va).doubleValue();
        ls = ls.convertTo(ShapeTypes.POLYGON);
        cValues = ls.getValues(minData, maxData);
        nv = cValues.length;
        shape = va.getShape();
        S1 = new int[shape[0]][shape[1]];
        x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
        y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
        if (x[1] - x[0] < 0.0) {
            ArrayUtils.reverse((double[])x);
            va = va.flip(1);
        }
        if (y[1] - y[0] < 0.0) {
            ArrayUtils.reverse((double[])y);
            va = va.flip(0);
        }
        missingValue = -9999.0;
        data = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)va, (double)missingValue);
        cbs = ContourDraw.tracingContourLines((double[][])data, (double[])cValues, (double[])x, (double[])y, (double)missingValue, (int[][])S1);
        contourLines = (List)cbs[0];
        borders = (List)cbs[1];
        if (isSmooth) {
            contourLines = Contour.smoothLines((List)contourLines);
        }
        contourPolygons = ContourDraw.tracingPolygons((double[][])data, (List)contourLines, (List)borders, (double[])cValues);
        cbb = ls.getLegendBreak(0);
        extendType = ls.getExtendType();
        graphics = new GraphicCollection();
        block16: for (i = 0; i < contourPolygons.size(); ++i) {
            block36: {
                block37: {
                    block38: {
                        block34: {
                            block35: {
                                poly = (Polygon)contourPolygons.get(i);
                                v = poly.LowValue;
                                valueIdx = Arrays.binarySearch(cValues, v);
                                if (valueIdx < 0) {
                                    valueIdx = valueIdx == -1 ? 0 : -valueIdx;
                                }
                                if (valueIdx != nv - 1) break block34;
                                if (!poly.IsHighCenter) break block35;
                                if (!(maxData > ls.getMaxValue())) ** GOTO lbl-1000
                                switch (7.$SwitchMap$org$meteoinfo$geometry$colors$ExtendType[extendType.ordinal()]) {
                                    case 1: 
                                    case 2: {
                                        continue block16;
                                    }
                                    default: lbl-1000:
                                    // 2 sources

                                    {
                                        min = v;
                                        max = maxData;
                                        break;
                                    }
                                }
                                break block36;
                            }
                            if (!(poly.HighValue > ls.getMaxValue())) ** GOTO lbl-1000
                            switch (7.$SwitchMap$org$meteoinfo$geometry$colors$ExtendType[extendType.ordinal()]) {
                                case 1: 
                                case 2: {
                                    continue block16;
                                }
                                default: lbl-1000:
                                // 2 sources

                                {
                                    max = v;
                                    if (cValues.length > 1) {
                                        min = cValues[valueIdx - 1];
                                        break;
                                    }
                                    min = ls.getMinValue();
                                    break;
                                }
                            }
                            break block36;
                        }
                        if (valueIdx != 0) break block37;
                        if (!poly.IsHighCenter) break block38;
                        if (!(v < ls.getMinValue())) ** GOTO lbl-1000
                        switch (7.$SwitchMap$org$meteoinfo$geometry$colors$ExtendType[extendType.ordinal()]) {
                            case 1: 
                            case 3: {
                                continue block16;
                            }
                            default: lbl-1000:
                            // 2 sources

                            {
                                min = v;
                                if (cValues.length > 1) {
                                    max = cValues[valueIdx + 1];
                                    break;
                                }
                                max = ls.getMaxValue();
                                break;
                            }
                        }
                        break block36;
                    }
                    if (!(minData < ls.getMinValue())) ** GOTO lbl-1000
                    switch (7.$SwitchMap$org$meteoinfo$geometry$colors$ExtendType[extendType.ordinal()]) {
                        case 1: 
                        case 3: {
                            continue block16;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            max = poly.HighValue;
                            min = minData;
                            break;
                        }
                    }
                    break block36;
                }
                if (poly.LowValue == poly.HighValue) {
                    if (poly.IsHighCenter) {
                        min = v;
                        max = cValues[valueIdx + 1];
                    } else {
                        max = v;
                        min = cValues[valueIdx - 1];
                    }
                } else {
                    min = v;
                    max = poly.HighValue;
                }
            }
            pList = new ArrayList<PointD>();
            for (Object pointList : poly.OutLine.PointList) {
                aPoint = new PointD();
                aPoint.X = pointList.X;
                aPoint.Y = pointList.Y;
                pList.add(aPoint);
            }
            if (!GeoComputation.isClockwise(pList)) {
                Collections.reverse(pList);
            }
            aPolygonShape = new PolygonShape();
            aPolygonShape.setPoints(pList);
            aPolygonShape.setExtent(GeometryUtil.getPointsExtent(pList));
            aPolygonShape.lowValue = min;
            aPolygonShape.highValue = max;
            if (poly.HasHoles()) {
                for (PolyLine holeLine : poly.HoleLines) {
                    pList = new ArrayList<E>();
                    for (wcontour.global.PointD pointList : holeLine.PointList) {
                        aPoint = new PointD();
                        aPoint.X = pointList.X;
                        aPoint.Y = pointList.Y;
                        pList.add(aPoint);
                    }
                    aPolygonShape.addHole(pList, 0);
                }
            }
            v = aPolygonShape.lowValue;
            cbb = ls.getLegendBreak(0);
            block12 : switch (7.$SwitchMap$org$meteoinfo$geometry$legend$LegendType[ls.getLegendType().ordinal()]) {
                case 1: {
                    for (j = 0; j < ls.getBreakNum(); ++j) {
                        cb = (ColorBreak)ls.getLegendBreaks().get(j);
                        if (!MIMath.doubleEquals((double)v, (double)Double.parseDouble(cb.getStartValue().toString()))) continue;
                        cbb = cb;
                        break block12;
                    }
                    break;
                }
                case 2: {
                    blNum = 0;
                    for (j = 0; j < ls.getBreakNum(); ++j) {
                        cb = (ColorBreak)ls.getLegendBreaks().get(j);
                        if (!(++blNum == 1 && v <= cb.getStartDoubleValue() || v >= cb.getStartDoubleValue() && v < cb.getEndDoubleValue()) && (blNum != ls.getBreakNum() || !(v >= cb.getEndDoubleValue()))) continue;
                        cbb = cb;
                        break block12;
                    }
                    break;
                }
            }
            graphics.add(new Graphic((Shape)aPolygonShape, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourPolygons(Array xa, Array ya, Array va, double offset, String zdir, LegendScheme ls, boolean isSmooth) {
        ls = ls.convertTo(ShapeTypes.POLYGON);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        double minData = ArrayMath.min((Array)va).doubleValue();
        double maxData = ArrayMath.max((Array)va).doubleValue();
        int[] shape = va.getShape();
        int[][] S1 = new int[shape[0]][shape[1]];
        double[] x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
        double[] y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
        if (x[1] - x[0] < 0.0) {
            ArrayUtils.reverse((double[])x);
            va = va.flip(1);
        }
        if (y[1] - y[0] < 0.0) {
            ArrayUtils.reverse((double[])y);
            va = va.flip(0);
        }
        double missingValue = -9999.0;
        double[][] data = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)va, (double)missingValue);
        Object[] cbs = ContourDraw.tracingContourLines((double[][])data, (double[])cValues, (double[])x, (double[])y, (double)missingValue, (int[][])S1);
        List contourLines = (List)cbs[0];
        List borders = (List)cbs[1];
        if (isSmooth) {
            contourLines = Contour.smoothLines((List)contourLines);
        }
        List contourPolygons = ContourDraw.tracingPolygons((double[][])data, (List)contourLines, (List)borders, (double[])cValues);
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZValue(offset);
        zdir = zdir.toLowerCase();
        graphics.setZDir(zdir);
        for (int i = 0; i < contourPolygons.size(); ++i) {
            int valueIdx;
            PointZ aPoint;
            Polygon poly = (Polygon)contourPolygons.get(i);
            double v = poly.LowValue;
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    for (wcontour.global.PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.Y = pointList.X;
                        aPoint.Z = pointList.Y;
                        aPoint.X = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "y": {
                    for (wcontour.global.PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.X = pointList.X;
                        aPoint.Z = pointList.Y;
                        aPoint.Y = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "z": {
                    for (wcontour.global.PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.X = pointList.X;
                        aPoint.Y = pointList.Y;
                        aPoint.Z = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
            }
            if (!GeoComputation.isClockwise(pList)) {
                Collections.reverse(pList);
            }
            PolygonZShape aPolygonShape = new PolygonZShape();
            aPolygonShape.setPoints(pList);
            aPolygonShape.setExtent(GeometryUtil.getPointsExtent(pList));
            aPolygonShape.lowValue = v;
            if (poly.HasHoles()) {
                switch (zdir) {
                    case "x": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (wcontour.global.PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.Y = pointList.X;
                                aPoint.Z = pointList.Y;
                                aPoint.X = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                    case "y": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (wcontour.global.PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.X = pointList.X;
                                aPoint.Z = pointList.Y;
                                aPoint.Y = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                    case "z": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (wcontour.global.PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.X = pointList.X;
                                aPoint.Y = pointList.Y;
                                aPoint.Z = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                }
            }
            if ((valueIdx = Arrays.binarySearch(cValues, v)) < 0) {
                valueIdx = -valueIdx;
            }
            aPolygonShape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
            if (!poly.IsHighCenter && poly.HighValue == poly.LowValue) {
                aPolygonShape.highValue = v;
                aPolygonShape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
            }
            v = aPolygonShape.lowValue;
            ColorBreak cbb = ls.findLegendBreak((Number)v);
            graphics.add(new Graphic((Shape)aPolygonShape, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourPolygons(Array xa, Array ya, Array va, double offset, String zdir, LegendScheme ls, boolean isSmooth, List<Number> sePoint) {
        ls = ls.convertTo(ShapeTypes.POLYGON);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        double minData = ArrayMath.min((Array)va).doubleValue();
        double maxData = ArrayMath.max((Array)va).doubleValue();
        int[] shape = va.getShape();
        int[][] S1 = new int[shape[0]][shape[1]];
        double[] xx = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
        double[] yy = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
        if (xx[1] - xx[0] < 0.0) {
            ArrayUtils.reverse((double[])xx);
            va = va.flip(1);
        }
        if (yy[1] - yy[0] < 0.0) {
            ArrayUtils.reverse((double[])yy);
            va = va.flip(0);
        }
        double missingValue = -9999.0;
        double[][] data = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)va, (double)missingValue);
        Object[] cbs = ContourDraw.tracingContourLines((double[][])data, (double[])cValues, (double[])xx, (double[])yy, (double)missingValue, (int[][])S1);
        List contourLines = (List)cbs[0];
        List borders = (List)cbs[1];
        if (isSmooth) {
            contourLines = Contour.smoothLines((List)contourLines);
        }
        List contourPolygons = ContourDraw.tracingPolygons((double[][])data, (List)contourLines, (List)borders, (double[])cValues);
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZValue(offset);
        graphics.setSEPoint(sePoint);
        zdir = zdir.toLowerCase();
        graphics.setZDir(zdir);
        double xs = sePoint.get(0).doubleValue();
        double ys = sePoint.get(1).doubleValue();
        double xe = sePoint.get(2).doubleValue();
        double ye = sePoint.get(3).doubleValue();
        for (int i = 0; i < contourPolygons.size(); ++i) {
            int valueIdx;
            PointZ aPoint;
            Polygon poly = (Polygon)contourPolygons.get(i);
            double v = poly.LowValue;
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    for (wcontour.global.PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.Y = pointList.X;
                        aPoint.Z = pointList.Y;
                        aPoint.X = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "y": {
                    for (wcontour.global.PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.X = pointList.X;
                        aPoint.Z = pointList.Y;
                        aPoint.Y = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "xy": {
                    for (wcontour.global.PointD pointList : poly.OutLine.PointList) {
                        double x = pointList.X;
                        double y = pointList.Y;
                        aPoint = new PointZ();
                        aPoint.X = x;
                        aPoint.Y = ys + (ye - ys) * (x - xs) / (xe - xs);
                        aPoint.Z = y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "z": {
                    for (wcontour.global.PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.X = pointList.X;
                        aPoint.Y = pointList.Y;
                        aPoint.Z = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
            }
            if (!GeoComputation.isClockwise(pList)) {
                Collections.reverse(pList);
            }
            PolygonZShape aPolygonShape = new PolygonZShape();
            aPolygonShape.setPoints(pList);
            aPolygonShape.setExtent(GeometryUtil.getPointsExtent(pList));
            aPolygonShape.lowValue = v;
            if (poly.HasHoles()) {
                switch (zdir) {
                    case "x": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (wcontour.global.PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.Y = pointList.X;
                                aPoint.Z = pointList.Y;
                                aPoint.X = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                    case "y": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (wcontour.global.PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.X = pointList.X;
                                aPoint.Z = pointList.Y;
                                aPoint.Y = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                    case "z": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (wcontour.global.PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.X = pointList.X;
                                aPoint.Y = pointList.Y;
                                aPoint.Z = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                }
            }
            if ((valueIdx = Arrays.binarySearch(cValues, v)) < 0) {
                valueIdx = -valueIdx;
            }
            aPolygonShape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
            if (!poly.IsHighCenter && poly.HighValue == poly.LowValue) {
                aPolygonShape.highValue = v;
                aPolygonShape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
            }
            v = aPolygonShape.lowValue;
            ColorBreak cbb = ls.findLegendBreak((Number)v);
            graphics.add(new Graphic((Shape)aPolygonShape, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourPolygons(GridData gridData, double offset, String zdir, LegendScheme ls, boolean isSmooth) {
        ls = ls.convertTo(ShapeTypes.POLYGON);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        double[] maxmin = new double[2];
        gridData.getMaxMinValue(maxmin);
        double maxData = maxmin[0];
        double minData = maxmin[1];
        int[][] S1 = new int[gridData.getYNum()][gridData.getXNum()];
        double[] xArray = gridData.getXArray();
        double[] yArray = gridData.getYArray();
        if (gridData.getXDelta() < 0.0) {
            ArrayUtils.reverse((double[])xArray);
            gridData.xReverse();
        }
        if (gridData.getYDelta() < 0.0) {
            ArrayUtils.reverse((double[])yArray);
            gridData.yReverse();
        }
        Object[] cbs = ContourDraw.tracingContourLines((double[][])gridData.getData(), (double[])cValues, (double[])xArray, (double[])yArray, (double)gridData.getDoubleMissingValue(), (int[][])S1);
        List contourLines = (List)cbs[0];
        List borders = (List)cbs[1];
        if (isSmooth) {
            contourLines = Contour.smoothLines((List)contourLines);
        }
        List contourPolygons = ContourDraw.tracingPolygons((double[][])gridData.getData(), (List)contourLines, (List)borders, (double[])cValues);
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZValue(offset);
        zdir = zdir.toLowerCase();
        graphics.setZDir(zdir);
        for (int i = 0; i < contourPolygons.size(); ++i) {
            int valueIdx;
            PointZ aPoint;
            Polygon poly = (Polygon)contourPolygons.get(i);
            double v = poly.LowValue;
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    for (wcontour.global.PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.Y = pointList.X;
                        aPoint.Z = pointList.Y;
                        aPoint.X = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "y": {
                    for (wcontour.global.PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.X = pointList.X;
                        aPoint.Z = pointList.Y;
                        aPoint.Y = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "z": {
                    for (wcontour.global.PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.X = pointList.X;
                        aPoint.Y = pointList.Y;
                        aPoint.Z = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
            }
            if (!GeoComputation.isClockwise(pList)) {
                Collections.reverse(pList);
            }
            PolygonZShape aPolygonShape = new PolygonZShape();
            aPolygonShape.setPoints(pList);
            aPolygonShape.setExtent(GeometryUtil.getPointsExtent(pList));
            aPolygonShape.lowValue = v;
            if (poly.HasHoles()) {
                switch (zdir) {
                    case "x": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (wcontour.global.PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.Y = pointList.X;
                                aPoint.Z = pointList.Y;
                                aPoint.X = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                    case "y": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (wcontour.global.PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.X = pointList.X;
                                aPoint.Z = pointList.Y;
                                aPoint.Y = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                    case "z": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (wcontour.global.PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.X = pointList.X;
                                aPoint.Y = pointList.Y;
                                aPoint.Z = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                }
            }
            if ((valueIdx = Arrays.binarySearch(cValues, v)) < 0) {
                valueIdx = -valueIdx;
            }
            aPolygonShape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
            if (!poly.IsHighCenter && poly.HighValue == poly.LowValue) {
                aPolygonShape.highValue = v;
                aPolygonShape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
            }
            v = aPolygonShape.lowValue;
            ColorBreak cbb = ls.findLegendBreak((Number)v);
            graphics.add(new Graphic((Shape)aPolygonShape, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourPolygons(GridData gridData, double offset, String zdir, LegendScheme ls, boolean isSmooth, List<Number> sePoint) {
        ls = ls.convertTo(ShapeTypes.POLYGON);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        double[] maxmin = new double[2];
        gridData.getMaxMinValue(maxmin);
        double maxData = maxmin[0];
        double minData = maxmin[1];
        int[][] S1 = new int[gridData.getYNum()][gridData.getXNum()];
        double[] xArray = gridData.getXArray();
        double[] yArray = gridData.getYArray();
        if (gridData.getXDelta() < 0.0) {
            ArrayUtils.reverse((double[])xArray);
            gridData.xReverse();
        }
        if (gridData.getYDelta() < 0.0) {
            ArrayUtils.reverse((double[])yArray);
            gridData.yReverse();
        }
        Object[] cbs = ContourDraw.tracingContourLines((double[][])gridData.getData(), (double[])cValues, (double[])xArray, (double[])yArray, (double)gridData.getDoubleMissingValue(), (int[][])S1);
        List contourLines = (List)cbs[0];
        List borders = (List)cbs[1];
        if (isSmooth) {
            contourLines = Contour.smoothLines((List)contourLines);
        }
        List contourPolygons = ContourDraw.tracingPolygons((double[][])gridData.getData(), (List)contourLines, (List)borders, (double[])cValues);
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZValue(offset);
        graphics.setSEPoint(sePoint);
        zdir = zdir.toLowerCase();
        graphics.setZDir(zdir);
        double xs = sePoint.get(0).doubleValue();
        double ys = sePoint.get(1).doubleValue();
        double xe = sePoint.get(2).doubleValue();
        double ye = sePoint.get(3).doubleValue();
        for (int i = 0; i < contourPolygons.size(); ++i) {
            int valueIdx;
            PointZ aPoint;
            Polygon poly = (Polygon)contourPolygons.get(i);
            double v = poly.LowValue;
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    for (wcontour.global.PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.Y = pointList.X;
                        aPoint.Z = pointList.Y;
                        aPoint.X = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "y": {
                    for (wcontour.global.PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.X = pointList.X;
                        aPoint.Z = pointList.Y;
                        aPoint.Y = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "xy": {
                    for (wcontour.global.PointD pointList : poly.OutLine.PointList) {
                        double x = pointList.X;
                        double y = pointList.Y;
                        aPoint = new PointZ();
                        aPoint.X = x;
                        aPoint.Y = ys + (ye - ys) * (x - xs) / (xe - xs);
                        aPoint.Z = y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "z": {
                    for (wcontour.global.PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.X = pointList.X;
                        aPoint.Y = pointList.Y;
                        aPoint.Z = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
            }
            if (!GeoComputation.isClockwise(pList)) {
                Collections.reverse(pList);
            }
            PolygonZShape aPolygonShape = new PolygonZShape();
            aPolygonShape.setPoints(pList);
            aPolygonShape.setExtent(GeometryUtil.getPointsExtent(pList));
            aPolygonShape.lowValue = v;
            if (poly.HasHoles()) {
                switch (zdir) {
                    case "x": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (wcontour.global.PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.Y = pointList.X;
                                aPoint.Z = pointList.Y;
                                aPoint.X = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                    case "y": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (wcontour.global.PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.X = pointList.X;
                                aPoint.Z = pointList.Y;
                                aPoint.Y = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                    case "z": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (wcontour.global.PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.X = pointList.X;
                                aPoint.Y = pointList.Y;
                                aPoint.Z = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                }
            }
            if ((valueIdx = Arrays.binarySearch(cValues, v)) < 0) {
                valueIdx = -valueIdx;
            }
            aPolygonShape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
            if (!poly.IsHighCenter && poly.HighValue == poly.LowValue) {
                aPolygonShape.highValue = v;
                aPolygonShape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
            }
            v = aPolygonShape.lowValue;
            ColorBreak cbb = ls.findLegendBreak((Number)v);
            graphics.add(new Graphic((Shape)aPolygonShape, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createPColorPolygons(Array x_s, Array y_s, Array a, LegendScheme ls) {
        GraphicCollection gc = new GraphicCollection();
        int[] shape = x_s.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        x_s = x_s.copyIfView();
        y_s = y_s.copyIfView();
        a = a.copyIfView();
        for (int i = 0; i < rowNum - 1; ++i) {
            for (int j = 0; j < colNum - 1; ++j) {
                PolygonBreak pb;
                double v = a.getDouble(i * colNum + j);
                if (Double.isNaN(v) || (pb = (PolygonBreak)ls.findLegendBreak((Number)v)) == null) continue;
                double x1 = x_s.getDouble(i * colNum + j);
                double x2 = x_s.getDouble(i * colNum + j + 1);
                double x3 = x_s.getDouble((i + 1) * colNum + j);
                double x4 = x_s.getDouble((i + 1) * colNum + j + 1);
                PolygonShape ps = new PolygonShape();
                ArrayList<PointD> points = new ArrayList<PointD>();
                points.add(new PointD(x1, y_s.getDouble(i * colNum + j)));
                points.add(new PointD(x3, y_s.getDouble((i + 1) * colNum + j)));
                points.add(new PointD(x4, y_s.getDouble((i + 1) * colNum + j + 1)));
                points.add(new PointD(x2, y_s.getDouble(i * colNum + j + 1)));
                points.add((PointD)((PointD)points.get(0)).clone());
                ps.setPoints(points);
                Graphic graphic = new Graphic((Shape)ps, (ColorBreak)pb);
                gc.add(graphic);
            }
        }
        gc.setSingleLegend(false);
        gc.setLegendScheme(ls);
        return gc;
    }

    public static GraphicCollection createGridPolygons(Array x_s, Array y_s, Array a, LegendScheme ls) {
        GraphicCollection gc = new GraphicCollection();
        if (!x_s.getIndexPrivate().isFastIterator()) {
            x_s = x_s.copy();
        }
        if (!y_s.getIndexPrivate().isFastIterator()) {
            y_s = y_s.copy();
        }
        if (!a.getIndexPrivate().isFastIterator()) {
            a = a.copy();
        }
        int colNum = (int)x_s.getSize();
        int rowNum = (int)y_s.getSize();
        double x1 = 0.0;
        double y1 = 0.0;
        for (int i = 0; i < rowNum; ++i) {
            double yd;
            double y2;
            if (i == 0) {
                y1 = y_s.getDouble(i);
            }
            double y = y_s.getDouble(i);
            if (i < rowNum - 1) {
                y2 = y_s.getDouble(i + 1);
                yd = y2 - y;
            } else {
                y2 = y_s.getDouble(i - 1);
                yd = y - y2;
            }
            if (i == 0) {
                y1 -= yd * 0.5;
            }
            y2 = y + yd * 0.5;
            for (int j = 0; j < colNum; ++j) {
                double xd;
                double x2;
                if (j == 0) {
                    x1 = x_s.getDouble(j);
                }
                double x = x_s.getDouble(j);
                if (j < colNum - 1) {
                    x2 = x_s.getDouble(j + 1);
                    xd = x2 - x;
                } else {
                    x2 = x_s.getDouble(j - 1);
                    xd = x - x2;
                }
                if (j == 0) {
                    x1 -= xd * 0.5;
                }
                x2 = x + xd * 0.5;
                PolygonShape ps = new PolygonShape();
                ArrayList<PointD> points = new ArrayList<PointD>();
                points.add(new PointD(x1, y1));
                points.add(new PointD(x1, y2));
                points.add(new PointD(x2, y2));
                points.add(new PointD(x2, y1));
                points.add((PointD)((PointD)points.get(0)).clone());
                ps.setPoints(points);
                double v = a.getDouble(i * colNum + j);
                PolygonBreak pb = (PolygonBreak)ls.findLegendBreak((Number)v);
                Graphic graphic = new Graphic((Shape)ps, (ColorBreak)pb);
                gc.add(graphic);
                x1 = x2;
            }
            y1 = y2;
        }
        gc.setSingleLegend(false);
        gc.setLegendScheme(ls);
        return gc;
    }

    /*
     * WARNING - void declaration
     */
    public static GraphicCollection createFillBetweenPolygons(Array xdata, Array y1data, Array y2data, Array where, PolygonBreak pb) {
        GraphicCollection gc = new GraphicCollection();
        int len = (int)xdata.getSize();
        if (!xdata.getIndexPrivate().isFastIterator()) {
            xdata = xdata.copy();
        }
        if (!y1data.getIndexPrivate().isFastIterator()) {
            y1data = y1data.copy();
        }
        if (!y2data.getIndexPrivate().isFastIterator()) {
            y2data = y2data.copy();
        }
        if (where == null && (ArrayMath.containsNaN((Array)y1data) || ArrayMath.containsNaN((Array)y2data))) {
            void var11_8;
            where = Array.factory((DataType)DataType.BOOLEAN, (int[])new int[]{len});
            boolean bl = false;
            while (var11_8 < len) {
                double v1 = y1data.getDouble((int)var11_8);
                double v2 = y2data.getDouble((int)var11_8);
                if (Double.isNaN(v1) || Double.isNaN(v2)) {
                    where.setBoolean((int)var11_8, false);
                } else {
                    where.setBoolean((int)var11_8, true);
                }
                ++var11_8;
            }
        }
        if (where == null) {
            int i;
            PolygonShape pgs = new PolygonShape();
            ArrayList<PointD> points = new ArrayList<PointD>();
            for (i = 0; i < len; ++i) {
                points.add(new PointD(xdata.getDouble(i), y1data.getDouble(i)));
            }
            for (i = len - 1; i >= 0; --i) {
                points.add(new PointD(xdata.getDouble(i), y2data.getDouble(i)));
            }
            pgs.setPoints(points);
            Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pb);
            gc.add(graphic);
        } else {
            if (!where.getIndexPrivate().isFastIterator()) {
                where = where.copy();
            }
            boolean ob = false;
            ArrayList idxs = new ArrayList();
            ArrayList<Integer> idx = new ArrayList<Integer>();
            for (int j = 0; j < len; ++j) {
                if (where.getInt(j) == 1) {
                    idx.add(j);
                } else if (ob) {
                    idxs.add(idx);
                    idx = new ArrayList();
                }
                ob = where.getInt(j) == 1;
            }
            if (!idx.isEmpty()) {
                idxs.add(idx);
            }
            for (List list : idxs) {
                int ii;
                int j;
                int nn = list.size();
                if (nn < 2) continue;
                PolygonShape pgs = new PolygonShape();
                ArrayList<PointD> points = new ArrayList<PointD>();
                for (j = 0; j < nn; ++j) {
                    ii = (Integer)list.get(j);
                    points.add(new PointD(xdata.getDouble(ii), y1data.getDouble(ii)));
                }
                for (j = 0; j < nn; ++j) {
                    ii = (Integer)list.get(nn - j - 1);
                    points.add(new PointD(xdata.getDouble(ii), y2data.getDouble(ii)));
                }
                pgs.setPoints(points);
                Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pb);
                gc.add(graphic);
            }
        }
        return gc;
    }

    /*
     * WARNING - void declaration
     */
    public static GraphicCollection createFillBetweenPolygonsX(Array ydata, Array x1data, Array x2data, Array where, PolygonBreak pb) {
        GraphicCollection gc = new GraphicCollection();
        int len = (int)ydata.getSize();
        if (!ydata.getIndexPrivate().isFastIterator()) {
            ydata = ydata.copy();
        }
        if (!x1data.getIndexPrivate().isFastIterator()) {
            x1data = x1data.copy();
        }
        if (!x2data.getIndexPrivate().isFastIterator()) {
            x2data = x2data.copy();
        }
        if (where == null && (ArrayMath.containsNaN((Array)x1data) || ArrayMath.containsNaN((Array)x2data))) {
            void var11_8;
            where = Array.factory((DataType)DataType.BOOLEAN, (int[])new int[]{len});
            boolean bl = false;
            while (var11_8 < len) {
                double v1 = x1data.getDouble((int)var11_8);
                double v2 = x2data.getDouble((int)var11_8);
                if (Double.isNaN(v1) || Double.isNaN(v2)) {
                    where.setBoolean((int)var11_8, false);
                } else {
                    where.setBoolean((int)var11_8, true);
                }
                ++var11_8;
            }
        }
        if (where == null) {
            int i;
            PolygonShape pgs = new PolygonShape();
            ArrayList<PointD> points = new ArrayList<PointD>();
            for (i = 0; i < len; ++i) {
                points.add(new PointD(x1data.getDouble(i), ydata.getDouble(i)));
            }
            for (i = len - 1; i >= 0; --i) {
                points.add(new PointD(x2data.getDouble(i), ydata.getDouble(i)));
            }
            pgs.setPoints(points);
            Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pb);
            gc.add(graphic);
        } else {
            if (!where.getIndexPrivate().isFastIterator()) {
                where = where.copy();
            }
            boolean ob = false;
            ArrayList idxs = new ArrayList();
            ArrayList<Integer> idx = new ArrayList<Integer>();
            for (int j = 0; j < len; ++j) {
                if (where.getInt(j) == 1) {
                    idx.add(j);
                } else if (ob) {
                    idxs.add(idx);
                    idx = new ArrayList();
                }
                ob = where.getInt(j) == 1;
            }
            if (!idx.isEmpty()) {
                idxs.add(idx);
            }
            for (List list : idxs) {
                int ii;
                int j;
                int nn = list.size();
                if (nn < 2) continue;
                PolygonShape pgs = new PolygonShape();
                ArrayList<PointD> points = new ArrayList<PointD>();
                for (j = 0; j < nn; ++j) {
                    ii = (Integer)list.get(j);
                    points.add(new PointD(x1data.getDouble(ii), ydata.getDouble(ii)));
                }
                for (j = 0; j < nn; ++j) {
                    ii = (Integer)list.get(nn - j - 1);
                    points.add(new PointD(x2data.getDouble(ii), ydata.getDouble(ii)));
                }
                pgs.setPoints(points);
                Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pb);
                gc.add(graphic);
            }
        }
        return gc;
    }

    /*
     * WARNING - void declaration
     */
    public static GraphicCollection createFillBetweenPolygons(Array xdata, Array y1data, Array y2data, Array where, PolygonBreak pb, double offset, String zdir) {
        GraphicCollection3D gc = new GraphicCollection3D();
        gc.setFixZ(true);
        gc.setZValue(offset);
        gc.setZDir(zdir);
        int len = (int)xdata.getSize();
        if (!xdata.getIndexPrivate().isFastIterator()) {
            xdata = xdata.copy();
        }
        if (!y1data.getIndexPrivate().isFastIterator()) {
            y1data = y1data.copy();
        }
        if (!y2data.getIndexPrivate().isFastIterator()) {
            y2data = y2data.copy();
        }
        if (where == null && (ArrayMath.containsNaN((Array)y1data) || ArrayMath.containsNaN((Array)y2data))) {
            void var14_10;
            where = Array.factory((DataType)DataType.BOOLEAN, (int[])new int[]{len});
            boolean bl = false;
            while (var14_10 < len) {
                double v1 = y1data.getDouble((int)var14_10);
                double v2 = y2data.getDouble((int)var14_10);
                if (Double.isNaN(v1) || Double.isNaN(v2)) {
                    where.setBoolean((int)var14_10, false);
                } else {
                    where.setBoolean((int)var14_10, true);
                }
                ++var14_10;
            }
        }
        if (where == null) {
            PolygonZShape pgs = new PolygonZShape();
            ArrayList<PointZ> points = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    void var14_14;
                    void var14_12;
                    boolean bl = false;
                    while (var14_12 < len) {
                        points.add(new PointZ(offset, xdata.getDouble((int)var14_12), y1data.getDouble((int)var14_12)));
                        ++var14_12;
                    }
                    int n = len - 1;
                    while (var14_14 >= 0) {
                        points.add(new PointZ(offset, xdata.getDouble((int)var14_14), y2data.getDouble((int)var14_14)));
                        --var14_14;
                    }
                    break;
                }
                case "y": {
                    void var14_18;
                    void var14_16;
                    boolean bl = false;
                    while (var14_16 < len) {
                        points.add(new PointZ(xdata.getDouble((int)var14_16), offset, y1data.getDouble((int)var14_16)));
                        ++var14_16;
                    }
                    int n = len - 1;
                    while (var14_18 >= 0) {
                        points.add(new PointZ(xdata.getDouble((int)var14_18), offset, y2data.getDouble((int)var14_18)));
                        --var14_18;
                    }
                    break;
                }
                case "z": {
                    void var14_22;
                    void var14_20;
                    boolean bl = false;
                    while (var14_20 < len) {
                        points.add(new PointZ(xdata.getDouble((int)var14_20), y1data.getDouble((int)var14_20), offset));
                        ++var14_20;
                    }
                    int n = len - 1;
                    while (var14_22 >= 0) {
                        points.add(new PointZ(xdata.getDouble((int)var14_22), y2data.getDouble((int)var14_22), offset));
                        --var14_22;
                    }
                    break;
                }
            }
            pgs.setPoints(points);
            Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pb);
            gc.add(graphic);
        } else {
            if (!where.getIndexPrivate().isFastIterator()) {
                where = where.copy();
            }
            boolean ob = false;
            ArrayList idxs = new ArrayList();
            ArrayList<Integer> idx = new ArrayList<Integer>();
            for (int j = 0; j < len; ++j) {
                if (where.getInt(j) == 1) {
                    idx.add(j);
                } else if (ob) {
                    idxs.add(idx);
                    idx = new ArrayList();
                }
                ob = where.getInt(j) == 1;
            }
            if (!idx.isEmpty()) {
                idxs.add(idx);
            }
            for (List list : idxs) {
                int nn = list.size();
                if (nn < 2) continue;
                PolygonZShape pgs = new PolygonZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                switch (zdir) {
                    case "x": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(offset, xdata.getDouble(ii), y1data.getDouble(ii)));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(offset, xdata.getDouble(ii), y2data.getDouble(ii)));
                        }
                        break;
                    }
                    case "y": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(xdata.getDouble(ii), offset, y1data.getDouble(ii)));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(xdata.getDouble(ii), offset, y2data.getDouble(ii)));
                        }
                        break;
                    }
                    case "z": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(xdata.getDouble(ii), y1data.getDouble(ii), offset));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(xdata.getDouble(ii), y2data.getDouble(ii), offset));
                        }
                        break;
                    }
                }
                pgs.setPoints(points);
                Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pb);
                gc.add(graphic);
            }
        }
        return gc;
    }

    /*
     * WARNING - void declaration
     */
    public static GraphicCollection createFillBetweenPolygons(Array xdata, Array ydata, Array y1data, Array y2data, Array where, PolygonBreak pb, double offset, String zdir) {
        GraphicCollection3D gc = new GraphicCollection3D();
        gc.setFixZ(true);
        gc.setZValue(offset);
        gc.setZDir(zdir);
        int len = (int)xdata.getSize();
        if (!xdata.getIndexPrivate().isFastIterator()) {
            xdata = xdata.copy();
        }
        if (!y1data.getIndexPrivate().isFastIterator()) {
            y1data = y1data.copy();
        }
        if (!y2data.getIndexPrivate().isFastIterator()) {
            y2data = y2data.copy();
        }
        if (where == null) {
            PolygonZShape pgs = new PolygonZShape();
            ArrayList<PointZ> points = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    void var15_22;
                    void var15_20;
                    boolean bl = false;
                    while (var15_20 < len) {
                        points.add(new PointZ(offset, xdata.getDouble((int)var15_20), y1data.getDouble((int)var15_20)));
                        ++var15_20;
                    }
                    int n = len - 1;
                    while (var15_22 >= 0) {
                        points.add(new PointZ(offset, xdata.getDouble((int)var15_22), y2data.getDouble((int)var15_22)));
                        --var15_22;
                    }
                    break;
                }
                case "y": {
                    void var15_26;
                    void var15_24;
                    boolean bl = false;
                    while (var15_24 < len) {
                        points.add(new PointZ(xdata.getDouble((int)var15_24), offset, y1data.getDouble((int)var15_24)));
                        ++var15_24;
                    }
                    int n = len - 1;
                    while (var15_26 >= 0) {
                        points.add(new PointZ(xdata.getDouble((int)var15_26), offset, y2data.getDouble((int)var15_26)));
                        --var15_26;
                    }
                    break;
                }
                case "xy": {
                    void var15_30;
                    void var15_28;
                    if (!ydata.getIndexPrivate().isFastIterator()) {
                        ydata = ydata.copy();
                    }
                    boolean bl = false;
                    while (var15_28 < len) {
                        points.add(new PointZ(xdata.getDouble((int)var15_28), ydata.getDouble((int)var15_28), y1data.getDouble((int)var15_28)));
                        ++var15_28;
                    }
                    int n = len - 1;
                    while (var15_30 >= 0) {
                        points.add(new PointZ(xdata.getDouble((int)var15_30), ydata.getDouble((int)var15_30), y2data.getDouble((int)var15_30)));
                        --var15_30;
                    }
                    break;
                }
                case "z": {
                    void var15_34;
                    void var15_32;
                    boolean bl = false;
                    while (var15_32 < len) {
                        points.add(new PointZ(xdata.getDouble((int)var15_32), y1data.getDouble((int)var15_32), offset));
                        ++var15_32;
                    }
                    int n = len - 1;
                    while (var15_34 >= 0) {
                        points.add(new PointZ(xdata.getDouble((int)var15_34), y2data.getDouble((int)var15_34), offset));
                        --var15_34;
                    }
                    break;
                }
            }
            pgs.setPoints(points);
            Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pb);
            gc.add(graphic);
        } else {
            boolean ob = false;
            ArrayList idxs = new ArrayList();
            ArrayList<Integer> idx = new ArrayList<Integer>();
            for (int j = 0; j < len; ++j) {
                if (where.getInt(j) == 1) {
                    if (!ob) {
                        idx = new ArrayList();
                    }
                    idx.add(j);
                } else if (ob) {
                    idxs.add(idx);
                }
                ob = where.getInt(j) == 1;
            }
            for (List list : idxs) {
                int nn = list.size();
                if (nn < 2) continue;
                PolygonZShape pgs = new PolygonZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                switch (zdir) {
                    case "x": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(offset, xdata.getDouble(ii), y1data.getDouble(ii)));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(offset, xdata.getDouble(ii), y2data.getDouble(ii)));
                        }
                        break;
                    }
                    case "y": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(xdata.getDouble(ii), offset, y1data.getDouble(ii)));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(xdata.getDouble(ii), offset, y2data.getDouble(ii)));
                        }
                        break;
                    }
                    case "xy": {
                        int ii;
                        int j;
                        if (!ydata.getIndexPrivate().isFastIterator()) {
                            ydata = ydata.copy();
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(xdata.getDouble(ii), ydata.getDouble(ii), y1data.getDouble(ii)));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(xdata.getDouble(ii), ydata.getDouble(ii), y2data.getDouble(ii)));
                        }
                        break;
                    }
                    case "z": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(xdata.getDouble(ii), y1data.getDouble(ii), offset));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(xdata.getDouble(ii), y2data.getDouble(ii), offset));
                        }
                        break;
                    }
                }
                pgs.setPoints(points);
                Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pb);
                gc.add(graphic);
            }
        }
        return gc;
    }

    public static GraphicCollection createBarbs(Array xdata, Array ydata, Array udata, Array vdata, Array cdata, LegendScheme ls, boolean isUV) {
        IndexIterator cIter;
        Array windSpeedData;
        Array windDirData;
        GraphicCollection gc = new GraphicCollection();
        if (isUV) {
            Array[] wwData = MeteoMath.uv2ds((Array)udata, (Array)vdata);
            windDirData = wwData[0];
            windSpeedData = wwData[1];
        } else {
            windDirData = udata;
            windSpeedData = vdata;
        }
        ShapeTypes sts = ls.getShapeType();
        ls = ls.convertTo(ShapeTypes.POINT);
        if (sts != ShapeTypes.POINT) {
            for (int i = 0; i < ls.getBreakNum(); ++i) {
                ((PointBreak)ls.getLegendBreaks().get(i)).setSize(10.0f);
            }
        }
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator wdIter = windDirData.getIndexIterator();
        IndexIterator wsIter = windSpeedData.getIndexIterator();
        IndexIterator indexIterator = cIter = cdata == null ? null : cdata.getIndexIterator();
        while (xIter.hasNext()) {
            double windDir = wdIter.getDoubleNext();
            double windSpeed = wsIter.getDoubleNext();
            if (!Double.isNaN(windDir) && !Double.isNaN(windSpeed)) {
                ColorBreak cb;
                PointD aPoint = new PointD();
                aPoint.X = xIter.getDoubleNext();
                aPoint.Y = yIter.getDoubleNext();
                WindBarb aWB = Draw.calWindBarb((float)((float)windDir), (float)((float)windSpeed), (double)0.0, (float)10.0f, (PointD)aPoint);
                if (cdata == null) {
                    cb = (ColorBreak)ls.getLegendBreaks().get(0);
                } else {
                    double v = cIter.getDoubleNext();
                    aWB.setValue(v);
                    cb = ls.findLegendBreak((Number)v);
                }
                Graphic graphic = new Graphic((Shape)aWB, cb);
                gc.add(graphic);
                continue;
            }
            xIter.next();
            yIter.next();
            if (cIter == null) continue;
            cIter.next();
        }
        gc.setLegendScheme(ls);
        if (cdata != null) {
            gc.setSingleLegend(false);
        }
        return gc;
    }

    public static Graphic createArrow(double x, double y, double dx, double dy, ArrowPolygonBreak ab) {
        double[] r = MeteoMath.uv2ds((double)dx, (double)dy);
        double length = r[1];
        if (ab.isLengthIncludesHead()) {
            length -= (double)ab.getHeadLength();
        }
        AffineTransform atf = new AffineTransform();
        atf.translate(x, y);
        atf.rotate(dx, dy);
        float width = ab.getWidth();
        float headLength = ab.getHeadLength();
        float overhang = ab.getOverhang();
        float lenShift = headLength * overhang;
        double[] srcPts = new double[]{0.0, (double)(-width) * 0.5, 0.0, (double)width * 0.5, length + (double)lenShift, (double)width * 0.5, length, (double)ab.getHeadWidth() * 0.5, length + (double)ab.getHeadLength(), 0.0, length, (double)(-ab.getHeadWidth()) * 0.5, length + (double)lenShift, (double)(-width) * 0.5, 0.0, (double)(-width) * 0.5};
        atf.transform(srcPts, 0, srcPts, 0, 8);
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (int i = 0; i < srcPts.length; i += 2) {
            points.add(new PointD(srcPts[i], srcPts[i + 1]));
        }
        PolygonShape pgs = new PolygonShape();
        pgs.setPoints(points);
        return new Graphic((Shape)pgs, (ColorBreak)ab);
    }

    public static Graphic createArrowLine(double x, double y, double dx, double dy, ArrowLineBreak ab) {
        ArrayList<PointD> points = new ArrayList<PointD>();
        points.add(new PointD(x, y));
        points.add(new PointD(x + dx, y + dy));
        PolylineShape pls = new PolylineShape();
        pls.setPoints(points);
        return new Graphic((Shape)pls, (ColorBreak)ab);
    }

    public static Graphic createArrowLine(Array x, Array y, ArrowLineBreak ab, boolean iscurve) {
        ArrayList<PointD> points = new ArrayList<PointD>();
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        while (xIter.hasNext()) {
            points.add(new PointD(xIter.getDoubleNext(), yIter.getDoubleNext()));
        }
        Object pls = iscurve ? new CurveLineShape() : new PolylineShape();
        pls.setPoints(points);
        return new Graphic((Shape)pls, (ColorBreak)ab);
    }

    public static GraphicCollection createArrows(Array xdata, Array ydata, Array udata, Array vdata, Array cdata, LegendScheme ls, boolean isUV) {
        IndexIterator cIter;
        Array windSpeedData;
        Array windDirData;
        GraphicCollection gc = new GraphicCollection();
        if (isUV) {
            Array[] wwData = MeteoMath.uv2ds((Array)udata, (Array)vdata);
            windDirData = wwData[0];
            windSpeedData = wwData[1];
        } else {
            windDirData = udata;
            windSpeedData = vdata;
        }
        ShapeTypes sts = ls.getShapeType();
        ls = ls.convertTo(ShapeTypes.POINT);
        if (sts != ShapeTypes.POINT) {
            for (int i = 0; i < ls.getBreakNum(); ++i) {
                ((PointBreak)ls.getLegendBreaks().get(i)).setSize(10.0f);
            }
        }
        double v = 0.0;
        float size = 6.0f;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator wdIter = windDirData.getIndexIterator();
        IndexIterator wsIter = windSpeedData.getIndexIterator();
        IndexIterator indexIterator = cIter = cdata == null ? null : cdata.getIndexIterator();
        while (xIter.hasNext()) {
            ColorBreak cb;
            double windDir = wdIter.getDoubleNext();
            double windSpeed = wsIter.getDoubleNext();
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (cdata != null) {
                v = cIter.getDoubleNext();
            }
            if (Double.isNaN(windDir) || Double.isNaN(windSpeed)) continue;
            PointD aPoint = new PointD();
            aPoint.X = x;
            aPoint.Y = y;
            WindArrow wa = new WindArrow();
            wa.angle = windDir;
            wa.length = (float)windSpeed;
            wa.size = size;
            wa.setPoint(aPoint);
            if (cdata == null) {
                cb = (ColorBreak)ls.getLegendBreaks().get(0);
            } else {
                wa.setValue(v);
                cb = ls.findLegendBreak((Number)v);
            }
            Graphic graphic = new Graphic((Shape)wa, cb);
            gc.add(graphic);
        }
        gc.setLegendScheme(ls);
        if (cdata != null) {
            gc.setSingleLegend(false);
        }
        return gc;
    }

    public static GraphicCollection3D createArrows3D(Array xdata, Array ydata, Array zdata, Array udata, Array vdata, Array wdata, float scale, float headWidth, float headLength, Array cdata, LegendScheme ls) {
        IndexIterator cIter;
        GraphicCollection3D gc = new GraphicCollection3D();
        ShapeTypes sts = ls.getShapeType();
        ls = ls.convertTo(ShapeTypes.POINT);
        if (sts != ShapeTypes.POINT) {
            for (int i = 0; i < ls.getBreakNum(); ++i) {
                ((PointBreak)ls.getLegendBreaks().get(i)).setSize(10.0f);
            }
        }
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        IndexIterator uIter = udata.getIndexIterator();
        IndexIterator vIter = vdata.getIndexIterator();
        IndexIterator wIter = wdata.getIndexIterator();
        IndexIterator indexIterator = cIter = cdata == null ? null : cdata.getIndexIterator();
        while (xIter.hasNext()) {
            double u = uIter.getDoubleNext();
            double v = vIter.getDoubleNext();
            double w = wIter.getDoubleNext();
            if (!(Double.isNaN(u) || Double.isNaN(v) || Double.isNaN(w))) {
                ColorBreak cb;
                PointZ aPoint = new PointZ();
                aPoint.X = xIter.getDoubleNext();
                aPoint.Y = yIter.getDoubleNext();
                aPoint.Z = zIter.getDoubleNext();
                WindArrow3D wa = new WindArrow3D();
                wa.u = u;
                wa.v = v;
                wa.w = w;
                wa.scale = scale;
                wa.setHeadWidth(headWidth);
                wa.setHeadLength(headLength);
                wa.setPoint((PointD)aPoint);
                if (cdata == null) {
                    cb = (ColorBreak)ls.getLegendBreaks().get(0);
                } else {
                    double value = cIter.getDoubleNext();
                    wa.setValue(value);
                    cb = ls.findLegendBreak((Number)value);
                }
                Graphic graphic = new Graphic((Shape)wa, cb);
                gc.add(graphic);
                continue;
            }
            xIter.next();
            yIter.next();
            zIter.next();
            if (cdata == null) continue;
            cIter.next();
        }
        gc.setLegendScheme(ls);
        if (cdata != null) {
            gc.setSingleLegend(false);
        }
        return gc;
    }

    public static GraphicCollection3D createStreamlines3D(Array xdata, Array ydata, Array zdata, Array udata, Array vdata, Array wdata, Array cdata, int density, LegendScheme ls, int minPoints, int loopLimit) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        double[][][] u = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)udata);
        double[][][] v = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)vdata);
        double[][][] w = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)wdata);
        if (xdata.getRank() == 1) {
            double[] x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xdata);
            double[] y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ydata);
            double[] z = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)zdata);
            if (cdata == null) {
                List streamLines = Contour.tracingStreamline3D((double[][][])u, (double[][][])v, (double[][][])w, null, (double[])x, (double[])y, (double[])z, (int)density, (int)loopLimit);
                ColorBreak cb = ls.getLegendBreak(0);
                for (PolyLine3D line : streamLines) {
                    if (line.PointList.size() < minPoints) continue;
                    PolylineZShape shape = new PolylineZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    for (Point3D point : line.PointList) {
                        points.add(new PointZ(point.X, point.Y, point.Z));
                    }
                    shape.setPoints(points);
                    graphics.add(new Graphic((Shape)shape, cb));
                }
            } else {
                double[][][] m = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)cdata);
                List streamLines = Contour.tracingStreamline3D((double[][][])u, (double[][][])v, (double[][][])w, (double[][][])m, (double[])x, (double[])y, (double[])z, (int)density, (int)loopLimit);
                for (PolyLine3D line : streamLines) {
                    if (line.PointList.size() < minPoints) continue;
                    PolylineZShape shape = new PolylineZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    ColorBreakCollection cbs = new ColorBreakCollection();
                    for (Point3D point : line.PointList) {
                        points.add(new PointZ(point.X, point.Y, point.Z));
                        ColorBreak cb = ls.findLegendBreak((Number)point.M);
                        cbs.add(cb);
                    }
                    shape.setPoints(points);
                    graphics.add(new Graphic((Shape)shape, (ColorBreak)cbs));
                }
            }
        } else {
            double[][][] x = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)xdata);
            double[][][] y = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)ydata);
            double[][][] z = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)zdata);
            if (cdata == null) {
                List streamLines = Contour.tracingStreamline3D((double[][][])u, (double[][][])v, (double[][][])w, null, (double[][][])x, (double[][][])y, (double[][][])z, (int)density, (int)loopLimit);
                ColorBreak cb = ls.getLegendBreak(0);
                for (PolyLine3D line : streamLines) {
                    if (line.PointList.size() < minPoints) continue;
                    PolylineZShape shape = new PolylineZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    for (Point3D point : line.PointList) {
                        points.add(new PointZ(point.X, point.Y, point.Z));
                    }
                    shape.setPoints(points);
                    graphics.add(new Graphic((Shape)shape, cb));
                }
            } else {
                double[][][] m = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)cdata);
                List streamLines = Contour.tracingStreamline3D((double[][][])u, (double[][][])v, (double[][][])w, (double[][][])m, (double[][][])x, (double[][][])y, (double[][][])z, (int)density, (int)loopLimit);
                for (PolyLine3D line : streamLines) {
                    if (line.PointList.size() < minPoints) continue;
                    PolylineZShape shape = new PolylineZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    ColorBreakCollection cbs = new ColorBreakCollection();
                    for (Point3D point : line.PointList) {
                        points.add(new PointZ(point.X, point.Y, point.Z));
                        ColorBreak cb = ls.findLegendBreak((Number)point.M);
                        cbs.add(cb);
                    }
                    shape.setPoints(points);
                    graphics.add(new Graphic((Shape)shape, (ColorBreak)cbs));
                }
            }
        }
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection3D createStreamlines3D(Array xdata, Array ydata, Array zdata, Array udata, Array vdata, Array wdata, Array cdata, int density, LegendScheme ls, int minPoints, int loopLimit, Array startX, Array startY, Array startZ) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        double[][][] u = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)udata);
        double[][][] v = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)vdata);
        double[][][] w = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)wdata);
        double[] sX = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)startX);
        double[] sY = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)startY);
        double[] sZ = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)startZ);
        if (xdata.getRank() == 1) {
            double[] x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xdata);
            double[] y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ydata);
            double[] z = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)zdata);
            if (cdata == null) {
                List streamLines = Contour.tracingStreamline3D((double[][][])u, (double[][][])v, (double[][][])w, null, (double[])x, (double[])y, (double[])z, (int)density, (double[])sX, (double[])sY, (double[])sZ, (int)loopLimit);
                ColorBreak cb = ls.getLegendBreak(0);
                for (PolyLine3D line : streamLines) {
                    if (line.PointList.size() < minPoints) continue;
                    PolylineZShape shape = new PolylineZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    for (Point3D point : line.PointList) {
                        points.add(new PointZ(point.X, point.Y, point.Z));
                    }
                    shape.setPoints(points);
                    graphics.add(new Graphic((Shape)shape, cb));
                }
            } else {
                double[][][] m = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)cdata);
                List streamLines = Contour.tracingStreamline3D((double[][][])u, (double[][][])v, (double[][][])w, (double[][][])m, (double[])x, (double[])y, (double[])z, (int)density, (double[])sX, (double[])sY, (double[])sZ, (int)loopLimit);
                for (PolyLine3D line : streamLines) {
                    if (line.PointList.size() < minPoints) continue;
                    PolylineZShape shape = new PolylineZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    ColorBreakCollection cbs = new ColorBreakCollection();
                    for (Point3D point : line.PointList) {
                        points.add(new PointZ(point.X, point.Y, point.Z));
                        ColorBreak cb = ls.findLegendBreak((Number)point.M);
                        cbs.add(cb);
                    }
                    shape.setPoints(points);
                    graphics.add(new Graphic((Shape)shape, (ColorBreak)cbs));
                }
            }
        } else {
            double[][][] x = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)xdata);
            double[][][] y = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)ydata);
            double[][][] z = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)zdata);
            if (cdata == null) {
                List streamLines = Contour.tracingStreamline3D((double[][][])u, (double[][][])v, (double[][][])w, null, (double[][][])x, (double[][][])y, (double[][][])z, (int)density, (double[])sX, (double[])sY, (double[])sZ, (int)loopLimit);
                ColorBreak cb = ls.getLegendBreak(0);
                for (PolyLine3D line : streamLines) {
                    if (line.PointList.size() < minPoints) continue;
                    PolylineZShape shape = new PolylineZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    for (Point3D point : line.PointList) {
                        points.add(new PointZ(point.X, point.Y, point.Z));
                    }
                    shape.setPoints(points);
                    graphics.add(new Graphic((Shape)shape, cb));
                }
            } else {
                double[][][] m = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)cdata);
                List streamLines = Contour.tracingStreamline3D((double[][][])u, (double[][][])v, (double[][][])w, (double[][][])m, (double[][][])x, (double[][][])y, (double[][][])z, (int)density, (double[])sX, (double[])sY, (double[])sZ, (int)loopLimit);
                for (PolyLine3D line : streamLines) {
                    if (line.PointList.size() < minPoints) continue;
                    PolylineZShape shape = new PolylineZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    ColorBreakCollection cbs = new ColorBreakCollection();
                    for (Point3D point : line.PointList) {
                        points.add(new PointZ(point.X, point.Y, point.Z));
                        ColorBreak cb = ls.findLegendBreak((Number)point.M);
                        cbs.add(cb);
                    }
                    shape.setPoints(points);
                    graphics.add(new Graphic((Shape)shape, (ColorBreak)cbs));
                }
            }
        }
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection3D createStreamlines(Array xdata, Array ydata, Array udata, Array vdata, Array cdata, int density, LegendScheme ls, boolean isUV, double offset, String zdir) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        if (!isUV) {
            Array[] uvData = MeteoMath.ds2uv((Array)udata, (Array)vdata);
            udata = uvData[0];
            vdata = uvData[1];
        }
        double[] x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xdata);
        double[] y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ydata);
        if (x[1] - x[0] < 0.0) {
            ArrayUtils.reverse((double[])x);
            udata = udata.flip(1);
            vdata = vdata.flip(1);
        }
        if (y[1] - y[0] < 0.0) {
            ArrayUtils.reverse((double[])y);
            udata = udata.flip(0);
            vdata = vdata.flip(0);
        }
        double[][] u = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)udata);
        double[][] v = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)vdata);
        List streamlines = Contour.tracingStreamline((double[][])u, (double[][])v, (double[])x, (double[])y, (int)density);
        int ny = u.length;
        int nx = u[0].length;
        ColorBreak cb = ls.getLegendBreak(0);
        if (cdata == null) {
            for (PolyLine line : streamlines) {
                PointZ p;
                int j;
                PolylineZShape shape = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                if (zdir.equals("x")) {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.Y = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                        p.Z = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                        p.X = offset;
                        points.add(p);
                    }
                } else if (zdir.equals("y")) {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.X = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                        p.Z = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                        p.Y = offset;
                        points.add(p);
                    }
                } else {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.X = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                        p.Y = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                        p.Z = offset;
                        points.add(p);
                    }
                }
                shape.setPoints(points);
                graphics.add(new Graphic((Shape)shape, cb));
            }
        } else {
            cdata = cdata.copyIfView();
            for (PolyLine line : streamlines) {
                int xi;
                int yi;
                int[] idx;
                PointZ p;
                int j;
                PolylineZShape shape = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                ColorBreakCollection cbs = new ColorBreakCollection();
                if (zdir.equals("x")) {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.Y = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                        p.Z = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                        p.X = offset;
                        idx = ArrayUtil.gridIndex((Array)xdata, (Array)ydata, (double)p.Y, (double)p.Z);
                        if (idx != null) {
                            yi = idx[0];
                            xi = idx[1];
                            p.M = cdata.getDouble(yi * nx + xi);
                        }
                        cb = ls.findLegendBreak((Number)p.M);
                        cbs.add(cb);
                        points.add(p);
                    }
                } else if (zdir.equals("y")) {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.X = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                        p.Z = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                        p.Y = offset;
                        idx = ArrayUtil.gridIndex((Array)xdata, (Array)ydata, (double)p.X, (double)p.Z);
                        if (idx != null) {
                            yi = idx[0];
                            xi = idx[1];
                            p.M = cdata.getDouble(yi * nx + xi);
                        }
                        cb = ls.findLegendBreak((Number)p.M);
                        cbs.add(cb);
                        points.add(p);
                    }
                } else {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.X = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                        p.Y = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                        p.Z = offset;
                        idx = ArrayUtil.gridIndex((Array)xdata, (Array)ydata, (double)p.X, (double)p.Y);
                        if (idx != null) {
                            yi = idx[0];
                            xi = idx[1];
                            p.M = cdata.getDouble(yi * nx + xi);
                        }
                        cb = ls.findLegendBreak((Number)p.M);
                        cbs.add(cb);
                        points.add(p);
                    }
                }
                shape.setPoints(points);
                graphics.add(new Graphic((Shape)shape, (ColorBreak)cbs));
            }
        }
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createStreamlines(Array xdata, Array ydata, Array udata, Array vdata, int density, StreamlineBreak slb, boolean isUV) {
        GraphicCollection gc = new GraphicCollection();
        if (!isUV) {
            Array[] uvData = MeteoMath.ds2uv((Array)udata, (Array)vdata);
            udata = uvData[0];
            vdata = uvData[1];
        }
        double[] x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xdata);
        double[] y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ydata);
        if (x[1] - x[0] < 0.0) {
            ArrayUtils.reverse((double[])x);
            udata = udata.flip(1);
            vdata = vdata.flip(1);
        }
        if (y[1] - y[0] < 0.0) {
            ArrayUtils.reverse((double[])y);
            udata = udata.flip(0);
            vdata = vdata.flip(0);
        }
        double[][] u = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)udata);
        double[][] v = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)vdata);
        List streamlines = Contour.tracingStreamline((double[][])u, (double[][])v, (double[])x, (double[])y, (int)density);
        for (int i = 0; i < streamlines.size(); ++i) {
            PolyLine line = (PolyLine)streamlines.get(i);
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<PointD> pList = new ArrayList<PointD>();
            for (int j = 0; j < line.PointList.size(); ++j) {
                PointD aPoint = new PointD();
                aPoint.X = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                aPoint.Y = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue((double)density);
            gc.add(new Graphic((Shape)aPolyline, (ColorBreak)slb));
        }
        return gc;
    }

    public static GraphicCollection createStreamlines(Array xdata, Array ydata, Array udata, Array vdata, Array cdata, int density, LegendScheme ls, boolean isUV) {
        GraphicCollection gc = new GraphicCollection();
        if (!isUV) {
            Array[] uvData = MeteoMath.ds2uv((Array)udata, (Array)vdata);
            udata = uvData[0];
            vdata = uvData[1];
        }
        double[] x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xdata);
        double[] y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ydata);
        if (x[1] - x[0] < 0.0) {
            ArrayUtils.reverse((double[])x);
            udata = udata.flip(1);
            vdata = vdata.flip(1);
        }
        if (y[1] - y[0] < 0.0) {
            ArrayUtils.reverse((double[])y);
            udata = udata.flip(0);
            vdata = vdata.flip(0);
        }
        double[][] u = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)udata);
        double[][] v = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)vdata);
        List streamlines = Contour.tracingStreamline((double[][])u, (double[][])v, (double[])x, (double[])y, (int)density);
        int ny = u.length;
        int nx = u[0].length;
        double c = 0.0;
        for (int i = 0; i < streamlines.size(); ++i) {
            PolyLine line = (PolyLine)streamlines.get(i);
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<PointD> pList = new ArrayList<PointD>();
            ColorBreakCollection cbc = new ColorBreakCollection();
            for (int j = 0; j < line.PointList.size(); ++j) {
                PointD p = new PointD();
                p.X = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                p.Y = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                int[] idx = ArrayUtil.gridIndex((Array)xdata, (Array)ydata, (double)p.X, (double)p.Y);
                if (idx != null) {
                    int yi = idx[0];
                    int xi = idx[1];
                    c = cdata.getDouble(yi * nx + xi);
                }
                ColorBreak cb = ls.findLegendBreak((Number)c);
                cbc.add(cb);
                pList.add(p);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue((double)density);
            gc.add(new Graphic((Shape)aPolyline, (ColorBreak)cbc));
        }
        gc.setSingleLegend(false);
        gc.setLegendScheme(ls);
        return gc;
    }

    public static GraphicCollection3D streamLines(Array xa, Array ya, double z, Array ua, Array va, Array data, int density, String zDir, LegendScheme ls) {
        List streamlines;
        Object y;
        Object x;
        GraphicCollection3D graphics = new GraphicCollection3D();
        double[][] u = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)ua);
        double[][] v = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)va);
        if (xa.getRank() == 1) {
            x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
            y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
            streamlines = Contour.tracingStreamline((double[][])u, (double[][])v, (double[])x, (double[])y, (int)density);
        } else {
            xa = xa.copyIfView();
            ya = ya.copyIfView();
            x = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
            y = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
            streamlines = Contour.tracingStreamline((double[][])u, (double[][])v, (double[][])x, (double[][])y, (int)density);
        }
        int ny = u.length;
        int nx = u[0].length;
        ColorBreak cb = ls.getLegendBreak(0);
        if (data == null) {
            for (PolyLine line : streamlines) {
                PointZ p;
                int j;
                PolylineZShape shape = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                if (zDir.equals("x")) {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.Y = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                        p.Z = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                        p.X = z;
                        points.add(p);
                    }
                } else if (zDir.equals("y")) {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.X = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                        p.Z = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                        p.Y = z;
                        points.add(p);
                    }
                } else {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.X = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                        p.Y = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                        p.Z = z;
                        points.add(p);
                    }
                }
                shape.setPoints(points);
                graphics.add(new Graphic((Shape)shape, cb));
            }
        } else {
            data = data.copyIfView();
            for (PolyLine line : streamlines) {
                int xi;
                int yi;
                int[] idx;
                PointZ p;
                int j;
                PolylineZShape shape = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                ColorBreakCollection cbs = new ColorBreakCollection();
                if (zDir.equals("x")) {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.Y = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                        p.Z = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                        p.X = z;
                        idx = ArrayUtil.gridIndex((Array)xa, (Array)ya, (double)p.Y, (double)p.Z);
                        if (idx != null) {
                            yi = idx[0];
                            xi = idx[1];
                            p.M = data.getDouble(yi * nx + xi);
                        }
                        cb = ls.findLegendBreak((Number)p.M);
                        cbs.add(cb);
                        points.add(p);
                    }
                } else if (zDir.equals("y")) {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.X = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                        p.Z = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                        p.Y = z;
                        idx = ArrayUtil.gridIndex((Array)xa, (Array)ya, (double)p.X, (double)p.Z);
                        if (idx != null) {
                            yi = idx[0];
                            xi = idx[1];
                            p.M = data.getDouble(yi * nx + xi);
                        }
                        cb = ls.findLegendBreak((Number)p.M);
                        cbs.add(cb);
                        points.add(p);
                    }
                } else {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.X = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                        p.Y = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                        p.Z = z;
                        idx = ArrayUtil.gridIndex((Array)xa, (Array)ya, (double)p.X, (double)p.Y);
                        if (idx != null) {
                            yi = idx[0];
                            xi = idx[1];
                            p.M = data.getDouble(yi * nx + xi);
                        }
                        cb = ls.findLegendBreak((Number)p.M);
                        cbs.add(cb);
                        points.add(p);
                    }
                }
                shape.setPoints(points);
                graphics.add(new Graphic((Shape)shape, (ColorBreak)cbs));
            }
        }
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection3D streamLinesXY(Array xa, Array ya, List<Number> xySlice, Array ua, Array va, Array data, int density, LegendScheme ls) {
        List streamlines;
        Object y;
        Object x;
        GraphicCollection3D graphics = new GraphicCollection3D();
        double[][] u = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)ua);
        double[][] v = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)va);
        if (xa.getRank() == 1) {
            x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
            y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
            streamlines = Contour.tracingStreamline((double[][])u, (double[][])v, (double[])x, (double[])y, (int)density);
        } else {
            xa = xa.copyIfView();
            ya = ya.copyIfView();
            x = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
            y = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
            streamlines = Contour.tracingStreamline((double[][])u, (double[][])v, (double[][])x, (double[][])y, (int)density);
        }
        int ny = u.length;
        int nx = u[0].length;
        ColorBreak cb = ls.getLegendBreak(0);
        double x1 = xySlice.get(0).doubleValue();
        double y1 = xySlice.get(1).doubleValue();
        double x2 = xySlice.get(2).doubleValue();
        double y2 = xySlice.get(3).doubleValue();
        if (data == null) {
            for (PolyLine line : streamlines) {
                PolylineZShape shape = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                for (int j = 0; j < line.PointList.size(); ++j) {
                    PointZ p = new PointZ();
                    p.X = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                    p.Z = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                    p.Y = y1 + (y2 - y1) * (p.X - x1) / (x2 - x1);
                    points.add(p);
                }
                shape.setPoints(points);
                graphics.add(new Graphic((Shape)shape, cb));
            }
        } else {
            data = data.copyIfView();
            for (PolyLine line : streamlines) {
                PolylineZShape shape = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                ColorBreakCollection cbs = new ColorBreakCollection();
                for (int j = 0; j < line.PointList.size(); ++j) {
                    PointZ p = new PointZ();
                    p.X = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                    p.Z = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                    p.Y = y1 + (y2 - y1) * (p.X - x1) / (x2 - x1);
                    int[] idx = ArrayUtil.gridIndex((Array)xa, (Array)ya, (double)p.X, (double)p.Z);
                    if (idx != null) {
                        int yi = idx[0];
                        int xi = idx[1];
                        p.M = data.getDouble(yi * nx + xi);
                    }
                    cb = ls.findLegendBreak((Number)p.M);
                    cbs.add(cb);
                    points.add(p);
                }
                shape.setPoints(points);
                graphics.add(new Graphic((Shape)shape, (ColorBreak)cbs));
            }
        }
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection3D streamLines(Array xa, Array ya, Array za, Array ua, Array va, Array data, int density, LegendScheme ls) {
        List streamlines;
        Object y;
        Object x;
        GraphicCollection3D graphics = new GraphicCollection3D();
        double[][] u = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)ua);
        double[][] v = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)va);
        if (xa.getRank() == 1) {
            x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
            y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
            streamlines = Contour.tracingStreamline((double[][])u, (double[][])v, (double[])x, (double[])y, (int)density);
        } else {
            xa = xa.copyIfView();
            ya = ya.copyIfView();
            x = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
            y = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
            streamlines = Contour.tracingStreamline((double[][])u, (double[][])v, (double[][])x, (double[][])y, (int)density);
        }
        int ny = u.length;
        int nx = u[0].length;
        ColorBreak cb = ls.getLegendBreak(0);
        if (data == null) {
            for (PolyLine line : streamlines) {
                PolylineZShape shape = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                for (int j = 0; j < line.PointList.size(); ++j) {
                    PointZ p = new PointZ();
                    p.X = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                    p.Y = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                    int[] idx = ArrayUtil.gridIndex((Array)xa, (Array)ya, (double)p.Y, (double)p.Z);
                    if (idx != null) {
                        int yi = idx[0];
                        int xi = idx[1];
                        p.Z = za.getDouble(yi * nx + xi);
                    }
                    points.add(p);
                }
                shape.setPoints(points);
                graphics.add(new Graphic((Shape)shape, cb));
            }
        } else {
            data = data.copyIfView();
            for (PolyLine line : streamlines) {
                PolylineZShape shape = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                ColorBreakCollection cbs = new ColorBreakCollection();
                for (int j = 0; j < line.PointList.size(); ++j) {
                    PointZ p = new PointZ();
                    p.X = ((wcontour.global.PointD)line.PointList.get((int)j)).X;
                    p.Y = ((wcontour.global.PointD)line.PointList.get((int)j)).Y;
                    int[] idx = ArrayUtil.gridIndex((Array)xa, (Array)ya, (double)p.X, (double)p.Y);
                    if (idx != null) {
                        int yi = idx[0];
                        int xi = idx[1];
                        p.Z = za.getDouble(yi * nx + xi);
                        p.M = data.getDouble(yi * nx + xi);
                    }
                    cb = ls.findLegendBreak((Number)p.M);
                    cbs.add(cb);
                    points.add(p);
                }
                shape.setPoints(points);
                graphics.add(new Graphic((Shape)shape, (ColorBreak)cbs));
            }
        }
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static List<GraphicCollection3D> streamSlice(Array xa, Array ya, Array za, Array ua, Array va, Array wa, Array data, List<Number> xSlice, List<Number> ySlice, List<Number> zSlice, int density, LegendScheme ls) throws InvalidRangeException {
        Array xxa;
        GraphicCollection3D graphics;
        Array[] xy;
        Array zza;
        Array r;
        Array xva;
        Array xua;
        int[] shape;
        Array aa;
        int i;
        ArrayList<GraphicCollection3D> sgs = new ArrayList<GraphicCollection3D>();
        for (i = 0; i < xSlice.size(); ++i) {
            double x = xSlice.get(i).doubleValue();
            aa = xa;
            if (xa.getRank() == 3) {
                shape = xa.getShape();
                aa = xa.section(new int[]{0, 0, 0}, new int[]{1, 1, shape[2]});
            }
            xua = ArrayUtil.slice((Array)va, (int)2, (Array)aa, (double)x);
            xva = ArrayUtil.slice((Array)wa, (int)2, (Array)aa, (double)x);
            r = data == null ? null : ArrayUtil.slice((Array)data, (int)2, (Array)aa, (double)x);
            Array yya = ya.getRank() == 1 ? ya : ArrayUtil.slice((Array)ya, (int)2, (Array)aa, (double)x);
            zza = za.getRank() == 1 ? za : ArrayUtil.slice((Array)za, (int)2, (Array)aa, (double)x);
            if ((zza = zza.copyIfView()).getDouble(1) - zza.getDouble(0) != zza.getDouble(2) - zza.getDouble(1)) {
                xy = ArrayUtil.meshgrid((Array)yya, (Array)zza);
                yya = xy[0];
                zza = xy[1];
            }
            graphics = GraphicFactory.streamLines(yya, zza, x, xua, xva, r, density, "x", ls);
            sgs.add(graphics);
        }
        for (i = 0; i < ySlice.size(); ++i) {
            double y = ySlice.get(i).doubleValue();
            aa = ya;
            if (ya.getRank() == 3) {
                shape = ya.getShape();
                aa = ya.section(new int[]{0, 0, 0}, new int[]{1, shape[1], 1});
            }
            xua = ArrayUtil.slice((Array)ua, (int)1, (Array)aa, (double)y);
            xva = ArrayUtil.slice((Array)wa, (int)1, (Array)aa, (double)y);
            r = data == null ? null : ArrayUtil.slice((Array)data, (int)1, (Array)aa, (double)y);
            xxa = xa.getRank() == 1 ? xa : ArrayUtil.slice((Array)xa, (int)1, (Array)aa, (double)y);
            zza = za.getRank() == 1 ? za : ArrayUtil.slice((Array)za, (int)1, (Array)aa, (double)y);
            if ((zza = zza.copyIfView()).getDouble(1) - zza.getDouble(0) != zza.getDouble(2) - zza.getDouble(1)) {
                xy = ArrayUtil.meshgrid((Array)xxa, (Array)zza);
                xxa = xy[0];
                zza = xy[1];
            }
            graphics = GraphicFactory.streamLines(xxa, zza, y, xua, xva, r, density, "y", ls);
            sgs.add(graphics);
        }
        for (i = 0; i < zSlice.size(); ++i) {
            double z = zSlice.get(i).doubleValue();
            aa = za;
            if (za.getRank() == 3) {
                shape = za.getShape();
                aa = za.section(new int[]{0, 0, 0}, new int[]{shape[0], 1, 1});
            }
            xua = ArrayUtil.slice((Array)ua, (int)0, (Array)aa, (double)z);
            xva = ArrayUtil.slice((Array)va, (int)0, (Array)aa, (double)z);
            r = data == null ? null : ArrayUtil.slice((Array)data, (int)0, (Array)aa, (double)z);
            xxa = xa.getRank() == 1 ? xa : ArrayUtil.slice((Array)xa, (int)0, (Array)aa, (double)z);
            Array yya = ya.getRank() == 1 ? ya : ArrayUtil.slice((Array)ya, (int)0, (Array)aa, (double)z);
            graphics = GraphicFactory.streamLines(xxa, yya, z, xua, xva, r, density, "z", ls);
            sgs.add(graphics);
        }
        return sgs;
    }

    public static List<GraphicCollection3D> streamSlice(Array xa, Array ya, Array za, Array ua, Array va, Array wa, Array data, List<Integer> zSliceIndex, int density, LegendScheme ls) throws InvalidRangeException {
        ArrayList<GraphicCollection3D> sgs = new ArrayList<GraphicCollection3D>();
        for (int i = 0; i < zSliceIndex.size(); ++i) {
            GraphicCollection3D graphics;
            Array yya;
            int zIdx = zSliceIndex.get(i);
            Array aa = za;
            Array xua = ArrayUtil.slice((Array)ua, (int)0, (int)zIdx);
            Array xva = ArrayUtil.slice((Array)va, (int)0, (int)zIdx);
            Array r = data == null ? null : ArrayUtil.slice((Array)data, (int)0, (int)zIdx);
            Array xxa = xa.getRank() == 1 ? xa : ArrayUtil.slice((Array)xa, (int)0, (int)zIdx);
            Array array = yya = ya.getRank() == 1 ? ya : ArrayUtil.slice((Array)ya, (int)0, (int)zIdx);
            if (za.getRank() == 1) {
                double z = za.getDouble(zIdx);
                graphics = GraphicFactory.streamLines(xxa, yya, z, xua, xva, r, density, "z", ls);
            } else {
                Array zza = ArrayUtil.slice((Array)za, (int)0, (int)zIdx);
                zza = zza.copyIfView();
                graphics = GraphicFactory.streamLines(xxa, yya, zza, xua, xva, r, density, ls);
            }
            sgs.add(graphics);
        }
        return sgs;
    }

    public static GraphicCollection3D streamSlice(Array xa, Array ya, Array za, Array ua, Array va, Array wa, Array data, List<Number> xySlice, InterpolationMethod method, int density, LegendScheme ls) throws InvalidRangeException {
        Array[] xyu = InterpUtil.sliceXY((Array)xa, (Array)ya, (Array)za, (Array)ua, xySlice, (InterpolationMethod)method);
        Array xua = xyu[0];
        Array[] xyv = InterpUtil.sliceXY((Array)xa, (Array)ya, (Array)za, (Array)va, xySlice, (InterpolationMethod)method);
        Array xva = xyv[0];
        Array[] wds = MeteoMath.uv2ds((Array)xua, (Array)xva);
        double x1 = xySlice.get(0).doubleValue();
        double y1 = xySlice.get(1).doubleValue();
        double x2 = xySlice.get(2).doubleValue();
        double y2 = xySlice.get(3).doubleValue();
        double angle = Math.atan2(y2 - y1, x2 - x1) * 180.0 / Math.PI;
        Array wd = ArrayMath.add((Array)wds[0], (Number)angle);
        Array[] uv = MeteoMath.ds2uv((Array)wd, (Array)wds[1]);
        xua = uv[0];
        Array[] xyw = InterpUtil.sliceXY((Array)xa, (Array)ya, (Array)za, (Array)wa, xySlice, (InterpolationMethod)method);
        Array xwa = xyw[0];
        Array r = data == null ? null : InterpUtil.sliceXY((Array)xa, (Array)ya, (Array)za, (Array)data, xySlice, (InterpolationMethod)method)[0];
        Array yya = xyu[1];
        Array zza = za.getRank() == 1 ? za : ArrayUtil.slice((Array)za, (int)2, (int)0);
        GraphicCollection3D graphics = GraphicFactory.streamLinesXY(yya, zza, xySlice, xua, xwa, r, density, ls);
        return graphics;
    }

    public static GraphicCollection[] createPieArcs(Array xdata, List<Color> colors, List<String> labels, float startAngle, List<Number> explode, Font labelFont, Color labelColor, float labelDis, String autopct, float pctDis, float radius, HashMap wedgeprops) {
        double dx;
        GraphicCollection gc = new GraphicCollection();
        GraphicCollection lgc = new GraphicCollection();
        GraphicCollection pgc = new GraphicCollection();
        double sum = ArrayMath.sum((Array)xdata).doubleValue();
        String pct = null;
        LegendScheme ls = new LegendScheme(ShapeTypes.POLYGON);
        Boolean drawEdge = wedgeprops.get("drawedge") == null ? null : (Boolean)wedgeprops.get("drawedge");
        Color edgeColor = wedgeprops.get("edgecolor") == null ? null : (Color)wedgeprops.get("edgecolor");
        Float lineWidth = wedgeprops.get("linewidth") == null ? null : Float.valueOf(Float.parseFloat(String.valueOf(wedgeprops.get("linewidth"))));
        Float wedgeWidth = wedgeprops.get("width") == null ? null : Float.valueOf(Float.parseFloat(String.valueOf(wedgeprops.get("width"))));
        IndexIterator xIter = xdata.getIndexIterator();
        int i = 0;
        while (xIter.hasNext()) {
            double ldy;
            double ldx;
            ChartText ps;
            String label;
            double dy;
            double v = xIter.getDoubleNext();
            if (Double.isNaN(v)) continue;
            if (sum > 1.0) {
                v /= sum;
            }
            float sweepAngle = (float)(360.0 * v);
            ArcShape aShape = new ArcShape();
            aShape.setStartAngle(startAngle);
            aShape.setSweepAngle(sweepAngle);
            float angle = startAngle + sweepAngle / 2.0f;
            if (explode == null) {
                dx = 0.0;
                dy = 0.0;
            } else {
                float ex = explode.get(i).floatValue();
                aShape.setExplode(ex);
                dx = (double)(radius * ex) * Math.cos((double)angle * Math.PI / 180.0);
                dy = (double)(radius * ex) * Math.sin((double)angle * Math.PI / 180.0);
            }
            ArrayList<PointD> points = new ArrayList<PointD>();
            points.add(new PointD((double)(-radius) + dx, (double)(-radius) + dy));
            points.add(new PointD((double)(-radius) + dx, (double)radius + dy));
            points.add(new PointD((double)radius + dx, (double)radius + dy));
            points.add(new PointD((double)radius + dx, (double)(-radius) + dy));
            points.add(new PointD(dx, dy));
            aShape.setPoints(points);
            if (wedgeWidth != null) {
                aShape.setWedgeWidth(wedgeWidth);
            }
            PolygonBreak pgb = new PolygonBreak();
            pgb.setColor(colors.get(i));
            if (drawEdge != null) {
                pgb.setDrawOutline(drawEdge.booleanValue());
            }
            if (edgeColor != null) {
                pgb.setOutlineColor(edgeColor);
            }
            if (lineWidth != null) {
                pgb.setOutlineSize(lineWidth.floatValue());
            }
            if (labels == null) {
                label = autopct == null ? "" : String.format(autopct, v * 100.0);
            } else {
                label = labels.get(i);
                if (autopct != null) {
                    pct = String.format(autopct, v * 100.0);
                }
            }
            pgb.setCaption(label);
            Graphic graphic = new Graphic((Shape)aShape, (ColorBreak)pgb);
            gc.add(graphic);
            ls.addLegendBreak((ColorBreak)pgb);
            if (!label.isEmpty()) {
                ps = new ChartText();
                ldx = dx + (double)(radius * labelDis) * Math.cos((double)angle * Math.PI / 180.0);
                ldy = dy + (double)(radius * labelDis) * Math.sin((double)angle * Math.PI / 180.0);
                ps.setPoint(ldx, ldy);
                ps.setText(label);
                ps.setFont(labelFont);
                ps.setColor(labelColor);
                if (angle > 90.0f && angle < 270.0f) {
                    ps.setXAlign(XAlign.RIGHT);
                }
                if (angle > 180.0f && angle < 360.0f) {
                    ps.setYAlign(YAlign.TOP);
                }
                if (angle == 0.0f || angle == 180.0f) {
                    ps.setYAlign(YAlign.CENTER);
                } else if (angle == 90.0f || angle == 270.0f) {
                    ps.setXAlign(XAlign.CENTER);
                }
                lgc.add(new Graphic((Shape)ps, new ColorBreak()));
            }
            if (pct != null) {
                ps = new ChartText();
                ldx = dx + (double)(radius * pctDis) * Math.cos((double)angle * Math.PI / 180.0);
                ldy = dy + (double)(radius * pctDis) * Math.sin((double)angle * Math.PI / 180.0);
                ps.setPoint(ldx, ldy);
                ps.setText(pct);
                ps.setFont(labelFont);
                ps.setColor(labelColor);
                ps.setXAlign(XAlign.CENTER);
                ps.setYAlign(YAlign.CENTER);
                pgc.add(new Graphic((Shape)ps, new ColorBreak()));
            }
            startAngle += sweepAngle;
            ++i;
        }
        gc.setSingleLegend(false);
        gc.setLegendScheme(ls);
        gc.getLabelSet().setLabelFont(labelFont);
        gc.getLabelSet().setLabelColor(labelColor);
        dx = (double)radius * 0.1;
        if (labels != null || autopct != null) {
            Extent ext = gc.getExtent().extend(dx, dx);
            gc.setExtent(ext);
        }
        if (pct == null) {
            if (lgc.isEmpty()) {
                return new GraphicCollection[]{gc};
            }
            return new GraphicCollection[]{gc, lgc};
        }
        if (lgc.isEmpty()) {
            return new GraphicCollection[]{gc, pgc};
        }
        return new GraphicCollection[]{gc, lgc, pgc};
    }

    public static GraphicCollection createBox(List<Array> xdata, List<Number> positions, List<Number> widths, boolean showcaps, boolean showfliers, boolean showmeans, boolean showmedians, PolygonBreak boxBreak, ColorBreak medianBreak, PolylineBreak whiskerBreak, PolylineBreak capBreak, ColorBreak meanBreak, PointBreak flierBreak) {
        int i;
        GraphicCollection gc = new GraphicCollection();
        int n = xdata.size();
        if (positions == null) {
            positions = new ArrayList<Number>();
            for (i = 0; i < n; ++i) {
                positions.add(i + 1);
            }
        }
        if (widths == null) {
            widths = new ArrayList<Number>();
            for (i = 0; i < n; ++i) {
                widths.add(0.5);
            }
        }
        if (boxBreak == null) {
            boxBreak = new PolygonBreak();
            boxBreak.setDrawFill(false);
            boxBreak.setOutlineColor(Color.blue);
        }
        if (medianBreak == null) {
            medianBreak = new PolylineBreak();
            medianBreak.setColor(Color.red);
        }
        if (whiskerBreak == null) {
            whiskerBreak = new PolylineBreak();
            whiskerBreak.setColor(Color.black);
            whiskerBreak.setStyle(LineStyles.DASH);
        }
        if (capBreak == null) {
            capBreak = new PolylineBreak();
            capBreak.setColor(Color.black);
        }
        if (flierBreak == null) {
            flierBreak = new PointBreak();
            flierBreak.setStyle(PointStyle.PLUS);
        }
        if (meanBreak == null) {
            meanBreak = new PointBreak();
            ((PointBreak)meanBreak).setStyle(PointStyle.SQUARE);
            ((PointBreak)meanBreak).setColor(Color.red);
            ((PointBreak)meanBreak).setOutlineColor(Color.black);
        }
        for (int i2 = 0; i2 < n; ++i2) {
            Array a = xdata.get(i2);
            if (Double.isNaN(ArrayMath.min((Array)a).doubleValue())) continue;
            double v = positions.get(i2).doubleValue();
            double width = widths.get(i2).doubleValue();
            double q1 = Statistics.quantile((Array)a, (int)1);
            double q3 = Statistics.quantile((Array)a, (int)3);
            double median = Statistics.quantile((Array)a, (int)2);
            double mind = ArrayMath.getMinimum((Array)a);
            double maxd = ArrayMath.getMaximum((Array)a);
            double mino = q1 - (q3 - q1) * 1.5;
            double maxo = q3 + (q3 - q1) * 1.5;
            ArrayList<PointD> pList = new ArrayList<PointD>();
            pList.add(new PointD(v - width * 0.5, q1));
            pList.add(new PointD(v - width * 0.5, q3));
            pList.add(new PointD(v + width * 0.5, q3));
            pList.add(new PointD(v + width * 0.5, q1));
            pList.add(new PointD(v - width * 0.5, q1));
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(pList);
            gc.add(new Graphic((Shape)pgs, (ColorBreak)boxBreak));
            if (showmedians) {
                if (medianBreak.getBreakType() == BreakTypes.POLYLINE_BREAK) {
                    pList = new ArrayList();
                    pList.add(new PointD(v - width * 0.5, median));
                    pList.add(new PointD(v + width * 0.5, median));
                    PolylineShape pls = new PolylineShape();
                    pls.setPoints(pList);
                    gc.add(new Graphic((Shape)pls, medianBreak));
                } else {
                    PointShape ps = new PointShape();
                    ps.setPoint(new PointD(v, median));
                    gc.add(new Graphic((Shape)ps, medianBreak));
                }
            }
            double min = Math.max(mino, mind);
            pList = new ArrayList();
            pList.add(new PointD(v, q1));
            pList.add(new PointD(v, min));
            PolylineShape pls = new PolylineShape();
            pls.setPoints(pList);
            gc.add(new Graphic((Shape)pls, (ColorBreak)whiskerBreak));
            if (showcaps) {
                pList = new ArrayList();
                pList.add(new PointD(v - width * 0.25, min));
                pList.add(new PointD(v + width * 0.25, min));
                pls = new PolylineShape();
                pls.setPoints(pList);
                gc.add(new Graphic((Shape)pls, (ColorBreak)capBreak));
            }
            if (showfliers && mino > mind) {
                int j = 0;
                while ((long)j < a.getSize()) {
                    if (a.getDouble(j) < mino) {
                        PointShape ps = new PointShape();
                        ps.setPoint(new PointD(v, a.getDouble(j)));
                        gc.add(new Graphic((Shape)ps, (ColorBreak)flierBreak));
                    }
                    ++j;
                }
            }
            double max = Math.min(maxo, maxd);
            pList = new ArrayList();
            pList.add(new PointD(v, q3));
            pList.add(new PointD(v, max));
            pls = new PolylineShape();
            pls.setPoints(pList);
            gc.add(new Graphic((Shape)pls, (ColorBreak)whiskerBreak));
            if (showcaps) {
                pList = new ArrayList();
                pList.add(new PointD(v - width * 0.25, max));
                pList.add(new PointD(v + width * 0.25, max));
                pls = new PolylineShape();
                pls.setPoints(pList);
                gc.add(new Graphic((Shape)pls, (ColorBreak)capBreak));
            }
            if (showfliers && maxo < maxd) {
                int j = 0;
                while ((long)j < a.getSize()) {
                    if (a.getDouble(j) > maxo) {
                        PointShape ps = new PointShape();
                        ps.setPoint(new PointD(v, a.getDouble(j)));
                        gc.add(new Graphic((Shape)ps, (ColorBreak)flierBreak));
                    }
                    ++j;
                }
            }
            if (!showmeans) continue;
            double mean = ArrayMath.mean((Array)a);
            if (meanBreak.getBreakType() == BreakTypes.POINT_BREAK) {
                PointShape ps = new PointShape();
                ps.setPoint(new PointD(v, mean));
                gc.add(new Graphic((Shape)ps, meanBreak));
                continue;
            }
            pList = new ArrayList();
            pList.add(new PointD(v - width * 0.5, mean));
            pList.add(new PointD(v + width * 0.5, mean));
            pls = new PolylineShape();
            pls.setPoints(pList);
            gc.add(new Graphic((Shape)pls, meanBreak));
        }
        gc.setSingleLegend(false);
        return gc;
    }

    public static GraphicCollection createHBox(List<Array> xdata, List<Number> positions, List<Number> widths, boolean showcaps, boolean showfliers, boolean showmeans, boolean showmedians, PolygonBreak boxBreak, ColorBreak medianBreak, PolylineBreak whiskerBreak, PolylineBreak capBreak, ColorBreak meanBreak, PointBreak flierBreak) {
        int i;
        GraphicCollection gc = new GraphicCollection();
        int n = xdata.size();
        if (positions == null) {
            positions = new ArrayList<Number>();
            for (i = 0; i < n; ++i) {
                positions.add(i + 1);
            }
        }
        if (widths == null) {
            widths = new ArrayList<Number>();
            for (i = 0; i < n; ++i) {
                widths.add(0.5);
            }
        }
        if (boxBreak == null) {
            boxBreak = new PolygonBreak();
            boxBreak.setDrawFill(false);
            boxBreak.setOutlineColor(Color.blue);
        }
        if (medianBreak == null) {
            medianBreak = new PolylineBreak();
            medianBreak.setColor(Color.red);
        }
        if (whiskerBreak == null) {
            whiskerBreak = new PolylineBreak();
            whiskerBreak.setColor(Color.black);
            whiskerBreak.setStyle(LineStyles.DASH);
        }
        if (capBreak == null) {
            capBreak = new PolylineBreak();
            capBreak.setColor(Color.black);
        }
        if (flierBreak == null) {
            flierBreak = new PointBreak();
            flierBreak.setStyle(PointStyle.PLUS);
        }
        if (meanBreak == null) {
            meanBreak = new PointBreak();
            ((PointBreak)meanBreak).setStyle(PointStyle.SQUARE);
            ((PointBreak)meanBreak).setColor(Color.red);
            ((PointBreak)meanBreak).setOutlineColor(Color.black);
        }
        for (int i2 = 0; i2 < n; ++i2) {
            Array a = xdata.get(i2);
            if (Double.isNaN(ArrayMath.min((Array)a).doubleValue())) continue;
            double v = positions.get(i2).doubleValue();
            double width = widths.get(i2).doubleValue();
            double q1 = Statistics.quantile((Array)a, (int)1);
            double q3 = Statistics.quantile((Array)a, (int)3);
            double median = Statistics.quantile((Array)a, (int)2);
            double mind = ArrayMath.getMinimum((Array)a);
            double maxd = ArrayMath.getMaximum((Array)a);
            double mino = q1 - (q3 - q1) * 1.5;
            double maxo = q3 + (q3 - q1) * 1.5;
            ArrayList<PointD> pList = new ArrayList<PointD>();
            pList.add(new PointD(q1, v - width * 0.5));
            pList.add(new PointD(q3, v - width * 0.5));
            pList.add(new PointD(q3, v + width * 0.5));
            pList.add(new PointD(q1, v + width * 0.5));
            pList.add(new PointD(q1, v - width * 0.5));
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(pList);
            gc.add(new Graphic((Shape)pgs, (ColorBreak)boxBreak));
            if (showmedians) {
                if (medianBreak.getBreakType() == BreakTypes.POLYLINE_BREAK) {
                    pList = new ArrayList();
                    pList.add(new PointD(median, v - width * 0.5));
                    pList.add(new PointD(median, v + width * 0.5));
                    PolylineShape pls = new PolylineShape();
                    pls.setPoints(pList);
                    gc.add(new Graphic((Shape)pls, medianBreak));
                } else {
                    PointShape ps = new PointShape();
                    ps.setPoint(new PointD(median, v));
                    gc.add(new Graphic((Shape)ps, medianBreak));
                }
            }
            double min = Math.max(mino, mind);
            pList = new ArrayList();
            pList.add(new PointD(q1, v));
            pList.add(new PointD(min, v));
            PolylineShape pls = new PolylineShape();
            pls.setPoints(pList);
            gc.add(new Graphic((Shape)pls, (ColorBreak)whiskerBreak));
            if (showcaps) {
                pList = new ArrayList();
                pList.add(new PointD(min, v - width * 0.25));
                pList.add(new PointD(min, v + width * 0.25));
                pls = new PolylineShape();
                pls.setPoints(pList);
                gc.add(new Graphic((Shape)pls, (ColorBreak)capBreak));
            }
            if (showfliers && mino > mind) {
                int j = 0;
                while ((long)j < a.getSize()) {
                    if (a.getDouble(j) < mino) {
                        PointShape ps = new PointShape();
                        ps.setPoint(new PointD(a.getDouble(j), v));
                        gc.add(new Graphic((Shape)ps, (ColorBreak)flierBreak));
                    }
                    ++j;
                }
            }
            double max = Math.min(maxo, maxd);
            pList = new ArrayList();
            pList.add(new PointD(q3, v));
            pList.add(new PointD(max, v));
            pls = new PolylineShape();
            pls.setPoints(pList);
            gc.add(new Graphic((Shape)pls, (ColorBreak)whiskerBreak));
            if (showcaps) {
                pList = new ArrayList();
                pList.add(new PointD(max, v - width * 0.25));
                pList.add(new PointD(max, v + width * 0.25));
                pls = new PolylineShape();
                pls.setPoints(pList);
                gc.add(new Graphic((Shape)pls, (ColorBreak)capBreak));
            }
            if (showfliers && maxo < maxd) {
                int j = 0;
                while ((long)j < a.getSize()) {
                    if (a.getDouble(j) > maxo) {
                        PointShape ps = new PointShape();
                        ps.setPoint(new PointD(a.getDouble(j), v));
                        gc.add(new Graphic((Shape)ps, (ColorBreak)flierBreak));
                    }
                    ++j;
                }
            }
            if (!showmeans) continue;
            double mean = ArrayMath.mean((Array)a);
            if (meanBreak.getBreakType() == BreakTypes.POINT_BREAK) {
                PointShape ps = new PointShape();
                ps.setPoint(new PointD(mean, v));
                gc.add(new Graphic((Shape)ps, meanBreak));
                continue;
            }
            pList = new ArrayList();
            pList.add(new PointD(mean, v - width * 0.5));
            pList.add(new PointD(mean, v + width * 0.5));
            pls = new PolylineShape();
            pls.setPoints(pList);
            gc.add(new Graphic((Shape)pls, meanBreak));
        }
        gc.setSingleLegend(false);
        return gc;
    }

    public static void polarToCartesian(GraphicCollection graphics) {
        for (int m = 0; m < graphics.getNumGraphics(); ++m) {
            Graphic graphic = graphics.get(m);
            for (int i = 0; i < graphic.getNumGraphics(); ++i) {
                Graphic gg = graphic.getGraphicN(i);
                Shape shape = gg.getShape();
                ArrayList<PointD> points = new ArrayList<PointD>();
                for (PointD p : shape.getPoints()) {
                    double[] xy = MIMath.polarToCartesian((double)p.X, (double)p.Y);
                    points.add(new PointD(xy[0], xy[1]));
                }
                shape.setPoints(points);
            }
        }
        graphics.updateExtent();
    }

    public static void polarToCartesian(Graphic graphic, double bottom) {
        if (graphic instanceof GraphicCollection) {
            GraphicFactory.polarToCartesian((GraphicCollection)graphic, bottom);
        } else {
            for (int i = 0; i < graphic.getNumGraphics(); ++i) {
                Graphic gg = graphic.getGraphicN(i);
                Shape shape = gg.getShape();
                ArrayList<PointD> points = new ArrayList<PointD>();
                for (PointD p : shape.getPoints()) {
                    double[] xy = MIMath.polarToCartesian((double)p.X, (double)(p.Y + bottom));
                    points.add(new PointD(xy[0], xy[1]));
                }
                shape.setPoints(points);
                gg.setShape(shape);
            }
        }
    }

    public static void polarToCartesian(GraphicCollection graphics, double bottom) {
        for (int m = 0; m < graphics.getNumGraphics(); ++m) {
            Graphic graphic = graphics.get(m);
            for (int i = 0; i < graphic.getNumGraphics(); ++i) {
                Graphic gg = graphic.getGraphicN(i);
                Shape shape = gg.getShape();
                ArrayList<PointD> points = new ArrayList<PointD>();
                for (PointD p : shape.getPoints()) {
                    double[] xy = MIMath.polarToCartesian((double)p.X, (double)(p.Y + bottom));
                    points.add(new PointD(xy[0], xy[1]));
                }
                shape.setPoints(points);
            }
        }
        graphics.updateExtent();
    }

    private static int findIndex(double[] values, double v) {
        int idx = -1;
        for (int i = 0; i < values.length; ++i) {
            if (i == values.length - 1) {
                if (v != values[i]) continue;
                idx = i;
                break;
            }
            if (v != values[i] && !(v < values[i + 1])) continue;
            idx = i;
            break;
        }
        return idx;
    }

    public static MeshGraphic surface(Array xa, Array ya, Array za, LegendScheme ls) {
        return GraphicFactory.surface(xa, ya, za, za, ls);
    }

    public static MeshGraphic surface(Array xa, Array ya, Array za, Array va, LegendScheme ls) {
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        va = va.copyIfView();
        MeshGraphic surfaceGraphic = new MeshGraphic();
        int[] shape = xa.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        float[] vertexPosition = new float[rowNum * colNum * 3];
        if (va.getRank() == 3) {
            float[] vertexColor = new float[rowNum * colNum * 4];
            Index index = va.getIndex();
            if (va.getDataType() == DataType.INT) {
                for (int i = 0; i < rowNum; ++i) {
                    for (int j = 0; j < colNum; ++j) {
                        int idx = i * colNum + j;
                        vertexPosition[idx * 3] = xa.getFloat(idx);
                        vertexPosition[idx * 3 + 1] = ya.getFloat(idx);
                        vertexPosition[idx * 3 + 2] = za.getFloat(idx);
                        index.set0(i);
                        index.set1(j);
                        Color color = new Color(va.getInt(index.set2(0)), va.getInt(index.set2(1)), va.getInt(index.set2(2)));
                        System.arraycopy(color.getRGBComponents(null), 0, vertexColor, idx * 4, 4);
                    }
                }
            } else {
                for (int i = 0; i < rowNum; ++i) {
                    for (int j = 0; j < colNum; ++j) {
                        int idx = i * colNum + j;
                        vertexPosition[idx * 3] = xa.getFloat(idx);
                        vertexPosition[idx * 3 + 1] = ya.getFloat(idx);
                        vertexPosition[idx * 3 + 2] = za.getFloat(idx);
                        index.set0(i);
                        index.set1(j);
                        Color color = new Color(va.getFloat(index.set2(0)), va.getFloat(index.set2(1)), va.getFloat(index.set2(2)));
                        System.arraycopy(color.getRGBComponents(null), 0, vertexColor, idx * 4, 4);
                    }
                }
            }
            surfaceGraphic.setVertexPosition(vertexPosition, rowNum);
            surfaceGraphic.setVertexColor(vertexColor);
            surfaceGraphic.setLegendScheme(ls);
        } else {
            float[] vertexValue = new float[rowNum * colNum];
            for (int i = 0; i < rowNum; ++i) {
                for (int j = 0; j < colNum; ++j) {
                    int idx = i * colNum + j;
                    vertexValue[idx] = va.getFloat(idx);
                    vertexPosition[idx * 3] = xa.getFloat(idx);
                    vertexPosition[idx * 3 + 1] = ya.getFloat(idx);
                    vertexPosition[idx * 3 + 2] = za.getFloat(idx);
                }
            }
            surfaceGraphic.setVertexPosition(vertexPosition, rowNum);
            surfaceGraphic.setVertexValue(vertexValue);
            surfaceGraphic.setLegendScheme(ls);
        }
        return surfaceGraphic;
    }

    public static MeshGraphic geoSurface(BufferedImage image, Extent extent, double offset, double xShift, int nLon, int nLat) throws IOException {
        Array lon = ArrayUtil.lineSpace((Number)(extent.minX + xShift), (Number)(extent.maxX + xShift), (int)(nLon + 1), (boolean)true);
        Array lat = ArrayUtil.lineSpace((Number)extent.minY, (Number)extent.maxY, (int)(nLat + 1), (boolean)true);
        lat = lat.flip(0).copy();
        Array[] lonlat = ArrayUtil.meshgrid((Array)lon, (Array)lat);
        lon = lonlat[0];
        lat = lonlat[1];
        Array alt = ArrayUtil.zeros((int[])lon.getShape(), (DataType)DataType.FLOAT);
        alt = ArrayMath.add((Array)alt, (Number)offset);
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POLYGON, (Color)Color.cyan, (float)1.0f);
        ((PolygonBreak)ls.getLegendBreak(0)).setDrawOutline(false);
        ((PolygonBreak)ls.getLegendBreak(0)).setOutlineColor(Color.white);
        MeshGraphic graphic = GraphicFactory.surface(lon, lat, alt, ls);
        graphic.setImage(image);
        return graphic;
    }

    public static MeshGraphic geoSurface(BufferedImage image, Extent imageExtent, double offset, double xShift, int nLon, int nLat, ProjectionInfo toProj) throws IOException {
        Extent extent = (Extent)imageExtent.clone();
        double width = extent.getWidth();
        double height = extent.getHeight();
        float cutoff = toProj.getCutoff();
        double cLon = toProj.getCenterLon();
        boolean extentChanged = false;
        switch (toProj.getProjectionName()) {
            case Lambert_Conformal_Conic: {
                if (!(extent.minY < (double)cutoff)) break;
                extent.minY = cutoff;
                extentChanged = true;
                break;
            }
            case North_Polar_Stereographic_Azimuthal: {
                if (!(extent.minY < (double)cutoff)) break;
                extent.minY = cutoff;
                extentChanged = true;
                break;
            }
            case South_Polar_Stereographic_Azimuthal: {
                if (!(extent.maxY > (double)cutoff)) break;
                extent.maxY = cutoff;
                extentChanged = true;
                break;
            }
            case Mercator: {
                if (extent.maxY > (double)cutoff) {
                    extent.maxY = cutoff;
                    extentChanged = true;
                }
                if (!(extent.minY < (double)(-cutoff))) break;
                extent.minY = -cutoff;
                extentChanged = true;
            }
        }
        if (cLon != 0.0) {
            extent.minX = cLon - 180.0 + 0.1;
            extent.maxX = cLon + 180.0 - 0.1;
            extentChanged = true;
        }
        if (extentChanged) {
            int x = (int)((extent.minX - imageExtent.minX) / width * (double)image.getWidth());
            int y = (int)((imageExtent.maxY - extent.maxY) / height * (double)image.getHeight());
            int w = (int)(extent.getWidth() / imageExtent.getWidth() * (double)image.getWidth());
            int h = (int)(extent.getHeight() / imageExtent.getHeight() * (double)image.getHeight());
            BufferedImage nImage = new BufferedImage(w, h, image.getType());
            if (cLon == 0.0) {
                int[] rgb = new int[w * h];
                rgb = image.getRGB(x, y, w, h, rgb, 0, w);
                nImage.setRGB(0, 0, w, h, rgb, 0, w);
            } else if (cLon > 0.0) {
                int w1 = (int)((imageExtent.maxX - extent.minX) / extent.getWidth() * (double)w);
                int[] rgb1 = new int[w1 * h];
                rgb1 = image.getRGB(x, y, w1, h, rgb1, 0, w1);
                int[] rgb2 = new int[(w - w1) * h];
                rgb2 = image.getRGB(0, y, w - w1, h, rgb2, 0, w - w1);
                nImage.setRGB(0, 0, w1, h, rgb1, 0, w1);
                nImage.setRGB(w1, 0, w - w1, h, rgb2, 0, w - w1);
            } else {
                int w1 = (int)((extent.maxX - imageExtent.minX) / extent.getWidth() * (double)w);
                int[] rgb1 = new int[w1 * h];
                rgb1 = image.getRGB(x, y, w1, h, rgb1, 0, w1);
                int[] rgb2 = new int[(w - w1) * h];
                rgb2 = image.getRGB(x + w1, y, w - w1, h, rgb2, 0, w - w1);
                nImage.setRGB(w - w1, 0, w1, h, rgb1, 0, w1);
                nImage.setRGB(0, 0, w - w1, h, rgb2, 0, w - w1);
            }
            image = nImage;
        }
        Array lon = ArrayUtil.lineSpace((Number)(extent.minX + xShift), (Number)(extent.maxX + xShift), (int)(nLon + 1), (boolean)true);
        Array lat = ArrayUtil.lineSpace((Number)extent.minY, (Number)extent.maxY, (int)(nLat + 1), (boolean)true);
        lat = lat.flip(0).copy();
        Array[] lonlat = ArrayUtil.meshgrid((Array)lon, (Array)lat);
        lon = lonlat[0];
        lat = lonlat[1];
        Array alt = ArrayUtil.zeros((int[])lon.getShape(), (DataType)DataType.FLOAT);
        alt = ArrayMath.add((Array)alt, (Number)offset);
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POLYGON, (Color)Color.cyan, (float)1.0f);
        ((PolygonBreak)ls.getLegendBreak(0)).setDrawOutline(false);
        ((PolygonBreak)ls.getLegendBreak(0)).setOutlineColor(Color.white);
        MeshGraphic graphic = GraphicFactory.surface(lon, lat, alt, ls);
        graphic.setImage(image);
        return graphic;
    }

    public static MeshGraphic geoSurface(BufferedImage image, Extent imageExtent, double offset, double xShift, int nLon, int nLat, ProjectionInfo toProj, List<Number> limits) throws IOException {
        Extent extent = new Extent(limits.get(0).doubleValue(), limits.get(1).doubleValue(), limits.get(2).doubleValue(), limits.get(3).doubleValue());
        double width = imageExtent.getWidth();
        double height = imageExtent.getHeight();
        int x = (int)((extent.minX - imageExtent.minX) / width * (double)image.getWidth());
        int y = (int)((imageExtent.maxY - extent.maxY) / height * (double)image.getHeight());
        int w = (int)(extent.getWidth() / imageExtent.getWidth() * (double)image.getWidth());
        int h = (int)(extent.getHeight() / imageExtent.getHeight() * (double)image.getHeight());
        BufferedImage nImage = new BufferedImage(w, h, image.getType());
        Graphics2D g2 = nImage.createGraphics();
        g2.drawImage((Image)image.getSubimage(x, y, w, h), 0, 0, null);
        image = nImage;
        Array lon = ArrayUtil.lineSpace((Number)(extent.minX + xShift), (Number)(extent.maxX + xShift), (int)(nLon + 1), (boolean)true);
        Array lat = ArrayUtil.lineSpace((Number)extent.minY, (Number)extent.maxY, (int)(nLat + 1), (boolean)true);
        lat = lat.flip(0).copy();
        Array[] lonlat = ArrayUtil.meshgrid((Array)lon, (Array)lat);
        lon = lonlat[0];
        lat = lonlat[1];
        Array alt = ArrayUtil.zeros((int[])lon.getShape(), (DataType)DataType.FLOAT);
        alt = ArrayMath.add((Array)alt, (Number)offset);
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POLYGON, (Color)Color.cyan, (float)1.0f);
        ((PolygonBreak)ls.getLegendBreak(0)).setDrawOutline(false);
        ((PolygonBreak)ls.getLegendBreak(0)).setOutlineColor(Color.white);
        MeshGraphic graphic = GraphicFactory.surface(lon, lat, alt, ls);
        graphic.setImage(image);
        return graphic;
    }

    public static List<MeshGraphic> slice(Array data, Array xa, Array ya, Array za, List<Number> xSlice, List<Number> ySlice, List<Number> zSlice, LegendScheme ls) throws InvalidRangeException {
        int idx;
        float x;
        int j;
        float y;
        int i;
        float[] vertexValue;
        float[] vertexPosition;
        MeshGraphic graphic;
        Index index;
        Array r;
        float z;
        int s;
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        ArrayList<MeshGraphic> sgs = new ArrayList<MeshGraphic>();
        int dim1 = (int)ya.getSize();
        int dim2 = (int)xa.getSize();
        for (s = 0; s < zSlice.size(); ++s) {
            z = zSlice.get(s).floatValue();
            r = za.getSize() <= 1L && data.getRank() == 2 ? data : ArrayUtil.slice((Array)data, (int)0, (Array)za, (double)z);
            if (r == null) continue;
            index = r.getIndex();
            graphic = new MeshGraphic();
            vertexPosition = new float[dim1 * dim2 * 3];
            vertexValue = new float[dim1 * dim2];
            for (i = 0; i < dim1; ++i) {
                y = ya.getFloat(i);
                for (j = 0; j < dim2; ++j) {
                    x = xa.getFloat(j);
                    idx = i * dim2 + j;
                    vertexValue[idx] = r.getFloat(index.set(i, j));
                    vertexPosition[idx *= 3] = x;
                    vertexPosition[idx + 1] = y;
                    vertexPosition[idx + 2] = z;
                }
            }
            graphic.setVertexPosition(vertexPosition, dim1);
            graphic.setVertexValue(vertexValue);
            graphic.setLegendScheme(ls);
            sgs.add(graphic);
        }
        dim1 = (int)za.getSize();
        dim2 = (int)ya.getSize();
        for (s = 0; s < xSlice.size(); ++s) {
            x = xSlice.get(s).floatValue();
            r = xa.getSize() <= 1L && data.getRank() == 2 ? data : ArrayUtil.slice((Array)data, (int)2, (Array)xa, (double)x);
            if (r == null) continue;
            index = r.getIndex();
            graphic = new MeshGraphic();
            vertexPosition = new float[dim1 * dim2 * 3];
            vertexValue = new float[dim1 * dim2];
            for (i = 0; i < dim1; ++i) {
                z = za.getFloat(i);
                for (j = 0; j < dim2; ++j) {
                    y = ya.getFloat(j);
                    idx = i * dim2 + j;
                    vertexValue[idx] = r.getFloat(index.set(i, j));
                    vertexPosition[idx *= 3] = x;
                    vertexPosition[idx + 1] = y;
                    vertexPosition[idx + 2] = z;
                }
            }
            graphic.setVertexPosition(vertexPosition, dim1);
            graphic.setVertexValue(vertexValue);
            graphic.setLegendScheme(ls);
            sgs.add(graphic);
        }
        dim1 = (int)za.getSize();
        dim2 = (int)xa.getSize();
        for (s = 0; s < ySlice.size(); ++s) {
            y = ySlice.get(s).floatValue();
            r = ya.getSize() <= 1L && data.getRank() == 2 ? data : ArrayUtil.slice((Array)data, (int)1, (Array)ya, (double)y);
            if (r == null) continue;
            index = r.getIndex();
            graphic = new MeshGraphic();
            vertexPosition = new float[dim1 * dim2 * 3];
            vertexValue = new float[dim1 * dim2];
            for (i = 0; i < dim1; ++i) {
                z = za.getFloat(i);
                for (j = 0; j < dim2; ++j) {
                    x = xa.getFloat(j);
                    idx = i * dim2 + j;
                    vertexValue[idx] = r.getFloat(index.set(i, j));
                    vertexPosition[idx *= 3] = x;
                    vertexPosition[idx + 1] = y;
                    vertexPosition[idx + 2] = z;
                }
            }
            graphic.setVertexPosition(vertexPosition, dim1);
            graphic.setVertexValue(vertexValue);
            graphic.setLegendScheme(ls);
            sgs.add(graphic);
        }
        return sgs;
    }

    public static List<MeshGraphic> slice(Array data, Array xa, Array ya, Array za, List<Number> xSlice, List<Number> ySlice, List<Number> zSlice, TransferFunction transferFunction) throws InvalidRangeException {
        int idx;
        float x;
        int j;
        float y;
        int i;
        float[] vertexValue;
        float[] vertexPosition;
        MeshGraphic graphic;
        Index index;
        Array r;
        float z;
        int s;
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        ArrayList<MeshGraphic> sgs = new ArrayList<MeshGraphic>();
        int dim1 = (int)ya.getSize();
        int dim2 = (int)xa.getSize();
        for (s = 0; s < zSlice.size(); ++s) {
            z = zSlice.get(s).floatValue();
            r = za.getSize() <= 1L && data.getRank() == 2 ? data : ArrayUtil.slice((Array)data, (int)0, (Array)za, (double)z);
            if (r == null) continue;
            index = r.getIndex();
            graphic = new MeshGraphic();
            vertexPosition = new float[dim1 * dim2 * 3];
            vertexValue = new float[dim1 * dim2];
            for (i = 0; i < dim1; ++i) {
                y = ya.getFloat(i);
                for (j = 0; j < dim2; ++j) {
                    x = xa.getFloat(j);
                    idx = i * dim2 + j;
                    vertexValue[idx] = r.getFloat(index.set(i, j));
                    vertexPosition[idx *= 3] = x;
                    vertexPosition[idx + 1] = y;
                    vertexPosition[idx + 2] = z;
                }
            }
            graphic.setVertexPosition(vertexPosition, dim1);
            graphic.setVertexValue(vertexValue);
            graphic.setTransferFunction(transferFunction);
            sgs.add(graphic);
        }
        dim1 = (int)za.getSize();
        dim2 = (int)ya.getSize();
        for (s = 0; s < xSlice.size(); ++s) {
            x = xSlice.get(s).floatValue();
            r = xa.getSize() <= 1L && data.getRank() == 2 ? data : ArrayUtil.slice((Array)data, (int)2, (Array)xa, (double)x);
            if (r == null) continue;
            index = r.getIndex();
            graphic = new MeshGraphic();
            vertexPosition = new float[dim1 * dim2 * 3];
            vertexValue = new float[dim1 * dim2];
            for (i = 0; i < dim1; ++i) {
                z = za.getFloat(i);
                for (j = 0; j < dim2; ++j) {
                    y = ya.getFloat(j);
                    idx = i * dim2 + j;
                    vertexValue[idx] = r.getFloat(index.set(i, j));
                    vertexPosition[idx *= 3] = x;
                    vertexPosition[idx + 1] = y;
                    vertexPosition[idx + 2] = z;
                }
            }
            graphic.setVertexPosition(vertexPosition, dim1);
            graphic.setVertexValue(vertexValue);
            graphic.setTransferFunction(transferFunction);
            sgs.add(graphic);
        }
        dim1 = (int)za.getSize();
        dim2 = (int)xa.getSize();
        for (s = 0; s < ySlice.size(); ++s) {
            y = ySlice.get(s).floatValue();
            r = ya.getSize() <= 1L && data.getRank() == 2 ? data : ArrayUtil.slice((Array)data, (int)1, (Array)ya, (double)y);
            if (r == null) continue;
            index = r.getIndex();
            graphic = new MeshGraphic();
            vertexPosition = new float[dim1 * dim2 * 3];
            vertexValue = new float[dim1 * dim2];
            for (i = 0; i < dim1; ++i) {
                z = za.getFloat(i);
                for (j = 0; j < dim2; ++j) {
                    x = xa.getFloat(j);
                    idx = i * dim2 + j;
                    vertexValue[idx] = r.getFloat(index.set(i, j));
                    vertexPosition[idx *= 3] = x;
                    vertexPosition[idx + 1] = y;
                    vertexPosition[idx + 2] = z;
                }
            }
            graphic.setVertexPosition(vertexPosition, dim1);
            graphic.setVertexValue(vertexValue);
            graphic.setTransferFunction(transferFunction);
            sgs.add(graphic);
        }
        return sgs;
    }

    public static MeshGraphic slice(Array data, Array xa, Array ya, Array za, List<Number> xySlice, LegendScheme ls, InterpolationMethod method) throws InvalidRangeException {
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        Array[] rxy = InterpUtil.sliceXY((Array)xa, (Array)ya, (Array)za, (Array)data, xySlice, (InterpolationMethod)method);
        Array r = rxy[0];
        Array x2d = rxy[4];
        Array y2d = rxy[5];
        Array z2d = rxy[6];
        MeshGraphic graphic = new MeshGraphic();
        int[] shape = r.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        float[] vertexPosition = new float[rowNum * colNum * 3];
        float[] vertexValue = new float[rowNum * colNum];
        for (int i = 0; i < vertexValue.length; ++i) {
            int idx = i * 3;
            vertexPosition[idx] = x2d.getFloat(i);
            vertexPosition[idx + 1] = y2d.getFloat(i);
            vertexPosition[idx + 2] = z2d.getFloat(i);
            vertexValue[i] = r.getFloat(i);
        }
        graphic.setVertexPosition(vertexPosition, rowNum);
        graphic.setVertexValue(vertexValue);
        graphic.setLegendScheme(ls);
        return graphic;
    }

    public static List<MeshGraphic> slice(Array data, Array xa, Array ya, Array za, Array xSlice, Array ySlice, Array zSlice, LegendScheme ls) throws InvalidRangeException {
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        xSlice = xSlice.copyIfView();
        ySlice = ySlice.copyIfView();
        zSlice = zSlice.copyIfView();
        ArrayList<MeshGraphic> sgs = new ArrayList<MeshGraphic>();
        RectNearestInterpolator3D interpolator3D = new RectNearestInterpolator3D(xa, ya, za, data);
        Array r = interpolator3D.interpolate(xSlice, ySlice, zSlice);
        MeshGraphic graphic = new MeshGraphic();
        int[] shape = r.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        float[] vertexPosition = new float[rowNum * colNum * 3];
        float[] vertexValue = new float[rowNum * colNum];
        for (int i = 0; i < vertexValue.length; ++i) {
            int idx = i * 3;
            vertexPosition[idx] = xSlice.getFloat(i);
            vertexPosition[idx + 1] = ySlice.getFloat(i);
            vertexPosition[idx + 2] = zSlice.getFloat(i);
            vertexValue[i] = r.getFloat(i);
        }
        graphic.setVertexPosition(vertexPosition, rowNum);
        graphic.setVertexValue(vertexValue);
        graphic.setLegendScheme(ls);
        sgs.add(graphic);
        return sgs;
    }

    public static TriMeshGraphic isosurface(Array data, Array x, Array y, Array z, float isoLevel, LegendScheme ls) {
        x = x.copyIfView();
        y = y.copyIfView();
        z = z.copyIfView();
        data = data.copyIfView();
        ArrayList<float[]> vertices = MarchingCubes.marchingCubes(data, x, y, z, isoLevel);
        int nVertex = vertices.size();
        float[] vertexData = new float[nVertex * 3];
        int pos = 0;
        for (int i = 0; i < vertices.size(); ++i) {
            System.arraycopy(vertices.get(i), 0, vertexData, pos, 3);
            pos += 3;
        }
        TriMeshGraphic meshGraphic = new TriMeshGraphic();
        meshGraphic.setTriangles(vertexData);
        meshGraphic.setLegendScheme(ls);
        return meshGraphic;
    }

    public static TriMeshGraphic isosurface(final Array data, final Array x, final Array y, final Array z, final float isoLevel, LegendScheme ls, int nThreads) {
        int i;
        ArrayList<2> threads = new ArrayList<2>();
        final ArrayList results = new ArrayList();
        int nz = (int)z.getSize();
        int remainder = nz % nThreads;
        int segment = nz / nThreads;
        int zAxisOffset = 0;
        for (i = 0; i < nThreads; ++i) {
            int segmentSize = remainder-- > 0 ? segment + 1 : segment;
            final int paddedSegmentSize = i != nThreads - 1 ? segmentSize + 1 : segmentSize;
            final CallbackMC callback = new CallbackMC(){

                @Override
                public void run() {
                    results.add(this.getVertices());
                }
            };
            final int finalZAxisOffset = zAxisOffset;
            Thread t = new Thread(){

                @Override
                public void run() {
                    MarchingCubes.marchingCubes(data, x, y, z, isoLevel, paddedSegmentSize, finalZAxisOffset, callback);
                }
            };
            threads.add(t);
            t.start();
            zAxisOffset += segmentSize;
        }
        for (i = 0; i < threads.size(); ++i) {
            try {
                ((Thread)threads.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int nVertex = 0;
        for (List vertices : results) {
            nVertex += vertices.size();
        }
        float[] vertexData = new float[nVertex * 3];
        int pos = 0;
        for (List vertices : results) {
            for (int i2 = 0; i2 < vertices.size(); ++i2) {
                System.arraycopy(vertices.get(i2), 0, vertexData, pos, 3);
                pos += 3;
            }
        }
        TriMeshGraphic meshGraphic = new TriMeshGraphic();
        meshGraphic.setTriangles(vertexData);
        meshGraphic.setLegendScheme(ls);
        return meshGraphic;
    }

    public static TriMeshGraphic isosurface(final Array data, final Array x, final Array y, final Array z, final float isoLevel, Array cData, LegendScheme ls, int nThreads) {
        int i;
        ArrayList<4> threads = new ArrayList<4>();
        final ArrayList results = new ArrayList();
        int nz = (int)z.getSize();
        int remainder = nz % nThreads;
        int segment = nz / nThreads;
        int zAxisOffset = 0;
        for (i = 0; i < nThreads; ++i) {
            int segmentSize = remainder-- > 0 ? segment + 1 : segment;
            final int paddedSegmentSize = i != nThreads - 1 ? segmentSize + 1 : segmentSize;
            final CallbackMC callback = new CallbackMC(){

                @Override
                public void run() {
                    results.add(this.getVertices());
                }
            };
            final int finalZAxisOffset = zAxisOffset;
            Thread t = new Thread(){

                @Override
                public void run() {
                    MarchingCubes.marchingCubes(data, x, y, z, isoLevel, paddedSegmentSize, finalZAxisOffset, callback);
                }
            };
            threads.add(t);
            t.start();
            zAxisOffset += segmentSize;
        }
        for (i = 0; i < threads.size(); ++i) {
            try {
                ((Thread)threads.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int nVertex = 0;
        for (List vertices : results) {
            nVertex += vertices.size();
        }
        float[] vertexData = new float[nVertex * 3];
        int pos = 0;
        for (List vertices : results) {
            for (int i2 = 0; i2 < vertices.size(); ++i2) {
                System.arraycopy(vertices.get(i2), 0, vertexData, pos, 3);
                pos += 3;
            }
        }
        TriMeshGraphic meshGraphic = new TriMeshGraphic();
        meshGraphic.setTriangles(vertexData, cData, x, y, z);
        meshGraphic.setLegendScheme(ls);
        return meshGraphic;
    }

    public static TriMeshGraphic isosurface(final Array data, final Array x, final Array y, final Array z, final float isoLevel, Array cData, TransferFunction transferFunction, int nThreads) {
        int i;
        ArrayList<6> threads = new ArrayList<6>();
        final ArrayList results = new ArrayList();
        int nz = (int)z.getSize();
        int remainder = nz % nThreads;
        int segment = nz / nThreads;
        int zAxisOffset = 0;
        for (i = 0; i < nThreads; ++i) {
            int segmentSize = remainder-- > 0 ? segment + 1 : segment;
            final int paddedSegmentSize = i != nThreads - 1 ? segmentSize + 1 : segmentSize;
            final CallbackMC callback = new CallbackMC(){

                @Override
                public void run() {
                    results.add(this.getVertices());
                }
            };
            final int finalZAxisOffset = zAxisOffset;
            Thread t = new Thread(){

                @Override
                public void run() {
                    MarchingCubes.marchingCubes(data, x, y, z, isoLevel, paddedSegmentSize, finalZAxisOffset, callback);
                }
            };
            threads.add(t);
            t.start();
            zAxisOffset += segmentSize;
        }
        for (i = 0; i < threads.size(); ++i) {
            try {
                ((Thread)threads.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int nVertex = 0;
        for (List vertices : results) {
            nVertex += vertices.size();
        }
        float[] vertexData = new float[nVertex * 3];
        int pos = 0;
        for (List vertices : results) {
            for (int i2 = 0; i2 < vertices.size(); ++i2) {
                System.arraycopy(vertices.get(i2), 0, vertexData, pos, 3);
                pos += 3;
            }
        }
        TriMeshGraphic meshGraphic = new TriMeshGraphic();
        meshGraphic.setTriangles(vertexData, cData, x, y, z);
        meshGraphic.setTransferFunction(transferFunction);
        return meshGraphic;
    }

    public static TriMeshGraphic triSurface(Array faceIndices, Array x, Array y, Array z, LegendScheme ls) {
        TriMeshGraphic meshGraphic = new TriMeshGraphic();
        meshGraphic.setTriangles(faceIndices, x, y, z);
        meshGraphic.setLegendScheme(ls);
        return meshGraphic;
    }

    public static TriMeshGraphic triSurface(Array faceIndices, Array x, Array y, Array z, Array normal, LegendScheme ls) {
        if (normal == null) {
            return GraphicFactory.triSurface(faceIndices, x, y, z, ls);
        }
        TriMeshGraphic meshGraphic = new TriMeshGraphic();
        meshGraphic.setTriangles(faceIndices, x, y, z, normal);
        meshGraphic.setLegendScheme(ls);
        return meshGraphic;
    }

    public static Model model(Array faceIndices, Array x, Array y, Array z, LegendScheme ls) {
        Model model = new Model();
        model.setTriangles(faceIndices, x, y, z);
        model.setLegendScheme(ls);
        return model;
    }

    public static Model model(Array faceIndices, Array x, Array y, Array z, Array normal, LegendScheme ls) {
        if (normal == null) {
            return GraphicFactory.model(faceIndices, x, y, z, ls);
        }
        Model model = new Model();
        model.setTriangles(faceIndices, x, y, z, normal);
        model.setLegendScheme(ls);
        return model;
    }

    public static GraphicCollection volume(Array data, Array xa, Array ya, Array za, ColorMap colorMap, double vMin, double vMax, float alphaMin, float alphaMax) {
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        VolumeGraphic graphics = new VolumeGraphic(data, colorMap, vMin, vMax);
        graphics.setAlphaMin(alphaMin);
        graphics.setAlphaMax(alphaMax);
        graphics.updateColors();
        Extent3D extent3D = new Extent3D();
        extent3D.minX = xa.getDouble(0);
        extent3D.maxX = xa.getDouble((int)xa.getSize() - 1);
        extent3D.minY = ya.getDouble(0);
        extent3D.maxY = ya.getDouble((int)ya.getSize() - 1);
        extent3D.minZ = za.getDouble(0);
        extent3D.maxZ = za.getDouble((int)za.getSize() - 1);
        graphics.setExtent((Extent)extent3D);
        return graphics;
    }

    public static GraphicCollection volume(Array data, Array xa, Array ya, Array za, ColorMap colorMap, Normalize norm, float alphaMin, float alphaMax) {
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        VolumeGraphic graphics = new VolumeGraphic(data, colorMap, norm);
        graphics.setAlphaMin(alphaMin);
        graphics.setAlphaMax(alphaMax);
        graphics.updateColors();
        Extent3D extent3D = new Extent3D();
        extent3D.minX = xa.getDouble(0);
        extent3D.maxX = xa.getDouble((int)xa.getSize() - 1);
        extent3D.minY = ya.getDouble(0);
        extent3D.maxY = ya.getDouble((int)ya.getSize() - 1);
        extent3D.minZ = za.getDouble(0);
        extent3D.maxZ = za.getDouble((int)za.getSize() - 1);
        graphics.setExtent((Extent)extent3D);
        return graphics;
    }

    public static GraphicCollection volume(Array data, Array xa, Array ya, Array za, ColorMap colorMap, Normalize norm, List<Number> opacityNodes, List<Number> opacityLevels) {
        OpacityTransferFunction opacityTransferFunction = new OpacityTransferFunction(opacityNodes, opacityLevels, norm);
        return GraphicFactory.volume(data, xa, ya, za, colorMap, norm, opacityTransferFunction);
    }

    public static GraphicCollection volume(Array data, Array xa, Array ya, Array za, TransferFunction transferFunction) {
        return GraphicFactory.volume(data, xa, ya, za, transferFunction.getColorMap(), transferFunction.getNormalize(), transferFunction.getOpacityTransferFunction());
    }

    public static GraphicCollection volume(Array data, Array xa, Array ya, Array za, ColorMap colorMap, Normalize norm, OpacityTransferFunction opacityTransferFunction) {
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        VolumeGraphic graphics = new VolumeGraphic(data, colorMap, norm);
        graphics.setOpacityTransferFunction(opacityTransferFunction);
        graphics.updateColors();
        Extent3D extent3D = new Extent3D();
        extent3D.minX = xa.getDouble(0);
        extent3D.maxX = xa.getDouble((int)xa.getSize() - 1);
        extent3D.minY = ya.getDouble(0);
        extent3D.maxY = ya.getDouble((int)ya.getSize() - 1);
        extent3D.minZ = za.getDouble(0);
        extent3D.maxZ = za.getDouble((int)za.getSize() - 1);
        graphics.setExtent((Extent)extent3D);
        return graphics;
    }

    public static GraphicCollection volume(Array data, Array xa, Array ya, Array za, LegendScheme ls, float alphaMin, float alphaMax) {
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        VolumeGraphic graphics = new VolumeGraphic(data, ls);
        graphics.setAlphaMin(alphaMin);
        graphics.setAlphaMax(alphaMax);
        graphics.updateColors();
        Extent3D extent3D = new Extent3D();
        extent3D.minX = xa.getDouble(0);
        extent3D.maxX = xa.getDouble((int)xa.getSize() - 1);
        extent3D.minY = ya.getDouble(0);
        extent3D.maxY = ya.getDouble((int)ya.getSize() - 1);
        extent3D.minZ = za.getDouble(0);
        extent3D.maxZ = za.getDouble((int)za.getSize() - 1);
        graphics.setExtent((Extent)extent3D);
        return graphics;
    }

    public static GraphicCollection particles(Array data, Array xa, Array ya, Array za, LegendScheme ls, float alphaMin, float alphaMax, int density) {
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        ParticleGraphics graphics = new ParticleGraphics();
        Random random = new Random();
        float dx = xa.getFloat(1) - xa.getFloat(0);
        float dy = ya.getFloat(1) - ya.getFloat(0);
        float dz = za.getFloat(1) - za.getFloat(0);
        int n = ls.getBreakNum();
        float[] alphas = new float[n];
        float dd = (alphaMax - alphaMin) / (float)(n - 1);
        for (int i = 0; i < n; ++i) {
            alphas[i] = alphaMin + (float)i * dd;
        }
        double vMin = ls.getMinValue();
        double vMax = ls.getMaxValue();
        Index index = data.getIndex();
        if (za.getRank() == 1) {
            int i = 0;
            while ((long)i < za.getSize()) {
                int j = 0;
                while ((long)j < ya.getSize()) {
                    int k = 0;
                    while ((long)k < xa.getSize()) {
                        int level;
                        index.set(i, j, k);
                        double v = data.getDouble(index);
                        if (!(Double.isNaN(v) || v < vMin || v > vMax || (level = ls.legendBreakIndex(v)) < 0)) {
                            ColorBreak cb = ls.getLegendBreak(level);
                            float[] rgba = cb.getColor().getRGBComponents(null);
                            rgba[3] = alphas[level];
                            for (int l = 0; l <= level * density; ++l) {
                                ParticleGraphics.Particle particle = new ParticleGraphics.Particle();
                                particle.x = xa.getFloat(k) + (random.nextFloat() - 0.5f) * dx * 2.0f;
                                particle.y = ya.getFloat(j) + (random.nextFloat() - 0.5f) * dy * 2.0f;
                                particle.z = za.getFloat(i) + (random.nextFloat() - 0.5f) * dz * 2.0f;
                                particle.rgba = rgba;
                                graphics.addParticle(level, particle);
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int zn = za.getShape()[0];
            Index zIndex = za.getIndex();
            for (int i = 0; i < zn; ++i) {
                int j = 0;
                while ((long)j < ya.getSize()) {
                    int k = 0;
                    while ((long)k < xa.getSize()) {
                        index.set(i, j, k);
                        double v = data.getDouble(index);
                        if (!(Double.isNaN(v) || v < vMin || v > vMax)) {
                            int level = ls.legendBreakIndex(v);
                            zIndex.set(i, j, k);
                            float z = za.getFloat(zIndex);
                            if (i == 0) {
                                zIndex.set(1, j, k);
                            } else {
                                zIndex.set(i - 1, j, k);
                            }
                            dz = Math.abs(z - za.getFloat(zIndex));
                            if (level >= 0) {
                                ColorBreak cb = ls.getLegendBreak(level);
                                float[] rgba = cb.getColor().getRGBComponents(null);
                                rgba[3] = alphas[level];
                                for (int l = 0; l <= level * density; ++l) {
                                    ParticleGraphics.Particle particle = new ParticleGraphics.Particle();
                                    particle.x = xa.getFloat(k) + (random.nextFloat() - 0.5f) * dx * 2.0f;
                                    particle.y = ya.getFloat(j) + (random.nextFloat() - 0.5f) * dy * 2.0f;
                                    particle.z = z + (random.nextFloat() - 0.5f) * dz * 2.0f;
                                    particle.rgba = rgba;
                                    graphics.addParticle(level, particle);
                                }
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
            }
        }
        Extent3D extent3D = new Extent3D();
        extent3D.minX = xa.getDouble(0);
        extent3D.maxX = xa.getDouble((int)xa.getSize() - 1);
        extent3D.minY = ya.getDouble(0);
        extent3D.maxY = ya.getDouble((int)ya.getSize() - 1);
        extent3D.minZ = za.getDouble(0);
        extent3D.maxZ = za.getDouble((int)za.getSize() - 1);
        graphics.setExtent((Extent)extent3D);
        graphics.setLegendScheme(ls);
        return graphics;
    }
}

