/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.Array1D;
import org.ojalgo.matrix.Provider2D;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.DynamicEvD;
import org.ojalgo.matrix.decomposition.GeneralEvD;
import org.ojalgo.matrix.decomposition.GeneralisedEvD;
import org.ojalgo.matrix.decomposition.HermitianEvD;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.RawEigenvalue;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.context.NumberContext;

public interface Eigenvalue<N extends Comparable<N>>
extends MatrixDecomposition<N>,
MatrixDecomposition.Hermitian<N>,
MatrixDecomposition.Determinant<N>,
MatrixDecomposition.Values<N>,
Provider2D.Eigenpairs {
    public static final Factory<ComplexNumber> COMPLEX = new Factory<ComplexNumber>(){

        @Override
        public Eigenvalue<ComplexNumber> make(Structure2D typical, boolean hermitian) {
            return hermitian ? new HermitianEvD.Complex() : null;
        }

        @Override
        public Generalised<ComplexNumber> makeGeneralised(Structure2D typical, Generalisation type) {
            PhysicalStore.Factory<ComplexNumber, GenericStore<ComplexNumber>> factory = GenericStore.COMPLEX;
            Cholesky cholesky = (Cholesky)Cholesky.COMPLEX.make(typical);
            Eigenvalue<ComplexNumber> eigenvalue = this.make(typical, true);
            return new GeneralisedEvD<ComplexNumber>(factory, cholesky, eigenvalue, type);
        }
    };
    public static final Comparator<ComplexNumber> DESCENDING_NORM = (arg1, arg2) -> {
        int retVal = Double.compare(arg2.norm(), arg1.norm());
        if (retVal == 0) {
            return arg2.compareTo((ComplexNumber)arg1);
        }
        return retVal;
    };
    public static final Factory<Double> PRIMITIVE = new Factory<Double>(){

        @Override
        public Eigenvalue<Double> make(Structure2D typical) {
            if (8192L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
                return new DynamicEvD.Primitive();
            }
            return new RawEigenvalue.Dynamic();
        }

        @Override
        public Eigenvalue<Double> make(Structure2D typical, boolean hermitian) {
            if (hermitian) {
                if (8192L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
                    return new HermitianEvD.Primitive();
                }
                return new RawEigenvalue.Symmetric();
            }
            if (8192L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
                return new GeneralEvD.Primitive();
            }
            return new RawEigenvalue.General();
        }

        @Override
        public Generalised<Double> makeGeneralised(Structure2D typical, Generalisation type) {
            PhysicalStore.Factory<Double, Primitive64Store> factory = Primitive64Store.FACTORY;
            Cholesky cholesky = (Cholesky)Cholesky.PRIMITIVE.make(typical);
            Eigenvalue<Double> eigenvalue = this.make(typical, true);
            return new GeneralisedEvD<Double>(factory, cholesky, eigenvalue, type);
        }
    };
    public static final Factory<Quaternion> QUATERNION = new Factory<Quaternion>(){

        @Override
        public Eigenvalue<Quaternion> make(Structure2D typical, boolean hermitian) {
            return hermitian ? new HermitianEvD.Quat() : null;
        }

        @Override
        public Generalised<Quaternion> makeGeneralised(Structure2D typical, Generalisation type) {
            PhysicalStore.Factory<Quaternion, GenericStore<Quaternion>> factory = GenericStore.QUATERNION;
            Cholesky cholesky = (Cholesky)Cholesky.QUATERNION.make(typical);
            Eigenvalue<Quaternion> eigenvalue = this.make(typical, true);
            return new GeneralisedEvD<Quaternion>(factory, cholesky, eigenvalue, type);
        }
    };
    public static final Factory<RationalNumber> RATIONAL = new Factory<RationalNumber>(){

        @Override
        public Eigenvalue<RationalNumber> make(Structure2D typical, boolean hermitian) {
            return hermitian ? new HermitianEvD.Rational() : null;
        }

        @Override
        public Generalised<RationalNumber> makeGeneralised(Structure2D typical, Generalisation type) {
            PhysicalStore.Factory<RationalNumber, GenericStore<RationalNumber>> factory = GenericStore.RATIONAL;
            Cholesky cholesky = (Cholesky)Cholesky.RATIONAL.make(typical);
            Eigenvalue<RationalNumber> eigenvalue = this.make(typical, true);
            return new GeneralisedEvD<RationalNumber>(factory, cholesky, eigenvalue, type);
        }
    };

    public static <N extends Comparable<N>> boolean equals(MatrixStore<N> matrix, Eigenvalue<N> decomposition, NumberContext context) {
        MatrixStore<N> tmpD = decomposition.getD();
        MatrixStore<MatrixStore<N>> tmpV = decomposition.getV();
        MatrixStore<MatrixStore<N>> tmpStore1 = matrix.multiply(tmpV);
        MatrixStore<MatrixStore<N>> tmpStore2 = tmpV.multiply(tmpD);
        return Access2D.equals(tmpStore1, tmpStore2, context);
    }

    private void copyEigenvector(int index, Array1D<ComplexNumber> destination) {
        MatrixStore<N> tmpV = this.getV();
        MatrixStore<N> tmpD = this.getD();
        long tmpDimension = tmpD.countColumns();
        int prevCol = index - 1;
        int nextCol = index + 1;
        if ((long)index < tmpDimension - 1L && tmpD.doubleValue(nextCol, index) != 0.0) {
            int i = 0;
            while ((long)i < tmpDimension) {
                destination.set(i, ComplexNumber.of(tmpV.doubleValue(i, index), tmpV.doubleValue(i, nextCol)));
                ++i;
            }
        } else if (index > 0 && tmpD.doubleValue(prevCol, index) != 0.0) {
            int i = 0;
            while ((long)i < tmpDimension) {
                destination.set(i, ComplexNumber.of(tmpV.doubleValue(i, prevCol), -tmpV.doubleValue(i, index)));
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < tmpDimension) {
                destination.set((long)i, tmpV.doubleValue(i, index));
                ++i;
            }
        }
    }

    public MatrixStore<N> getD();

    default public Eigenpair getEigenpair(int index) {
        long dim = this.getV().countColumns();
        Structure1D vector = Array1D.C128.make(dim);
        this.copyEigenvector(index, (Array1D<ComplexNumber>)vector);
        Array1D<ComplexNumber> values = this.getEigenvalues();
        ComplexNumber value = (ComplexNumber)values.get(index);
        return new Eigenpair(value, (Access1D<ComplexNumber>)vector);
    }

    @Override
    default public List<Eigenpair> getEigenpairs() {
        ArrayList<Eigenpair> retVal = new ArrayList<Eigenpair>();
        int limit = this.getEigenvalues().size();
        for (int i = 0; i < limit; ++i) {
            retVal.add(this.getEigenpair(i));
        }
        Collections.sort(retVal);
        return retVal;
    }

    public Array1D<ComplexNumber> getEigenvalues();

    default public void getEigenvalues(double[] realParts, Optional<double[]> imaginaryParts) {
        ProgrammingError.throwIfNull((Object)realParts, imaginaryParts);
        Array1D<ComplexNumber> values = this.getEigenvalues();
        int length = realParts.length;
        if (imaginaryParts.isPresent()) {
            double[] imagParts = imaginaryParts.get();
            for (int i = 0; i < length; ++i) {
                ComplexNumber value = (ComplexNumber)values.get(i);
                realParts[i] = value.getReal();
                imagParts[i] = value.getImaginary();
            }
        } else {
            for (int i = 0; i < length; ++i) {
                realParts[i] = values.doubleValue(i);
            }
        }
    }

    default public MatrixStore<ComplexNumber> getEigenvectors() {
        long tmpDimension = this.getV().countColumns();
        GenericStore retVal = (GenericStore)GenericStore.COMPLEX.make(tmpDimension, tmpDimension);
        int j = 0;
        while ((long)j < tmpDimension) {
            this.copyEigenvector(j, (Array1D<ComplexNumber>)retVal.sliceColumn(0L, j));
            ++j;
        }
        return retVal;
    }

    public ComplexNumber getTrace();

    public MatrixStore<N> getV();

    public boolean isHermitian();

    @Override
    public boolean isOrdered();

    @Override
    default public MatrixStore<N> reconstruct() {
        MatrixStore<MatrixStore<N>> mtrxV = this.getV();
        MatrixStore<N> mtrxD = this.getD();
        return mtrxV.multiply(mtrxD).multiply((MatrixStore<Object>)mtrxV.conjugate());
    }

    public static interface Generalised<N extends Comparable<N>>
    extends Eigenvalue<N> {
        default public boolean computeValuesOnly(Access2D.Collectable<N, ? super PhysicalStore<N>> matrixA, Access2D.Collectable<N, ? super PhysicalStore<N>> matrixB) {
            return this.prepare(matrixB) && this.computeValuesOnly(matrixA);
        }

        default public boolean decompose(Access2D.Collectable<N, ? super PhysicalStore<N>> matrixA, Access2D.Collectable<N, ? super PhysicalStore<N>> matrixB) {
            return this.prepare(matrixB) && this.decompose(matrixA);
        }

        public boolean prepare(Access2D.Collectable<N, ? super PhysicalStore<N>> var1);
    }

    public static enum Generalisation {
        A_B,
        AB,
        BA;

    }

    public static interface Factory<N extends Comparable<N>>
    extends MatrixDecomposition.Factory<Eigenvalue<N>> {
        default public Eigenvalue<N> make(boolean hermitian) {
            return this.make(MatrixDecomposition.TYPICAL, hermitian);
        }

        default public Eigenvalue<N> make(final int dimension, boolean hermitian) {
            return this.make(new Structure2D(){

                @Override
                public long countColumns() {
                    return dimension;
                }

                @Override
                public long countRows() {
                    return dimension;
                }
            }, hermitian);
        }

        @Override
        default public Eigenvalue<N> make(Structure2D typical) {
            if (typical instanceof MatrixStore) {
                return this.make(typical, ((MatrixStore)typical).isHermitian());
            }
            return this.make(typical, false);
        }

        public Eigenvalue<N> make(Structure2D var1, boolean var2);

        default public Generalised<N> makeGeneralised(Structure2D typical) {
            return this.makeGeneralised(typical, Generalisation.A_B);
        }

        public Generalised<N> makeGeneralised(Structure2D var1, Generalisation var2);
    }

    public static class Eigenpair
    implements Comparable<Eigenpair> {
        public final ComplexNumber value;
        public final Access1D<ComplexNumber> vector;

        public Eigenpair(ComplexNumber aValue, Access1D<ComplexNumber> aVector) {
            this.value = aValue;
            this.vector = aVector;
        }

        @Override
        public int compareTo(Eigenpair other) {
            return DESCENDING_NORM.compare(this.value, other.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Eigenpair)) {
                return false;
            }
            Eigenpair other = (Eigenpair)obj;
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return !(this.vector == null ? other.vector != null : !this.vector.equals(other.vector));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return 31 * result + (this.vector == null ? 0 : this.vector.hashCode());
        }
    }
}

