/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.ProgrammingError;
import org.ojalgo.array.Array1D;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.ComplexAggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.EigenvalueDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.structure.Access2D;

abstract class GeneralEvD<N extends Comparable<N>>
extends EigenvalueDecomposition<N> {
    protected GeneralEvD(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory) {
        super(factory);
    }

    @Override
    public boolean checkAndDecompose(MatrixStore<N> matrix) {
        return this.decompose(matrix);
    }

    @Override
    public final N getDeterminant() {
        AggregatorFunction<ComplexNumber> tmpVisitor = ComplexAggregator.getSet().product();
        this.getEigenvalues().visitAll(tmpVisitor);
        return this.scalar().cast((Comparable)tmpVisitor.get());
    }

    public MatrixStore<N> getInverse() {
        ProgrammingError.throwForUnsupportedOptionalOperation();
        return null;
    }

    public MatrixStore<N> getInverse(DecompositionStore<N> newPreallocated) {
        ProgrammingError.throwForUnsupportedOptionalOperation();
        return null;
    }

    @Override
    public final ComplexNumber getTrace() {
        AggregatorFunction<ComplexNumber> tmpVisitor = ComplexAggregator.getSet().sum();
        this.getEigenvalues().visitAll(tmpVisitor);
        return (ComplexNumber)tmpVisitor.get();
    }

    @Override
    public final boolean isHermitian() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    protected boolean checkSolvability() {
        return this.isComputed() && this.isHermitian();
    }

    @Override
    protected boolean doDecompose(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean valuesOnly) {
        int tmpDiagDim = (int)matrix.countRows();
        DecompositionStore tmpMtrxA = this.makeZero(tmpDiagDim, tmpDiagDim);
        matrix.supplyTo(tmpMtrxA);
        DecompositionStore tmpV = this.makeEye(tmpDiagDim, tmpDiagDim);
        Array1D<ComplexNumber> tmpEigenvalues = tmpMtrxA.computeInPlaceSchur(tmpV, true);
        this.setV(tmpV);
        this.setEigenvalues(tmpEigenvalues);
        DecompositionStore tmpD = this.makeZero(tmpDiagDim, tmpDiagDim);
        for (int ij = 0; ij < tmpDiagDim; ++ij) {
            ComplexNumber tmpValue = (ComplexNumber)tmpEigenvalues.get(ij);
            tmpD.set((long)ij, (long)ij, tmpValue.doubleValue());
            double tmpImaginary = tmpValue.i;
            if (tmpImaginary > PrimitiveMath.ZERO) {
                tmpD.set((long)ij, (long)(ij + 1), tmpImaginary);
                continue;
            }
            if (!(tmpImaginary < PrimitiveMath.ZERO)) continue;
            tmpD.set((long)ij, (long)(ij - 1), tmpImaginary);
        }
        this.setD(tmpD);
        return this.computed(true);
    }

    @Override
    protected final MatrixStore<N> makeD() {
        return null;
    }

    @Override
    protected Array1D<ComplexNumber> makeEigenvalues() {
        return null;
    }

    protected final MatrixStore<N> makeInverse() {
        MatrixStore tmpV = this.getV();
        MatrixStore tmpD = this.getD();
        int tmpDim = (int)tmpD.countRows();
        PhysicalStore<Comparable<Object>> tmpMtrx = tmpV.transpose().copy();
        Comparable tmpZero = (Comparable)this.scalar().zero().get();
        BinaryFunction tmpDivide = this.function().divide();
        for (int i = 0; i < tmpDim; ++i) {
            if (tmpD.isSmall(i, i, PrimitiveMath.ONE)) {
                tmpMtrx.fillRow((long)i, 0L, tmpZero);
                continue;
            }
            tmpMtrx.modifyRow(i, 0L, tmpDivide.second(tmpD.get(i, i)));
        }
        return tmpV.multiply(tmpMtrx);
    }

    @Override
    protected MatrixStore<N> makeV() {
        return null;
    }

    static final class Primitive
    extends GeneralEvD<Double> {
        Primitive() {
            super(Primitive64Store.FACTORY);
        }
    }
}

