/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.RecoverableCondition;
import org.ojalgo.array.operation.AXPY;
import org.ojalgo.array.operation.NRM2;
import org.ojalgo.array.operation.NRMINF;
import org.ojalgo.array.operation.VisitAll;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.RawDecomposition;
import org.ojalgo.matrix.operation.HouseholderLeft;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.RawStore;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

final class RawQR
extends RawDecomposition
implements QR<Double> {
    private double[] myDiagonalR;
    private int myNumberOfHouseholderTransformations = 0;

    RawQR() {
    }

    @Override
    public Double calculateDeterminant(Access2D<?> matrix) {
        double[][] retVal = this.reset(matrix, true);
        Primitive64Store.FACTORY.makeWrapper(matrix).transpose().supplyTo(this.getInternalStore());
        this.doDecompose(retVal);
        return this.getDeterminant();
    }

    @Override
    public int countSignificant(double threshold) {
        int significant = 0;
        int limit = this.myDiagonalR.length;
        for (int ij = 0; ij < limit; ++ij) {
            if (!(Math.abs(this.myDiagonalR[ij]) > threshold)) continue;
            ++significant;
        }
        return significant;
    }

    @Override
    public boolean decompose(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        double[][] retVal = this.reset(matrix, true);
        if (matrix instanceof ElementsSupplier) {
            ((ElementsSupplier)matrix).transpose().supplyTo(this.getInternalStore());
        } else {
            ((RawStore)matrix.collect(RawStore.FACTORY)).transpose().supplyTo(this.getInternalStore());
        }
        return this.doDecompose(retVal);
    }

    @Override
    public Double getDeterminant() {
        AggregatorFunction<Double> aggregator = PrimitiveAggregator.getSet().product();
        VisitAll.visit(this.myDiagonalR, aggregator);
        if (this.myNumberOfHouseholderTransformations % 2 != 0) {
            return -((Double)aggregator.get()).doubleValue();
        }
        return (Double)aggregator.get();
    }

    @Override
    public MatrixStore<Double> getInverse() {
        int tmpRowDim = this.getRowDim();
        return this.doGetInverse(this.allocate(tmpRowDim, tmpRowDim));
    }

    @Override
    public MatrixStore<Double> getInverse(PhysicalStore<Double> preallocated) {
        return this.doGetInverse((Primitive64Store)preallocated);
    }

    public RawStore getQ() {
        int m = this.getRowDim();
        int r = this.getMinDim();
        double[][] internalData = this.getInternalData();
        RawStore retVal = RawDecomposition.make(m, r);
        double[][] retData = retVal.data;
        for (int k = r - 1; k >= 0; --k) {
            for (int i = 0; i < m; ++i) {
                retData[i][k] = PrimitiveMath.ZERO;
            }
            retData[k][k] = PrimitiveMath.ONE;
            for (int j = k; j < r; ++j) {
                int i;
                if (internalData[k][k] == 0.0) continue;
                double s = PrimitiveMath.ZERO;
                for (i = k; i < m; ++i) {
                    s += internalData[k][i] * retData[i][j];
                }
                s = -s / internalData[k][k];
                for (i = k; i < m; ++i) {
                    double[] dArray = retData[i];
                    int n = j;
                    dArray[n] = dArray[n] + s * internalData[k][i];
                }
            }
        }
        return retVal;
    }

    @Override
    public MatrixStore<Double> getR() {
        int n = this.getColDim();
        int r = this.getMinDim();
        double[][] internalData = this.getInternalData();
        RawStore retVal = RawDecomposition.make(r, n);
        double[][] retData = retVal.data;
        for (int i = 0; i < r; ++i) {
            double[] tmpRow = retData[i];
            tmpRow[i] = this.myDiagonalR[i];
            for (int j = i + 1; j < n; ++j) {
                tmpRow[j] = internalData[j][i];
            }
        }
        return retVal;
    }

    @Override
    public double getRankThreshold() {
        double largest = Double.MIN_NORMAL;
        int limit = this.myDiagonalR.length;
        for (int ij = 0; ij < limit; ++ij) {
            largest = Math.max(largest, Math.abs(this.myDiagonalR[ij]));
        }
        double epsilon = this.getDimensionalEpsilon();
        return largest * epsilon;
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs) {
        return this.getSolution(rhs, this.allocate(rhs.countRows(), rhs.countColumns()));
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs, PhysicalStore<Double> preallocated) {
        rhs.supplyTo(preallocated);
        return this.doSolve((Primitive64Store)preallocated);
    }

    @Override
    public MatrixStore<Double> invert(Access2D<?> original, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        double[][] tmpData = this.reset(Primitive64Store.FACTORY.makeWrapper(original), true);
        Primitive64Store.FACTORY.makeWrapper(original).transpose().supplyTo(this.getInternalStore());
        this.doDecompose(tmpData);
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public boolean isFullSize() {
        return false;
    }

    @Override
    public boolean isSolvable() {
        return super.isSolvable();
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D template) {
        return this.allocate(template.countRows(), template.countRows());
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.allocate(templateBody.countRows(), templateRHS.countColumns());
    }

    @Override
    public void reset() {
        super.reset();
        this.myNumberOfHouseholderTransformations = 0;
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs) throws RecoverableCondition {
        return this.solve(body, rhs, this.preallocate(body, rhs));
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        double[][] tmpData = this.reset(body, true);
        Primitive64Store.FACTORY.makeWrapper(body).transpose().supplyTo(this.getInternalStore());
        this.doDecompose(tmpData);
        if (this.isSolvable()) {
            preallocated.fillMatching(rhs);
            return this.doSolve((Primitive64Store)preallocated);
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    private boolean doDecompose(double[][] data) {
        double[] colK;
        double norm;
        int m = this.getRowDim();
        int r = this.getMinDim();
        this.myDiagonalR = new double[r];
        for (int k = 0; k < r && (norm = NRMINF.invoke(colK = data[k], k, m)) != PrimitiveMath.ZERO; ++k) {
            norm = NRM2.invoke(colK, norm, k, m);
            ++this.myNumberOfHouseholderTransformations;
            if (colK[k] < 0.0) {
                norm = -norm;
            }
            int i = k;
            while (i < m) {
                int n = i++;
                colK[n] = colK[n] / norm;
            }
            int n = k;
            colK[n] = colK[n] + PrimitiveMath.ONE;
            double hBeta = PrimitiveMath.ONE / colK[k];
            HouseholderLeft.call(data, m, k + 1, colK, k, hBeta);
            this.myDiagonalR[k] = -norm;
        }
        return this.computed(true);
    }

    private MatrixStore<Double> doGetInverse(Primitive64Store preallocated) {
        Primitive64Store.FACTORY.makeIdentity(this.getRowDim()).supplyTo(preallocated);
        return this.doSolve(preallocated);
    }

    private MatrixStore<Double> doSolve(Primitive64Store preallocated) {
        double[] colK;
        int k;
        double[] dataRHS = preallocated.data;
        int m = this.getRowDim();
        int n = this.getColDim();
        int s = preallocated.getColDim();
        if (preallocated.getRowDim() != m) {
            throw new IllegalArgumentException("Row dimensions must agree!");
        }
        if (!this.isFullRank()) {
            throw new RuntimeException("Rank deficient!");
        }
        double[][] dataInternal = this.getInternalData();
        for (k = 0; k < n; ++k) {
            colK = dataInternal[k];
            double beta = PrimitiveMath.ONE / colK[k];
            HouseholderLeft.call(dataRHS, m, 0, colK, k, beta);
        }
        for (k = n - 1; k >= 0; --k) {
            colK = dataInternal[k];
            double tmpDiagK = this.myDiagonalR[k];
            for (int j = 0; j < s; ++j) {
                int n2 = k + j * m;
                dataRHS[n2] = dataRHS[n2] / tmpDiagK;
                AXPY.invoke(dataRHS, j * m, -dataRHS[k + j * m], colK, 0, 0, k);
            }
        }
        return preallocated.limits(n, s);
    }

    @Override
    protected boolean checkSolvability() {
        return this.isAspectRatioNormal() && this.isFullRank();
    }
}

