/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.TransjugatedStore;
import org.ojalgo.scalar.Scalar;

final class ConjugatedStore<N extends Comparable<N>>
extends TransjugatedStore<N> {
    ConjugatedStore(MatrixStore<N> base) {
        super(base);
    }

    @Override
    public MatrixStore<N> conjugate() {
        return this.base();
    }

    @Override
    public N get(long aRow, long aCol) {
        return (N)((Comparable)((Scalar)this.base().toScalar((int)aCol, (int)aRow).conjugate()).get());
    }

    @Override
    public MatrixStore<N> multiply(MatrixStore<N> right) {
        MatrixStore<MatrixStore<N>> retVal;
        if (right instanceof ConjugatedStore) {
            retVal = ((ConjugatedStore)right).getOriginal().multiply(this.base());
            retVal = new ConjugatedStore<MatrixStore<MatrixStore<N>>>(retVal);
        } else {
            retVal = super.multiply(right);
        }
        return retVal;
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return (Scalar)this.base().toScalar(column, row).conjugate();
    }
}

