/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.SelectingStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;

final class RowsStore<N extends Comparable<N>>
extends SelectingStore<N> {
    private final int[] myRows;

    RowsStore(MatrixStore<N> base, int ... rows) {
        super(base, rows.length, (int)base.countColumns());
        this.myRows = rows;
    }

    @Override
    public double doubleValue(long row, long col) {
        int rowIndex = this.toBaseIndex(row);
        if (rowIndex >= 0) {
            return this.base().doubleValue(rowIndex, col);
        }
        return PrimitiveMath.ZERO;
    }

    @Override
    public int firstInRow(int row) {
        int rowIndex = this.toBaseIndex(row);
        if (rowIndex >= 0) {
            return this.base().firstInRow(rowIndex);
        }
        return this.getColDim();
    }

    @Override
    public N get(long row, long col) {
        int rowIndex = this.toBaseIndex(row);
        if (rowIndex >= 0) {
            return this.base().get(rowIndex, col);
        }
        return (N)((Comparable)this.zero().get());
    }

    @Override
    public int limitOfRow(int row) {
        int rowIndex = this.toBaseIndex(row);
        if (rowIndex >= 0) {
            return this.base().limitOfRow(rowIndex);
        }
        return 0;
    }

    @Override
    public void supplyTo(TransformableRegion<N> consumer) {
        MatrixStore base = this.base();
        for (int i = 0; i < this.myRows.length; ++i) {
            int rowIndex = this.toBaseIndex(i);
            if (rowIndex >= 0) {
                consumer.fillRow((long)i, base.sliceRow(rowIndex));
                continue;
            }
            consumer.fillColumn((long)i, (Access1D<Comparable>)((Object)((Comparable)this.zero().get())));
        }
    }

    @Override
    public Scalar<N> toScalar(long row, long col) {
        int rowIndex = this.toBaseIndex(row);
        if (rowIndex >= 0) {
            return this.base().toScalar(rowIndex, col);
        }
        return this.zero();
    }

    private int toBaseIndex(int row) {
        return this.myRows[row];
    }

    private int toBaseIndex(long row) {
        return this.myRows[Math.toIntExact(row)];
    }
}

