/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task.iterative;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;
import org.ojalgo.RecoverableCondition;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.concurrent.Parallelism;
import org.ojalgo.concurrent.ProcessingService;
import org.ojalgo.equation.Equation;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.task.iterative.IterativeSolverTask;
import org.ojalgo.matrix.task.iterative.StationaryIterativeSolver;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.context.NumberContext;

public final class ParallelGaussSeidelSolver
extends StationaryIterativeSolver
implements IterativeSolverTask.SparseDelegate {
    private static final DivideAndConquer.Divider DIVIDER = ProcessingService.INSTANCE.divider();
    private static final IntSupplier PARALLELISM = Parallelism.CORES;
    private static final int THRESHOLD = 128;

    private static void divide(int nbEquations, DivideAndConquer.Conquerer conquerer) {
        DIVIDER.parallelism(PARALLELISM).threshold(128).divide(0, nbEquations, conquerer);
    }

    @Override
    public double resolve(List<Equation> equations, PhysicalStore<Double> solution) {
        int nbEquations = equations.size();
        double tmpNorm = PrimitiveMath.ZERO;
        for (int r = 0; r < nbEquations; ++r) {
            tmpNorm = PrimitiveMath.HYPOT.invoke(tmpNorm, equations.get(r).getRHS());
        }
        double normRHS = tmpNorm;
        AtomicInteger iterationsCounter = new AtomicInteger();
        ParallelGaussSeidelSolver.divide(nbEquations, (first, last) -> this.resolve(equations, solution, normRHS, iterationsCounter, first, last));
        return this.resolve(equations, solution, normRHS, iterationsCounter, 0, nbEquations);
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> current) throws RecoverableCondition {
        List<Equation> equations = IterativeSolverTask.toListOfRows(body, rhs);
        this.resolve(equations, current);
        return current;
    }

    private double resolve(List<Equation> equations, PhysicalStore<Double> solution, double normRHS, AtomicInteger iterationsCounter, int first, int last) {
        int iterationsLimit = this.getIterationsLimit();
        NumberContext accuracy = this.getAccuracyContext();
        double relaxationFactor = this.getRelaxationFactor();
        double normErr = Double.POSITIVE_INFINITY;
        do {
            normErr = PrimitiveMath.ZERO;
            for (int r = first; r < last; ++r) {
                normErr = PrimitiveMath.HYPOT.invoke(normErr, equations.get(r).adjust(solution, relaxationFactor));
            }
            iterationsCounter.incrementAndGet();
            if (!this.isDebugPrinterSet()) continue;
            this.debug(iterationsCounter.intValue(), normErr / normRHS, solution);
        } while (iterationsCounter.intValue() < iterationsLimit && !accuracy.isSmall(normRHS, normErr));
        return normErr / normRHS;
    }
}

