/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.integer;

import org.ojalgo.function.constant.BigMath;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.GenericSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.integer.IntegerStrategy;
import org.ojalgo.optimisation.integer.ModelStrategy;
import org.ojalgo.optimisation.integer.NodeSolver;
import org.ojalgo.structure.Access1D;

public final class GomorySolver
extends GenericSolver {
    public static final ExpressionsBasedModel.Integration<GomorySolver> INTEGRATION = new ModelIntegration();
    private static final IntegerStrategy.GMICutConfiguration GMI_CUT_CONFIGURATION = new IntegerStrategy.GMICutConfiguration().withFractionality(0.01).withViolation(BigMath.HUNDRED);
    private final MultiaryFunction.TwiceDifferentiable<Double> myFunction;
    private final ExpressionsBasedModel myIntegerModel;

    GomorySolver(ExpressionsBasedModel model) {
        super(model.options);
        this.myIntegerModel = model.simplify();
        this.myFunction = this.myIntegerModel.limitObjective(null, null).toFunction();
    }

    @Override
    public Optimisation.Result solve(Optimisation.Result kickStarter) {
        ModelStrategy strategy = IntegerStrategy.DEFAULT.withGMICutConfiguration(GMI_CUT_CONFIGURATION).newModelStrategy(this.myIntegerModel);
        ExpressionsBasedModel iteratorModel = this.myIntegerModel.snapshot();
        NodeSolver iterativeSolver = iteratorModel.prepare(NodeSolver::new);
        Optimisation.Result retVal = iterativeSolver.solve();
        this.incrementIterationsCount();
        if (this.isLogProgress()) {
            this.log("Iteration {}: {}", this.countIterations(), retVal);
            this.log();
        }
        while (retVal.getState().isFeasible() && !this.myIntegerModel.validate(retVal)) {
            iterativeSolver.generateCuts(strategy);
            retVal = iterativeSolver.solve();
            this.incrementIterationsCount();
            if (!this.isLogProgress()) continue;
            this.log("Iteration {}: {}", this.countIterations(), retVal);
            this.log();
        }
        return retVal;
    }

    protected Optimisation.Result buildResult() {
        Access1D<?> solution = this.extractSolution();
        double value = this.evaluateFunction(solution);
        Optimisation.State state = this.getState();
        return new Optimisation.Result(state, value, solution);
    }

    protected double evaluateFunction(Access1D<?> solution) {
        if (this.myFunction != null && solution != null && (long)this.myFunction.arity() == solution.count()) {
            return this.myFunction.invoke(Access1D.asPrimitive1D(solution));
        }
        return Double.NaN;
    }

    protected Access1D<?> extractSolution() {
        return this.myIntegerModel.getVariableValues();
    }

    public static final class ModelIntegration
    extends ExpressionsBasedModel.Integration<GomorySolver> {
        @Override
        public GomorySolver build(ExpressionsBasedModel model) {
            return new GomorySolver(model);
        }

        @Override
        public boolean isCapable(ExpressionsBasedModel model) {
            return model.isAnyVariableInteger() && !model.isAnyConstraintQuadratic();
        }

        @Override
        public Optimisation.Result toModelState(Optimisation.Result solverState, ExpressionsBasedModel model) {
            return solverState;
        }

        @Override
        public Optimisation.Result toSolverState(Optimisation.Result modelState, ExpressionsBasedModel model) {
            return modelState;
        }

        @Override
        protected boolean isSolutionMapped() {
            return false;
        }
    }
}

