/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.function;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.ojalgo.type.function.AutoFunctional;
import org.ojalgo.type.function.ManagedSupplier;
import org.ojalgo.type.function.MappedSupplier;
import org.ojalgo.type.function.QueuedSupplier;
import org.ojalgo.type.function.SequencedSupplier;
import org.ojalgo.type.function.SupplierIterator;
import org.ojalgo.type.management.MBeanUtils;
import org.ojalgo.type.management.Throughput;

@FunctionalInterface
public interface AutoSupplier<T>
extends AutoCloseable,
Supplier<T>,
AutoFunctional,
Iterable<T> {
    public static <T> AutoSupplier<T> empty() {
        return () -> null;
    }

    public static <T> AutoSupplier<T> managed(String name, Supplier<T> supplier) {
        Throughput manager = new Throughput();
        MBeanUtils.register(manager, name);
        return new ManagedSupplier<T>(manager, supplier);
    }

    public static <T> AutoSupplier<T> managed(Throughput manager, Supplier<T> supplier) {
        return new ManagedSupplier<T>(manager, supplier);
    }

    public static <T, U> AutoSupplier<U> mapped(Supplier<T> supplier, Function<T, U> mapper) {
        return new MappedSupplier<T, U>(supplier, mapper);
    }

    public static <T, U> AutoSupplier<U> mapped(Supplier<T> supplier, Predicate<T> filter, Function<T, U> mapper) {
        return new MappedSupplier<T, U>(supplier, filter, mapper);
    }

    public static <T> AutoSupplier<T> queued(ExecutorService executor, BlockingQueue<T> queue, Supplier<T> ... suppliers) {
        return new QueuedSupplier<T>(executor, queue, suppliers);
    }

    public static <T> AutoSupplier<T> sequenced(BlockingQueue<? extends Supplier<T>> sources) {
        return new SequencedSupplier(sources, s -> s);
    }

    public static <S, T> AutoSupplier<T> sequenced(BlockingQueue<S> sources, Function<S, ? extends Supplier<T>> factory) {
        return new SequencedSupplier(sources, factory);
    }

    @Override
    default public void close() throws Exception {
    }

    default public int drainTo(Collection<? super T> container, int maxElements) {
        int retVal;
        Object item = null;
        for (retVal = 0; retVal < maxElements; ++retVal) {
            T t = this.get();
            item = t;
            if (t == null) break;
            container.add(item);
        }
        return retVal;
    }

    @Override
    default public T get() {
        return this.read();
    }

    @Override
    default public Iterator<T> iterator() {
        return new SupplierIterator(this);
    }

    default public void processAll(Consumer<T> processor) {
        for (T item : this) {
            processor.accept(item);
        }
    }

    public T read();
}

