/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.function;

import java.util.function.Consumer;
import org.ojalgo.type.function.AutoConsumer;
import org.ojalgo.type.management.Throughput;

final class ManagedConsumer<T>
implements AutoConsumer<T> {
    private final Consumer<T> myConsumer;
    private final Throughput myManager;

    ManagedConsumer(Throughput manager, Consumer<T> consumer) {
        this.myManager = manager;
        this.myConsumer = consumer;
    }

    @Override
    public void close() throws Exception {
        if (this.myConsumer instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.myConsumer)).close();
        }
    }

    @Override
    public void write(T item) {
        this.myManager.increment();
        this.myConsumer.accept(item);
    }
}

