/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.coord;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;

@Immutable
public class TimeCoordIntvValue
implements Comparable<TimeCoordIntvValue> {
    private final int b1;
    private final int b2;

    public TimeCoordIntvValue(int b1, int b2) {
        this.b1 = b1;
        this.b2 = b2;
    }

    public int getBounds1() {
        return this.b1;
    }

    public int getBounds2() {
        return this.b2;
    }

    public int getIntervalSize() {
        return Math.abs(this.b2 - this.b1);
    }

    public double getCoordValue() {
        return this.b2;
    }

    public TimeCoordIntvValue convertReferenceDate(CalendarDate fromDate, CalendarPeriod fromUnit, CalendarDate toDate, CalendarPeriod toUnit) {
        CalendarDate start = fromDate.add(fromUnit.multiply(this.b1));
        CalendarDate end = fromDate.add(fromUnit.multiply(this.b2));
        int startOffset = toUnit.getOffset(toDate, start);
        int endOffset = toUnit.getOffset(toDate, end);
        return new TimeCoordIntvValue(startOffset, endOffset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeCoordIntvValue that = (TimeCoordIntvValue)o;
        return this.b1 == that.b1 && this.b2 == that.b2;
    }

    public int hashCode() {
        return Objects.hash(this.b1, this.b2);
    }

    @Override
    public int compareTo(@Nonnull TimeCoordIntvValue o) {
        int c1 = this.b2 - o.b2;
        return c1 == 0 ? this.b1 - o.b1 : c1;
    }

    public String toString() {
        return String.format("(%d,%d)", this.b1, this.b2);
    }

    public TimeCoordIntvValue offset(double offset) {
        return new TimeCoordIntvValue((int)(offset + (double)this.b1), (int)(offset + (double)this.b2));
    }
}

