/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.grib1.tables.Grib1ParamTableReader;
import ucar.unidata.util.StringUtil2;

@Immutable
public class Grib1Parameter
implements GribTables.Parameter {
    private final Grib1ParamTableReader table;
    private final int number;
    private final String name;
    private final String description;
    private final String unit;
    private final String cfName;

    public Grib1Parameter(Grib1ParamTableReader table, int number, String name, String description, String unit) {
        this.table = table;
        this.number = number;
        this.name = this.setName(name);
        this.description = this.setDescription(description);
        this.unit = unit;
        this.cfName = null;
    }

    public Grib1Parameter(Grib1ParamTableReader table, int number, String name, String description, String unit, String cf_name) {
        this.table = table;
        this.number = number;
        this.name = this.setName(name);
        this.description = this.setDescription(description);
        this.unit = unit;
        this.cfName = cf_name;
    }

    public Grib1ParamTableReader getTable() {
        return this.table;
    }

    @Override
    public int getDiscipline() {
        return 0;
    }

    @Override
    public int getCategory() {
        return 0;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean useName() {
        return this.name != null && this.table.useParamName();
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.table.getCenter_id() + "." + this.table.getSubcenter_id() + "." + this.number;
    }

    @Override
    public final String getUnit() {
        return this.unit;
    }

    @Override
    public String getAbbrev() {
        return null;
    }

    @Override
    public Float getFill() {
        return null;
    }

    @Override
    public Float getMissing() {
        return Float.valueOf(Float.NaN);
    }

    @Override
    public String getOperationalStatus() {
        return null;
    }

    public String getCFname() {
        return this.cfName;
    }

    private String setName(String name) {
        if (name == null) {
            name = "";
        }
        return StringUtil2.replace((String)name, (char)' ', (String)"_");
    }

    private String setDescription(String description) {
        return GribUtils.cleanupDescription(description);
    }

    private String cleanupUnit(String unit) {
        return GribUtils.cleanupUnits(unit);
    }

    public String toString() {
        return "GridParameter{number=" + this.number + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", unit='" + this.unit + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grib1Parameter that = (Grib1Parameter)o;
        if (this.number != that.number) {
            return false;
        }
        if (!Objects.equals(this.cfName, that.cfName)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.unit, that.unit);
    }

    public int hashCode() {
        int result = this.number;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        result = 31 * result + (this.cfName != null ? this.cfName.hashCode() : 0);
        return result;
    }
}

