/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.hardware.platform.unix.solaris.SolarisComputerSystem;
import oshi.jna.platform.linux.Libc;
import oshi.jna.platform.unix.solaris.LibKstat;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.solaris.KstatUtil;

public class SolarisCentralProcessor
extends AbstractCentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SolarisCentralProcessor.class);
    private static final Pattern PSRINFO = Pattern.compile(".*physical processor has (\\d+) virtual processors.*");

    public SolarisCentralProcessor() {
        this.initVars();
        this.initTicks();
        LOG.debug("Initialized Processor");
    }

    private void initVars() {
        LibKstat.Kstat ksp = KstatUtil.kstatLookup("cpu_info", -1, null);
        if (ksp != null && KstatUtil.kstatRead(ksp)) {
            this.setVendor(KstatUtil.kstatDataLookupString(ksp, "vendor_id"));
            this.setName(KstatUtil.kstatDataLookupString(ksp, "brand"));
            this.setStepping(KstatUtil.kstatDataLookupString(ksp, "stepping"));
            this.setModel(KstatUtil.kstatDataLookupString(ksp, "model"));
            this.setFamily(KstatUtil.kstatDataLookupString(ksp, "family"));
        }
        this.setCpu64("64".equals(ExecutingCommand.getFirstAnswer("isainfo -b").trim()));
        this.setProcessorID(this.getProcessorID(this.getStepping(), this.getModel(), this.getFamily()));
    }

    @Override
    protected void calculateProcessorCounts() {
        this.logicalProcessorCount = 0;
        this.physicalProcessorCount = 0;
        for (String cpu : ExecutingCommand.runNative("psrinfo -pv")) {
            Matcher m = PSRINFO.matcher(cpu.trim());
            if (!m.matches()) continue;
            ++this.physicalProcessorCount;
            this.logicalProcessorCount += ParseUtil.parseIntOrDefault(m.group(1), 0);
        }
        if (this.logicalProcessorCount < 1) {
            LOG.error("Couldn't find logical processor count. Assuming 1.");
            this.logicalProcessorCount = 1;
        }
        if (this.physicalProcessorCount < 1) {
            LOG.error("Couldn't find physical processor count. Assuming 1.");
            this.physicalProcessorCount = 1;
        }
    }

    @Override
    public synchronized long[] getSystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        long[][] procTicks = this.getProcessorCpuLoadTicks();
        int i = 0;
        while (i < ticks.length) {
            for (long[] procTick : procTicks) {
                int n = i;
                ticks[n] = ticks[n] + procTick[i];
            }
            int n = i++;
            ticks[n] = ticks[n] / (long)procTicks.length;
        }
        return ticks;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = Libc.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            for (int i = Math.max(retval, 0); i < average.length; ++i) {
                average[i] = -1.0;
            }
        }
        return average;
    }

    @Override
    public long[][] getProcessorCpuLoadTicks() {
        long[][] ticks = new long[this.logicalProcessorCount][CentralProcessor.TickType.values().length];
        int cpu = -1;
        for (LibKstat.Kstat ksp : KstatUtil.kstatLookupAll("cpu", -1, "sys")) {
            if (++cpu >= ticks.length) break;
            if (!KstatUtil.kstatRead(ksp)) continue;
            ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = KstatUtil.kstatDataLookupLong(ksp, "cpu_ticks_idle");
            ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = KstatUtil.kstatDataLookupLong(ksp, "cpu_ticks_kernel");
            ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = KstatUtil.kstatDataLookupLong(ksp, "cpu_ticks_user");
        }
        return ticks;
    }

    @Override
    public long getSystemUptime() {
        LibKstat.Kstat ksp = KstatUtil.kstatLookup("unix", 0, "system_misc");
        if (ksp == null) {
            return 0L;
        }
        return ksp.ks_snaptime / 1000000000L;
    }

    @Override
    @Deprecated
    public String getSystemSerialNumber() {
        return new SolarisComputerSystem().getSerialNumber();
    }

    private String getProcessorID(String stepping, String model, String family) {
        List<String> isainfo = ExecutingCommand.runNative("isainfo -v");
        StringBuilder flags = new StringBuilder();
        for (String line : isainfo) {
            if (line.startsWith("64-bit")) continue;
            if (line.startsWith("32-bit")) break;
            flags.append(' ').append(line.trim());
        }
        return this.createProcessorID(stepping, model, family, flags.toString().toLowerCase().split("\\s+"));
    }
}

