/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray.io.npy;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.meteoinfo.ndarray.io.npy.NpyFormatException;
import org.meteoinfo.ndarray.io.npy.NpyUtil;

class NpyVersion {
    final int major;
    final int minor;

    private NpyVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    static NpyVersion of(byte[] bytes) throws NpyFormatException {
        if (bytes.length < 8) {
            throw new NpyFormatException("invalid NPY header");
        }
        if (NpyUtil.u1ToShort(bytes[0]) != 147) {
            throw new NpyFormatException("invalid NPY header");
        }
        String numpy = new String(bytes, 1, 5);
        if (!numpy.equals("NUMPY")) {
            throw new NpyFormatException("invalid NPY header");
        }
        short major = NpyUtil.u1ToShort(bytes[6]);
        short minor = NpyUtil.u1ToShort(bytes[7]);
        if (major != 1 && major != 2 && major != 3) {
            throw new NpyFormatException("unsupported NPY version: " + major);
        }
        return new NpyVersion(major, minor);
    }

    Charset headerEncoding() {
        return this.major >= 3 ? StandardCharsets.UTF_8 : StandardCharsets.US_ASCII;
    }
}

