/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray.io.npy.dict;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.meteoinfo.ndarray.io.npy.NpyByteOrder;
import org.meteoinfo.ndarray.io.npy.NpyDataType;
import org.meteoinfo.ndarray.io.npy.NpyFormatException;
import org.meteoinfo.ndarray.io.npy.dict.Parser;
import org.meteoinfo.ndarray.io.npy.dict.PyDict;
import org.meteoinfo.ndarray.io.npy.dict.PyTuple;
import org.meteoinfo.ndarray.io.npy.dict.PyValue;

public class NpyHeaderDict {
    private final NpyDataType dataType;
    private final NpyByteOrder byteOrder;
    private final boolean fortranOrder;
    private final int[] shape;
    private final Map<String, String> properties;
    private final int typeSize;

    private NpyHeaderDict(Builder builder) {
        this.dataType = Objects.requireNonNull(builder.dataType);
        this.fortranOrder = builder.fortranOrder;
        this.shape = builder.shape == null ? new int[]{} : Arrays.copyOf(builder.shape, builder.shape.length);
        this.byteOrder = builder.byteOrder == null ? NpyByteOrder.NOT_APPLICABLE : builder.byteOrder;
        this.typeSize = this.dataType.size() != 0 ? this.dataType.size() : builder.typeSize;
        this.properties = builder.properties != null ? builder.properties : Collections.emptyMap();
    }

    public static Builder of(NpyDataType dataType) {
        return new Builder(dataType);
    }

    public NpyDataType dataType() {
        return this.dataType;
    }

    public NpyByteOrder byteOrder() {
        return this.byteOrder;
    }

    public int typeSize() {
        return this.typeSize;
    }

    public boolean hasFortranOrder() {
        return this.fortranOrder;
    }

    public int dimensions() {
        return this.shape.length;
    }

    public int sizeOfDimension(int i) {
        if (i < 0 || i >= this.shape.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        return this.shape[i];
    }

    public long dataSize() {
        long elemCount = this.numberOfElements();
        NpyDataType type = this.dataType();
        if (type.size() != 0) {
            return elemCount * (long)this.typeSize();
        }
        if (type == NpyDataType.U) {
            return (long)this.typeSize() * 4L;
        }
        return elemCount * (long)this.typeSize();
    }

    public int numberOfElements() {
        int count = 1;
        int n = this.dimensions();
        for (int i = 0; i < n; ++i) {
            count *= this.sizeOfDimension(i);
        }
        return count;
    }

    public int[] shape() {
        int n = this.dimensions();
        int[] shape = new int[n];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = this.sizeOfDimension(i);
        }
        return shape;
    }

    public String property(String key) {
        return this.properties.get(key);
    }

    public Map<String, String> otherProperties() {
        return this.properties.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.properties);
    }

    public static NpyHeaderDict parse(String s) throws NpyFormatException {
        PyValue value = Parser.parse(s);
        if (value.isError()) {
            throw new NpyFormatException("invalid header dictionary: " + value.asError().message());
        }
        if (!value.isDict()) {
            throw new NpyFormatException("invalid header dictionary; type is " + value.getClass());
        }
        PyDict dict = value.asDict();
        PyValue typeEntry = dict.get("descr");
        if (typeEntry.isNone()) {
            throw new NpyFormatException("invalid header dictionary; data type field 'descr' is missing");
        }
        if (!typeEntry.isString()) {
            throw new NpyFormatException("invalid header dictionary; data type field 'descr' is not a string but: " + typeEntry);
        }
        String dtype = typeEntry.asString().value();
        NpyDataType dataType = NpyDataType.of(dtype);
        if (dataType == null) {
            throw new NpyFormatException("unsupported data type: " + dtype);
        }
        Builder builder = NpyHeaderDict.of(dataType).withShape(NpyHeaderDict.getShape(dict)).withFortranOrder(NpyHeaderDict.getFortranOrder(dict)).withByteOrder(NpyDataType.byteOrderOf(dtype));
        if (dataType.size() == 0) {
            for (int i = 0; i < dtype.length(); ++i) {
                if (!Character.isDigit(dtype.charAt(i))) continue;
                try {
                    String lenStr = dtype.substring(i);
                    int typeSize = Integer.parseInt(lenStr);
                    builder.withTypeSize(typeSize);
                }
                catch (Exception exception) {}
                break;
            }
        }
        dict.forEach((key, val) -> {
            if (!val.isString()) {
                return;
            }
            if (key.equals("descr") || key.equals("shape") || key.equals("fortran_order")) {
                return;
            }
            builder.withOtherProperty((String)key, val.asString().value());
        });
        return builder.create();
    }

    private static boolean getFortranOrder(PyDict dict) throws NpyFormatException {
        String value;
        PyValue entry = dict.get("fortran_order");
        if (entry.isNone()) {
            return false;
        }
        if (!entry.isIdentifier()) {
            throw new NpyFormatException("invalid header dictionary: fortran_order must be True or False but was '" + entry + "'");
        }
        switch (value = entry.asIdentifier().value()) {
            case "True": {
                return true;
            }
            case "False": {
                return false;
            }
        }
        throw new NpyFormatException("invalid header dictionary: fortran_order must be True or False but was '" + value + "'");
    }

    private static int[] getShape(PyDict dict) throws NpyFormatException {
        PyValue entry = dict.get("shape");
        if (entry.isNone()) {
            throw new NpyFormatException("invalid header dictionary: property 'shape' is missing");
        }
        if (!entry.isTuple()) {
            throw new NpyFormatException("invalid header dictionary: property 'shape' is not a tuple");
        }
        PyTuple tuple = entry.asTuple();
        int[] shape = new int[tuple.size()];
        for (int i = 0; i < tuple.size(); ++i) {
            PyValue value = tuple.at(i);
            if (!value.isInt()) {
                throw new NpyFormatException("invalid header dictionary: argument " + i + " of tuple 'shape' is not an integer");
            }
            shape[i] = (int)value.asInt().value();
        }
        return shape;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("{'descr': '");
        if (this.dataType != null) {
            if (this.dataType.size() != 1) {
                buffer.append(this.byteOrder.symbol());
            }
            buffer.append(this.dataType.symbol());
            if (this.dataType.size() == 0) {
                buffer.append(this.typeSize);
            }
        }
        buffer.append("', 'fortran_order': ");
        if (this.fortranOrder) {
            buffer.append("True");
        } else {
            buffer.append("False");
        }
        buffer.append(", 'shape': (");
        if (this.shape != null) {
            for (int i = 0; i < this.shape.length; ++i) {
                if (i > 0) {
                    buffer.append(' ');
                }
                buffer.append(this.shape[i]).append(',');
            }
        }
        buffer.append(")");
        for (Map.Entry<String, String> prop : this.properties.entrySet()) {
            String key = prop.getKey();
            String val = prop.getValue();
            if (key == null || val == null || "descr".equals(key) || "shape".equals(key) || "fortran_order".equals(key)) continue;
            buffer.append(", '").append(key.replace('\'', '\"')).append("': '").append(val.replace('\'', '\"')).append('\'');
        }
        buffer.append('}');
        return buffer.toString();
    }

    public byte[] toNpyHeader() {
        int version = 1;
        String s = this.toString();
        boolean allAscii = StandardCharsets.US_ASCII.newEncoder().canEncode(s);
        if (!allAscii) {
            version = 3;
        }
        byte[] dictBytes = allAscii ? s.getBytes(StandardCharsets.US_ASCII) : s.getBytes(StandardCharsets.UTF_8);
        int filled = version == 1 ? 11 + dictBytes.length : 13 + dictBytes.length;
        int padding = 64 - filled % 64;
        int totalLen = filled + padding;
        if (version == 1 && totalLen > 65535) {
            version = 2;
            filled = 13 + dictBytes.length;
            padding = 64 - filled % 64;
            totalLen = filled + padding;
        }
        ByteBuffer buf = ByteBuffer.allocate(totalLen);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.put((byte)-109);
        buf.put("NUMPY".getBytes());
        buf.put((byte)version);
        buf.put((byte)0);
        if (version == 1) {
            buf.putShort((short)(totalLen - 10));
        } else {
            buf.putInt(totalLen - 12);
        }
        buf.put(dictBytes);
        for (int i = 0; i < padding; ++i) {
            buf.put((byte)32);
        }
        buf.put((byte)10);
        return buf.array();
    }

    public static class Builder {
        private final NpyDataType dataType;
        private int[] shape;
        private NpyByteOrder byteOrder;
        private boolean fortranOrder;
        private Map<String, String> properties;
        private int typeSize;

        private Builder(NpyDataType dataType) {
            this.dataType = Objects.requireNonNull(dataType);
        }

        public Builder withShape(int[] shape) {
            this.shape = shape;
            return this;
        }

        public Builder withByteOrder(NpyByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public Builder withFortranOrder(boolean b) {
            this.fortranOrder = b;
            return this;
        }

        public Builder withTypeSize(int typeSize) {
            this.typeSize = typeSize;
            return this;
        }

        public Builder withOtherProperty(String key, String value) {
            if (key == null || value == null) {
                return this;
            }
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            this.properties.put(key, value);
            return this;
        }

        public NpyHeaderDict create() {
            return new NpyHeaderDict(this);
        }
    }
}

