/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.extension.gui.dock.preference.Preference;
import bibliothek.extension.gui.dock.preference.PreferenceListener;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPreference<V>
implements Preference<V> {
    private List<PreferenceListener<V>> listeners = new ArrayList<PreferenceListener<V>>();

    @Override
    public void addPreferenceListener(PreferenceListener<V> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    @Override
    public void removePreferenceListener(PreferenceListener<V> listener) {
        this.listeners.remove(listener);
    }

    protected boolean hasListeners() {
        return this.listeners.size() > 0;
    }

    protected PreferenceListener<V>[] listeners() {
        return this.listeners.toArray(new PreferenceListener[this.listeners.size()]);
    }

    protected void fireChanged() {
        for (PreferenceListener<V> listener : this.listeners()) {
            listener.changed(this);
        }
    }

    @Override
    public boolean isEnabled(PreferenceOperation operation) {
        return false;
    }

    @Override
    public PreferenceOperation[] getOperations() {
        return null;
    }

    @Override
    public void doOperation(PreferenceOperation operation) {
    }
}

