/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import bibliothek.extension.gui.dock.theme.eclipse.OwnedEclipseBorder;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.Arch;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BaseTabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BorderedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.DefaultInvisibleTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.LinePainter;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPainter;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPanePainter;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.util.Colors;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class ArchGradientPainter
extends BaseTabComponent {
    private final int[] TOP_LEFT_CORNER_X = new int[]{0, 1, 1, 2, 3, 4, 5, 6};
    private final int[] TOP_LEFT_CORNER_Y = new int[]{6, 5, 4, 3, 2, 1, 1, 0};
    private Arch arch;
    private boolean wasPreviousSelected = false;
    public static final TabPainter FACTORY = new TabPainter(){

        @Override
        public TabComponent createTabComponent(EclipseTabPane pane, Dockable dockable) {
            return new ArchGradientPainter(pane, dockable);
        }

        @Override
        public TabPanePainter createDecorationPainter(EclipseTabPane pane) {
            return new LinePainter(pane);
        }

        @Override
        public InvisibleTab createInvisibleTab(InvisibleTabPane pane, Dockable dockable) {
            return new DefaultInvisibleTab(pane, dockable);
        }

        @Override
        public Border getFullBorder(BorderedComponent owner, DockController controller, Dockable dockable) {
            return new OwnedEclipseBorder(owner, controller, true);
        }
    };
    private final int TAB_OVERLAP = 24;

    public ArchGradientPainter(EclipseTabPane pane, Dockable dockable) {
        super(pane, dockable);
        this.setOpaque(false);
        this.update();
        this.updateFont();
        this.updateBorder();
    }

    @Override
    public void updateBorder() {
        EclipseTabPane pane = this.getPane();
        int index = this.getDockableIndex();
        if (this.isBound() && pane != null && index >= 0) {
            Window window = SwingUtilities.getWindowAncestor(this.getComponent());
            boolean focusTemporarilyLost = false;
            if (window != null) {
                boolean bl = focusTemporarilyLost = !window.isActive();
            }
            Color color2 = !this.isEnabled() ? (Color)this.colorStackTabBorderDisabled.value() : (this.isSelected() ? (this.isFocused() ? (focusTemporarilyLost ? (Color)this.colorStackTabBorderSelectedFocusLost.value() : (Color)this.colorStackTabBorderSelectedFocused.value()) : (Color)this.colorStackTabBorderSelected.value()) : (Color)this.colorStackTabBorder.value());
            pane.setContentBorderAt(index, new MatteBorder(2, 2, 2, 2, color2));
        }
    }

    @Override
    public Insets getOverlap(TabComponent other) {
        ArchGradientPainter painter;
        if (other instanceof ArchGradientPainter && (painter = (ArchGradientPainter)other).isSelected()) {
            if (this.getOrientation().isHorizontal()) {
                return new Insets(0, 34, 0, 0);
            }
            return new Insets(34, 0, 0, 0);
        }
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        boolean previousSelected = this.isPreviousTabSelected();
        if (this.wasPreviousSelected != previousSelected) {
            this.update();
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        boolean previousSelected = this.isPreviousTabSelected();
        if (this.wasPreviousSelected != previousSelected) {
            this.update();
        }
        return super.getMinimumSize();
    }

    @Override
    public void updateFocus() {
        this.update();
        this.updateBorder();
        this.updateFont();
    }

    @Override
    protected void updateOrientation() {
        this.update();
    }

    @Override
    protected void updateSelected() {
        this.update();
        this.updateBorder();
        this.updateFont();
    }

    @Override
    protected void updateColors() {
        this.update();
    }

    @Override
    protected void updateEnabled() {
        this.updateBorder();
        this.update();
    }

    protected void update() {
        this.wasPreviousSelected = this.isPreviousTabSelected();
        Insets labelInsets = null;
        Insets buttonInsets = null;
        switch (this.getOrientation()) {
            case TOP_OF_DOCKABLE: 
            case BOTTOM_OF_DOCKABLE: {
                labelInsets = new Insets(3, 5, 3, 2);
                buttonInsets = new Insets(1, 0, 1, 5);
                break;
            }
            case LEFT_OF_DOCKABLE: 
            case RIGHT_OF_DOCKABLE: {
                labelInsets = new Insets(5, 3, 2, 3);
                buttonInsets = new Insets(0, 1, 5, 1);
            }
        }
        boolean horizontal = this.getOrientation().isHorizontal();
        if (this.isSelected()) {
            if (horizontal) {
                buttonInsets.right += 35;
            } else {
                buttonInsets.bottom += 35;
            }
        }
        if (this.wasPreviousSelected) {
            if (horizontal) {
                labelInsets.left += 24;
            } else {
                labelInsets.top += 24;
            }
        }
        this.getLabel().setForeground(this.getTextColor());
        this.setLabelInsets(labelInsets);
        this.setButtonInsets(buttonInsets);
        this.revalidate();
        this.repaint();
    }

    protected Arch arch(int width, int height) {
        if (this.arch == null || this.arch.getWidth() != width || this.arch.getHeight() != height) {
            this.arch = new Arch(width, height);
        }
        return this.arch;
    }

    private Color getTextColor() {
        boolean focusTemporarilyLost = this.isFocusTemporarilyLost();
        if (!this.isEnabled()) {
            return (Color)this.colorStackTabTextDisabled.value();
        }
        if (this.isFocused() && !focusTemporarilyLost) {
            return (Color)this.colorStackTabTextSelectedFocused.value();
        }
        if (this.isFocused() && focusTemporarilyLost) {
            return (Color)this.colorStackTabTextSelectedFocusLost.value();
        }
        if (this.isSelected()) {
            return (Color)this.colorStackTabTextSelected.value();
        }
        return (Color)this.colorStackTabText.value();
    }

    @Override
    public void paintBackground(Graphics g) {
        Color color2;
        Color color1;
        int x = 0;
        int y = 0;
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g2d = (Graphics2D)g;
        boolean focusTemporarilyLost = this.isFocusTemporarilyLost();
        if (!this.isEnabled()) {
            color1 = (Color)this.colorStackTabTopDisabled.value();
            color2 = (Color)this.colorStackTabBottomDisabled.value();
        } else if (this.isFocused() && !focusTemporarilyLost) {
            color1 = (Color)this.colorStackTabTopSelectedFocused.value();
            color2 = (Color)this.colorStackTabBottomSelectedFocused.value();
        } else if (this.isFocused() && focusTemporarilyLost) {
            color1 = (Color)this.colorStackTabTopSelectedFocusLost.value();
            color2 = (Color)this.colorStackTabBottomSelectedFocusLost.value();
        } else if (this.isSelected()) {
            color1 = (Color)this.colorStackTabTopSelected.value();
            color2 = (Color)this.colorStackTabBottomSelected.value();
        } else {
            color1 = (Color)this.colorStackTabTop.value();
            color2 = (Color)this.colorStackTabBottom.value();
        }
        if (this.isSelected()) {
            switch (this.getOrientation()) {
                case TOP_OF_DOCKABLE: 
                case LEFT_OF_DOCKABLE: {
                    this.paintSelected(g2d, color1, color2);
                    break;
                }
                case BOTTOM_OF_DOCKABLE: 
                case RIGHT_OF_DOCKABLE: {
                    this.paintSelected(g2d, color2, color1);
                }
            }
        } else if (this.getTransparency() != Transparency.TRANSPARENT) {
            GradientPaint gradient = color1.equals(color2) ? null : new GradientPaint(x, y, color1, x, y + h, color2);
            Paint old = g2d.getPaint();
            if (gradient != null) {
                g2d.setPaint(gradient);
            } else {
                g2d.setPaint(color1);
            }
            g2d.fillRect(x, y, w, h - 1);
            g2d.setPaint(old);
        }
    }

    @Override
    public void paintForeground(Graphics g) {
        if (!this.isSelected() && !this.isNextTabSelected()) {
            Color lineColor = (Color)this.colorStackBorder.value();
            int w = this.getWidth();
            int h = this.getHeight();
            g.setColor(lineColor);
            if (this.getOrientation().isHorizontal()) {
                g.drawLine(w - 1, 0, w - 1, h);
            } else {
                g.drawLine(0, h - 1, w, h - 1);
            }
        }
    }

    @Override
    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        if (this.containsButton(x, y)) {
            return true;
        }
        if (this.isSelected()) {
            int h;
            int w = this.getWidth();
            Polygon left = this.leftSide(0, 0, w, h = this.getHeight());
            if (left.contains(x, y)) {
                return true;
            }
            Polygon right = this.rightSide(0, 0, w, h);
            if (right.contains(x, y)) {
                return true;
            }
            Rectangle leftBox = left.getBounds();
            Rectangle rightBox = right.getBounds();
            if (this.getOrientation().isHorizontal()) {
                if (leftBox.x + leftBox.width > x) {
                    return false;
                }
                if (rightBox.x < x) {
                    return false;
                }
            } else {
                if (leftBox.y + leftBox.height > y) {
                    return false;
                }
                if (rightBox.y < y) {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private void paintSelected(Graphics g, Color top, Color bottom) {
        int x = 0;
        int y = 0;
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g2d = (Graphics2D)g;
        Color lineColor = (Color)this.colorStackBorder.value();
        boolean firstTab = this.getTabIndex() == 0;
        TabPlacement orientation = this.getOrientation();
        Polygon left = orientation.isHorizontal() ? this.leftSide(x - 1, y - 1, w, h + 1) : this.leftSide(x - 1, y - 1, w + 1, h);
        Polygon right = this.rightSide(x, y, w, h);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (firstTab) {
            if (orientation.isHorizontal() && this.getX() <= 1) {
                left.translate(-1, 0);
            } else if (orientation.isVertical() && this.getY() <= 1) {
                left.translate(0, -1);
            }
        }
        g.setColor(Colors.between(lineColor, this.getBackground(), 0.75));
        g.drawPolyline(left.xpoints, left.ypoints, left.npoints - 1);
        g.drawPolyline(right.xpoints, right.ypoints, right.npoints - 1);
        GradientPaint gradient = null;
        if (!top.equals(bottom)) {
            gradient = this.getOrientation().isHorizontal() ? new GradientPaint(x, y, top, x, y + h, bottom) : new GradientPaint(x, y, top, x + w, y, bottom);
        }
        Paint old = g2d.getPaint();
        if (gradient != null) {
            g2d.setPaint(gradient);
        } else {
            g2d.setPaint(top);
        }
        if (orientation.isHorizontal()) {
            left.translate(1, 0);
            right.translate(-1, 0);
        } else {
            left.translate(0, 1);
            right.translate(0, -1);
        }
        if (this.getTransparency() != Transparency.TRANSPARENT) {
            g.fillPolygon(left);
            right.translate(1, 1);
            g.fillPolygon(right);
            right.translate(-1, -1);
        }
        switch (this.getOrientation()) {
            case TOP_OF_DOCKABLE: {
                g.drawLine(0, h - 1, w - 1, h - 1);
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                g.drawLine(0, 0, w - 1, 0);
                break;
            }
            case LEFT_OF_DOCKABLE: {
                g.drawLine(w - 1, 0, w - 1, h - 1);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                g.drawLine(0, 0, 0, h - 1);
            }
        }
        if (this.getTransparency() != Transparency.TRANSPARENT) {
            Rectangle leftBox = left.getBounds();
            Rectangle rightBox = right.getBounds();
            if (orientation.isHorizontal()) {
                if (leftBox.x + leftBox.width <= rightBox.x) {
                    g.fillRect(leftBox.x + leftBox.width, 0, rightBox.x - leftBox.x - leftBox.width + 1, h);
                }
            } else if (leftBox.y + leftBox.height <= rightBox.y) {
                g.fillRect(0, leftBox.y + leftBox.height, w, rightBox.y - leftBox.y - leftBox.height + 1);
            }
        }
        g2d.setPaint(old);
        g.setColor(lineColor);
        g.drawPolyline(left.xpoints, left.ypoints, left.npoints - 1);
        g.drawPolyline(right.xpoints, right.ypoints, right.npoints - 1);
        switch (this.getOrientation()) {
            case TOP_OF_DOCKABLE: 
            case LEFT_OF_DOCKABLE: {
                g.drawRect(x + w - 1, y + h - 1, 0, 0);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                g.drawRect(x, y + h - 1, 0, 0);
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                g.drawRect(x + w - 1, y, 0, 0);
            }
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    private void mirror(int[] coordinates) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int c : coordinates) {
            min = Math.min(min, c);
            max = Math.max(max, c);
        }
        int n = coordinates.length;
        for (int i = 0; i < n; ++i) {
            coordinates[i] = max - (coordinates[i] - min);
        }
    }

    private void transformFromTopToOrientation(Polygon polygon) {
        switch (this.getOrientation()) {
            case BOTTOM_OF_DOCKABLE: {
                this.mirror(polygon.ypoints);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                this.mirror(polygon.ypoints);
            }
            case LEFT_OF_DOCKABLE: {
                int[] temp = polygon.xpoints;
                polygon.xpoints = polygon.ypoints;
                polygon.ypoints = temp;
            }
        }
    }

    private Polygon leftSide(int x, int y, int w, int h) {
        if (this.getOrientation().isVertical()) {
            int t = x;
            x = y;
            y = t;
            t = w;
            w = h;
            h = t;
        }
        Polygon polygon = this.leftSideTop(x, y, w, h);
        this.transformFromTopToOrientation(polygon);
        return polygon;
    }

    private Polygon leftSideTop(int x, int y, int w, int h) {
        int[] xPoints = new int[this.TOP_LEFT_CORNER_X.length + 2];
        int[] yPoints = new int[this.TOP_LEFT_CORNER_Y.length + 2];
        System.arraycopy(this.TOP_LEFT_CORNER_X, 0, xPoints, 1, this.TOP_LEFT_CORNER_X.length);
        System.arraycopy(this.TOP_LEFT_CORNER_Y, 0, yPoints, 1, this.TOP_LEFT_CORNER_Y.length);
        int max = 0;
        int i = 1;
        int n = xPoints.length - 1;
        while (i < n) {
            max = Math.max(max, xPoints[i]);
            int n2 = i;
            xPoints[n2] = xPoints[n2] + x;
            int n3 = i++;
            yPoints[n3] = yPoints[n3] + y;
        }
        xPoints[0] = x;
        yPoints[0] = y + h - 1;
        int index = xPoints.length - 1;
        xPoints[index] = x + max;
        yPoints[index] = y + h - 1;
        return new Polygon(xPoints, yPoints, xPoints.length);
    }

    private Polygon rightSide(int x, int y, int w, int h) {
        int labelMin = 6;
        if (this.getIcon() != null) {
            labelMin = this.getOrientation().isHorizontal() ? (labelMin += this.getIcon().getIconWidth() + this.getLabel().getIconOffset()) : (labelMin += this.getIcon().getIconHeight() + this.getLabel().getIconOffset());
        }
        if (this.getOrientation().isVertical()) {
            int t = x;
            x = y;
            y = t;
            t = w;
            w = h;
            h = t;
        }
        Polygon polygon = this.rightSideTop(x, y, w, h, labelMin);
        this.transformFromTopToOrientation(polygon);
        return polygon;
    }

    private Polygon rightSideTop(int x, int y, int w, int h, int labelMin) {
        Arch arch = this.arch(Math.max(1, Math.min(w - labelMin, h * 34 / 22)), h);
        int[] xPoints = new int[arch.getWidth() + 1];
        int[] yPoints = new int[arch.getWidth() + 1];
        int n = arch.getWidth();
        for (int i = 0; i < n; ++i) {
            xPoints[i] = x + w - n + i;
            yPoints[i] = arch.getValue(i) + y;
        }
        int index = xPoints.length - 1;
        xPoints[index] = xPoints[0];
        yPoints[index] = yPoints[index - 1];
        return new Polygon(xPoints, yPoints, xPoints.length);
    }
}

