/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockStationAdapter;

public class VisibilityFocusObserver
extends DockRegisterAdapter {
    private StationListener listener = new StationListener();
    private DockController controller;

    public VisibilityFocusObserver(DockController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = controller;
    }

    @Override
    public void dockStationRegistered(DockController controller, DockStation station) {
        station.addDockStationListener(this.listener);
    }

    @Override
    public void dockStationUnregistered(DockController controller, DockStation station) {
        station.removeDockStationListener(this.listener);
    }

    @Override
    public void dockableUnregistered(DockController controller, Dockable dockable) {
        if (dockable == controller.getFocusedDockable()) {
            controller.setFocusedDockable(new DefaultFocusRequest(null, null, false));
        }
    }

    private class StationListener
    extends DockStationAdapter {
        private StationListener() {
        }

        @Override
        public void dockableAdded(DockStation station, Dockable dockable) {
            Dockable focusedDockable;
            if (!VisibilityFocusObserver.this.controller.getRelocator().isOnPut() && (dockable == (focusedDockable = VisibilityFocusObserver.this.controller.getFocusedDockable()) || focusedDockable == null) && dockable.isDockableShowing()) {
                VisibilityFocusObserver.this.controller.setFocusedDockable(new DefaultFocusRequest(dockable, null, true));
            }
        }

        @Override
        public void dockableShowingChanged(DockStation station, Dockable dockable, boolean visible) {
            if (!VisibilityFocusObserver.this.controller.isOnFocusing() && !visible && VisibilityFocusObserver.this.controller.isFocused(dockable)) {
                DockStation parent = dockable.getDockParent();
                while (parent != null && (dockable = parent.asDockable()) != null) {
                    parent = dockable.getDockParent();
                    if (parent == null || !parent.isChildShowing(dockable)) continue;
                    VisibilityFocusObserver.this.controller.setFocusedDockable(new DefaultFocusRequest(dockable, null, false));
                    return;
                }
                VisibilityFocusObserver.this.controller.setFocusedDockable(new DefaultFocusRequest(null, null, false));
            }
        }
    }
}

