/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.control.focus.FocusController;
import bibliothek.gui.dock.control.focus.FocusRequest;
import bibliothek.gui.dock.event.FocusVetoListener;
import java.awt.Component;
import java.awt.KeyboardFocusManager;

public class RepeatingFocusRequest
implements FocusRequest {
    private int delay;
    private int attempts;
    private DockElementRepresentative source;
    private Component component;
    private boolean hardRequest;

    public RepeatingFocusRequest(DockElementRepresentative source, Component component, boolean hardRequest) {
        this(source, component, 10, 20, hardRequest);
    }

    public RepeatingFocusRequest(DockElementRepresentative source, Component component, int delay, int attempts, boolean hardRequest) {
        if (component == null) {
            throw new IllegalArgumentException("component must not be null");
        }
        if (delay < 1) {
            throw new IllegalArgumentException("delay must be >= 1: " + delay);
        }
        if (attempts < 1) {
            throw new IllegalArgumentException("attempts must be >= 1: " + attempts);
        }
        this.source = source;
        this.component = component;
        this.delay = delay;
        this.attempts = attempts;
        this.hardRequest = hardRequest;
    }

    @Override
    public boolean validate(FocusController controller) {
        return true;
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    @Override
    public DockElementRepresentative getSource() {
        return this.source;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public boolean acceptable(Component component) {
        return this.component == component;
    }

    @Override
    public boolean isHardRequest() {
        return this.hardRequest;
    }

    @Override
    public void veto(FocusVetoListener.FocusVeto veto) {
    }

    @Override
    public FocusRequest grant(Component component) {
        --this.attempts;
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (manager.getPermanentFocusOwner() != component) {
            manager.clearGlobalFocusOwner();
            component.requestFocus();
        }
        if (this.attempts > 0) {
            return this;
        }
        return null;
    }
}

