/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap.layer;

import bibliothek.gui.DockStation;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.layer.LayerPriority;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class FlapSideDropLayer
implements DockStationDropLayer {
    private FlapDockStation station;
    private LayerPriority priority = LayerPriority.OUTSIDE_HIGH;

    public FlapSideDropLayer(FlapDockStation station) {
        this.station = station;
    }

    @Override
    public DockStation getStation() {
        return this.station;
    }

    @Override
    public Component getComponent() {
        return this.station.getComponent();
    }

    @Override
    public DockStationDropLayer modify(DockStationDropLayer child) {
        return child;
    }

    @Override
    public boolean contains(int x, int y) {
        Point point = new Point(x, y);
        SwingUtilities.convertPointFromScreen(point, this.getComponent());
        Rectangle bounds = this.getComponent().getBounds();
        if (bounds.contains(point)) {
            return false;
        }
        x = point.x;
        y = point.y;
        int deltaX = Math.min(Math.abs(x), Math.abs(x - bounds.width));
        if (x > 0 && x < bounds.width) {
            deltaX = 0;
        }
        int deltaY = Math.min(Math.abs(y), Math.abs(y - bounds.height));
        if (y > 0 && y < bounds.height) {
            deltaY = 0;
        }
        if (this.station.getDirection() == FlapDockStation.Direction.NORTH || this.station.getDirection() == FlapDockStation.Direction.SOUTH ? deltaX > 0 : deltaY > 0) {
            return false;
        }
        int size = this.station.getBorderSideSnapSize();
        return deltaX <= size && deltaY <= size;
    }

    @Override
    public LayerPriority getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(LayerPriority priority) {
        this.priority = priority;
    }

    @Override
    public boolean canCompare(DockStationDropLayer level) {
        return false;
    }

    @Override
    public int compare(DockStationDropLayer level) {
        return 0;
    }
}

